/*
 * Decompiled with CFR 0.152.
 */
package net.soulsandman.contentified.block.entity;

import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1769;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1842;
import net.minecraft.class_1844;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import net.minecraft.class_9334;
import net.soulsandman.contentified.block.custom.ColoredWaterCauldronBlock;
import net.soulsandman.contentified.util.BedrockCauldronBlocks;
import net.soulsandman.contentified.util.ColorBlenderHelper;
import org.jetbrains.annotations.Nullable;

public class WaterCauldronBlockEntity
extends class_2586 {
    public static final String KEY_FLUID_TINT = "tint_color";
    public static final String KEY_FLUID_ITEM = "item_id";
    public static final String KEY_POTION_TYPE = "potion_type";
    private static final int COLOR_WHEN_ERROR = -16777216;
    private int tintColor;
    private class_2960 fluidId;
    private class_2960 potionTypeId;

    public WaterCauldronBlockEntity(class_2338 pos, class_2680 state) {
        super(BedrockCauldronBlocks.WATER_CAULDRON_ENTITY, pos, state);
    }

    public int getTintColor() {
        return this.tintColor;
    }

    @Nullable
    public class_2960 getFluidId() {
        return this.fluidId;
    }

    public class_1792 getPotionType() {
        class_1792 item = (class_1792)class_7923.field_41178.method_63535(this.potionTypeId);
        if (Objects.equals(class_7923.field_41178.method_10221((Object)item), class_7923.field_41178.method_10137())) {
            item = class_1802.field_8574;
        }
        return item;
    }

    public void setPotion(class_1799 potionItem) {
        class_1844 component = (class_1844)potionItem.method_58694(class_9334.field_49651);
        if (component == null) {
            return;
        }
        Optional optionalPotion = component.comp_2378();
        if (optionalPotion.isEmpty()) {
            return;
        }
        class_6880 potion = (class_6880)optionalPotion.get();
        this.potionTypeId = class_7923.field_41178.method_10221((Object)potionItem.method_7909());
        this.fluidId = class_7923.field_41179.method_10221((Object)((class_1842)potion.comp_349()));
        this.setTintColor(component.method_8064());
    }

    public void setDyeColor(int itemColor) {
        int resultColor;
        if (Objects.equals(this.fluidId, class_7923.field_41175.method_10221((Object)BedrockCauldronBlocks.COLORED_WATER_CAULDRON))) {
            resultColor = ColorBlenderHelper.blendColors(this.getTintColor(), itemColor);
        } else {
            this.fluidId = class_7923.field_41175.method_10221((Object)BedrockCauldronBlocks.COLORED_WATER_CAULDRON);
            resultColor = itemColor;
        }
        this.setTintColor(resultColor);
    }

    private void setTintColor(int tintColor) {
        this.tintColor = tintColor;
        this.method_5431();
        this.updateListeners();
    }

    private void checkExactIds() {
        boolean valid = false;
        Object object = class_7923.field_41178.method_63535(this.getFluidId());
        if (object instanceof class_1769) {
            class_1769 dyeItem = (class_1769)object;
            this.setDyeColor(ColorBlenderHelper.fromDyeItem(dyeItem));
            valid = true;
        } else if (class_7923.field_41175.method_63535(this.getFluidId()) instanceof ColoredWaterCauldronBlock) {
            valid = true;
        } else {
            Optional potionEntry = class_7923.field_41179.method_10223(this.getFluidId());
            if (potionEntry.isPresent()) {
                valid = true;
                this.setTintColor(Objects.requireNonNull((class_1844)class_1844.method_57400((class_1792)class_1802.field_8469, (class_6880)((class_6880)potionEntry.get())).method_58694(class_9334.field_49651)).method_8064());
            }
        }
        if (!valid) {
            this.setTintColor(-16777216);
        }
    }

    private void updateListeners() {
        if (this.field_11863 != null) {
            this.field_11863.method_8413(this.method_11016(), this.method_11010(), this.method_11010(), 2);
        }
    }

    protected void method_11014(class_11368 view) {
        super.method_11014(view);
        this.tintColor = view.method_71424(KEY_FLUID_TINT, 0);
        this.fluidId = class_2960.method_12829((String)view.method_71428(KEY_FLUID_ITEM, "water"));
        this.potionTypeId = class_2960.method_12829((String)view.method_71428(KEY_POTION_TYPE, "night_vision"));
        this.checkExactIds();
        this.updateListeners();
    }

    protected void method_11007(class_11372 view) {
        view.method_71465(KEY_FLUID_TINT, this.tintColor);
        view.method_71469(KEY_FLUID_ITEM, this.fluidId == null ? "<NULL>" : this.fluidId.toString());
        view.method_71469(KEY_POTION_TYPE, this.potionTypeId == null ? "<NULL>" : this.potionTypeId.toString());
        super.method_11007(view);
    }

    @Nullable
    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585((class_2586)this);
    }

    public class_2487 method_16887(class_7225.class_7874 registryLookup) {
        return this.method_38244(registryLookup);
    }
}

