/*
 * Decompiled with CFR 0.152.
 */
package net.soulsandman.contentified.command.custom;

import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.minecraft.class_1314;
import net.minecraft.class_2168;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.server.MinecraftServer;

public class EntityNavigatorTracker {
    private static final Map<UUID, NavigationData> ACTIVE_NAVIGATORS = new ConcurrentHashMap<UUID, NavigationData>();
    private static boolean registeredTickEvent = false;

    public static void startTracking(MinecraftServer server, class_1314 entity, class_243 target, float speed, class_2168 source) {
        ACTIVE_NAVIGATORS.put(entity.method_5667(), new NavigationData(entity, target, speed, source));
        if (!registeredTickEvent) {
            ServerTickEvents.END_SERVER_TICK.register(s -> EntityNavigatorTracker.tick());
            registeredTickEvent = true;
        }
    }

    public static boolean stopTracking(class_1314 entity) {
        return ACTIVE_NAVIGATORS.remove(entity.method_5667()) != null;
    }

    private static void tick() {
        ACTIVE_NAVIGATORS.values().removeIf(data -> {
            double successRange;
            class_1314 entity = data.entity;
            if (entity == null || !entity.method_5805() || entity.method_5942() == null || entity.method_73183().method_8608()) {
                return true;
            }
            class_243 currentPos = entity.method_73189();
            double dist = currentPos.method_1022(data.target);
            if (dist <= (successRange = Math.max(1.25, (double)entity.method_17681() * 1.5))) {
                if (data.source != null) {
                    data.source.method_9226(() -> class_2561.method_43470((String)(entity.method_5477().getString() + " successfully reached the target position.")), false);
                }
                entity.method_5942().method_6340();
                return true;
            }
            double moved = currentPos.method_1022(data.lastPos);
            data.stuckTicks = moved < 0.05 ? ++data.stuckTicks : 0;
            data.lastPos = currentPos;
            if (data.stuckTicks > 120) {
                if (data.source != null) {
                    data.source.method_9226(() -> class_2561.method_43470((String)(entity.method_5477().getString() + " got stuck before reaching the target.")), false);
                }
                entity.method_5942().method_6340();
                return true;
            }
            if (data.ticks % 10 == 0) {
                if (entity.method_5942().method_6357()) {
                    entity.method_5942().method_6337(data.target.field_1352, data.target.field_1351, data.target.field_1350, (double)data.speed);
                    if (entity.method_5942().method_6357() && dist < 3.0) {
                        class_243 dir = data.target.method_1020(currentPos).method_1029().method_1021(0.1);
                        entity.method_18799(dir);
                        entity.field_6037 = true;
                    }
                } else {
                    entity.method_5942().method_6337(data.target.field_1352, data.target.field_1351, data.target.field_1350, (double)data.speed);
                }
            }
            ++data.ticks;
            return false;
        });
    }

    private static class NavigationData {
        final class_1314 entity;
        final class_243 target;
        final float speed;
        final class_2168 source;
        int ticks = 0;
        int stuckTicks = 0;
        class_243 lastPos;

        NavigationData(class_1314 entity, class_243 target, float speed, class_2168 source) {
            this.entity = entity;
            this.target = target;
            this.speed = speed;
            this.source = source;
            this.lastPos = entity.method_73189();
        }
    }
}

