/*
 * Decompiled with CFR 0.152.
 */
package net.soulsandman.contentified.mixin.bedrock_features;

import java.util.Optional;
import net.minecraft.class_10055;
import net.minecraft.class_1268;
import net.minecraft.class_1306;
import net.minecraft.class_572;
import net.minecraft.class_591;
import net.minecraft.class_630;
import net.soulsandman.contentified.ContentifiedClient;
import net.soulsandman.contentified.util.IEatingState;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_591.class})
public class PlayerEntityModelMixin
extends class_572<class_10055> {
    @Unique
    private static final float ITEM_START_TIME = 0.4f;
    @Unique
    private static final float ITEM_INTERVAL_TIME = 0.2f;

    public PlayerEntityModelMixin(class_630 root) {
        super(root);
    }

    @Inject(method={"setAngles"}, at={@At(value="TAIL")})
    private void applyEatingAnimation(class_10055 playerEntityRenderState, CallbackInfo info) {
        if (!(playerEntityRenderState instanceof IEatingState)) {
            return;
        }
        IEatingState state = (IEatingState)playerEntityRenderState;
        Optional<class_1268> eatingHand = state.getEatingHand();
        class_1306 mainArm = playerEntityRenderState.field_55303;
        eatingHand.ifPresent(hand -> {
            if (hand == class_1268.field_5808) {
                this.playEatingAnimation(playerEntityRenderState, mainArm);
            } else if (hand == class_1268.field_5810) {
                this.playEatingAnimation(playerEntityRenderState, mainArm.method_5928());
            }
        });
    }

    @Unique
    private void playEatingAnimation(class_10055 state, class_1306 targetArm) {
        float ticks = (float)ContentifiedClient.deltaTime * 1.0E-9f;
        float itemUseTime = state.field_53407;
        float smoothingTicks = 0.0f;
        float itemStartProgress = Math.min(itemUseTime + smoothingTicks, 8.0f) * 0.05f / 0.4f;
        float itemIntervalProgress = itemUseTime * 0.05f < 0.4f ? 0.0f : ((itemUseTime - 0.0f) % 4.0f + smoothingTicks) * 0.2f;
        float animPitch = itemStartProgress * -this.degToMatAngle(60.0f) + itemIntervalProgress * this.degToMatAngle(11.25f);
        float animYaw = itemStartProgress * -this.degToMatAngle(22.5f) + itemIntervalProgress * this.degToMatAngle(11.25f);
        float animRoll = itemStartProgress * -this.degToMatAngle(5.625f) + itemIntervalProgress * this.degToMatAngle(11.25f);
        if (targetArm == class_1306.field_6183) {
            this.field_3401.field_3654 += animPitch;
            this.field_3401.field_3675 += animYaw;
            this.field_3401.field_3674 += animRoll;
        } else {
            this.field_27433.field_3654 += animPitch;
            this.field_27433.field_3675 -= animYaw;
            this.field_27433.field_3674 += animRoll;
        }
    }

    @Unique
    private float degToMatAngle(float angle) {
        return 7.07f * angle * 0.002777778f;
    }
}

