/*
 * Decompiled with CFR 0.152.
 */
package net.soulsandman.contentified.util;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1769;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1812;
import net.minecraft.class_1842;
import net.minecraft.class_1844;
import net.minecraft.class_1847;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3468;
import net.minecraft.class_3489;
import net.minecraft.class_5328;
import net.minecraft.class_5556;
import net.minecraft.class_5620;
import net.minecraft.class_5712;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_8710;
import net.minecraft.class_9334;
import net.soulsandman.contentified.Contentified;
import net.soulsandman.contentified.block.custom.ColoredWaterCauldronBlock;
import net.soulsandman.contentified.block.custom.PotionCauldronBlock;
import net.soulsandman.contentified.block.entity.WaterCauldronBlockEntity;
import net.soulsandman.contentified.util.BedrockCauldronBlocks;
import net.soulsandman.contentified.util.CauldronParticlePayload;
import net.soulsandman.contentified.util.ColorBlenderHelper;

public interface BedrockCauldronBehavior {
    public static final class_5620.class_8821 POTION_CAULDRON_BEHAVIOR = class_5620.method_32206((String)"potion");
    public static final class_5620.class_8821 COLORED_WATER_CAULDRON_BEHAVIOR = class_5620.method_32206((String)"dye");
    public static final class_5620 DYE_ITEM_BY_COLORED_WATER = (state, world, pos, player, hand, stack) -> {
        if (state == null || world == null || pos == null) {
            return class_1269.field_52423;
        }
        if (!stack.method_31573(class_3489.field_48803)) {
            return class_1269.field_52423;
        }
        Optional<WaterCauldronBlockEntity> entity = BedrockCauldronBehavior.retrieveCauldronEntity(world, pos);
        if (entity.isEmpty()) {
            return BedrockCauldronBehavior.emptyCauldronFromWrongState(state, world, pos, player, hand, stack);
        }
        WaterCauldronBlockEntity blockEntity = entity.get();
        if (!world.field_9236) {
            ColoredWaterCauldronBlock.decrementWhenDye(state, world, pos);
            player.method_7281(class_3468.field_15373);
            player.method_6122(hand, ColorBlenderHelper.blendColors(stack, blockEntity.getTintColor()));
            world.method_8396(null, pos, class_3417.field_14737, class_3419.field_15245, 0.15f, 1.25f);
            world.method_33596(null, (class_6880)class_5712.field_28167, pos);
        }
        return class_1269.field_5812;
    };
    public static final class_5620 DYE_WATER = (state, world, pos, player, hand, stack) -> {
        int level;
        int nextColor;
        if (state == null || world == null || pos == null) {
            return class_1269.field_52423;
        }
        class_1792 item = stack.method_7909();
        if (!(item instanceof class_1769)) {
            return class_1269.field_52423;
        }
        class_1769 dyeItem = (class_1769)item;
        Optional entity = world.method_35230(pos, BedrockCauldronBlocks.WATER_CAULDRON_ENTITY);
        if (entity.isPresent()) {
            int currentColor = ((WaterCauldronBlockEntity)((Object)((Object)entity.get()))).getTintColor();
            nextColor = ColorBlenderHelper.blendColors(currentColor, ColorBlenderHelper.fromDyeItem(dyeItem));
            if (nextColor == currentColor) {
                return class_1269.field_5812;
            }
            level = (Integer)state.method_11654((class_2769)ColoredWaterCauldronBlock.LEVEL);
        } else {
            nextColor = ColorBlenderHelper.fromDyeItem(dyeItem);
            level = ColoredWaterCauldronBlock.getLevelFromWaterCauldronState(state);
        }
        if (!world.field_9236) {
            class_2680 newState = (class_2680)BedrockCauldronBlocks.COLORED_WATER_CAULDRON.method_9564().method_11657((class_2769)ColoredWaterCauldronBlock.LEVEL, (Comparable)Integer.valueOf(level));
            world.method_8501(pos, newState);
            if (!player.method_31549().field_7477) {
                stack.method_7934(1);
            }
            player.method_7259(class_3468.field_15372.method_14956((Object)item));
            world.method_45447(null, pos, class_3417.field_28391, class_3419.field_15245);
            world.method_33596(null, (class_6880)class_5712.field_28733, pos);
        }
        world.method_35230(pos, BedrockCauldronBlocks.WATER_CAULDRON_ENTITY).ifPresent(blockEntity -> blockEntity.setDyeColor(nextColor));
        return class_1269.field_5812;
    };
    public static final class_5620 PLACE_WATER_BY_POTION = (state, world, pos, player, hand, stack) -> {
        int nextLevel;
        if (state == null || world == null || pos == null) {
            return class_1269.field_52423;
        }
        class_1844 component = (class_1844)stack.method_58694(class_9334.field_49651);
        if (component != null && !component.method_57401(class_1847.field_8991)) {
            return class_1269.field_5812;
        }
        if (state.method_27852(class_2246.field_27097)) {
            if ((Integer)state.method_11654((class_2769)class_5556.field_27206) >= 3) {
                return class_1269.field_5812;
            }
            nextLevel = (Integer)((class_2680)state.method_28493((class_2769)class_5556.field_27206)).method_11654((class_2769)class_5556.field_27206);
        } else if (state.method_27852(BedrockCauldronBlocks.COLORED_WATER_CAULDRON)) {
            if ((Integer)state.method_11654((class_2769)ColoredWaterCauldronBlock.LEVEL) >= 6) {
                return class_1269.field_5812;
            }
            nextLevel = Math.min(ColoredWaterCauldronBlock.convertToWaterCauldronLevel(state) + 1, 3);
        } else {
            nextLevel = (Integer)class_2246.field_27097.method_9564().method_11654((class_2769)class_5556.field_27206);
        }
        if (!world.field_9236) {
            player.method_7281(class_3468.field_15373);
            player.method_7259(class_3468.field_15372.method_14956((Object)stack.method_7909()));
            player.method_6122(hand, class_5328.method_30012((class_1799)stack, (class_1657)player, (class_1799)new class_1799((class_1935)class_1802.field_8469)));
            world.method_8501(pos, (class_2680)class_2246.field_27097.method_9564().method_11657((class_2769)class_5556.field_27206, (Comparable)Integer.valueOf(nextLevel)));
            world.method_45447(null, pos, class_3417.field_14826, class_3419.field_15245);
            world.method_33596(null, (class_6880)class_5712.field_28166, pos);
        }
        return class_1269.field_5812;
    };
    public static final class_5620 PICK_POTION_FLUID = (state, world, pos, player, hand, stack) -> {
        if (state == null || world == null || pos == null) {
            return class_1269.field_52423;
        }
        Optional<WaterCauldronBlockEntity> entity = BedrockCauldronBehavior.retrieveCauldronEntity(world, pos);
        if (entity.isEmpty()) {
            return BedrockCauldronBehavior.emptyCauldronFromWrongState(state, world, pos, player, hand, stack);
        }
        WaterCauldronBlockEntity blockEntity = entity.get();
        class_1792 item = stack.method_7909();
        Optional<class_1842> optionalPotion = BedrockCauldronBehavior.retrievePotion(blockEntity);
        if (optionalPotion.isEmpty()) {
            return BedrockCauldronBehavior.emptyCauldronFromWrongState(state, world, pos, player, hand, stack);
        }
        class_1842 potion = optionalPotion.get();
        class_6880 potionEntry = class_7923.field_41179.method_47983((Object)potion);
        class_1792 potionType = blockEntity.getPotionType();
        if (!world.field_9236) {
            if (!PotionCauldronBlock.tryPickFluid(state, world, pos)) {
                return class_1269.field_52422;
            }
            class_1799 potionStack = class_1844.method_57400((class_1792)potionType, (class_6880)potionEntry);
            if (!potionStack.method_57826(class_9334.field_49651)) {
                return class_1269.field_52422;
            }
            int potionColor = Objects.requireNonNull((class_1844)potionStack.method_58694(class_9334.field_49651)).method_8064();
            player.method_7281(class_3468.field_15373);
            player.method_7259(class_3468.field_15372.method_14956((Object)item));
            player.method_6122(hand, class_5328.method_30012((class_1799)stack, (class_1657)player, (class_1799)potionStack));
            world.method_45447(null, pos, class_3417.field_14779, class_3419.field_15245);
            world.method_33596(null, (class_6880)class_5712.field_28167, pos);
            BedrockCauldronBehavior.addPotionParticle(world.method_8320(pos), world, pos, potionColor);
        }
        return class_1269.field_5812;
    };
    public static final class_5620 PLACE_POTION_FLUID = (state, world, pos, player, hand, stack) -> {
        class_2680 newState;
        if (state == null || world == null || pos == null) {
            return class_1269.field_52423;
        }
        if (!(stack.method_7909() instanceof class_1812)) {
            return class_1269.field_52423;
        }
        class_1844 component = (class_1844)stack.method_58694(class_9334.field_49651);
        if (component == null) {
            return class_1269.field_52423;
        }
        Optional optionalPotion = component.comp_2378();
        if (optionalPotion.isEmpty()) {
            return class_1269.field_52423;
        }
        class_6880 potionEntry = (class_6880)optionalPotion.get();
        if (((class_1842)potionEntry.comp_349()).method_8049().isEmpty() && !component.method_57401(class_1847.field_8991)) {
            return class_1269.field_5812;
        }
        class_2960 inStackPotionId = class_7923.field_41179.method_10221((Object)((class_1842)potionEntry.comp_349()));
        if (state.method_28498((class_2769)PotionCauldronBlock.LEVEL)) {
            Optional<WaterCauldronBlockEntity> entity = BedrockCauldronBehavior.retrieveCauldronEntity(world, pos);
            if (entity.isEmpty()) {
                return BedrockCauldronBehavior.emptyCauldronFromWrongState(state, world, pos, player, hand, stack);
            }
            class_2960 currentPotionId = entity.get().getFluidId();
            if (!Objects.equals(currentPotionId, inStackPotionId)) {
                return BedrockCauldronBehavior.evaporateCauldron(state, world, pos, player, hand, stack, new class_1799((class_1935)class_1802.field_8469));
            }
            int currentLevel = (Integer)state.method_11654((class_2769)PotionCauldronBlock.LEVEL);
            if (currentLevel >= 8) {
                return class_1269.field_52422;
            }
            int nextLevel = Math.min(currentLevel + 3, 8);
            newState = (class_2680)BedrockCauldronBlocks.POTION_CAULDRON.method_9564().method_11657((class_2769)PotionCauldronBlock.LEVEL, (Comparable)Integer.valueOf(nextLevel));
        } else {
            newState = BedrockCauldronBlocks.POTION_CAULDRON.method_9564();
        }
        if (component.method_57401(class_1847.field_8991)) {
            return PLACE_WATER_BY_POTION.interact(state, world, pos, player, hand, stack);
        }
        class_1799 processing = stack.method_7972();
        if (!world.field_9236) {
            player.method_7281(class_3468.field_15373);
            player.method_7259(class_3468.field_15372.method_14956((Object)stack.method_7909()));
            player.method_6122(hand, class_5328.method_30012((class_1799)stack, (class_1657)player, (class_1799)new class_1799((class_1935)class_1802.field_8469)));
            world.method_8501(pos, newState);
            world.method_45447(null, pos, class_3417.field_14826, class_3419.field_15245);
            world.method_33596(null, (class_6880)class_5712.field_28166, pos);
            BedrockCauldronBehavior.addPotionParticle(newState, world, pos, component.method_8064());
        }
        world.method_35230(pos, BedrockCauldronBlocks.WATER_CAULDRON_ENTITY).ifPresent(blockEntity -> blockEntity.setPotion(processing));
        return class_1269.field_5812;
    };
    public static final class_5620 TIPPED_ARROW_WITH_POTION = (state, world, pos, player, hand, stack) -> {
        if (state == null || world == null || pos == null) {
            return class_1269.field_52423;
        }
        if (!stack.method_31574(class_1802.field_8107)) {
            return class_1269.field_52423;
        }
        Optional<WaterCauldronBlockEntity> entity = BedrockCauldronBehavior.retrieveCauldronEntity(world, pos);
        if (entity.isEmpty()) {
            return BedrockCauldronBehavior.emptyCauldronFromWrongState(state, world, pos, player, hand, stack);
        }
        WaterCauldronBlockEntity blockEntity = entity.get();
        Optional<class_1842> optionalPotion = BedrockCauldronBehavior.retrievePotion(blockEntity);
        if (optionalPotion.isEmpty()) {
            return BedrockCauldronBehavior.emptyCauldronFromWrongState(state, world, pos, player, hand, stack);
        }
        class_1842 potion = optionalPotion.get();
        class_6880 potionEntry = class_7923.field_41179.method_47983((Object)potion);
        if (!world.field_9236) {
            int tippedArrowCount = PotionCauldronBlock.getMaxTippedArrowCount(stack, state);
            if (tippedArrowCount <= 0) {
                return class_1269.field_52422;
            }
            int consumedFluidLevel = PotionCauldronBlock.getDecLevelByStack(stack, tippedArrowCount);
            int afterFluidLevel = (Integer)state.method_11654((class_2769)PotionCauldronBlock.LEVEL) - consumedFluidLevel;
            class_1799 result = new class_1799((class_1935)class_1802.field_8087, tippedArrowCount);
            class_1799 lingeringEffect = class_1844.method_57400((class_1792)class_1802.field_8150, (class_6880)potionEntry);
            result.method_57379(class_9334.field_49651, (Object)((class_1844)lingeringEffect.method_58694(class_9334.field_49651)));
            if (player.method_68878()) {
                if (!player.method_31548().method_7379(result)) {
                    player.method_31548().method_7394(result);
                }
                player.method_6122(hand, stack);
            } else {
                stack.method_7934(tippedArrowCount);
                if (stack.method_7960()) {
                    player.method_6122(hand, result);
                } else {
                    if (!player.method_31548().method_7394(result)) {
                        player.method_7328(result, false);
                    }
                    player.method_6122(hand, stack);
                }
            }
            if (afterFluidLevel <= 1) {
                world.method_8501(pos, class_2246.field_10593.method_9564());
            } else {
                world.method_8501(pos, (class_2680)BedrockCauldronBlocks.POTION_CAULDRON.method_9564().method_11657((class_2769)PotionCauldronBlock.LEVEL, (Comparable)Integer.valueOf(afterFluidLevel)));
            }
            player.method_7281(class_3468.field_15373);
            player.method_7342(class_3468.field_15372.method_14956((Object)class_1802.field_8107), tippedArrowCount);
            world.method_8396(null, pos, class_3417.field_14737, class_3419.field_15245, 0.15f, 1.25f);
            world.method_33596(null, (class_6880)class_5712.field_28167, pos);
        }
        return class_1269.field_5812;
    };
    public static final class_5620 PICK_COLORED_WATER = (state, world, pos, player, hand, stack) -> {
        if (!world.field_9236) {
            if (!ColoredWaterCauldronBlock.tryPickFluid(state, world, pos)) {
                return class_1269.field_52422;
            }
            class_1792 item = stack.method_7909();
            player.method_6122(hand, class_5328.method_30012((class_1799)stack, (class_1657)player, (class_1799)class_1844.method_57400((class_1792)class_1802.field_8574, (class_6880)class_1847.field_8991)));
            player.method_7281(class_3468.field_15373);
            player.method_7259(class_3468.field_15372.method_14956((Object)item));
            world.method_45447(null, pos, class_3417.field_14779, class_3419.field_15245);
            world.method_33596(null, (class_6880)class_5712.field_28167, pos);
        }
        return class_1269.field_5812;
    };
    public static final class_5620 FILL_BUCKET_WITH_COLORED_WATER = (state, world, pos, player, hand, stack) -> class_5620.method_32210((class_2680)state, (class_1937)world, (class_2338)pos, (class_1657)player, (class_1268)hand, (class_1799)stack, (class_1799)new class_1799((class_1935)class_1802.field_8705), statex -> (Integer)statex.method_11654((class_2769)ColoredWaterCauldronBlock.LEVEL) == 6, (class_3414)class_3417.field_15126);

    public static Optional<WaterCauldronBlockEntity> retrieveCauldronEntity(class_1937 world, class_2338 pos) {
        Optional entity = world.method_35230(pos, BedrockCauldronBlocks.WATER_CAULDRON_ENTITY);
        if (entity.isEmpty()) {
            Contentified.LOGGER.error("[{}] something went wrong to get the fluid in cauldron", (Object)Contentified.class.getSimpleName(), (Object)new NullPointerException("RegistryWorldView#getBlockEntity is not present at " + String.valueOf(pos)));
            return Optional.empty();
        }
        return entity;
    }

    public static Optional<class_1842> retrievePotion(WaterCauldronBlockEntity blockEntity) {
        class_2960 potionId = blockEntity.getFluidId();
        class_1842 potion = (class_1842)class_7923.field_41179.method_63535(potionId);
        if (!class_7923.field_41179.method_10250(potionId) || potion == null) {
            Contentified.LOGGER.error("[{}] something went wrong to get the potion from Registries", (Object)Contentified.class.getSimpleName(), (Object)new IllegalStateException("potion has disappeared, maybe the mod is gone?"));
            return Optional.empty();
        }
        return Optional.of(potion);
    }

    public static class_1269 emptyCauldronFromWrongState(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_1799 stack) {
        return BedrockCauldronBehavior.evaporateCauldron(state, world, pos, player, hand, stack, stack.method_7972());
    }

    public static void registerEvaporateBucketBehavior(Map<class_1792, class_5620> map) {
        map.put(class_1802.field_8705, (state, world, pos, player, hand, stack) -> BedrockCauldronBehavior.evaporateCauldron(state, world, pos, player, hand, stack, new class_1799((class_1935)class_1802.field_8550)));
        map.put(class_1802.field_8187, (state, world, pos, player, hand, stack) -> BedrockCauldronBehavior.evaporateCauldron(state, world, pos, player, hand, stack, new class_1799((class_1935)class_1802.field_8550)));
        map.put(class_1802.field_27876, (state, world, pos, player, hand, stack) -> BedrockCauldronBehavior.evaporateCauldron(state, world, pos, player, hand, stack, new class_1799((class_1935)class_1802.field_8550)));
    }

    public static class_1269 evaporateCauldron(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_1799 current, class_1799 after) {
        if (!world.field_9236) {
            class_2960 particleId = class_7923.field_41180.method_10221((Object)class_2398.field_11203);
            for (int i = 0; i < 10; ++i) {
                CauldronParticlePayload particlePayload = new CauldronParticlePayload();
                particlePayload.setParticleType(particleId);
                particlePayload.setPosition(new class_243((double)pos.method_10263() + 0.25 + Math.random() * 0.5, (double)pos.method_10264() + 0.35, (double)pos.method_10260() + 0.25 + Math.random() * 0.5));
                particlePayload.setVelocity(new class_243(Math.random() * 0.075, 0.0, Math.random() * 0.075));
                PlayerLookup.world((class_3218)((class_3218)world)).forEach(serverPlayerEntity -> ServerPlayNetworking.send((class_3222)serverPlayerEntity, (class_8710)particlePayload));
            }
        }
        return class_5620.method_32210((class_2680)state, (class_1937)world, (class_2338)pos, (class_1657)player, (class_1268)hand, (class_1799)current, (class_1799)after, statex -> true, (class_3414)class_3417.field_15102);
    }

    public static void addPotionParticle(class_2680 state, class_1937 world, class_2338 pos, int color) {
        double offsetY;
        if (world.field_9236) {
            return;
        }
        class_2248 class_22482 = state.method_26204();
        if (class_22482 instanceof PotionCauldronBlock) {
            PotionCauldronBlock potionCauldronBlock = (PotionCauldronBlock)class_22482;
            offsetY = 0.05 + potionCauldronBlock.method_31615(state);
        } else {
            offsetY = 0.5;
        }
        double red = (double)(color >> 16 & 0xFF) / 255.0;
        double green = (double)(color >> 8 & 0xFF) / 255.0;
        double blue = (double)(color & 0xFF) / 255.0;
        class_2960 particleId = class_7923.field_41180.method_10221((Object)class_2398.field_11226);
        for (int i = 0; i < 7; ++i) {
            CauldronParticlePayload particlePayload = new CauldronParticlePayload();
            particlePayload.setParticleType(particleId);
            particlePayload.setPosition(new class_243((double)pos.method_10263() + 0.15 + Math.random() * 0.7, (double)pos.method_10264() + offsetY, (double)pos.method_10260() + 0.15 + Math.random() * 0.7));
            particlePayload.setVelocity(new class_243(red, green, blue));
            PlayerLookup.world((class_3218)((class_3218)world)).forEach(serverPlayerEntity -> ServerPlayNetworking.send((class_3222)serverPlayerEntity, (class_8710)particlePayload));
        }
    }

    public static void registerBehavior() {
        Map dyeableBehaviorMap = COLORED_WATER_CAULDRON_BEHAVIOR.comp_1982();
        Map potionBehaviorMap = POTION_CAULDRON_BEHAVIOR.comp_1982();
        Map vanillaWaterBehaviorMap = class_5620.field_27776.comp_1982();
        Map vanillaEmptyBehaviorMap = class_5620.field_27775.comp_1982();
        class_7923.field_41178.method_10220().filter(item -> item instanceof class_1769).forEach(vanillaWaterBehaviorMap::remove);
        class_7923.field_41178.method_10220().filter(item -> item instanceof class_1812).forEach(potionItem -> {
            vanillaEmptyBehaviorMap.remove(potionItem);
            vanillaWaterBehaviorMap.remove(potionItem);
        });
        dyeableBehaviorMap.clear();
        potionBehaviorMap.clear();
        class_7923.field_41178.method_10220().filter(item -> item instanceof class_1769).forEach(dyeItem -> {
            vanillaWaterBehaviorMap.putIfAbsent(dyeItem, DYE_WATER);
            dyeableBehaviorMap.putIfAbsent(dyeItem, DYE_WATER);
        });
        class_7923.field_41178.method_10220().filter(item -> item.method_7854().method_31573(class_3489.field_48803)).forEach(item -> dyeableBehaviorMap.putIfAbsent(item, DYE_ITEM_BY_COLORED_WATER));
        dyeableBehaviorMap.putIfAbsent(class_1802.field_8550, FILL_BUCKET_WITH_COLORED_WATER);
        dyeableBehaviorMap.putIfAbsent(class_1802.field_8469, PICK_COLORED_WATER);
        class_5620.method_34850((Map)dyeableBehaviorMap);
        class_7923.field_41178.method_10220().filter(item -> item instanceof class_1812).forEach(potionItem -> {
            vanillaEmptyBehaviorMap.putIfAbsent(potionItem, PLACE_POTION_FLUID);
            potionBehaviorMap.putIfAbsent(potionItem, PLACE_POTION_FLUID);
            vanillaWaterBehaviorMap.putIfAbsent(potionItem, PLACE_WATER_BY_POTION);
            dyeableBehaviorMap.putIfAbsent(potionItem, PLACE_WATER_BY_POTION);
        });
        potionBehaviorMap.putIfAbsent(class_1802.field_8469, PICK_POTION_FLUID);
        potionBehaviorMap.putIfAbsent(class_1802.field_8107, TIPPED_ARROW_WITH_POTION);
        BedrockCauldronBehavior.registerEvaporateBucketBehavior(potionBehaviorMap);
    }
}

