/*
 * Decompiled with CFR 0.152.
 */
package net.soulsandman.contentified.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2561;
import net.minecraft.class_7172;

@Environment(value=EnvType.CLIENT)
public class ModOptions {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final File CONFIG_FILE = FabricLoader.getInstance().getConfigDir().resolve("contentified_options.json").toFile();
    private static boolean showOwnNametag = true;
    private static boolean displayCoordinates = false;
    private static boolean displayDaysPlayed = false;
    public static final class_7172<Boolean> SHOW_OWN_NAMETAG = class_7172.method_41750((String)"options.contentified.show_own_nametag", (class_7172.class_7277)class_7172.method_42717((class_2561)class_2561.method_43471((String)"options.contentified.show_own_nametag.desc")), (boolean)showOwnNametag, value -> {
        showOwnNametag = value;
        ModOptions.save();
    });
    public static final class_7172<Boolean> DISPLAY_COORDINATES = class_7172.method_41750((String)"options.contentified.display_coordinates", (class_7172.class_7277)class_7172.method_42717((class_2561)class_2561.method_43471((String)"options.contentified.display_coordinates.desc")), (boolean)displayCoordinates, value -> {
        displayCoordinates = value;
        ModOptions.save();
    });
    public static final class_7172<Boolean> DISPLAY_DAYS_PLAYED = class_7172.method_41750((String)"options.contentified.display_days_played", (class_7172.class_7277)class_7172.method_42717((class_2561)class_2561.method_43471((String)"options.contentified.display_days_played.desc")), (boolean)displayDaysPlayed, value -> {
        displayDaysPlayed = value;
        ModOptions.save();
    });

    public static void load() {
        if (!CONFIG_FILE.exists()) {
            return;
        }
        try (FileReader reader = new FileReader(CONFIG_FILE);){
            Data data = (Data)GSON.fromJson((Reader)reader, Data.class);
            if (data != null) {
                showOwnNametag = data.showOwnNametag;
                displayCoordinates = data.displayCoordinates;
                displayDaysPlayed = data.displayDaysPlayed;
                SHOW_OWN_NAMETAG.method_41748((Object)showOwnNametag);
                DISPLAY_COORDINATES.method_41748((Object)displayCoordinates);
                DISPLAY_DAYS_PLAYED.method_41748((Object)displayDaysPlayed);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void save() {
        try (FileWriter writer = new FileWriter(CONFIG_FILE);){
            GSON.toJson((Object)new Data(showOwnNametag, displayCoordinates, displayDaysPlayed), (Appendable)writer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static boolean showOwnNametagInThirdPerson() {
        return showOwnNametag;
    }

    public static boolean showCoordinates() {
        return displayCoordinates;
    }

    public static boolean showDaysPlayed() {
        return displayDaysPlayed;
    }

    private static class Data {
        boolean showOwnNametag;
        boolean displayCoordinates;
        boolean displayDaysPlayed;

        Data(boolean showOwnNametag, boolean displayCoordinates, boolean displayDaysPlayed) {
            this.showOwnNametag = showOwnNametag;
            this.displayCoordinates = displayCoordinates;
            this.displayDaysPlayed = displayDaysPlayed;
        }
    }
}

