/*
 * Decompiled with CFR 0.152.
 */
package net.soulsandman.contentified.block.entity;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_5819;
import net.minecraft.class_7225;
import net.soulsandman.contentified.block.ModBlockEntityTypes;
import net.soulsandman.contentified.block.ModBlocks;
import net.soulsandman.contentified.block.custom.CindermawBlock;
import net.soulsandman.contentified.item.ModItems;
import org.jetbrains.annotations.Nullable;

public class CindermawBlockEntity
extends class_2586 {
    private static final int SPIT_COOLDOWN_TICKS_MIN = 10;
    private static final int SPIT_COOLDOWN_TICKS_MAX = 20;
    private static final int SPIT_DURATION_TICKS = 60;
    private static final int LOOT_SPIT_INTERVAL_TICKS_MIN = 5;
    private static final int LOOT_SPIT_INTERVAL_TICKS_MAX = 15;
    private int spittingTimer = 0;
    private int lootSpitCooldown = 0;
    private int currentSpitDelay = 0;
    private boolean isSpitting = false;
    private final List<class_1799> possibleLoot = new ArrayList<class_1799>(Arrays.asList(new class_1799((class_1935)class_1802.field_8606), new class_1799((class_1935)class_1802.field_8713, 2), new class_1799((class_1935)class_1802.field_8745)));
    private final List<class_1799> possibleLavaRoomLoot = new ArrayList<class_1799>(Arrays.asList(new class_1799((class_1935)class_1802.field_8687), new class_1799((class_1935)class_1802.field_8695, 2), new class_1799((class_1935)class_1802.field_8477), new class_1799((class_1935)class_1802.field_8620, 5), new class_1799((class_1935)class_1802.field_8790, 2), new class_1799((class_1935)ModBlocks.WARPED_WART, 2), new class_1799((class_1935)ModItems.GHOST_ARROW)));
    private class_5819 random = class_5819.method_43047();

    public CindermawBlockEntity(class_2338 pos, class_2680 state) {
        super(ModBlockEntityTypes.CINDERMAW_BE, pos, state);
    }

    public void startSpitting(@Nullable class_1657 player) {
        if (!this.field_11863.method_8608()) {
            this.isSpitting = true;
            this.spittingTimer = 60;
            this.currentSpitDelay = this.random.method_43048(11) + 10;
            this.method_5431();
        }
    }

    public void tick(class_1937 world, class_2338 pos, class_2680 state) {
        if (!world.method_8608() && this.isSpitting) {
            --this.spittingTimer;
            if (this.spittingTimer <= 0) {
                this.isSpitting = false;
                world.method_8652(pos, (class_2680)state.method_11657((class_2769)CindermawBlock.LOOT_GONE, (Comparable)Boolean.valueOf(true)), 3);
                this.method_5431();
            } else if (this.currentSpitDelay > 0) {
                --this.currentSpitDelay;
            } else {
                this.spitLoot(world, pos);
                this.currentSpitDelay = this.lootSpitCooldown = this.random.method_43048(11) + 5;
            }
        }
    }

    private void spitLoot(class_1937 world, class_2338 pos) {
        if (this.possibleLoot.isEmpty()) {
            return;
        }
        class_1799 chosenLoot = this.possibleLoot.get(this.random.method_43048(this.possibleLoot.size())).method_7972();
        if (((Boolean)world.method_8320(pos).method_11654((class_2769)CindermawBlock.LAVA_ROOM_LOOT)).booleanValue()) {
            if (this.possibleLavaRoomLoot.isEmpty()) {
                return;
            }
            chosenLoot = this.possibleLavaRoomLoot.get(this.random.method_43048(this.possibleLavaRoomLoot.size())).method_7972();
        }
        double xOffset = 0.5;
        double yOffset = 0.35;
        double zOffset = 0.5;
        class_1542 itemEntity = new class_1542(world, (double)pos.method_10263() + xOffset, (double)pos.method_10264() + yOffset, (double)pos.method_10260() + zOffset, chosenLoot);
        float speed = 0.15f + this.random.method_43057() * 0.1f;
        itemEntity.method_18800((this.random.method_43058() - 0.5) * (double)speed, 0.5 + this.random.method_43058() * 0.1, (this.random.method_43058() - 0.5) * (double)speed);
        world.method_8649((class_1297)itemEntity);
        world.method_8396(null, pos, class_3417.field_14563, class_3419.field_15245, 0.5f, 0.8f + this.random.method_43057() * 0.4f);
        for (int i = 0; i < 5; ++i) {
            world.method_8406((class_2394)class_2398.field_11251, (double)((float)pos.method_10263() + 0.5f), (double)((float)pos.method_10264() + 0.75f), (double)((float)pos.method_10260() + 0.5f), 0.0, 0.5, 0.0);
        }
    }

    public void method_11014(class_11368 view) {
        super.method_11014(view);
        this.spittingTimer = view.method_71424("SpittingTimer", 0);
        this.lootSpitCooldown = view.method_71424("LootSpitCooldown", 0);
        this.currentSpitDelay = view.method_71424("CurrentSpitDelay", 0);
        this.isSpitting = view.method_71433("IsSpitting", false);
    }

    protected void method_11007(class_11372 view) {
        super.method_11007(view);
        view.method_71465("SpittingTimer", this.spittingTimer);
        view.method_71465("LootSpitCooldown", this.lootSpitCooldown);
        view.method_71465("CurrentSpitDelay", this.currentSpitDelay);
        view.method_71472("IsSpitting", this.isSpitting);
    }

    @Nullable
    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585((class_2586)this);
    }

    public class_2487 method_16887(class_7225.class_7874 registries) {
        return this.method_38244(registries);
    }
}

