/*
 * Decompiled with CFR 0.152.
 */
package net.soulsandman.contentified.entity.custom;

import java.util.Optional;
import java.util.function.Function;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1657;
import net.minecraft.class_1665;
import net.minecraft.class_1676;
import net.minecraft.class_1688;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1922;
import net.minecraft.class_1927;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3481;
import net.minecraft.class_3532;
import net.minecraft.class_3610;
import net.minecraft.class_5362;
import net.minecraft.class_6012;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_8103;
import net.minecraft.class_9749;
import net.soulsandman.contentified.block.ModBlocks;
import net.soulsandman.contentified.item.ModItems;
import net.soulsandman.contentified.util.ModGameRules;
import org.jetbrains.annotations.Nullable;

public class WindTntMinecartEntity
extends class_1688 {
    private static final byte PRIME_TNT_STATUS = 10;
    private static final String EXPLOSION_POWER_NBT_KEY = "explosion_power";
    private static final String EXPLOSION_SPEED_FACTOR_NBT_KEY = "explosion_speed_factor";
    private static final String FUSE_NBT_KEY = "fuse";
    private static final float DEFAULT_EXPLOSION_POWER = 4.0f;
    private static final float DEFAULT_EXPLOSION_SPEED_FACTOR = 1.0f;
    private static final int DEFAULT_FUSE_TICKS = -1;
    @Nullable
    public class_1282 damageSource;
    public int fuseTicks = -1;
    private float explosionPower = 4.0f;
    private float explosionSpeedFactor = 1.0f;
    private static final class_5362 EXPLOSION_BEHAVIOR = new class_9749(false, false, Optional.of(Float.valueOf(2.22f)), class_7923.field_41175.method_46733(class_3481.field_49051).map(Function.identity()));

    public WindTntMinecartEntity(class_1299<? extends WindTntMinecartEntity> entityType, class_1937 world) {
        super(entityType, world);
    }

    public class_2680 method_7517() {
        return ModBlocks.WIND_TNT.method_9564();
    }

    public void method_5773() {
        double d;
        super.method_5773();
        if (this.fuseTicks > 0) {
            --this.fuseTicks;
            this.method_73183().method_8406((class_2394)class_2398.field_11251, this.method_23317(), this.method_23318() + 0.5, this.method_23321(), 0.0, 0.0, 0.0);
        } else if (this.fuseTicks == 0) {
            this.explode(this.damageSource, this.method_18798().method_37268());
        }
        if (this.field_5976 && (d = this.method_18798().method_37268()) >= (double)0.01f) {
            this.explode(this.damageSource, d);
        }
    }

    public boolean method_64397(class_3218 world, class_1282 source, float amount) {
        class_1665 persistentProjectileEntity;
        class_1297 entity = source.method_5526();
        if (entity instanceof class_1665 && (persistentProjectileEntity = (class_1665)entity).method_5809()) {
            class_1282 damageSource = this.method_48923().method_48819((class_1297)this, source.method_5529());
            this.explode(damageSource, persistentProjectileEntity.method_18798().method_1027());
        }
        return super.method_64397(world, source, amount);
    }

    public void method_7516(class_3218 world, class_1282 damageSource) {
        double d = this.method_18798().method_37268();
        if (!WindTntMinecartEntity.shouldDetonate(damageSource) && !(d >= (double)0.01f)) {
            this.method_54298(world, this.method_7557());
        } else if (this.fuseTicks < 0) {
            this.prime(damageSource);
            this.fuseTicks = this.field_5974.method_43048(20) + this.field_5974.method_43048(20);
        }
    }

    public class_1269 method_5688(class_1657 player, class_1268 hand) {
        if (player.method_5998(hand).method_7909() == class_1802.field_8868) {
            if (this.fuseTicks > -1) {
                this.method_73183().method_43128(null, this.method_23317(), this.method_23318(), this.method_23321(), class_3417.field_14975, class_3419.field_15245, 1.0f, 1.0f);
                this.fuseTicks = -1;
                this.damageSource = null;
                this.method_73183().method_8421((class_1297)this, (byte)100);
                if (!player.method_68878()) {
                    player.method_5998(player.method_6058()).method_61653(1, player);
                }
                return class_1269.field_5812;
            }
        } else if ((player.method_5998(hand).method_7909() == class_1802.field_8884 || player.method_5998(hand).method_7909() == class_1802.field_8814) && this.fuseTicks == -1 && !this.method_73183().method_8608() && this.method_73183().method_8503().method_3767().method_8355(ModGameRules.WIND_TNT_EXPLODES)) {
            this.prime(null);
            if (!player.method_68878()) {
                if (player.method_5998(hand).method_7909() == class_1802.field_8884) {
                    player.method_5998(player.method_6058()).method_61653(1, player);
                } else {
                    player.method_5998(player.method_6058()).method_7934(1);
                }
            }
        }
        if ((player.method_5998(hand).method_7909() == class_1802.field_8884 || player.method_5998(hand).method_7909() == class_1802.field_8814) && this.fuseTicks == -1) {
            return class_1269.field_5812;
        }
        return class_1269.field_5811;
    }

    protected class_1792 method_7557() {
        return ModItems.WIND_TNT_MINECART;
    }

    public class_1799 method_31480() {
        return new class_1799((class_1935)ModItems.WIND_TNT_MINECART);
    }

    public void explode(@Nullable class_1282 damageSource, double power) {
        class_1937 world = this.method_73183();
        if (world instanceof class_3218) {
            class_3218 serverWorld = (class_3218)world;
            if (serverWorld.method_64395().method_8355(ModGameRules.WIND_TNT_EXPLODES)) {
                double d2 = Math.min(Math.sqrt(power), 5.0);
                serverWorld.method_8454((class_1297)this, damageSource, EXPLOSION_BEHAVIOR, this.method_23317(), this.method_23318(), this.method_23321(), (float)((double)this.explosionPower + (double)this.explosionSpeedFactor * this.field_5974.method_43058() * 1.5 * d2), false, class_1937.class_7867.field_40891, (class_2394)class_2398.field_49139, (class_2394)class_2398.field_49140, class_6012.method_34990(), (class_6880)class_3417.field_49044);
                this.method_31472();
            } else if (this.isPrimed()) {
                this.method_31472();
            }
        }
    }

    public boolean method_5747(double fallDistance, float damagePerDistance, class_1282 damageSource) {
        if (fallDistance >= 3.0) {
            double d = fallDistance / 10.0;
            this.explode(this.damageSource, d * d);
        }
        return super.method_5747(fallDistance, damagePerDistance, damageSource);
    }

    public void method_7506(int x, int y, int z, boolean powered) {
        if (powered && this.fuseTicks < 0) {
            this.prime(null);
        }
    }

    public void method_5711(byte status) {
        if (status == 10) {
            this.prime(null);
        } else if (status == 100) {
            this.fuseTicks = -1;
        } else {
            super.method_5711(status);
        }
    }

    public void prime(@Nullable class_1282 source) {
        class_3218 serverWorld;
        class_1937 var3 = this.method_73183();
        if (var3 instanceof class_3218 && !(serverWorld = (class_3218)var3).method_64395().method_8355(ModGameRules.WIND_TNT_EXPLODES)) {
            return;
        }
        this.fuseTicks = 80;
        if (!this.method_73183().method_8608()) {
            if (source != null && this.damageSource == null) {
                this.damageSource = this.method_48923().method_48819((class_1297)this, source.method_5529());
            }
            this.method_73183().method_8421((class_1297)this, (byte)10);
            if (!this.method_5701()) {
                this.method_73183().method_43128((class_1297)null, this.method_23317(), this.method_23318(), this.method_23321(), class_3417.field_15079, class_3419.field_15245, 1.0f, 1.0f);
            }
        }
    }

    public int getFuseTicks() {
        return this.fuseTicks;
    }

    public boolean isPrimed() {
        return this.fuseTicks > -1;
    }

    public float method_5774(class_1927 explosion, class_1922 world, class_2338 pos, class_2680 blockState, class_3610 fluidState, float max) {
        return !this.isPrimed() || !blockState.method_26164(class_3481.field_15463) && !world.method_8320(pos.method_10084()).method_26164(class_3481.field_15463) ? super.method_5774(explosion, world, pos, blockState, fluidState, max) : 0.0f;
    }

    public boolean method_5853(class_1927 explosion, class_1922 world, class_2338 pos, class_2680 state, float explosionPower) {
        return !this.isPrimed() || !state.method_26164(class_3481.field_15463) && !world.method_8320(pos.method_10084()).method_26164(class_3481.field_15463) ? super.method_5853(explosion, world, pos, state, explosionPower) : false;
    }

    protected void method_5749(class_11368 view) {
        super.method_5749(view);
        this.fuseTicks = view.method_71424(FUSE_NBT_KEY, -1);
        this.explosionPower = class_3532.method_15363((float)view.method_71423(EXPLOSION_POWER_NBT_KEY, 4.0f), (float)0.0f, (float)128.0f);
        this.explosionSpeedFactor = class_3532.method_15363((float)view.method_71423(EXPLOSION_SPEED_FACTOR_NBT_KEY, 1.0f), (float)0.0f, (float)128.0f);
    }

    protected void method_5652(class_11372 view) {
        super.method_5652(view);
        view.method_71465(FUSE_NBT_KEY, this.fuseTicks);
        if (this.explosionPower != 4.0f) {
            view.method_71464(EXPLOSION_POWER_NBT_KEY, this.explosionPower);
        }
        if (this.explosionSpeedFactor != 1.0f) {
            view.method_71464(EXPLOSION_SPEED_FACTOR_NBT_KEY, this.explosionSpeedFactor);
        }
    }

    boolean method_55056(class_1282 source) {
        return WindTntMinecartEntity.shouldDetonate(source);
    }

    private static boolean shouldDetonate(class_1282 source) {
        class_1297 var2 = source.method_5526();
        if (var2 instanceof class_1676) {
            class_1676 projectileEntity = (class_1676)var2;
            return projectileEntity.method_5809();
        }
        return source.method_48789(class_8103.field_42246) || source.method_48789(class_8103.field_42249);
    }
}

