/*
 * Decompiled with CFR 0.152.
 */
package net.soulsandman.contentified;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.biome.v1.BiomeModifications;
import net.fabricmc.fabric.api.biome.v1.BiomeSelectors;
import net.fabricmc.fabric.api.biome.v1.ModificationPhase;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.entity.event.v1.ServerLivingEntityEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.event.player.AttackEntityCallback;
import net.fabricmc.fabric.api.event.player.PlayerBlockBreakEvents;
import net.fabricmc.fabric.api.event.player.UseBlockCallback;
import net.fabricmc.fabric.api.event.player.UseEntityCallback;
import net.fabricmc.fabric.api.event.player.UseItemCallback;
import net.fabricmc.fabric.api.loot.v3.LootTableEvents;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.object.builder.v1.trade.TradeOfferHelper;
import net.fabricmc.fabric.api.registry.CompostingChanceRegistry;
import net.fabricmc.fabric.api.registry.FabricBrewingRecipeRegistryBuilder;
import net.fabricmc.fabric.api.registry.OxidizableBlocksRegistry;
import net.fabricmc.fabric.api.registry.StrippableBlockRegistry;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.fabric.api.resource.ResourcePackActivationType;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_117;
import net.minecraft.class_11978;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1295;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1322;
import net.minecraft.class_1324;
import net.minecraft.class_141;
import net.minecraft.class_1429;
import net.minecraft.class_1531;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1847;
import net.minecraft.class_1914;
import net.minecraft.class_1928;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_1944;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_2396;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2746;
import net.minecraft.class_2902;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3264;
import net.minecraft.class_3481;
import net.minecraft.class_3489;
import net.minecraft.class_3730;
import net.minecraft.class_3853;
import net.minecraft.class_39;
import net.minecraft.class_44;
import net.minecraft.class_4663;
import net.minecraft.class_4719;
import net.minecraft.class_5134;
import net.minecraft.class_5321;
import net.minecraft.class_55;
import net.minecraft.class_5658;
import net.minecraft.class_5662;
import net.minecraft.class_7145;
import net.minecraft.class_77;
import net.minecraft.class_79;
import net.minecraft.class_7924;
import net.minecraft.class_8111;
import net.minecraft.class_8177;
import net.minecraft.class_8813;
import net.minecraft.class_9306;
import net.minecraft.server.MinecraftServer;
import net.soulsandman.contentified.block.ModBlockEntityTypes;
import net.soulsandman.contentified.block.ModBlocks;
import net.soulsandman.contentified.command.RenameCommand;
import net.soulsandman.contentified.effect.ModEffects;
import net.soulsandman.contentified.enchantment.ModEnchantmentEffects;
import net.soulsandman.contentified.entity.ModEntities;
import net.soulsandman.contentified.event.ModEvents;
import net.soulsandman.contentified.interfaces.IPhantomSign;
import net.soulsandman.contentified.item.ModArmorMaterials;
import net.soulsandman.contentified.item.ModConsumeEffects;
import net.soulsandman.contentified.item.ModItems;
import net.soulsandman.contentified.item.ModToolMaterial;
import net.soulsandman.contentified.item.ModVariantSpawnEggs;
import net.soulsandman.contentified.particle.ModParticles;
import net.soulsandman.contentified.particle.custom.packet.BeamParticlePacket;
import net.soulsandman.contentified.potion.ModPotions;
import net.soulsandman.contentified.screen.ModScreenHandlers;
import net.soulsandman.contentified.sound.ModSounds;
import net.soulsandman.contentified.util.ArmorStandPoseLoader;
import net.soulsandman.contentified.util.BedrockCauldronBehavior;
import net.soulsandman.contentified.util.BedrockCauldronBlocks;
import net.soulsandman.contentified.util.CauldronParticlePayload;
import net.soulsandman.contentified.util.EatParticlePayload;
import net.soulsandman.contentified.util.EndoriumUtils;
import net.soulsandman.contentified.util.ModComponents;
import net.soulsandman.contentified.util.ModDamageTypes;
import net.soulsandman.contentified.util.ModDispenserBehavior;
import net.soulsandman.contentified.util.ModGameRuleCategories;
import net.soulsandman.contentified.util.ModGameRules;
import net.soulsandman.contentified.util.ModProperties;
import net.soulsandman.contentified.util.ModTreeDecoratorTypes;
import net.soulsandman.contentified.util.SherdRegistry;
import net.soulsandman.contentified.world.ModConfiguredFeatures;
import net.soulsandman.contentified.world.decorator.FullTrunkVineTreeDecorator;
import net.soulsandman.contentified.world.decorator.UnderneathVineTreeDecorator;
import net.soulsandman.contentified.world.feature.ModFeatures;
import net.soulsandman.contentified.world.gen.ModWorldGeneration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Contentified
implements ModInitializer {
    public static final String MOD_ID = "contentified";
    public static final CauldronParticlePayload CAULDRON_PARTICLE_PAYLOAD = new CauldronParticlePayload();
    public static final EatParticlePayload EAT_PARTICLE_PAYLOAD = new EatParticlePayload();
    public static final class_2960 ORGANIZE_INVENTORY_PACKET_ID = class_2960.method_60655((String)"contentified", (String)"organize_inventory");
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"contentified");
    public static final class_2746 SHEARED = class_2746.method_11825((String)"sheared");
    public static final class_2746 SAFE_GUARD_PLACED = class_2746.method_11825((String)"safe_guard_placed");
    public static final class_4663<FullTrunkVineTreeDecorator> VINE_DECORATOR = class_4663.method_28895((String)"contentified:vinedecorator", FullTrunkVineTreeDecorator.CODEC);
    public static final class_5321<class_7145> MAZE_WORLD = class_5321.method_29179((class_5321)class_7924.field_41250, (class_2960)class_2960.method_60655((String)"contentified", (String)"maze_world"));
    public static final class_8177 WILLOW_BLOCKSET = class_8177.method_49233((class_8177)new class_8177("willow"));
    public static final class_4719 WILLOW = class_4719.method_24027((class_4719)new class_4719("willow", WILLOW_BLOCKSET));
    public static final class_8813 WILLOW_SAPLING_GENERATOR = new class_8813("willow", 0.0f, Optional.empty(), Optional.empty(), Optional.of(ModConfiguredFeatures.WILLOW_TREE_KEY), Optional.empty(), Optional.empty(), Optional.empty());
    private static final class_2960 MOVEMENT_SPEED_MODIFIER_UUID = class_2960.method_60656((String)"movement_speed");
    private static final class_2960 JUMP_STRENGTH_MODIFIER_UUID = class_2960.method_60656((String)"jump_strength");
    private long serverTickCounter = 0L;
    private static final int TICKS_PER_SECOND = 20;
    private static final int SPAWN_INTERVAL_SECONDS = 60;
    private static final int SPAWN_INTERVAL_TICKS = 1200;
    private final Random random = new Random();
    private final List<class_1299<? extends class_1308>> HOSTILE_MOBS = Arrays.asList(class_1299.field_6051, class_1299.field_6137, class_1299.field_6079, class_1299.field_6091, class_1299.field_6069, class_1299.field_6078);

    public void onInitialize() {
        ModItems.registerModItems();
        ModItems.registerModItemSettings();
        ModVariantSpawnEggs.registerModSpawnEggVariants();
        ModBlocks.registerModBlocks();
        ModEntities.registerModEntities();
        ModEffects.registerEffects();
        ModPotions.registerPotions();
        ModWorldGeneration.generateModWorldGen();
        ModSounds.registerSounds();
        ModDispenserBehavior.registerDispenserBehavior();
        ModConsumeEffects.registerModConsumeEffects();
        ModBlockEntityTypes.registerBlockEntityTypes();
        ModDamageTypes.registerModDamageTypes();
        ModParticles.registerParticles();
        ModComponents.registerComponents();
        ModEvents.registerModEvents();
        ModGameRuleCategories.registerGameRuleCategories();
        ModGameRules.registerGameRules();
        SherdRegistry.registerModSherds();
        ModProperties.registerModProperties();
        ModScreenHandlers.registerScreenHandlers();
        ModEnchantmentEffects.registerEnchantmentEffects();
        ModToolMaterial.registerModToolMaterials();
        ModArmorMaterials.registerModArmorMaterials();
        ModFeatures.registerModFeatures();
        StrippableBlockRegistry.register((class_2248)ModBlocks.WILLOW_LOG, (class_2248)ModBlocks.STRIPPED_WILLOW_LOG);
        StrippableBlockRegistry.register((class_2248)ModBlocks.WILLOW_WOOD, (class_2248)ModBlocks.STRIPPED_WILLOW_WOOD);
        OxidizableBlocksRegistry.registerOxidizableBlockPair((class_2248)ModBlocks.COPPER_TILES, (class_2248)ModBlocks.EXPOSED_COPPER_TILES);
        OxidizableBlocksRegistry.registerOxidizableBlockPair((class_2248)ModBlocks.EXPOSED_COPPER_TILES, (class_2248)ModBlocks.WEATHERED_COPPER_TILES);
        OxidizableBlocksRegistry.registerOxidizableBlockPair((class_2248)ModBlocks.WEATHERED_COPPER_TILES, (class_2248)ModBlocks.OXIDIZED_COPPER_TILES);
        OxidizableBlocksRegistry.registerWaxableBlockPair((class_2248)ModBlocks.COPPER_TILES, (class_2248)ModBlocks.WAXED_COPPER_TILES);
        OxidizableBlocksRegistry.registerWaxableBlockPair((class_2248)ModBlocks.EXPOSED_COPPER_TILES, (class_2248)ModBlocks.WAXED_EXPOSED_COPPER_TILES);
        OxidizableBlocksRegistry.registerWaxableBlockPair((class_2248)ModBlocks.WEATHERED_COPPER_TILES, (class_2248)ModBlocks.WAXED_WEATHERED_COPPER_TILES);
        OxidizableBlocksRegistry.registerWaxableBlockPair((class_2248)ModBlocks.OXIDIZED_COPPER_TILES, (class_2248)ModBlocks.WAXED_OXIDIZED_COPPER_TILES);
        OxidizableBlocksRegistry.registerOxidizableBlockPair((class_2248)ModBlocks.COPPER_MOSAIC, (class_2248)ModBlocks.EXPOSED_COPPER_MOSAIC);
        OxidizableBlocksRegistry.registerOxidizableBlockPair((class_2248)ModBlocks.EXPOSED_COPPER_MOSAIC, (class_2248)ModBlocks.WEATHERED_COPPER_MOSAIC);
        OxidizableBlocksRegistry.registerOxidizableBlockPair((class_2248)ModBlocks.WEATHERED_COPPER_MOSAIC, (class_2248)ModBlocks.OXIDIZED_COPPER_MOSAIC);
        OxidizableBlocksRegistry.registerWaxableBlockPair((class_2248)ModBlocks.COPPER_MOSAIC, (class_2248)ModBlocks.WAXED_COPPER_MOSAIC);
        OxidizableBlocksRegistry.registerWaxableBlockPair((class_2248)ModBlocks.EXPOSED_COPPER_MOSAIC, (class_2248)ModBlocks.WAXED_EXPOSED_COPPER_MOSAIC);
        OxidizableBlocksRegistry.registerWaxableBlockPair((class_2248)ModBlocks.WEATHERED_COPPER_MOSAIC, (class_2248)ModBlocks.WAXED_WEATHERED_COPPER_MOSAIC);
        OxidizableBlocksRegistry.registerWaxableBlockPair((class_2248)ModBlocks.OXIDIZED_COPPER_MOSAIC, (class_2248)ModBlocks.WAXED_OXIDIZED_COPPER_MOSAIC);
        OxidizableBlocksRegistry.registerOxidizableBlockPair((class_2248)ModBlocks.HUMAN_WEIGHTED_PRESSURE_PLATE, (class_2248)ModBlocks.EXPOSED_HUMAN_WEIGHTED_PRESSURE_PLATE);
        OxidizableBlocksRegistry.registerOxidizableBlockPair((class_2248)ModBlocks.EXPOSED_HUMAN_WEIGHTED_PRESSURE_PLATE, (class_2248)ModBlocks.WEATHERED_HUMAN_WEIGHTED_PRESSURE_PLATE);
        OxidizableBlocksRegistry.registerOxidizableBlockPair((class_2248)ModBlocks.WEATHERED_HUMAN_WEIGHTED_PRESSURE_PLATE, (class_2248)ModBlocks.OXIDIZED_HUMAN_WEIGHTED_PRESSURE_PLATE);
        OxidizableBlocksRegistry.registerWaxableBlockPair((class_2248)ModBlocks.HUMAN_WEIGHTED_PRESSURE_PLATE, (class_2248)ModBlocks.WAXED_HUMAN_WEIGHTED_PRESSURE_PLATE);
        OxidizableBlocksRegistry.registerWaxableBlockPair((class_2248)ModBlocks.EXPOSED_HUMAN_WEIGHTED_PRESSURE_PLATE, (class_2248)ModBlocks.WAXED_EXPOSED_HUMAN_WEIGHTED_PRESSURE_PLATE);
        OxidizableBlocksRegistry.registerWaxableBlockPair((class_2248)ModBlocks.WEATHERED_HUMAN_WEIGHTED_PRESSURE_PLATE, (class_2248)ModBlocks.WAXED_WEATHERED_HUMAN_WEIGHTED_PRESSURE_PLATE);
        OxidizableBlocksRegistry.registerWaxableBlockPair((class_2248)ModBlocks.OXIDIZED_HUMAN_WEIGHTED_PRESSURE_PLATE, (class_2248)ModBlocks.WAXED_OXIDIZED_HUMAN_WEIGHTED_PRESSURE_PLATE);
        OxidizableBlocksRegistry.registerOxidizableBlockPair((class_2248)ModBlocks.MOB_WEIGHTED_PRESSURE_PLATE, (class_2248)ModBlocks.EXPOSED_MOB_WEIGHTED_PRESSURE_PLATE);
        OxidizableBlocksRegistry.registerOxidizableBlockPair((class_2248)ModBlocks.EXPOSED_MOB_WEIGHTED_PRESSURE_PLATE, (class_2248)ModBlocks.WEATHERED_MOB_WEIGHTED_PRESSURE_PLATE);
        OxidizableBlocksRegistry.registerOxidizableBlockPair((class_2248)ModBlocks.WEATHERED_MOB_WEIGHTED_PRESSURE_PLATE, (class_2248)ModBlocks.OXIDIZED_MOB_WEIGHTED_PRESSURE_PLATE);
        OxidizableBlocksRegistry.registerWaxableBlockPair((class_2248)ModBlocks.MOB_WEIGHTED_PRESSURE_PLATE, (class_2248)ModBlocks.WAXED_MOB_WEIGHTED_PRESSURE_PLATE);
        OxidizableBlocksRegistry.registerWaxableBlockPair((class_2248)ModBlocks.EXPOSED_MOB_WEIGHTED_PRESSURE_PLATE, (class_2248)ModBlocks.WAXED_EXPOSED_MOB_WEIGHTED_PRESSURE_PLATE);
        OxidizableBlocksRegistry.registerWaxableBlockPair((class_2248)ModBlocks.WEATHERED_MOB_WEIGHTED_PRESSURE_PLATE, (class_2248)ModBlocks.WAXED_WEATHERED_MOB_WEIGHTED_PRESSURE_PLATE);
        OxidizableBlocksRegistry.registerWaxableBlockPair((class_2248)ModBlocks.OXIDIZED_MOB_WEIGHTED_PRESSURE_PLATE, (class_2248)ModBlocks.WAXED_OXIDIZED_MOB_WEIGHTED_PRESSURE_PLATE);
        OxidizableBlocksRegistry.registerOxidizableBlockPair((class_2248)ModBlocks.COPPER_LADDER, (class_2248)ModBlocks.EXPOSED_COPPER_LADDER);
        OxidizableBlocksRegistry.registerOxidizableBlockPair((class_2248)ModBlocks.EXPOSED_COPPER_LADDER, (class_2248)ModBlocks.WEATHERED_COPPER_LADDER);
        OxidizableBlocksRegistry.registerOxidizableBlockPair((class_2248)ModBlocks.WEATHERED_COPPER_LADDER, (class_2248)ModBlocks.OXIDIZED_COPPER_LADDER);
        OxidizableBlocksRegistry.registerWaxableBlockPair((class_2248)ModBlocks.COPPER_LADDER, (class_2248)ModBlocks.WAXED_COPPER_LADDER);
        OxidizableBlocksRegistry.registerWaxableBlockPair((class_2248)ModBlocks.EXPOSED_COPPER_LADDER, (class_2248)ModBlocks.WAXED_EXPOSED_COPPER_LADDER);
        OxidizableBlocksRegistry.registerWaxableBlockPair((class_2248)ModBlocks.WEATHERED_COPPER_LADDER, (class_2248)ModBlocks.WAXED_WEATHERED_COPPER_LADDER);
        OxidizableBlocksRegistry.registerWaxableBlockPair((class_2248)ModBlocks.OXIDIZED_COPPER_LADDER, (class_2248)ModBlocks.WAXED_OXIDIZED_COPPER_LADDER);
        ModTreeDecoratorTypes.UNDERNEATH_VINE = ModTreeDecoratorTypes.register("underneath_vine", UnderneathVineTreeDecorator.CODEC);
        CompostingChanceRegistry.INSTANCE.add((class_1935)ModBlocks.BEACHGRASS, (Object)Float.valueOf(0.5f));
        CompostingChanceRegistry.INSTANCE.add((class_1935)ModBlocks.THATCH, (Object)Float.valueOf(1.0f));
        CompostingChanceRegistry.INSTANCE.add((class_1935)ModBlocks.THATCH_STAIRS, (Object)Float.valueOf(1.0f));
        CompostingChanceRegistry.INSTANCE.add((class_1935)ModBlocks.THATCH_SLAB, (Object)Float.valueOf(1.0f));
        CompostingChanceRegistry.INSTANCE.add((class_1935)ModItems.BLUEBERRIES, (Object)Float.valueOf(0.15f));
        CompostingChanceRegistry.INSTANCE.add((class_1935)ModBlocks.CLOVERS, (Object)Float.valueOf(0.25f));
        CompostingChanceRegistry.INSTANCE.add((class_1935)ModBlocks.EYEVERS, (Object)Float.valueOf(0.25f));
        CompostingChanceRegistry.INSTANCE.add((class_1935)ModBlocks.DAFFODIL, (Object)Float.valueOf(0.25f));
        CompostingChanceRegistry.INSTANCE.add((class_1935)ModBlocks.ROSE, (Object)Float.valueOf(0.2f));
        CompostingChanceRegistry.INSTANCE.add((class_1935)ModBlocks.BLUE_ROSE, (Object)Float.valueOf(0.2f));
        CompostingChanceRegistry.INSTANCE.add((class_1935)ModBlocks.BUTTERFLY_BUSH, (Object)Float.valueOf(0.3f));
        CompostingChanceRegistry.INSTANCE.add((class_1935)ModBlocks.WILLOW_SAPLING, (Object)Float.valueOf(0.5f));
        CompostingChanceRegistry.INSTANCE.add((class_1935)class_1802.field_8635, (Object)Float.valueOf(0.35f));
        ResourceManagerHelper.get((class_3264)class_3264.field_14190).registerReloadListener((IdentifiableResourceReloadListener)new ArmorStandPoseLoader());
        RenameCommand.register();
        FabricBrewingRecipeRegistryBuilder.BUILD.register(builder -> {
            builder.method_59705(class_1847.field_8999, ModBlocks.CLOVERS.method_8389(), class_1847.field_8995);
            builder.method_59705(class_1847.field_8999, ModBlocks.EYEVERS.method_8389(), ModPotions.BAD_LUCK_POTION);
            builder.method_59705(class_1847.field_8999, class_1802.field_8511, ModPotions.HUNGER_POTION);
            builder.method_59705(class_1847.field_8999, ModItems.WITHER_ESSENCE, ModPotions.WITHER_POTION);
        });
        TradeOfferHelper.registerWanderingTraderOffers(factories -> factories.addOffersToPool(class_2960.method_60655((String)MOD_ID, (String)"emerald_for_xp"), new class_3853.class_1652[]{(entity, random) -> new class_1914(new class_9306((class_1935)class_1802.field_8687, 1), new class_1799((class_1935)class_1802.field_8287, 5), 7, 2, 0.04f)}));
        PayloadTypeRegistry.playS2C().register(CAULDRON_PARTICLE_PAYLOAD.method_56479(), CauldronParticlePayload.CODEC);
        BedrockCauldronBlocks.register();
        ServerLifecycleEvents.SERVER_STARTED.register(server -> BedrockCauldronBehavior.registerBehavior());
        PayloadTypeRegistry.playS2C().register(EAT_PARTICLE_PAYLOAD.method_56479(), EatParticlePayload.CODEC);
        PayloadTypeRegistry.playC2S().register(BeamParticlePacket.ID, BeamParticlePacket.CODEC);
        PayloadTypeRegistry.playS2C().register(BeamParticlePacket.ID, BeamParticlePacket.CODEC);
        BiomeModifications.create((class_2960)class_2960.method_60655((String)MOD_ID, (String)"end_water_tint")).add(ModificationPhase.ADDITIONS, BiomeSelectors.foundInTheEnd(), (context, mutable) -> {
            mutable.getEffects().setWaterColor(0xAA00FF);
            mutable.getEffects().setWaterFogColor(0x550066);
        });
        UseBlockCallback.EVENT.register((player, world, hand, hitResult) -> {
            class_2338 pos;
            class_1799 stack = player.method_5998(hand);
            if (stack.method_31574(class_1802.field_8613) && world.method_8320(pos = hitResult.method_17777().method_10093(hitResult.method_17780())).method_26215()) {
                class_1295 areaEffectCloudEntity = new class_1295(world, (double)hitResult.method_17777().method_10263(), (double)hitResult.method_17777().method_10264(), (double)hitResult.method_17777().method_10260());
                areaEffectCloudEntity.method_5608((class_2394)class_11978.method_74410((class_2396)class_2398.field_11216, (float)1.0f));
                areaEffectCloudEntity.method_5603(1.5f);
                areaEffectCloudEntity.method_5604(300);
                areaEffectCloudEntity.method_5596((3.0f - areaEffectCloudEntity.method_5599()) / (float)areaEffectCloudEntity.method_5605());
                areaEffectCloudEntity.method_66232(0.25f);
                areaEffectCloudEntity.method_5610(new class_1293(class_1294.field_5921, 1, 1));
                areaEffectCloudEntity.method_5814(hitResult.method_17784().method_10216(), hitResult.method_17784().method_10214(), hitResult.method_17784().method_10215());
                world.method_8649((class_1297)areaEffectCloudEntity);
                if (!player.method_68878()) {
                    stack.method_7934(1);
                    player.method_31548().method_7394(new class_1799((class_1935)class_1802.field_8469));
                }
                return class_1269.field_5812;
            }
            return class_1269.field_5811;
        });
        LootTableEvents.MODIFY.register((key, tableBuilder, source, registries) -> {
            if (key.equals(class_39.field_22402) && source.isBuiltin()) {
                tableBuilder.modifyPools(pool -> pool.method_351((class_79.class_80)class_77.method_411((class_1935)class_1802.field_22021).method_437(5).method_438((class_117.class_118)class_141.method_621((class_5658)class_5662.method_32462((float)1.0f, (float)3.0f)))));
            }
        });
        LootTableEvents.MODIFY.register((key, tableBuilder, source, registries) -> {
            if (key.equals(class_39.field_274) && source.isBuiltin()) {
                class_55.class_56 poolBuilder = class_55.method_347().method_352((class_5658)class_44.method_32448((float)1.0f)).method_351((class_79.class_80)class_77.method_411((class_1935)class_1802.field_22021).method_437(1).method_438((class_117.class_118)class_141.method_621((class_5658)class_5662.method_32462((float)0.0f, (float)2.0f)))).method_351((class_79.class_80)class_77.method_411((class_1935)ModItems.ENDORIUM_FRAGMENT).method_437(5).method_438((class_117.class_118)class_141.method_621((class_5658)class_5662.method_32462((float)1.0f, (float)3.0f)))).method_351((class_79.class_80)class_77.method_411((class_1935)ModItems.ENDORIUM_UPGRADE_SMITHING_TEMPLATE).method_437(25).method_438((class_117.class_118)class_141.method_621((class_5658)class_5662.method_32462((float)1.0f, (float)1.0f))));
                tableBuilder.method_336(poolBuilder);
            }
        });
        ModContainer yourModContainer = (ModContainer)FabricLoader.getInstance().getModContainer(MOD_ID).orElseThrow(() -> new RuntimeException("ModContainer for contentified not found!"));
        class_2960 programmerArtId = class_2960.method_60655((String)MOD_ID, (String)"contentified_programmer_art");
        boolean registered = ResourceManagerHelper.registerBuiltinResourcePack((class_2960)programmerArtId, (ModContainer)yourModContainer, (String)"Contentified Programmer Art", (ResourcePackActivationType)ResourcePackActivationType.NORMAL);
        if (registered) {
            LOGGER.info("Successfully registered Programmer Art resource pack!");
        } else {
            LOGGER.error("Failed to register Programmer Art resource pack!");
        }
        PlayerBlockBreakEvents.BEFORE.register((world, player, pos, state, blockEntity) -> {
            IPhantomSign phantomSign;
            if ((state.method_26164(class_3481.field_41282) || state.method_26164(class_3481.field_40105)) && blockEntity instanceof IPhantomSign && (phantomSign = (IPhantomSign)blockEntity).contentified$isPhantom()) {
                world.method_8649((class_1297)new class_1542(world, (double)((float)pos.method_10263() + 0.5f), (double)((float)pos.method_10264() + 0.5f), (double)((float)pos.method_10260() + 0.5f), class_1802.field_8614.method_7854()));
            }
            return true;
        });
        if (FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT) {
            ClientTickEvents.END_CLIENT_TICK.register(client -> {
                if (client.field_1687 == null) {
                    return;
                }
                for (class_1657 player : client.field_1687.method_18456()) {
                    if (!EndoriumUtils.isWearingFullEndoriumArmor((class_1309)player) || player.method_7325() || client.method_1493()) continue;
                    for (int i = 0; i < 1; ++i) {
                        if (!(Math.random() < 0.05)) continue;
                        client.field_1687.method_8406((class_2394)class_2398.field_11214, player.method_23322(0.5), player.method_23319() - 0.25, player.method_23325(0.5), (Math.random() - 0.5) * 2.0, -Math.random(), (Math.random() - 0.5) * 2.0);
                    }
                }
            });
        }
        UseEntityCallback.EVENT.register((player, world, hand, entity, hitResult) -> {
            class_1429 animal;
            if (world.method_8608()) {
                return class_1269.field_5811;
            }
            if (player.method_5998(hand).method_7909() == class_1802.field_8635 && entity instanceof class_1429 && (animal = (class_1429)entity).method_6109()) {
                animal.method_5614(Integer.MIN_VALUE);
                if (!player.method_68878()) {
                    player.method_5998(hand).method_7934(1);
                }
                animal.method_6475(player, hand, class_1802.field_8635.method_7854());
                LOGGER.info("Froze baby {} with a Poisonous Potato!", (Object)animal.method_5477().getString());
                return class_1269.field_5812;
            }
            return class_1269.field_5811;
        });
        AttackEntityCallback.EVENT.register((player, world, hand, entity, hitResult) -> {
            class_1657 targetPlayer;
            if (player.method_6047().method_7909() == ModItems.MINECRAFT_MOVIE_SWORD && entity instanceof class_1657 && (targetPlayer = (class_1657)entity).method_68878() && world instanceof class_3218) {
                class_3218 serverWorld = (class_3218)world;
                targetPlayer.method_5768(serverWorld);
                return class_1269.field_5812;
            }
            return class_1269.field_5811;
        });
        ServerLivingEntityEvents.AFTER_DEATH.register((entity, damageSource) -> {
            class_3218 world;
            if (entity.method_73183() instanceof class_3218 && (world = (class_3218)entity.method_73183()).method_64395().method_8355(ModGameRules.CHALLENGE_DEATH_DETONATIONS) && entity instanceof class_1309) {
                if (entity instanceof class_1531) {
                    return;
                }
                double x = entity.method_23317();
                double y = entity.method_23318();
                double z = entity.method_23321();
                world.method_55117(null, damageSource, null, x, y, z, 2.0f, false, class_1937.class_7867.field_40890);
            }
        });
        PlayerBlockBreakEvents.AFTER.register((world, player, pos, state, blockEntity) -> {
            if (world.method_8503().method_3767().method_8355(ModGameRules.CHALLENGE_HURTFUL_BLOCKS)) {
                float damageAmount = 1.0f;
                player.method_64397((class_3218)player.method_73183(), player.method_73183().method_48963().method_48831(), damageAmount);
            }
        });
        ServerTickEvents.END_SERVER_TICK.register(this::onServerTickZombieChallenge);
        ServerTickEvents.END_SERVER_TICK.register(server -> {
            if (server.method_3767().method_8355(ModGameRules.CHALLENGE_SNEAK_ATTACK)) {
                this.handleMobSpawnChallenge(server);
            }
        });
        ServerTickEvents.START_SERVER_TICK.register(this::onServerTickNoSprintChallenge);
        ServerTickEvents.END_SERVER_TICK.register(server -> this.onServerTickSlowerSpeedWithItems(server));
        ServerTickEvents.END_SERVER_TICK.register(server -> {
            if (server.method_3767().method_8355(ModGameRules.CHALLENGE_DARKNESS_FALLS_ACROSS_THE_LAND)) {
                Objects.requireNonNull(server.method_3847(class_1937.field_25179)).method_29199(18000L);
            }
        });
        ServerLivingEntityEvents.AFTER_DEATH.register((entity, damageSource) -> {
            class_1937 world = entity.method_73183();
            if (!(world instanceof class_3218)) {
                return;
            }
            class_3218 serverWorld = (class_3218)world;
            if (!serverWorld.method_64395().method_8355(ModGameRules.CHALLENGE_SPLIT_DECISION)) {
                return;
            }
            if (!(entity instanceof class_1308)) {
                return;
            }
            class_1308 mob = (class_1308)entity;
            if (mob.method_6109()) {
                return;
            }
            Random random = new Random();
            if (random.nextDouble() >= 0.15) {
                return;
            }
            class_1299 type = mob.method_5864();
            for (int i = 0; i < 2; ++i) {
                class_1309 newEntity = (class_1309)type.method_5883((class_1937)serverWorld, class_3730.field_16467);
                if (newEntity == null) continue;
                newEntity.method_5808(mob.method_23317() + (serverWorld.field_9229.method_43058() - 0.5), mob.method_23318(), mob.method_23321() + (serverWorld.field_9229.method_43058() - 0.5), mob.method_36454(), 0.0f);
                float newMaxHealth = mob.method_6063() / 2.0f;
                newEntity.method_5996(class_5134.field_23716).method_6192(Math.max(1.0, (double)newMaxHealth));
                newEntity.method_6033((float)Math.max(1.0, (double)newMaxHealth));
                serverWorld.method_8649((class_1297)newEntity);
            }
        });
        UseItemCallback.EVENT.register((player, world, hand) -> {
            if (!world.field_9236) {
                class_1799 stack = player.method_5998(hand);
                if (player.method_73183().method_8503().method_3767().method_8355(ModGameRules.CHALLENGE_VEGAN_MODE) && player.method_7344().method_7587() && Contentified.isMeat(stack)) {
                    player.method_5768((class_3218)world);
                }
            }
            return class_1269.field_5811;
        });
        ServerTickEvents.END_WORLD_TICK.register(world -> {
            if (!world.method_8503().method_3767().method_8355(ModGameRules.CHALLENGE_VEGAN_MODE)) {
                return;
            }
            for (class_1309 entity : world.method_8390(class_1309.class, new class_238(world.method_74854().method_74897()).method_1014(30000.0), e -> true)) {
                int skyLight;
                class_2338 pos = entity.method_24515();
                int light = world.method_8314(class_1944.field_9282, pos);
                int totalLight = Math.max(light, skyLight = world.method_8314(class_1944.field_9284, pos));
                if (totalLight == 0) {
                    if (entity.method_5767()) continue;
                    entity.method_5648(true);
                    continue;
                }
                if (!entity.method_5767()) continue;
                entity.method_5648(false);
            }
        });
        ServerLivingEntityEvents.ALLOW_DAMAGE.register((entity, source, amount) -> {
            class_3222 player;
            if (entity instanceof class_3222 && (player = (class_3222)entity).method_51469().method_64395().method_8355(ModGameRules.CHALLENGE_GLASS_BONES) && source.method_49708(class_8111.field_42345)) {
                player.method_5768(player.method_51469());
                return false;
            }
            return true;
        });
    }

    private static boolean isMeat(class_1799 stack) {
        return stack.method_31573(class_3489.field_49932);
    }

    private void onServerTickSlowerSpeedWithItems(MinecraftServer server) {
        boolean isEnabled = server.method_3767().method_8355(ModGameRules.CHALLENGE_WEIGHT_OF_THE_WORLD);
        if (!isEnabled) {
            for (class_3222 player : server.method_3760().method_14571()) {
                class_1324 jumpAttribute;
                class_1324 speedAttribute = player.method_5996(class_5134.field_23719);
                if (speedAttribute != null && speedAttribute.method_6196(MOVEMENT_SPEED_MODIFIER_UUID)) {
                    speedAttribute.method_6200(MOVEMENT_SPEED_MODIFIER_UUID);
                }
                if ((jumpAttribute = player.method_5996(class_5134.field_23728)) == null || !jumpAttribute.method_6196(JUMP_STRENGTH_MODIFIER_UUID)) continue;
                jumpAttribute.method_6200(JUMP_STRENGTH_MODIFIER_UUID);
            }
            return;
        }
        for (class_3222 player : server.method_3760().method_14571()) {
            class_1324 jumpAttribute;
            long stackCount = player.method_31548().method_67533().stream().filter(stack -> !stack.method_7960()).count();
            double penalty = Math.floor((double)stackCount / 3.0) * -0.05;
            class_1324 speedAttribute = player.method_5996(class_5134.field_23719);
            if (speedAttribute != null) {
                if (speedAttribute.method_6196(MOVEMENT_SPEED_MODIFIER_UUID)) {
                    speedAttribute.method_6200(MOVEMENT_SPEED_MODIFIER_UUID);
                }
                if (penalty < 0.0) {
                    class_1322 speedModifier = new class_1322(MOVEMENT_SPEED_MODIFIER_UUID, penalty, class_1322.class_1323.field_6330);
                    speedAttribute.method_26837(speedModifier);
                }
            }
            if ((jumpAttribute = player.method_5996(class_5134.field_23728)) != null) {
                if (jumpAttribute.method_6196(JUMP_STRENGTH_MODIFIER_UUID)) {
                    jumpAttribute.method_6200(JUMP_STRENGTH_MODIFIER_UUID);
                }
                if (penalty < 0.0) {
                    class_1322 jumpModifier = new class_1322(JUMP_STRENGTH_MODIFIER_UUID, penalty, class_1322.class_1323.field_6330);
                    jumpAttribute.method_26837(jumpModifier);
                }
            }
            if (!(penalty < 0.0)) continue;
        }
    }

    private void onServerTickZombieChallenge(MinecraftServer server) {
        for (class_3218 world : server.method_3738()) {
            class_1928 gameRules = world.method_64395();
            if (!gameRules.method_8355(ModGameRules.CHALLENGE_FLESH_OF_A_ZOMBIE) || !world.method_8530()) continue;
            for (class_1657 player : world.method_18456()) {
                class_2338 playerPos = player.method_24515();
                if (!world.method_8311(playerPos.method_10084()) || player.method_55667().method_27852(class_2246.field_10382) || player.method_5809() || player.method_6118(class_1304.field_6169).method_31573(class_3489.field_48297)) continue;
                player.method_5639(4.0f);
            }
        }
    }

    private void onServerTickNoSprintChallenge(MinecraftServer server) {
        if (server.method_3767().method_8355(ModGameRules.CHALLENGE_INJURED_LEGS)) {
            for (class_3222 player : server.method_3760().method_14571()) {
                if (!player.method_5624()) continue;
                player.method_64397(player.method_51469(), player.method_51469().method_48963().method_48831(), 1.0f);
            }
        }
    }

    public static void handleRecoilDamage(class_1309 livingEntity, class_1282 damageSource, float originalDamage) {
        if (livingEntity.method_73183().method_8608() || !livingEntity.method_73183().method_8503().method_3847(class_1937.field_25179).method_64395().method_8355(ModGameRules.CHALLENGE_REVERSE_DAMAGE)) {
            return;
        }
        class_1297 class_12972 = damageSource.method_5529();
        if (class_12972 instanceof class_1657) {
            class_1657 player = (class_1657)class_12972;
            if (!Objects.equals(livingEntity.method_5667(), player.method_5667())) {
                float reverseDamageAmount = originalDamage * 0.5f;
                if (reverseDamageAmount <= 0.0f) {
                    return;
                }
                class_1282 playerDamageSource = player.method_73183().method_48963().method_48831();
                player.method_64397((class_3218)livingEntity.method_73183(), playerDamageSource, reverseDamageAmount);
            }
        }
    }

    private void handleMobSpawnChallenge(MinecraftServer server) {
        ++this.serverTickCounter;
        if (this.serverTickCounter % 1200L == 0L) {
            this.spawnRandomHostileMob(server);
        }
    }

    private void spawnRandomHostileMob(MinecraftServer server) {
        if (this.HOSTILE_MOBS.isEmpty()) {
            System.out.println("No hostile mobs defined for spawning!");
            return;
        }
        for (class_3222 player : server.method_3760().method_14571()) {
            class_1308 mob;
            class_3218 world = player.method_51469().method_8503().method_30002();
            class_1299<? extends class_1308> chosenMobType = this.HOSTILE_MOBS.get(this.random.nextInt(this.HOSTILE_MOBS.size()));
            class_2338 playerPos = player.method_24515();
            class_243 spawnPos = this.findSafeSpawnPosition(world, playerPos);
            if (spawnPos == null || (mob = (class_1308)chosenMobType.method_5883((class_1937)world, class_3730.field_16467)) == null) continue;
            mob.method_5808(spawnPos.method_10216(), spawnPos.method_10214(), spawnPos.method_10215(), this.random.nextFloat() * 360.0f, 0.0f);
            world.method_8649((class_1297)mob);
        }
    }

    private class_243 findSafeSpawnPosition(class_3218 world, class_2338 playerPos) {
        for (int i = 0; i < 10; ++i) {
            int xOffset = this.random.nextInt(10) - 5;
            int zOffset = this.random.nextInt(10) - 5;
            class_2338 potentialSpawnPos = playerPos.method_10069(xOffset, 0, zOffset);
            if (!world.method_8320((potentialSpawnPos = world.method_8598(class_2902.class_2903.field_13203, potentialSpawnPos)).method_10074()).method_51367() || !world.method_22347(potentialSpawnPos) || !world.method_22347(potentialSpawnPos.method_10084())) continue;
            return class_243.method_24955((class_2382)potentialSpawnPos);
        }
        return null;
    }
}

