/*
 * Decompiled with CFR 0.152.
 */
package org.stepan.audio_disc.api;

public class AudioModification {
    private final boolean modified;
    private final byte[] modifiedData;
    private final float volumeMultiplier;
    private final boolean cancelled;

    private AudioModification(boolean modified, byte[] modifiedData, float volumeMultiplier, boolean cancelled) {
        this.modified = modified;
        this.modifiedData = modifiedData;
        this.volumeMultiplier = volumeMultiplier;
        this.cancelled = cancelled;
    }

    public static AudioModification noChange() {
        return new AudioModification(false, null, 1.0f, false);
    }

    public static AudioModification withModifiedData(byte[] modifiedData) {
        return new AudioModification(true, modifiedData, 1.0f, false);
    }

    public static AudioModification withVolume(float volumeMultiplier) {
        return new AudioModification(true, null, volumeMultiplier, false);
    }

    public static AudioModification cancel() {
        return new AudioModification(false, null, 1.0f, true);
    }

    public boolean isModified() {
        return this.modified;
    }

    public byte[] getModifiedData() {
        return this.modifiedData;
    }

    public float getVolumeMultiplier() {
        return this.volumeMultiplier;
    }

    public boolean isCancelled() {
        return this.cancelled;
    }
}

