/*
 * Decompiled with CFR 0.152.
 */
package org.stepan.audio_disc.api.example;

import net.minecraft.class_2338;
import net.minecraft.class_3218;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.stepan.audio_disc.api.AudioPacketEvent;
import org.stepan.audio_disc.api.AudioStreamListener;

public class ExampleStreamListener
implements AudioStreamListener {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"AudioDisc-Example");
    private int packetCount = 0;
    private long totalBytes = 0L;

    @Override
    public void onAudioPacket(AudioPacketEvent event) {
        ++this.packetCount;
        this.totalBytes += (long)event.getAudioData().length;
        if (this.packetCount % 50 == 0) {
            LOGGER.info("Received {} audio packets, total {} bytes from jukebox at {}", new Object[]{this.packetCount, this.totalBytes, event.getJukeboxPosition()});
            LOGGER.info("Current packet: {} bytes, sample rate: {} Hz, disc: {}", new Object[]{event.getAudioData().length, event.getSampleRate(), event.getDiscName()});
        }
    }

    @Override
    public void onStreamStart(class_3218 world, class_2338 jukeboxPos, String discName, String audioId) {
        LOGGER.info("=== Audio stream started ===");
        LOGGER.info("Position: {}", (Object)jukeboxPos);
        LOGGER.info("Disc: {}", (Object)discName);
        LOGGER.info("Audio ID: {}", (Object)audioId);
        LOGGER.info("World: {}", (Object)world.method_27983().method_29177());
        this.packetCount = 0;
        this.totalBytes = 0L;
    }

    @Override
    public void onStreamStop(class_3218 world, class_2338 jukeboxPos, String audioId) {
        LOGGER.info("=== Audio stream stopped ===");
        LOGGER.info("Position: {}", (Object)jukeboxPos);
        LOGGER.info("Audio ID: {}", (Object)audioId);
        LOGGER.info("Total packets received: {}", (Object)this.packetCount);
        LOGGER.info("Total bytes received: {}", (Object)this.totalBytes);
        if (this.packetCount > 0) {
            double avgPacketSize = (double)this.totalBytes / (double)this.packetCount;
            LOGGER.info("Average packet size: {:.2f} bytes", (Object)avgPacketSize);
        }
    }

    private void processAudio(byte[] audioData) {
        long sum = 0L;
        for (int i = 0; i < audioData.length - 1; i += 2) {
            short sample = (short)(audioData[i] & 0xFF | (audioData[i + 1] & 0xFF) << 8);
            sum += (long)(sample * sample);
        }
        int sampleCount = audioData.length / 2;
        if (sampleCount > 0) {
            double rms = Math.sqrt((double)sum / (double)sampleCount);
            double level = rms / 32768.0 * 100.0;
            if (this.packetCount % 100 == 0) {
                LOGGER.debug("Audio level: {:.1f}%", (Object)level);
            }
        }
    }
}

