/*
 * Decompiled with CFR 0.152.
 */
package org.stepan.audio_disc.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_7157;
import net.minecraft.class_9279;
import net.minecraft.class_9290;
import net.minecraft.class_9334;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.stepan.audio_disc.Audio_disc;
import org.stepan.audio_disc.api.AudioDiscAPIImpl;
import org.stepan.audio_disc.api.AudioUploadEvent;
import org.stepan.audio_disc.config.AudioDiscConfig;
import org.stepan.audio_disc.download.AudioDownloadManager;
import org.stepan.audio_disc.download.FFmpegManager;
import org.stepan.audio_disc.download.YtDlpManager;
import org.stepan.audio_disc.model.AudioData;
import org.stepan.audio_disc.model.AudioMetadata;
import org.stepan.audio_disc.model.ValidationResult;
import org.stepan.audio_disc.processing.AudioProcessor;
import org.stepan.audio_disc.storage.AudioStorageManager;
import org.stepan.audio_disc.util.Localization;
import org.stepan.audio_disc.util.RateLimiter;

public class AudioDiscCommand {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"AudioDisc");

    public static void register(CommandDispatcher<class_2168> dispatcher, class_7157 registryAccess, class_2170.class_5364 environment) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"audiodisc").then(class_2170.method_9247((String)"upload").then(class_2170.method_9244((String)"url", (ArgumentType)StringArgumentType.greedyString()).executes(context -> AudioDiscCommand.executeUpload((CommandContext<class_2168>)context, StringArgumentType.getString((CommandContext)context, (String)"url")))))).then(class_2170.method_9247((String)"youtube").then(class_2170.method_9244((String)"url", (ArgumentType)StringArgumentType.greedyString()).executes(context -> AudioDiscCommand.executeYouTube((CommandContext<class_2168>)context, StringArgumentType.getString((CommandContext)context, (String)"url")))))).then(class_2170.method_9247((String)"info").executes(AudioDiscCommand::executeInfo))).then(class_2170.method_9247((String)"clear").executes(AudioDiscCommand::executeClear))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"reload").requires(source -> source.method_9259(3))).executes(AudioDiscCommand::executeReload))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"lang").requires(source -> source.method_9259(3))).then(class_2170.method_9247((String)"create").then(class_2170.method_9244((String)"language", (ArgumentType)StringArgumentType.string()).executes(context -> AudioDiscCommand.executeCreateLang((CommandContext<class_2168>)context, StringArgumentType.getString((CommandContext)context, (String)"language")))))).then(class_2170.method_9247((String)"list").executes(AudioDiscCommand::executeListLang)))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"rename").then(class_2170.method_9247((String)"title").then(class_2170.method_9244((String)"title", (ArgumentType)StringArgumentType.greedyString()).executes(context -> AudioDiscCommand.executeRenameTitle((CommandContext<class_2168>)context, StringArgumentType.getString((CommandContext)context, (String)"title")))))).then(class_2170.method_9247((String)"lore").then(class_2170.method_9244((String)"lore", (ArgumentType)StringArgumentType.greedyString()).executes(context -> AudioDiscCommand.executeRenameLore((CommandContext<class_2168>)context, StringArgumentType.getString((CommandContext)context, (String)"lore")))))).then(class_2170.method_9247((String)"music_name").then(class_2170.method_9244((String)"music_name", (ArgumentType)StringArgumentType.greedyString()).executes(context -> AudioDiscCommand.executeRenameMusicName((CommandContext<class_2168>)context, StringArgumentType.getString((CommandContext)context, (String)"music_name"))))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"help").executes(AudioDiscCommand::executeHelp)).then(class_2170.method_9244((String)"command", (ArgumentType)StringArgumentType.word()).executes(context -> AudioDiscCommand.executeHelpCommand((CommandContext<class_2168>)context, StringArgumentType.getString((CommandContext)context, (String)"command"))))));
        LOGGER.info("Registered /audiodisc command");
    }

    private static int executeUpload(CommandContext<class_2168> context, String url) {
        RateLimiter.RateLimitResult limitResult;
        class_2168 source = (class_2168)context.getSource();
        if (!source.method_43737()) {
            source.method_9213((class_2561)class_2561.method_43470((String)"This command can only be executed by a player"));
            return 0;
        }
        class_3222 player = source.method_44023();
        if (player == null) {
            return 0;
        }
        if (!AudioDiscCommand.validateHeldItem(player)) {
            player.method_7353((class_2561)class_2561.method_43470((String)Localization.getForPlayer("command.upload.no_disc", player)), false);
            return 0;
        }
        if (url == null || url.trim().isEmpty()) {
            player.method_7353((class_2561)class_2561.method_43470((String)Localization.getForPlayer("command.upload.invalid_url", player)), false);
            return 0;
        }
        RateLimiter rateLimiter = Audio_disc.getRateLimiter();
        if (rateLimiter != null && !(limitResult = rateLimiter.checkLimit(player.method_5667())).isAllowed()) {
            player.method_7353((class_2561)class_2561.method_43470((String)Localization.formatForPlayer("command.upload.rate_limit", player, limitResult.getMessage())), false);
            return 0;
        }
        player.method_7353((class_2561)class_2561.method_43470((String)Localization.getForPlayer("command.upload.starting", player)), false);
        CompletableFuture.runAsync(() -> {
            try {
                AudioDiscCommand.processDirectUpload(player, url, player.method_6047());
            }
            catch (Exception e) {
                LOGGER.error("Error processing direct upload", (Throwable)e);
                player.method_7353((class_2561)class_2561.method_43470((String)("\u00a7c\u041e\u0448\u0438\u0431\u043a\u0430 \u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0438: " + e.getMessage())), false);
            }
        });
        return 1;
    }

    private static int executeYouTube(CommandContext<class_2168> context, String url) {
        class_2168 source = (class_2168)context.getSource();
        if (!source.method_43737()) {
            source.method_9213((class_2561)class_2561.method_43470((String)"This command can only be executed by a player"));
            return 0;
        }
        class_3222 player = source.method_44023();
        if (player == null) {
            return 0;
        }
        if (!AudioDiscCommand.validateHeldItem(player)) {
            player.method_7353((class_2561)class_2561.method_43470((String)Localization.getForPlayer("command.upload.no_disc", player)), false);
            return 0;
        }
        if (!AudioDiscCommand.isValidYouTubeUrl(url)) {
            player.method_7353((class_2561)class_2561.method_43470((String)Localization.getForPlayer("command.youtube.invalid_url", player)), false);
            player.method_7353((class_2561)class_2561.method_43470((String)Localization.getForPlayer("command.youtube.supported_formats", player)), false);
            return 0;
        }
        if (!YtDlpManager.isAvailable()) {
            player.method_7353((class_2561)class_2561.method_43470((String)Localization.getForPlayer("command.youtube.yt_dlp_required", player)), false);
            player.method_7353((class_2561)class_2561.method_43470((String)Localization.getForPlayer("command.youtube.use_direct", player)), false);
            return 0;
        }
        player.method_7353((class_2561)class_2561.method_43470((String)Localization.getForPlayer("command.youtube.starting", player)), false);
        player.method_7353((class_2561)class_2561.method_43470((String)("\u00a77URL: " + url)), false);
        CompletableFuture.runAsync(() -> {
            try {
                AudioDiscCommand.processYouTubeDownload(player, url, player.method_6047());
            }
            catch (Exception e) {
                LOGGER.error("Error processing YouTube download", (Throwable)e);
                player.method_7353((class_2561)class_2561.method_43470((String)("\u00a7c\u041e\u0448\u0438\u0431\u043a\u0430 \u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0438: " + e.getMessage())), false);
            }
        });
        return 1;
    }

    private static int executeInfo(CommandContext<class_2168> context) {
        class_2168 source = (class_2168)context.getSource();
        if (!source.method_43737()) {
            source.method_9213((class_2561)class_2561.method_43470((String)"This command can only be executed by a player"));
            return 0;
        }
        class_3222 player = source.method_44023();
        if (player == null) {
            return 0;
        }
        if (!AudioDiscCommand.validateHeldItem(player)) {
            player.method_7353((class_2561)class_2561.method_43470((String)Localization.getForPlayer("command.info.no_disc", player)), false);
            return 0;
        }
        try {
            AudioStorageManager storageManager = Audio_disc.getStorageManager();
            if (storageManager == null) {
                player.method_7353((class_2561)class_2561.method_43470((String)"\u00a7cError: Storage manager not initialized"), false);
                return 0;
            }
            class_1799 disc = player.method_6047();
            String audioId = storageManager.getDiscAudioId(disc).orElse(null);
            if (audioId == null) {
                player.method_7353((class_2561)class_2561.method_43470((String)Localization.getForPlayer("command.info.no_audio", player)), false);
                return 0;
            }
            Optional<AudioData> audioData = storageManager.getAudio(audioId);
            if (audioData.isEmpty()) {
                player.method_7353((class_2561)class_2561.method_43470((String)Localization.getForPlayer("command.info.no_audio", player)), false);
                return 0;
            }
            AudioData audio = audioData.get();
            AudioMetadata metadata = audio.getMetadata();
            player.method_7353((class_2561)class_2561.method_43470((String)Localization.getForPlayer("command.info.header", player)), false);
            player.method_7353((class_2561)class_2561.method_43470((String)Localization.formatForPlayer("command.info.id", player, audioId)), false);
            player.method_7353((class_2561)class_2561.method_43470((String)Localization.formatForPlayer("command.info.title", player, metadata.title())), false);
            player.method_7353((class_2561)class_2561.method_43470((String)Localization.formatForPlayer("command.info.format", player, metadata.format().toUpperCase())), false);
            if (metadata.duration() > 0L) {
                String duration = AudioDiscCommand.formatDuration(metadata.duration());
                player.method_7353((class_2561)class_2561.method_43470((String)Localization.formatForPlayer("command.info.duration", player, duration)), false);
            }
            if (metadata.bitrate() > 0) {
                player.method_7353((class_2561)class_2561.method_43470((String)Localization.formatForPlayer("command.info.bitrate", player, metadata.bitrate())), false);
            }
            if (metadata.sampleRate() > 0) {
                player.method_7353((class_2561)class_2561.method_43470((String)Localization.formatForPlayer("command.info.sample_rate", player, metadata.sampleRate())), false);
            }
            player.method_7353((class_2561)class_2561.method_43470((String)Localization.formatForPlayer("command.info.uploaded_by", player, audio.getUploadedBy())), false);
            player.method_7353((class_2561)class_2561.method_43470((String)Localization.formatForPlayer("command.info.file_size", player, AudioDiscCommand.formatFileSize(audio.getData().length))), false);
        }
        catch (Exception e) {
            LOGGER.error("Error getting disc info", (Throwable)e);
            player.method_7353((class_2561)class_2561.method_43470((String)("\u00a7cError getting disc information: " + e.getMessage())), false);
        }
        return 1;
    }

    private static int executeClear(CommandContext<class_2168> context) {
        class_2168 source = (class_2168)context.getSource();
        if (!source.method_43737()) {
            source.method_9213((class_2561)class_2561.method_43470((String)"This command can only be executed by a player"));
            return 0;
        }
        class_3222 player = source.method_44023();
        if (player == null) {
            return 0;
        }
        if (!AudioDiscCommand.validateHeldItem(player)) {
            player.method_7353((class_2561)class_2561.method_43470((String)Localization.getForPlayer("command.clear.no_disc", player)), false);
            return 0;
        }
        try {
            AudioStorageManager storageManager = Audio_disc.getStorageManager();
            if (storageManager == null) {
                player.method_7353((class_2561)class_2561.method_43470((String)"\u00a7cError: Storage manager not initialized"), false);
                return 0;
            }
            class_1799 disc = player.method_6047();
            String audioId = storageManager.getDiscAudioId(disc).orElse(null);
            if (audioId == null) {
                player.method_7353((class_2561)class_2561.method_43470((String)Localization.getForPlayer("command.clear.no_audio", player)), false);
                return 0;
            }
            storageManager.clearDiscAudio(disc);
            player.method_7353((class_2561)class_2561.method_43470((String)Localization.getForPlayer("command.clear.success", player)), false);
        }
        catch (Exception e) {
            LOGGER.error("Error clearing disc audio", (Throwable)e);
            player.method_7353((class_2561)class_2561.method_43470((String)Localization.formatForPlayer("command.clear.error", player, e.getMessage())), false);
        }
        return 1;
    }

    private static int executeReload(CommandContext<class_2168> context) {
        class_2168 source = (class_2168)context.getSource();
        try {
            Path configPath = FabricLoader.getInstance().getConfigDir().resolve("audiodisc").resolve("config.json");
            AudioDiscConfig newConfig = AudioDiscConfig.load(configPath);
            if (newConfig.validate()) {
                Audio_disc.updateConfig(newConfig);
                Localization.loadLanguage(newConfig.getLanguage());
                source.method_9226(() -> class_2561.method_43470((String)Localization.get("command.reload.success")), true);
            } else {
                source.method_9226(() -> class_2561.method_43470((String)Localization.get("command.reload.failed")), true);
            }
        }
        catch (Exception e) {
            LOGGER.error("Error reloading configuration", (Throwable)e);
            source.method_9226(() -> class_2561.method_43470((String)Localization.format("command.reload.failed", e.getMessage(), new Object[0])), true);
        }
        return 1;
    }

    private static int executeCreateLang(CommandContext<class_2168> context, String language) {
        class_2168 source = (class_2168)context.getSource();
        try {
            boolean success = Localization.createFullLanguageFile(language);
            if (success) {
                source.method_9226(() -> class_2561.method_43470((String)("\u00a7a\u0421\u043e\u0437\u0434\u0430\u043d \u0444\u0430\u0439\u043b \u043b\u043e\u043a\u0430\u043b\u0438\u0437\u0430\u0446\u0438\u0438 \u0434\u043b\u044f \u044f\u0437\u044b\u043a\u0430: " + language)), true);
                source.method_9226(() -> class_2561.method_43470((String)("\u00a77\u0424\u0430\u0439\u043b: config/audiodisc/lang/" + language.toLowerCase() + ".json")), false);
                source.method_9226(() -> class_2561.method_43470((String)"\u00a77\u041e\u0442\u0440\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u0443\u0439\u0442\u0435 \u0444\u0430\u0439\u043b \u0438 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0439\u0442\u0435 /audiodisc reload \u0434\u043b\u044f \u043f\u0440\u0438\u043c\u0435\u043d\u0435\u043d\u0438\u044f"), false);
            } else {
                source.method_9226(() -> class_2561.method_43470((String)("\u00a7c\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0441\u043e\u0437\u0434\u0430\u0442\u044c \u0444\u0430\u0439\u043b \u043b\u043e\u043a\u0430\u043b\u0438\u0437\u0430\u0446\u0438\u0438 \u0434\u043b\u044f \u044f\u0437\u044b\u043a\u0430: " + language)), true);
            }
        }
        catch (Exception e) {
            LOGGER.error("Error creating language file", (Throwable)e);
            source.method_9226(() -> class_2561.method_43470((String)("\u00a7c\u041e\u0448\u0438\u0431\u043a\u0430 \u0441\u043e\u0437\u0434\u0430\u043d\u0438\u044f \u0444\u0430\u0439\u043b\u0430 \u043b\u043e\u043a\u0430\u043b\u0438\u0437\u0430\u0446\u0438\u0438: " + e.getMessage())), true);
        }
        return 1;
    }

    private static int executeListLang(CommandContext<class_2168> context) {
        class_2168 source = (class_2168)context.getSource();
        try {
            Path langDir = FabricLoader.getInstance().getConfigDir().resolve("audiodisc").resolve("lang");
            source.method_9226(() -> class_2561.method_43470((String)"\u00a7a=== \u0424\u0430\u0439\u043b\u044b \u043b\u043e\u043a\u0430\u043b\u0438\u0437\u0430\u0446\u0438\u0438 ==="), false);
            source.method_9226(() -> class_2561.method_43470((String)"\u00a77\u0412\u0441\u0442\u0440\u043e\u0435\u043d\u043d\u044b\u0435 \u044f\u0437\u044b\u043a\u0438: ru_ru, en_us, fr_fr, de_de, es_es, zh_cn"), false);
            if (Files.exists(langDir, new LinkOption[0])) {
                source.method_9226(() -> class_2561.method_43470((String)"\u00a77\u041a\u0430\u0441\u0442\u043e\u043c\u043d\u044b\u0435 \u0444\u0430\u0439\u043b\u044b \u0432 config/audiodisc/lang/:"), false);
                Files.list(langDir).filter(path -> path.toString().endsWith(".json")).forEach(path -> {
                    String fileName = path.getFileName().toString();
                    String langCode = fileName.replace(".json", "");
                    source.method_9226(() -> class_2561.method_43470((String)("\u00a7f- " + langCode + " \u00a77(" + fileName + ")")), false);
                });
            } else {
                source.method_9226(() -> class_2561.method_43470((String)"\u00a77\u041a\u0430\u0441\u0442\u043e\u043c\u043d\u044b\u0445 \u0444\u0430\u0439\u043b\u043e\u0432 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u043e"), false);
            }
            source.method_9226(() -> class_2561.method_43470((String)"\u00a77\u0418\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0439\u0442\u0435 \u00a7f/audiodisc lang create <\u043a\u043e\u0434_\u044f\u0437\u044b\u043a\u0430> \u00a77\u0434\u043b\u044f \u0441\u043e\u0437\u0434\u0430\u043d\u0438\u044f"), false);
        }
        catch (Exception e) {
            LOGGER.error("Error listing language files", (Throwable)e);
            source.method_9226(() -> class_2561.method_43470((String)("\u00a7c\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u044f \u0441\u043f\u0438\u0441\u043a\u0430 \u0444\u0430\u0439\u043b\u043e\u0432: " + e.getMessage())), true);
        }
        return 1;
    }

    private static int executeRenameTitle(CommandContext<class_2168> context, String title) {
        class_2168 source = (class_2168)context.getSource();
        if (!source.method_43737()) {
            source.method_9213((class_2561)class_2561.method_43470((String)"This command can only be executed by a player"));
            return 0;
        }
        class_3222 player = source.method_44023();
        if (player == null) {
            return 0;
        }
        if (!AudioDiscCommand.validateHeldItem(player)) {
            player.method_7353((class_2561)class_2561.method_43470((String)Localization.getForPlayer("command.rename.no_disc", player)), false);
            return 0;
        }
        try {
            AudioStorageManager storageManager = Audio_disc.getStorageManager();
            if (storageManager == null) {
                player.method_7353((class_2561)class_2561.method_43470((String)"\u00a7cError: Storage manager not initialized"), false);
                return 0;
            }
            class_1799 disc = player.method_6047();
            String audioId = storageManager.getDiscAudioId(disc).orElse(null);
            if (audioId == null) {
                player.method_7353((class_2561)class_2561.method_43470((String)Localization.getForPlayer("command.rename.no_audio", player)), false);
                return 0;
            }
            disc.method_57379(class_9334.field_49631, (Object)class_2561.method_43470((String)title));
            player.method_7353((class_2561)class_2561.method_43470((String)Localization.formatForPlayer("command.rename.title_success", player, title)), false);
        }
        catch (Exception e) {
            LOGGER.error("Error renaming disc title", (Throwable)e);
            player.method_7353((class_2561)class_2561.method_43470((String)Localization.formatForPlayer("command.rename.error", player, e.getMessage())), false);
        }
        return 1;
    }

    private static int executeRenameLore(CommandContext<class_2168> context, String lore) {
        class_2168 source = (class_2168)context.getSource();
        if (!source.method_43737()) {
            source.method_9213((class_2561)class_2561.method_43470((String)"This command can only be executed by a player"));
            return 0;
        }
        class_3222 player = source.method_44023();
        if (player == null) {
            return 0;
        }
        if (!AudioDiscCommand.validateHeldItem(player)) {
            player.method_7353((class_2561)class_2561.method_43470((String)Localization.getForPlayer("command.rename.no_disc", player)), false);
            return 0;
        }
        try {
            AudioStorageManager storageManager = Audio_disc.getStorageManager();
            if (storageManager == null) {
                player.method_7353((class_2561)class_2561.method_43470((String)"\u00a7cError: Storage manager not initialized"), false);
                return 0;
            }
            class_1799 disc = player.method_6047();
            String audioId = storageManager.getDiscAudioId(disc).orElse(null);
            if (audioId == null) {
                player.method_7353((class_2561)class_2561.method_43470((String)Localization.getForPlayer("command.rename.no_audio", player)), false);
                return 0;
            }
            Object formattedLore = AudioDiscCommand.parseColorCodes(lore);
            if (!((String)formattedLore).startsWith("\u00a7")) {
                formattedLore = "\u00a7f" + (String)formattedLore;
            }
            class_9290 loreComponent = new class_9290(List.of(class_2561.method_43470((String)formattedLore)));
            disc.method_57379(class_9334.field_49632, (Object)loreComponent);
            player.method_7353((class_2561)class_2561.method_43470((String)Localization.formatForPlayer("command.rename.lore_success", player, AudioDiscCommand.stripColorCodes(lore))), false);
        }
        catch (Exception e) {
            LOGGER.error("Error setting disc lore", (Throwable)e);
            player.method_7353((class_2561)class_2561.method_43470((String)Localization.formatForPlayer("command.rename.error", player, e.getMessage())), false);
        }
        return 1;
    }

    private static int executeRenameMusicName(CommandContext<class_2168> context, String musicName) {
        class_2168 source = (class_2168)context.getSource();
        if (!source.method_43737()) {
            source.method_9213((class_2561)class_2561.method_43470((String)"This command can only be executed by a player"));
            return 0;
        }
        class_3222 player = source.method_44023();
        if (player == null) {
            return 0;
        }
        if (!AudioDiscCommand.validateHeldItem(player)) {
            player.method_7353((class_2561)class_2561.method_43470((String)Localization.getForPlayer("command.rename.no_disc", player)), false);
            return 0;
        }
        try {
            Optional metadataNbtOpt;
            class_2487 audioDiscNbt;
            Optional audioDiscNbtOpt;
            AudioStorageManager storageManager = Audio_disc.getStorageManager();
            if (storageManager == null) {
                player.method_7353((class_2561)class_2561.method_43470((String)"\u00a7cError: Storage manager not initialized"), false);
                return 0;
            }
            class_1799 disc = player.method_6047();
            String audioId = storageManager.getDiscAudioId(disc).orElse(null);
            if (audioId == null) {
                player.method_7353((class_2561)class_2561.method_43470((String)Localization.getForPlayer("command.rename.no_audio", player)), false);
                return 0;
            }
            class_9279 currentData = (class_9279)disc.method_58695(class_9334.field_49628, (Object)class_9279.field_49302);
            class_2487 rootNbt = currentData.method_57461();
            if (rootNbt.method_10545("audio_disc") && (audioDiscNbtOpt = rootNbt.method_10562("audio_disc")).isPresent() && (audioDiscNbt = (class_2487)audioDiscNbtOpt.get()).method_10545("metadata") && (metadataNbtOpt = audioDiscNbt.method_10562("metadata")).isPresent()) {
                class_2487 metadataNbt = (class_2487)metadataNbtOpt.get();
                metadataNbt.method_10582("title", musicName);
                audioDiscNbt.method_10566("metadata", (class_2520)metadataNbt);
                rootNbt.method_10566("audio_disc", (class_2520)audioDiscNbt);
                disc.method_57379(class_9334.field_49628, (Object)class_9279.method_57456((class_2487)rootNbt));
            }
            player.method_7353((class_2561)class_2561.method_43470((String)Localization.formatForPlayer("command.rename.music_name_success", player, musicName)), false);
        }
        catch (Exception e) {
            LOGGER.error("Error setting music name", (Throwable)e);
            player.method_7353((class_2561)class_2561.method_43470((String)Localization.formatForPlayer("command.rename.error", player, e.getMessage())), false);
        }
        return 1;
    }

    private static String parseColorCodes(String text) {
        if (text == null) {
            return "";
        }
        return text.replaceAll("&([0-9a-fk-or])", "\u00a7$1");
    }

    private static String stripColorCodes(String text) {
        if (text == null) {
            return "";
        }
        return text.replaceAll("[&\u00a7][0-9a-fk-or]", "");
    }

    private static int executeHelp(CommandContext<class_2168> context) {
        class_2168 source = (class_2168)context.getSource();
        if (!source.method_43737()) {
            source.method_9213((class_2561)class_2561.method_43470((String)"This command can only be executed by a player"));
            return 0;
        }
        class_3222 player = source.method_44023();
        if (player == null) {
            return 0;
        }
        player.method_7353((class_2561)class_2561.method_43470((String)Localization.getForPlayer("command.help.header", player)), false);
        player.method_7353((class_2561)class_2561.method_43470((String)Localization.getForPlayer("command.help.upload", player)), false);
        player.method_7353((class_2561)class_2561.method_43470((String)Localization.getForPlayer("command.help.youtube", player)), false);
        player.method_7353((class_2561)class_2561.method_43470((String)Localization.getForPlayer("command.help.rename", player)), false);
        player.method_7353((class_2561)class_2561.method_43470((String)Localization.getForPlayer("command.help.info", player)), false);
        player.method_7353((class_2561)class_2561.method_43470((String)Localization.getForPlayer("command.help.clear", player)), false);
        player.method_7353((class_2561)class_2561.method_43470((String)Localization.getForPlayer("command.help.help", player)), false);
        if (player.method_64475(3)) {
            player.method_7353((class_2561)class_2561.method_43470((String)Localization.getForPlayer("command.help.admin_header", player)), false);
            player.method_7353((class_2561)class_2561.method_43470((String)Localization.getForPlayer("command.help.reload", player)), false);
            player.method_7353((class_2561)class_2561.method_43470((String)Localization.getForPlayer("command.help.lang", player)), false);
        }
        player.method_7353((class_2561)class_2561.method_43470((String)Localization.getForPlayer("command.help.footer", player)), false);
        return 1;
    }

    private static int executeHelpCommand(CommandContext<class_2168> context, String command) {
        class_2168 source = (class_2168)context.getSource();
        if (!source.method_43737()) {
            source.method_9213((class_2561)class_2561.method_43470((String)"This command can only be executed by a player"));
            return 0;
        }
        class_3222 player = source.method_44023();
        if (player == null) {
            return 0;
        }
        String key = "command.help.detail." + command.toLowerCase();
        String helpText = Localization.getForPlayer(key, player);
        if (helpText.equals(key)) {
            player.method_7353((class_2561)class_2561.method_43470((String)Localization.formatForPlayer("command.help.unknown", player, command)), false);
            player.method_7353((class_2561)class_2561.method_43470((String)Localization.getForPlayer("command.help.use_help", player)), false);
            return 0;
        }
        player.method_7353((class_2561)class_2561.method_43470((String)helpText), false);
        return 1;
    }

    private static boolean isYtDlpAvailable() {
        return YtDlpManager.isAvailable();
    }

    private static void processDirectUpload(class_3222 player, String url, class_1799 disc) {
        try {
            LOGGER.info("Starting direct upload from URL: {}", (Object)url);
            if (!AudioDiscCommand.isValidUrl(url)) {
                player.method_7353((class_2561)class_2561.method_43470((String)Localization.getForPlayer("command.upload.url_protocol", player)), false);
                return;
            }
            AudioDownloadManager downloadManager = Audio_disc.getDownloadManager();
            AudioProcessor audioProcessor = Audio_disc.getAudioProcessor();
            AudioStorageManager storageManager = Audio_disc.getStorageManager();
            if (downloadManager == null || audioProcessor == null || storageManager == null) {
                player.method_7353((class_2561)class_2561.method_43470((String)Localization.getForPlayer("command.upload.system_error", player)), false);
                return;
            }
            ProgressTracker progressTracker = new ProgressTracker(player);
            progressTracker.setStage("downloading");
            CompletableFuture<byte[]> downloadFuture = downloadManager.downloadAudio(url, player.method_5667(), progress -> {
                if (progress % 10 == 0) {
                    progressTracker.updateProgress(progress / 4);
                }
            });
            ((CompletableFuture)downloadFuture.thenAccept(audioData -> {
                try {
                    if (audioData == null || ((byte[])audioData).length == 0) {
                        player.method_7353((class_2561)class_2561.method_43470((String)Localization.formatForPlayer("command.upload.download_failed", player, "File not found")), false);
                        return;
                    }
                    progressTracker.updateProgress(30);
                    ValidationResult validation = audioProcessor.validateFormat((byte[])audioData);
                    if (!validation.valid()) {
                        player.method_7353((class_2561)class_2561.method_43470((String)Localization.formatForPlayer("command.upload.error", player, validation.errorMessage())), false);
                        return;
                    }
                    progressTracker.setStage("processing");
                    progressTracker.updateProgress(50);
                    AudioMetadata metadata = audioProcessor.extractMetadata((byte[])audioData);
                    byte[] processedData = audioProcessor.processAudio((byte[])audioData);
                    progressTracker.setStage("saving");
                    progressTracker.updateProgress(80);
                    String audioId = storageManager.storeAudio(processedData, metadata, player.method_5477().getString());
                    storageManager.attachToDisc(disc, audioId);
                    progressTracker.updateProgress(100);
                    player.method_7353((class_2561)class_2561.method_43470((String)Localization.getForPlayer("command.upload.success", player)), false);
                    RateLimiter rateLimiter = Audio_disc.getRateLimiter();
                    if (rateLimiter != null) {
                        rateLimiter.recordUpload(player.method_5667());
                    }
                    AudioDiscAPIImpl.getInstance().fireAudioUploadEvent(new AudioUploadEvent(player, disc, audioId, metadata, System.currentTimeMillis()));
                }
                catch (Exception e) {
                    LOGGER.error("Error processing uploaded audio", (Throwable)e);
                    player.method_7353((class_2561)class_2561.method_43470((String)Localization.formatForPlayer("command.upload.error", player, e.getMessage())), false);
                }
            })).exceptionally(throwable -> {
                LOGGER.error("Error downloading audio", throwable);
                player.method_7353((class_2561)class_2561.method_43470((String)Localization.formatForPlayer("command.upload.download_failed", player, throwable.getMessage())), false);
                return null;
            });
        }
        catch (Exception e) {
            LOGGER.error("Direct upload failed", (Throwable)e);
            player.method_7353((class_2561)class_2561.method_43470((String)Localization.formatForPlayer("command.upload.download_failed", player, e.getMessage())), false);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void processYouTubeDownload(class_3222 player, String youtubeUrl, class_1799 disc) {
        try {
            RateLimiter rateLimiter;
            ValidationResult validation;
            File mp3File;
            ProcessBuilder pb;
            LOGGER.info("Starting YouTube download and conversion to MP3: {}", (Object)youtubeUrl);
            Path tempDir = FabricLoader.getInstance().getGameDir().resolve("temp_audio");
            if (!tempDir.toFile().exists()) {
                tempDir.toFile().mkdirs();
            }
            String videoId = AudioDiscCommand.extractVideoId(youtubeUrl);
            String outputFileName = videoId + ".mp3";
            Path outputFile = tempDir.resolve(outputFileName);
            String ytDlpPath = YtDlpManager.getExecutablePath();
            if (ytDlpPath == null) {
                player.method_7353((class_2561)class_2561.method_43470((String)"\u00a7c\u041e\u0448\u0438\u0431\u043a\u0430: yt-dlp \u043d\u0435\u0434\u043e\u0441\u0442\u0443\u043f\u0435\u043d"), false);
                return;
            }
            player.method_7353((class_2561)class_2561.method_43470((String)"\u00a77\u0421\u043a\u0430\u0447\u0438\u0432\u0430\u043d\u0438\u0435 \u0432\u0438\u0434\u0435\u043e \u0441 YouTube..."), false);
            boolean hasFFmpeg = AudioDiscCommand.isFFmpegAvailable();
            if (hasFFmpeg) {
                player.method_7353((class_2561)class_2561.method_43470((String)"\u00a77FFmpeg \u043d\u0430\u0439\u0434\u0435\u043d, \u043a\u043e\u043d\u0432\u0435\u0440\u0442\u0438\u0440\u0443\u0435\u043c \u0432 MP3..."), false);
                pb = new ProcessBuilder(ytDlpPath, "--extract-audio", "--audio-format", "mp3", "--audio-quality", "0", "--max-filesize", "50M", "--no-playlist", "--output", tempDir.resolve(videoId + ".%(ext)s").toString(), youtubeUrl);
            } else {
                player.method_7353((class_2561)class_2561.method_43470((String)"\u00a77FFmpeg \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d, \u0441\u043a\u0430\u0447\u0438\u0432\u0430\u0435\u043c \u0432 \u0438\u0441\u0445\u043e\u0434\u043d\u043e\u043c \u0444\u043e\u0440\u043c\u0430\u0442\u0435..."), false);
                pb = new ProcessBuilder(ytDlpPath, "--format", "bestaudio[ext=mp3]/bestaudio[ext=ogg]/bestaudio", "--max-filesize", "50M", "--no-playlist", "--output", tempDir.resolve(videoId + ".%(ext)s").toString(), youtubeUrl);
            }
            pb.directory(tempDir.toFile());
            pb.redirectErrorStream(true);
            Process process = pb.start();
            StringBuilder output = new StringBuilder();
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));){
                String line;
                while ((line = reader.readLine()) != null) {
                    output.append(line).append("\n");
                    LOGGER.debug("yt-dlp: {}", (Object)line);
                    if (!line.contains("[download]") || !line.contains("%")) continue;
                    try {
                        int progress;
                        String percent = line.substring(line.indexOf("]") + 1).trim();
                        if (!percent.contains("%") || !(percent = percent.substring(0, percent.indexOf("%")).trim()).matches("\\d+\\.\\d+") || (progress = (int)Double.parseDouble(percent)) % 25 != 0) continue;
                        player.method_7353((class_2561)class_2561.method_43470((String)("\u00a77\u041f\u0440\u043e\u0433\u0440\u0435\u0441\u0441: " + progress + "%")), false);
                    }
                    catch (Exception percent) {}
                }
            }
            int exitCode = process.waitFor();
            LOGGER.info("yt-dlp finished with exit code: {}", (Object)exitCode);
            if (output.length() > 0) {
                LOGGER.info("yt-dlp output:\n{}", (Object)output.toString());
            }
            boolean ffmpegMissing = false;
            if (exitCode != 0) {
                LOGGER.error("yt-dlp failed with exit code: {}", (Object)exitCode);
                String errorMsg = output.toString();
                if (errorMsg.contains("Sign in to confirm")) {
                    player.method_7353((class_2561)class_2561.method_43470((String)"\u00a7c\u041e\u0448\u0438\u0431\u043a\u0430: \u0432\u0438\u0434\u0435\u043e \u0442\u0440\u0435\u0431\u0443\u0435\u0442 \u0430\u0432\u0442\u043e\u0440\u0438\u0437\u0430\u0446\u0438\u0438"), false);
                    return;
                }
                if (errorMsg.contains("Video unavailable")) {
                    player.method_7353((class_2561)class_2561.method_43470((String)"\u00a7c\u041e\u0448\u0438\u0431\u043a\u0430: \u0432\u0438\u0434\u0435\u043e \u043d\u0435\u0434\u043e\u0441\u0442\u0443\u043f\u043d\u043e"), false);
                    return;
                }
                if (errorMsg.contains("Private video")) {
                    player.method_7353((class_2561)class_2561.method_43470((String)"\u00a7c\u041e\u0448\u0438\u0431\u043a\u0430: \u043f\u0440\u0438\u0432\u0430\u0442\u043d\u043e\u0435 \u0432\u0438\u0434\u0435\u043e"), false);
                    return;
                }
                if (!errorMsg.contains("ffmpeg not found") && !errorMsg.contains("ffprobe and ffmpeg not found")) {
                    player.method_7353((class_2561)class_2561.method_43470((String)"\u00a7c\u041e\u0448\u0438\u0431\u043a\u0430 \u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0438 \u0441 YouTube"), false);
                    player.method_7353((class_2561)class_2561.method_43470((String)"\u00a77\u041f\u0440\u043e\u0432\u0435\u0440\u044c\u0442\u0435 \u0441\u0441\u044b\u043b\u043a\u0443 \u0438 \u043f\u043e\u043f\u0440\u043e\u0431\u0443\u0439\u0442\u0435 \u0435\u0449\u0435 \u0440\u0430\u0437"), false);
                    return;
                }
                player.method_7353((class_2561)class_2561.method_43470((String)"\u00a7e\u0412\u043d\u0438\u043c\u0430\u043d\u0438\u0435: FFmpeg \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u0434\u043b\u044f \u043a\u043e\u043d\u0432\u0435\u0440\u0442\u0430\u0446\u0438\u0438 \u0432 MP3"), false);
                player.method_7353((class_2561)class_2561.method_43470((String)"\u00a77\u041f\u043e\u043f\u0440\u043e\u0431\u0443\u0435\u043c \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u044c \u0441\u043a\u0430\u0447\u0430\u043d\u043d\u044b\u0439 \u0444\u0430\u0439\u043b \u043d\u0430\u043f\u0440\u044f\u043c\u0443\u044e..."), false);
                ffmpegMissing = true;
            }
            if (!(mp3File = outputFile.toFile()).exists()) {
                File[] files = tempDir.toFile().listFiles((dir, name) -> name.startsWith(videoId) && (name.endsWith(".mp3") || name.endsWith(".m4a") || name.endsWith(".webm") || name.endsWith(".ogg")));
                if (files != null && files.length > 0) {
                    mp3File = files[0];
                    LOGGER.info("Found alternative audio file: {}", (Object)mp3File.getName());
                } else {
                    LOGGER.error("No audio file found after yt-dlp conversion");
                    player.method_7353((class_2561)class_2561.method_43470((String)"\u00a7c\u041e\u0448\u0438\u0431\u043a\u0430: \u043a\u043e\u043d\u0432\u0435\u0440\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u043d\u044b\u0439 \u0444\u0430\u0439\u043b \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d"), false);
                    return;
                }
            }
            LOGGER.info("Found audio file: {}", (Object)mp3File.getName());
            if (ffmpegMissing) {
                player.method_7353((class_2561)class_2561.method_43470((String)"\u00a7a\u0412\u0438\u0434\u0435\u043e \u0441\u043a\u0430\u0447\u0430\u043d\u043e! \u0418\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u043c \u0438\u0441\u0445\u043e\u0434\u043d\u044b\u0439 \u0444\u043e\u0440\u043c\u0430\u0442."), false);
                player.method_7353((class_2561)class_2561.method_43470((String)("\u00a77\u0424\u0430\u0439\u043b: " + mp3File.getName())), false);
            } else {
                player.method_7353((class_2561)class_2561.method_43470((String)"\u00a7a\u0412\u0438\u0434\u0435\u043e \u0441\u043a\u0430\u0447\u0430\u043d\u043e \u0438 \u043a\u043e\u043d\u0432\u0435\u0440\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u043e \u0432 MP3!"), false);
            }
            player.method_7353((class_2561)class_2561.method_43470((String)("\u00a77\u0420\u0430\u0437\u043c\u0435\u0440: " + AudioDiscCommand.formatFileSize(mp3File.length()))), false);
            byte[] audioData = Files.readAllBytes(mp3File.toPath());
            player.method_7353((class_2561)class_2561.method_43470((String)"\u00a77\u041e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0430 \u0430\u0443\u0434\u0438\u043e \u0447\u0435\u0440\u0435\u0437 \u0441\u0438\u0441\u0442\u0435\u043c\u0443 \u043c\u043e\u0434\u0430..."), false);
            AudioProcessor audioProcessor = Audio_disc.getAudioProcessor();
            AudioStorageManager storageManager = Audio_disc.getStorageManager();
            if (audioProcessor == null || storageManager == null) {
                player.method_7353((class_2561)class_2561.method_43470((String)"\u00a7c\u041e\u0448\u0438\u0431\u043a\u0430: \u0441\u0438\u0441\u0442\u0435\u043c\u044b \u043c\u043e\u0434\u0430 \u043d\u0435 \u0438\u043d\u0438\u0446\u0438\u0430\u043b\u0438\u0437\u0438\u0440\u043e\u0432\u0430\u043d\u044b"), false);
                return;
            }
            String fileExtension = AudioDiscCommand.getFileExtension(mp3File.getName());
            if ("webm".equals(fileExtension)) {
                File convertedFile;
                player.method_7353((class_2561)class_2561.method_43470((String)"\u00a7e\u0412\u043d\u0438\u043c\u0430\u043d\u0438\u0435: WebM \u0444\u043e\u0440\u043c\u0430\u0442 \u043e\u0431\u043d\u0430\u0440\u0443\u0436\u0435\u043d"), false);
                if (!AudioDiscCommand.isFFmpegAvailable()) {
                    player.method_7353((class_2561)class_2561.method_43470((String)"\u00a77FFmpeg \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d, \u043e\u0436\u0438\u0434\u0430\u0435\u043c \u0430\u0432\u0442\u043e\u043c\u0430\u0442\u0438\u0447\u0435\u0441\u043a\u043e\u0439 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043a\u0438..."), false);
                    boolean ffmpegReady = AudioDiscCommand.waitForFFmpeg(30);
                    if (!ffmpegReady) {
                        player.method_7353((class_2561)class_2561.method_43470((String)"\u00a7cFFmpeg \u043d\u0435 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u043b\u0441\u044f \u0432 \u0442\u0435\u0447\u0435\u043d\u0438\u0435 30 \u0441\u0435\u043a\u0443\u043d\u0434"), false);
                        player.method_7353((class_2561)class_2561.method_43470((String)"\u00a77WebM \u043d\u0435 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u0442\u0441\u044f \u0434\u043b\u044f \u0432\u043e\u0441\u043f\u0440\u043e\u0438\u0437\u0432\u0435\u0434\u0435\u043d\u0438\u044f"), false);
                        player.method_7353((class_2561)class_2561.method_43470((String)"\u00a77\u041f\u043e\u043f\u0440\u043e\u0431\u0443\u0439\u0442\u0435 \u043f\u043e\u0437\u0436\u0435 \u0438\u043b\u0438 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u0435 FFmpeg \u0432\u0440\u0443\u0447\u043d\u0443\u044e"), false);
                        return;
                    }
                    player.method_7353((class_2561)class_2561.method_43470((String)"\u00a7aFFmpeg \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d! \u041a\u043e\u043d\u0432\u0435\u0440\u0442\u0438\u0440\u0443\u0435\u043c WebM..."), false);
                }
                if ((convertedFile = AudioDiscCommand.tryConvertWebMToOgg(mp3File, tempDir)) == null) {
                    player.method_7353((class_2561)class_2561.method_43470((String)"\u00a7c\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043a\u043e\u043d\u0432\u0435\u0440\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c WebM"), false);
                    player.method_7353((class_2561)class_2561.method_43470((String)"\u00a77\u041f\u0440\u043e\u0432\u0435\u0440\u044c\u0442\u0435 \u043b\u043e\u0433\u0438 \u0441\u0435\u0440\u0432\u0435\u0440\u0430 \u0434\u043b\u044f \u043f\u043e\u0434\u0440\u043e\u0431\u043d\u043e\u0441\u0442\u0435\u0439"), false);
                    return;
                }
                player.method_7353((class_2561)class_2561.method_43470((String)"\u00a7aWebM \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u043a\u043e\u043d\u0432\u0435\u0440\u0442\u0438\u0440\u043e\u0432\u0430\u043d \u0432 MP3"), false);
                mp3File = convertedFile;
                audioData = Files.readAllBytes(mp3File.toPath());
            }
            if (!(validation = audioProcessor.validateFormat(audioData)).valid()) {
                player.method_7353((class_2561)class_2561.method_43470((String)("\u00a7c\u041e\u0448\u0438\u0431\u043a\u0430: " + validation.errorMessage())), false);
                return;
            }
            AudioMetadata metadata = audioProcessor.extractMetadata(audioData);
            byte[] processedData = audioProcessor.processAudio(audioData);
            String audioId = storageManager.storeAudio(processedData, metadata, player.method_5477().getString());
            storageManager.attachToDisc(disc, audioId);
            player.method_7353((class_2561)class_2561.method_43470((String)"\u00a7a\u2705 YouTube \u0430\u0443\u0434\u0438\u043e \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u0434\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u043e \u043d\u0430 \u0434\u0438\u0441\u043a!"), false);
            player.method_7353((class_2561)class_2561.method_43470((String)("\u00a77ID: " + audioId)), false);
            String title = AudioDiscCommand.extractVideoTitle(youtubeUrl, videoId);
            player.method_7353((class_2561)class_2561.method_43470((String)("\u00a77\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435: " + title)), false);
            if (metadata.duration() > 0L) {
                long durationSeconds = metadata.duration() / 1000L;
                long minutes = durationSeconds / 60L;
                long seconds = durationSeconds % 60L;
                player.method_7353((class_2561)class_2561.method_43470((String)String.format("\u00a77\u0414\u043b\u0438\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u044c: %d:%02d", minutes, seconds)), false);
            }
            if ((rateLimiter = Audio_disc.getRateLimiter()) != null) {
                rateLimiter.recordUpload(player.method_5667());
            }
            AudioDiscAPIImpl.getInstance().fireAudioUploadEvent(new AudioUploadEvent(player, disc, audioId, metadata, System.currentTimeMillis()));
            mp3File.delete();
            LOGGER.info("Cleaned up temporary file: {}", (Object)mp3File.getName());
            return;
        }
        catch (Exception e) {
            LOGGER.error("YouTube download and conversion failed", (Throwable)e);
            if (e.getMessage() != null) {
                if (!(e.getMessage().contains("Cannot run program") || e.getMessage().contains("CreateProcess error=2") || e.getMessage().contains("No such file or directory"))) {
                    player.method_7353((class_2561)class_2561.method_43470((String)("\u00a7c\u041e\u0448\u0438\u0431\u043a\u0430 \u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0438 \u0441 YouTube: " + e.getMessage())), false);
                    return;
                }
                player.method_7353((class_2561)class_2561.method_43470((String)"\u00a7c\u274c yt-dlp \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u0437\u0430\u043f\u0443\u0449\u0435\u043d!"), false);
                player.method_7353((class_2561)class_2561.method_43470((String)"\u00a77\u041f\u043e\u043f\u0440\u043e\u0431\u0443\u0439\u0442\u0435: \u00a7f/audiodisc ytdlp install"), false);
                return;
            }
            player.method_7353((class_2561)class_2561.method_43470((String)"\u00a7c\u041d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u0430\u044f \u043e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0435 \u0441 YouTube"), false);
        }
    }

    private static String extractVideoId(String url) {
        try {
            if (url.contains("youtu.be/")) {
                String id = url.substring(url.lastIndexOf("/") + 1);
                return (id = id.split("\\?")[0].split("#")[0]).isEmpty() ? "unknown" : id;
            }
            if (url.contains("watch?v=") || url.contains("watch&v=")) {
                String id = url.substring(url.indexOf("v=") + 2);
                return (id = id.split("&")[0].split("#")[0]).isEmpty() ? "unknown" : id;
            }
            if (url.contains("/embed/")) {
                String id = url.substring(url.indexOf("/embed/") + 7);
                return (id = id.split("\\?")[0].split("#")[0]).isEmpty() ? "unknown" : id;
            }
        }
        catch (Exception e) {
            LOGGER.warn("Failed to extract video ID from URL: {}", (Object)url, (Object)e);
        }
        return "video_" + System.currentTimeMillis();
    }

    private static boolean validateHeldItem(class_3222 player) {
        return AudioDiscCommand.isMusicDisc(player.method_6047());
    }

    private static boolean isMusicDisc(class_1799 stack) {
        if (stack.method_7960()) {
            return false;
        }
        return stack.method_7909() == class_1802.field_8144 || stack.method_7909() == class_1802.field_8075 || stack.method_7909() == class_1802.field_8425 || stack.method_7909() == class_1802.field_8623 || stack.method_7909() == class_1802.field_8502 || stack.method_7909() == class_1802.field_8534 || stack.method_7909() == class_1802.field_8344 || stack.method_7909() == class_1802.field_8834 || stack.method_7909() == class_1802.field_8355 || stack.method_7909() == class_1802.field_8731 || stack.method_7909() == class_1802.field_8806 || stack.method_7909() == class_1802.field_23984 || stack.method_7909() == class_1802.field_35358 || stack.method_7909() == class_1802.field_38973 || stack.method_7909() == class_1802.field_44705 || stack.method_7909() == class_1802.field_51628 || stack.method_7909() == class_1802.field_51629 || stack.method_7909() == class_1802.field_51630;
    }

    private static int executeYtDlpInstall(CommandContext<class_2168> context) {
        class_2168 source = (class_2168)context.getSource();
        if (YtDlpManager.isAvailable()) {
            source.method_9226(() -> class_2561.method_43470((String)"\u00a7ayt-dlp \u0443\u0436\u0435 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d \u0438 \u0434\u043e\u0441\u0442\u0443\u043f\u0435\u043d"), false);
            return 1;
        }
        source.method_9226(() -> class_2561.method_43470((String)"\u00a7e\u041d\u0430\u0447\u0438\u043d\u0430\u0435\u0442\u0441\u044f \u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0430 yt-dlp..."), false);
        YtDlpManager.downloadAndInstall().thenAccept(success -> {
            if (success.booleanValue()) {
                source.method_9226(() -> class_2561.method_43470((String)"\u00a7a\u2705 yt-dlp \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d!"), true);
            } else {
                source.method_9226(() -> class_2561.method_43470((String)"\u00a7c\u274c \u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c yt-dlp"), true);
            }
        });
        return 1;
    }

    private static int executeYtDlpUninstall(CommandContext<class_2168> context) {
        class_2168 source = (class_2168)context.getSource();
        boolean removed = YtDlpManager.uninstall();
        if (removed) {
            source.method_9226(() -> class_2561.method_43470((String)"\u00a7ayt-dlp \u0443\u0434\u0430\u043b\u0435\u043d \u0438\u0437 \u043c\u043e\u0434\u0430"), true);
        } else {
            source.method_9226(() -> class_2561.method_43470((String)"\u00a77\u041d\u0435\u0442 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u043d\u043e\u0433\u043e yt-dlp \u0434\u043b\u044f \u0443\u0434\u0430\u043b\u0435\u043d\u0438\u044f"), false);
        }
        return 1;
    }

    private static int executeYtDlpStatus(CommandContext<class_2168> context) {
        class_2168 source = (class_2168)context.getSource();
        source.method_9226(() -> class_2561.method_43470((String)"\u00a76=== yt-dlp Status ==="), false);
        if (YtDlpManager.isAvailable()) {
            String executablePath = YtDlpManager.getExecutablePath();
            source.method_9226(() -> class_2561.method_43470((String)"\u00a7a\u2705 yt-dlp \u0434\u043e\u0441\u0442\u0443\u043f\u0435\u043d"), false);
            source.method_9226(() -> class_2561.method_43470((String)("\u00a77\u041f\u0443\u0442\u044c: " + executablePath)), false);
            long size = YtDlpManager.getInstallationSize();
            if (size > 0L) {
                source.method_9226(() -> class_2561.method_43470((String)("\u00a77\u0420\u0430\u0437\u043c\u0435\u0440: " + AudioDiscCommand.formatFileSize(size))), false);
            }
        } else {
            source.method_9226(() -> class_2561.method_43470((String)"\u00a7c\u274c yt-dlp \u043d\u0435\u0434\u043e\u0441\u0442\u0443\u043f\u0435\u043d"), false);
            source.method_9226(() -> class_2561.method_43470((String)"\u00a77\u0418\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0439\u0442\u0435 \u00a7f/audiodisc ytdlp install \u00a77\u0434\u043b\u044f \u0430\u0432\u0442\u043e\u043c\u0430\u0442\u0438\u0447\u0435\u0441\u043a\u043e\u0439 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043a\u0438"), false);
        }
        return 1;
    }

    private static String extractVideoTitle(String youtubeUrl, String videoId) {
        return "YouTube Audio " + videoId;
    }

    private static String getFileExtension(String filename) {
        int lastDot = filename.lastIndexOf(46);
        if (lastDot > 0 && lastDot < filename.length() - 1) {
            return filename.substring(lastDot + 1).toLowerCase();
        }
        return "unknown";
    }

    private static String formatFileSize(long bytes) {
        if (bytes < 1024L) {
            return bytes + " B";
        }
        if (bytes < 0x100000L) {
            return String.format("%.1f KB", (double)bytes / 1024.0);
        }
        return String.format("%.1f MB", (double)bytes / 1048576.0);
    }

    private static String formatDuration(long durationMs) {
        long seconds = durationMs / 1000L;
        long minutes = seconds / 60L;
        return String.format("%d:%02d", minutes, seconds %= 60L);
    }

    private static File tryConvertM4AToOgg(File m4aFile, Path tempDir) {
        try {
            if (!AudioDiscCommand.isFFmpegAvailable()) {
                LOGGER.info("FFmpeg not available for M4A conversion");
                return null;
            }
            String baseName = m4aFile.getName().replaceAll("\\.[^.]+$", "");
            File oggFile = tempDir.resolve(baseName + ".mp3").toFile();
            LOGGER.info("Converting M4A to MP3 using FFmpeg: {} -> {}", (Object)m4aFile.getName(), (Object)oggFile.getName());
            String ffmpegPath = AudioDiscCommand.getFFmpegExecutablePath();
            if (ffmpegPath == null) {
                LOGGER.warn("FFmpeg executable not found");
                return null;
            }
            ProcessBuilder pb = new ProcessBuilder(ffmpegPath, "-i", m4aFile.getAbsolutePath(), "-c:a", "libmp3lame", "-b:a", "128k", "-y", oggFile.getAbsolutePath());
            pb.directory(tempDir.toFile());
            pb.redirectErrorStream(true);
            Process process = pb.start();
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));){
                String line;
                while ((line = reader.readLine()) != null) {
                    LOGGER.debug("FFmpeg: {}", (Object)line);
                }
            }
            int exitCode = process.waitFor();
            if (exitCode == 0 && oggFile.exists() && oggFile.length() > 0L) {
                LOGGER.info("Successfully converted M4A to MP3: {} bytes", (Object)oggFile.length());
                return oggFile;
            }
            LOGGER.warn("FFmpeg conversion failed with exit code: {}", (Object)exitCode);
            return null;
        }
        catch (Exception e) {
            LOGGER.warn("Failed to convert M4A to MP3: {}", (Object)e.getMessage());
            return null;
        }
    }

    private static boolean isValidUrl(String url) {
        if (url == null || url.trim().isEmpty()) {
            return false;
        }
        try {
            URL urlObj = new URL(url);
            String protocol = urlObj.getProtocol().toLowerCase();
            if (!protocol.equals("http") && !protocol.equals("https")) {
                return false;
            }
            String host = urlObj.getHost().toLowerCase();
            return !host.equals("localhost") && !host.equals("127.0.0.1") && !host.startsWith("192.168.") && !host.startsWith("10.") && !host.startsWith("172.16.") && !host.startsWith("172.17.") && !host.startsWith("172.18.") && !host.startsWith("172.19.") && !host.startsWith("172.20.") && !host.startsWith("172.21.") && !host.startsWith("172.22.") && !host.startsWith("172.23.") && !host.startsWith("172.24.") && !host.startsWith("172.25.") && !host.startsWith("172.26.") && !host.startsWith("172.27.") && !host.startsWith("172.28.") && !host.startsWith("172.29.") && !host.startsWith("172.30.") && !host.startsWith("172.31.");
        }
        catch (Exception e) {
            return false;
        }
    }

    private static boolean isValidYouTubeUrl(String url) {
        if (url == null || url.trim().isEmpty()) {
            return false;
        }
        return url.contains("youtube.com/watch") || url.contains("youtu.be/") || url.contains("youtube.com/embed/") || url.contains("m.youtube.com/watch");
    }

    private static File tryConvertWebMToOgg(File webmFile, Path tempDir) {
        try {
            if (!AudioDiscCommand.isFFmpegAvailable()) {
                LOGGER.info("FFmpeg not available for WebM conversion");
                return null;
            }
            String baseName = webmFile.getName().replaceAll("\\.[^.]+$", "");
            File oggFile = tempDir.resolve(baseName + ".mp3").toFile();
            LOGGER.info("Converting WebM to MP3 using FFmpeg: {} -> {}", (Object)webmFile.getName(), (Object)oggFile.getName());
            String ffmpegPath = AudioDiscCommand.getFFmpegExecutablePath();
            if (ffmpegPath == null) {
                LOGGER.warn("FFmpeg executable not found");
                return null;
            }
            ProcessBuilder pb = new ProcessBuilder(ffmpegPath, "-i", webmFile.getAbsolutePath(), "-c:a", "libmp3lame", "-b:a", "128k", "-y", oggFile.getAbsolutePath());
            pb.directory(tempDir.toFile());
            pb.redirectErrorStream(true);
            Process process = pb.start();
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));){
                String line;
                while ((line = reader.readLine()) != null) {
                    LOGGER.debug("FFmpeg: {}", (Object)line);
                }
            }
            int exitCode = process.waitFor();
            if (exitCode == 0 && oggFile.exists() && oggFile.length() > 0L) {
                LOGGER.info("Successfully converted WebM to MP3: {} bytes", (Object)oggFile.length());
                return oggFile;
            }
            LOGGER.warn("FFmpeg WebM conversion failed with exit code: {}", (Object)exitCode);
            return null;
        }
        catch (Exception e) {
            LOGGER.warn("Failed to convert WebM to MP3: {}", (Object)e.getMessage());
            return null;
        }
    }

    private static boolean isFFmpegAvailable() {
        if (FFmpegManager.isAvailable()) {
            return true;
        }
        try {
            ProcessBuilder pb = new ProcessBuilder("ffmpeg", "-version");
            Process process = pb.start();
            int exitCode = process.waitFor();
            return exitCode == 0;
        }
        catch (Exception e) {
            return false;
        }
    }

    private static String getFFmpegExecutablePath() {
        String path;
        if (FFmpegManager.isAvailable() && (path = FFmpegManager.getExecutablePath()) != null) {
            return path;
        }
        return "ffmpeg";
    }

    private static boolean waitForFFmpeg(int timeoutSeconds) {
        int maxAttempts = timeoutSeconds * 2;
        for (int attempts = 0; attempts < maxAttempts; ++attempts) {
            if (AudioDiscCommand.isFFmpegAvailable()) {
                return true;
            }
            try {
                Thread.sleep(500L);
                continue;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return false;
            }
        }
        return false;
    }

    private static class ProgressTracker {
        private final class_3222 player;
        private String currentStage = "downloading";
        private int lastReportedProgress = -1;

        public ProgressTracker(class_3222 player) {
            this.player = player;
        }

        public void setStage(String stage) {
            this.currentStage = stage;
        }

        public void updateProgress(int progress) {
            int roundedProgress = progress / 10 * 10;
            if (roundedProgress != this.lastReportedProgress && roundedProgress >= 0 && roundedProgress <= 100) {
                this.lastReportedProgress = roundedProgress;
                String key = "progress." + this.currentStage;
                this.player.method_7353((class_2561)class_2561.method_43470((String)Localization.formatForPlayer(key, this.player, roundedProgress)), false);
            }
        }
    }
}

