/*
 * Decompiled with CFR 0.152.
 */
package org.stepan.audio_disc.download;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.loader.api.FabricLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.stepan.audio_disc.util.FilePermissionUtil;

public class YtDlpManager {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"AudioDisc");
    private static final String WINDOWS_URL = "https://github.com/yt-dlp/yt-dlp/releases/latest/download/yt-dlp.exe";
    private static final String LINUX_URL = "https://github.com/yt-dlp/yt-dlp/releases/latest/download/yt-dlp";
    private static final String MACOS_URL = "https://github.com/yt-dlp/yt-dlp/releases/latest/download/yt-dlp_macos";
    private static final Path YT_DLP_DIR = FabricLoader.getInstance().getGameDir().resolve("audiodisc").resolve("yt-dlp");
    private static Path ytDlpExecutable = null;

    public static boolean isAvailable() {
        if (YtDlpManager.isSystemYtDlpAvailable()) {
            return true;
        }
        return YtDlpManager.isModYtDlpAvailable();
    }

    public static String getExecutablePath() {
        if (YtDlpManager.isSystemYtDlpAvailable()) {
            return "yt-dlp";
        }
        if (ytDlpExecutable != null && Files.exists(ytDlpExecutable, new LinkOption[0])) {
            return ytDlpExecutable.toString();
        }
        return null;
    }

    public static CompletableFuture<Boolean> downloadAndInstall() {
        return CompletableFuture.supplyAsync(() -> {
            try {
                LOGGER.info("Starting automatic yt-dlp download...");
                if (!Files.exists(YT_DLP_DIR, new LinkOption[0])) {
                    Files.createDirectories(YT_DLP_DIR, new FileAttribute[0]);
                }
                String downloadUrl = YtDlpManager.getDownloadUrlForPlatform();
                String fileName = YtDlpManager.getExecutableNameForPlatform();
                if (downloadUrl == null || fileName == null) {
                    LOGGER.error("Unsupported platform for automatic yt-dlp download");
                    return false;
                }
                Path executable = YT_DLP_DIR.resolve(fileName);
                LOGGER.info("Downloading yt-dlp from: {}", (Object)downloadUrl);
                if (!YtDlpManager.downloadFile(downloadUrl, executable)) {
                    YtDlpManager.logDownloadFailure();
                    return false;
                }
                if (!FilePermissionUtil.setExecutablePermissions(executable)) {
                    YtDlpManager.logPermissionFailure(executable);
                }
                ytDlpExecutable = executable;
                LOGGER.info("Successfully downloaded and installed yt-dlp to: {}", (Object)executable);
                if (YtDlpManager.testYtDlp(executable.toString())) {
                    LOGGER.info("yt-dlp installation verified successfully");
                    return true;
                }
                YtDlpManager.logVerificationFailure(executable);
                return false;
            }
            catch (Exception e) {
                LOGGER.error("Failed to download and install yt-dlp", (Throwable)e);
                return false;
            }
        });
    }

    private static boolean isSystemYtDlpAvailable() {
        return YtDlpManager.testYtDlp("yt-dlp");
    }

    private static boolean isModYtDlpAvailable() {
        Path executable;
        String fileName;
        if (ytDlpExecutable == null && (fileName = YtDlpManager.getExecutableNameForPlatform()) != null && Files.exists(executable = YT_DLP_DIR.resolve(fileName), new LinkOption[0])) {
            ytDlpExecutable = executable;
            return YtDlpManager.testYtDlp(executable.toString());
        }
        return ytDlpExecutable != null && Files.exists(ytDlpExecutable, new LinkOption[0]) && YtDlpManager.testYtDlp(ytDlpExecutable.toString());
    }

    private static boolean testYtDlp(String executable) {
        try {
            ProcessBuilder pb = new ProcessBuilder(executable, "--version");
            pb.redirectErrorStream(true);
            Process process = pb.start();
            StringBuilder output = new StringBuilder();
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));){
                String line;
                while ((line = reader.readLine()) != null) {
                    output.append(line).append("\n");
                }
            }
            int exitCode = process.waitFor();
            if (exitCode == 0) {
                LOGGER.debug("yt-dlp version check successful: {}", (Object)output.toString().trim());
                return true;
            }
            LOGGER.error("yt-dlp version check failed with exit code {}: {}", (Object)exitCode, (Object)output);
            return false;
        }
        catch (IOException e) {
            LOGGER.error("Failed to execute yt-dlp (file may not be executable or not found): {}", (Object)e.getMessage());
            return false;
        }
        catch (Exception e) {
            LOGGER.error("yt-dlp verification error: {}", (Object)e.getMessage());
            return false;
        }
    }

    private static void logDownloadFailure() {
        LOGGER.error("\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550");
        LOGGER.error("Failed to download yt-dlp automatically");
        LOGGER.error("YouTube functionality will not be available");
        LOGGER.error("");
        LOGGER.error("Manual installation options:");
        LOGGER.error("1. Use the in-game command: /audiodisc ytdlp install");
        LOGGER.error("2. Install yt-dlp system-wide:");
        LOGGER.error("   - Linux: sudo apt install yt-dlp  OR  pip install yt-dlp");
        LOGGER.error("   - macOS: brew install yt-dlp");
        LOGGER.error("   - Windows: Download from https://github.com/yt-dlp/yt-dlp/releases");
        LOGGER.error("3. Disable auto-install in config: autoInstallYtDlp = false");
        LOGGER.error("\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550");
    }

    private static void logPermissionFailure(Path executable) {
        LOGGER.warn("\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550");
        LOGGER.warn("Failed to set executable permissions for yt-dlp");
        LOGGER.warn("File location: {}", (Object)executable);
        LOGGER.warn("");
        LOGGER.warn("Manual fix:");
        LOGGER.warn("Run this command in your terminal:");
        LOGGER.warn("  chmod +x {}", (Object)executable);
        LOGGER.warn("\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550");
    }

    private static void logVerificationFailure(Path executable) {
        LOGGER.error("\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550");
        LOGGER.error("yt-dlp installation verification failed");
        LOGGER.error("YouTube functionality will not be available");
        LOGGER.error("");
        LOGGER.error("Troubleshooting steps:");
        LOGGER.error("1. Check if file has executable permissions:");
        LOGGER.error("   ls -l {}", (Object)executable);
        LOGGER.error("");
        LOGGER.error("2. If permissions are missing, run:");
        LOGGER.error("   chmod +x {}", (Object)executable);
        LOGGER.error("");
        LOGGER.error("3. Test manually:");
        LOGGER.error("   {} --version", (Object)executable);
        LOGGER.error("");
        LOGGER.error("4. Alternative: Install yt-dlp system-wide:");
        LOGGER.error("   - Linux: sudo apt install yt-dlp  OR  pip install yt-dlp");
        LOGGER.error("   - macOS: brew install yt-dlp");
        LOGGER.error("");
        LOGGER.error("5. Or disable auto-install in config: autoInstallYtDlp = false");
        LOGGER.error("\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550");
    }

    private static boolean downloadFile(String urlString, Path destination) {
        try {
            URL url = new URL(urlString);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("GET");
            connection.setConnectTimeout(30000);
            connection.setReadTimeout(60000);
            connection.setRequestProperty("User-Agent", "AudioDisc-Mod/1.0");
            int responseCode = connection.getResponseCode();
            if (responseCode != 200) {
                LOGGER.error("Failed to download yt-dlp: HTTP {}", (Object)responseCode);
                return false;
            }
            long fileSize = connection.getContentLengthLong();
            LOGGER.info("Downloading yt-dlp ({} MB)...", (Object)(fileSize > 0L ? String.format("%.1f", (double)fileSize / 1024.0 / 1024.0) : "unknown size"));
            try (InputStream in = connection.getInputStream();){
                Files.copy(in, destination, StandardCopyOption.REPLACE_EXISTING);
            }
            LOGGER.info("Download completed: {}", (Object)destination);
            return true;
        }
        catch (Exception e) {
            LOGGER.error("Failed to download yt-dlp", (Throwable)e);
            return false;
        }
    }

    private static String getDownloadUrlForPlatform() {
        String os = System.getProperty("os.name").toLowerCase();
        if (os.contains("win")) {
            return WINDOWS_URL;
        }
        if (os.contains("mac")) {
            return MACOS_URL;
        }
        if (os.contains("nix") || os.contains("nux") || os.contains("aix")) {
            return LINUX_URL;
        }
        return null;
    }

    private static String getExecutableNameForPlatform() {
        String os = System.getProperty("os.name").toLowerCase();
        if (os.contains("win")) {
            return "yt-dlp.exe";
        }
        return "yt-dlp";
    }

    private static boolean isWindows() {
        return System.getProperty("os.name").toLowerCase().contains("win");
    }

    public static long getInstallationSize() {
        if (ytDlpExecutable != null && Files.exists(ytDlpExecutable, new LinkOption[0])) {
            try {
                return Files.size(ytDlpExecutable);
            }
            catch (IOException e) {
                return 0L;
            }
        }
        return 0L;
    }

    public static boolean uninstall() {
        try {
            if (ytDlpExecutable != null && Files.exists(ytDlpExecutable, new LinkOption[0])) {
                Files.delete(ytDlpExecutable);
                ytDlpExecutable = null;
                LOGGER.info("Uninstalled mod-installed yt-dlp");
                return true;
            }
            return false;
        }
        catch (Exception e) {
            LOGGER.error("Failed to uninstall yt-dlp", (Throwable)e);
            return false;
        }
    }
}

