/*
 * Decompiled with CFR 0.152.
 */
package org.stepan.audio_disc.exception;

public class AudioDiscException
extends Exception {
    private final ErrorType type;
    private final String userMessage;

    public AudioDiscException(ErrorType type, String userMessage) {
        super(userMessage);
        this.type = type;
        this.userMessage = userMessage;
    }

    public AudioDiscException(ErrorType type, String userMessage, Throwable cause) {
        super(userMessage, cause);
        this.type = type;
        this.userMessage = userMessage;
    }

    public ErrorType getType() {
        return this.type;
    }

    public String getUserMessage() {
        return this.userMessage;
    }

    public static AudioDiscException invalidUrl(String message) {
        return new AudioDiscException(ErrorType.INVALID_URL, message);
    }

    public static AudioDiscException downloadFailed(String message, Throwable cause) {
        return new AudioDiscException(ErrorType.DOWNLOAD_FAILED, message, cause);
    }

    public static AudioDiscException unsupportedFormat(String message) {
        return new AudioDiscException(ErrorType.UNSUPPORTED_FORMAT, message);
    }

    public static AudioDiscException fileTooLarge(String message) {
        return new AudioDiscException(ErrorType.FILE_TOO_LARGE, message);
    }

    public static AudioDiscException noDiscInHand(String message) {
        return new AudioDiscException(ErrorType.NO_DISC_IN_HAND, message);
    }

    public static AudioDiscException storageError(String message, Throwable cause) {
        return new AudioDiscException(ErrorType.STORAGE_ERROR, message, cause);
    }

    public static AudioDiscException playbackError(String message, Throwable cause) {
        return new AudioDiscException(ErrorType.PLAYBACK_ERROR, message, cause);
    }

    public static enum ErrorType {
        INVALID_URL("Invalid URL"),
        DOWNLOAD_FAILED("Download failed"),
        UNSUPPORTED_FORMAT("Unsupported format"),
        FILE_TOO_LARGE("File too large"),
        NO_DISC_IN_HAND("No disc in hand"),
        STORAGE_ERROR("Storage error"),
        PLAYBACK_ERROR("Playback error");

        private final String displayName;

        private ErrorType(String displayName) {
            this.displayName = displayName;
        }

        public String getDisplayName() {
            return this.displayName;
        }
    }
}

