/*
 * Decompiled with CFR 0.152.
 */
package org.stepan.audio_disc.mixin;

import java.util.Optional;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_2614;
import net.minecraft.class_2619;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.stepan.audio_disc.Audio_disc;
import org.stepan.audio_disc.playback.PlaybackManager;
import org.stepan.audio_disc.storage.AudioStorageManager;

@Mixin(value={class_2619.class})
public abstract class JukeboxBlockEntityMixin {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"AudioDisc");
    private class_1799 audio_disc$previousStack = class_1799.field_8037;

    @Shadow
    public abstract class_1799 method_54079();

    @Inject(method={"method_54077(Lnet/minecraft/class_1799;)V"}, at={@At(value="HEAD")})
    private void onSetStackHead(class_1799 stack, CallbackInfo ci) {
        class_2619 jukebox = (class_2619)this;
        this.audio_disc$previousStack = jukebox.method_54079().method_7972();
        LOGGER.info("JukeboxBlockEntity.setStack called - Previous: {}, New: {}", (Object)(this.audio_disc$previousStack.method_7960() ? "empty" : this.audio_disc$previousStack.method_7909().toString()), (Object)(stack.method_7960() ? "empty" : stack.method_7909().toString()));
    }

    @Inject(method={"method_54077(Lnet/minecraft/class_1799;)V"}, at={@At(value="TAIL")})
    private void onSetStackTail(class_1799 stack, CallbackInfo ci) {
        class_2619 jukebox = (class_2619)this;
        if (jukebox.method_10997() == null || jukebox.method_10997().method_8608()) {
            LOGGER.info("Skipping setStack processing - client side or null world");
            return;
        }
        class_2338 pos = jukebox.method_11016();
        if (stack.method_7960() && !this.audio_disc$previousStack.method_7960()) {
            PlaybackManager playbackManager = Audio_disc.getPlaybackManager();
            if (playbackManager != null && playbackManager.getPlayback(pos).isPresent()) {
                LOGGER.info("Disc removed from jukebox at {} (via setStack), stopping playback", (Object)pos);
                playbackManager.stopPlayback(pos);
            }
            return;
        }
        if (!stack.method_7960() && this.audio_disc$previousStack.method_7960()) {
            AudioStorageManager storageManager = Audio_disc.getStorageManager();
            if (storageManager == null) {
                LOGGER.warn("AudioStorageManager is null");
                return;
            }
            Optional<String> audioId = storageManager.getDiscAudioId(stack);
            if (audioId.isEmpty()) {
                LOGGER.info("Not a custom disc, ignoring");
                return;
            }
            LOGGER.info("Custom audio disc inserted into jukebox at {} (via setStack), starting playback", (Object)pos);
            PlaybackManager playbackManager = Audio_disc.getPlaybackManager();
            if (playbackManager != null) {
                boolean started = playbackManager.startPlayback((class_3218)jukebox.method_10997(), pos, stack);
                if (started) {
                    LOGGER.info("Started custom audio playback at {} from automated insertion", (Object)pos);
                } else {
                    LOGGER.warn("Failed to start custom audio playback at {}", (Object)pos);
                }
            } else {
                LOGGER.warn("PlaybackManager is null");
            }
        }
        if (!stack.method_7960() && !this.audio_disc$previousStack.method_7960()) {
            Optional<String> audioId;
            AudioStorageManager storageManager;
            PlaybackManager playbackManager = Audio_disc.getPlaybackManager();
            if (playbackManager != null && playbackManager.getPlayback(pos).isPresent()) {
                LOGGER.info("Replacing disc at {}, stopping old playback", (Object)pos);
                playbackManager.stopPlayback(pos);
            }
            if ((storageManager = Audio_disc.getStorageManager()) != null && (audioId = storageManager.getDiscAudioId(stack)).isPresent()) {
                LOGGER.info("New custom audio disc inserted at {}, starting playback", (Object)pos);
                if (playbackManager != null) {
                    playbackManager.startPlayback((class_3218)jukebox.method_10997(), pos, stack);
                }
            }
        }
    }

    @Inject(method={"method_44370(Lnet/minecraft/class_1937;Lnet/minecraft/class_2338;Lnet/minecraft/class_2680;Lnet/minecraft/class_2619;)V"}, at={@At(value="HEAD")}, cancellable=true)
    private static void onTick(class_1937 world, class_2338 pos, class_2680 state, class_2619 jukebox, CallbackInfo ci) {
        if (world.method_8608()) {
            return;
        }
        class_1799 stack = jukebox.method_54079();
        if (stack.method_7960()) {
            return;
        }
        AudioStorageManager storageManager = Audio_disc.getStorageManager();
        if (storageManager == null) {
            return;
        }
        Optional<String> audioId = storageManager.getDiscAudioId(stack);
        if (audioId.isEmpty()) {
            return;
        }
        LOGGER.debug("Custom disc at {}, cancelling vanilla tick to prevent vanilla sound", (Object)pos);
        PlaybackManager playbackManager = Audio_disc.getPlaybackManager();
        if (playbackManager == null) {
            ci.cancel();
            return;
        }
        if (playbackManager.isPlaying(pos)) {
            LOGGER.debug("Custom disc still playing at {}", (Object)pos);
            ci.cancel();
            return;
        }
        LOGGER.debug("Custom audio playback finished at {}, checking for hopper", (Object)pos);
        class_2338 hopperPos = pos.method_10074();
        class_2586 blockEntity = world.method_8321(hopperPos);
        if (blockEntity instanceof class_2614) {
            class_2614 hopper = (class_2614)blockEntity;
            class_1799 discCopy = stack.method_7972();
            for (int i = 0; i < hopper.method_5439(); ++i) {
                int spaceLeft;
                class_1799 slotStack = hopper.method_5438(i);
                if (slotStack.method_7960()) {
                    hopper.method_5447(i, discCopy);
                    jukebox.method_54077(class_1799.field_8037);
                    LOGGER.info("Disc extracted into hopper at {}", (Object)hopperPos);
                    ci.cancel();
                    return;
                }
                if (!class_1799.method_31577((class_1799)slotStack, (class_1799)discCopy) || slotStack.method_7947() >= slotStack.method_7914() || (spaceLeft = slotStack.method_7914() - slotStack.method_7947()) < discCopy.method_7947()) continue;
                slotStack.method_7933(discCopy.method_7947());
                jukebox.method_54077(class_1799.field_8037);
                LOGGER.info("Disc extracted into hopper at {}", (Object)hopperPos);
                ci.cancel();
                return;
            }
            LOGGER.debug("Hopper is full, disc remains in jukebox");
        } else {
            LOGGER.debug("No hopper below, disc remains in jukebox");
        }
        ci.cancel();
    }
}

