/*
 * Decompiled with CFR 0.152.
 */
package org.stepan.audio_disc.mixin.client;

import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_2619;
import net.minecraft.class_2767;
import net.minecraft.class_310;
import net.minecraft.class_3419;
import net.minecraft.class_634;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.stepan.audio_disc.Audio_disc;
import org.stepan.audio_disc.storage.AudioStorageManager;

@Environment(value=EnvType.CLIENT)
@Mixin(value={class_634.class})
public class ClientPlayNetworkHandlerMixin {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"AudioDisc");
    @Shadow
    private class_310 field_45588;

    @Inject(method={"method_11146(Lnet/minecraft/class_2767;)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void onPlaySound(class_2767 packet, CallbackInfo ci) {
        if (packet.method_11888() != class_3419.field_15247) {
            return;
        }
        LOGGER.info("Intercepted RECORDS sound packet on client - sound: {} at {}, {}, {}", new Object[]{packet.method_11894(), packet.method_11890(), packet.method_11889(), packet.method_11893()});
        if (this.field_45588.field_1687 == null) {
            return;
        }
        class_2338 pos = class_2338.method_49637((double)packet.method_11890(), (double)packet.method_11889(), (double)packet.method_11893());
        class_2586 blockEntity = this.field_45588.field_1687.method_8321(pos);
        if (!(blockEntity instanceof class_2619)) {
            LOGGER.info("No jukebox found at {}", (Object)pos);
            return;
        }
        class_2619 jukebox = (class_2619)blockEntity;
        class_1799 stack = jukebox.method_54079();
        if (stack.method_7960()) {
            LOGGER.info("Jukebox at {} is empty", (Object)pos);
            return;
        }
        AudioStorageManager storageManager = Audio_disc.getStorageManager();
        if (storageManager == null) {
            LOGGER.warn("AudioStorageManager is null on client");
            return;
        }
        Optional<String> audioId = storageManager.getDiscAudioId(stack);
        if (audioId.isPresent()) {
            LOGGER.info("\u2713 Cancelling vanilla jukebox sound on CLIENT at {} for custom disc {}", (Object)pos, (Object)audioId.get());
            ci.cancel();
        } else {
            LOGGER.info("Disc at {} is not custom, allowing vanilla sound", (Object)pos);
        }
    }
}

