/*
 * Decompiled with CFR 0.152.
 */
package org.stepan.audio_disc.mixin.client;

import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1113;
import net.minecraft.class_1144;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_2619;
import net.minecraft.class_310;
import net.minecraft.class_3419;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.stepan.audio_disc.Audio_disc;
import org.stepan.audio_disc.storage.AudioStorageManager;

@Environment(value=EnvType.CLIENT)
@Mixin(value={class_1144.class})
public class SoundManagerMixin {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"AudioDisc");

    @Inject(method={"method_4873(Lnet/minecraft/class_1113;)Lnet/minecraft/class_1140$class_11518;"}, at={@At(value="HEAD")}, cancellable=true)
    private void onPlay(class_1113 sound, CallbackInfo ci) {
        if (sound.method_4774() != class_3419.field_15247) {
            return;
        }
        LOGGER.info("Intercepted RECORDS sound in SoundManager - sound: {} at {}, {}, {}", new Object[]{sound.method_4775(), sound.method_4784(), sound.method_4779(), sound.method_4778()});
        class_310 client = class_310.method_1551();
        if (client.field_1687 == null) {
            return;
        }
        class_2338 pos = class_2338.method_49637((double)sound.method_4784(), (double)sound.method_4779(), (double)sound.method_4778());
        for (class_2338 checkPos : class_2338.method_25996((class_2338)pos, (int)2, (int)2, (int)2)) {
            class_2619 jukebox;
            class_1799 stack;
            class_2586 blockEntity = client.field_1687.method_8321(checkPos);
            if (!(blockEntity instanceof class_2619) || (stack = (jukebox = (class_2619)blockEntity).method_54079()).method_7960()) continue;
            AudioStorageManager storageManager = Audio_disc.getStorageManager();
            if (storageManager == null) {
                LOGGER.warn("AudioStorageManager is null on client");
                continue;
            }
            Optional<String> audioId = storageManager.getDiscAudioId(stack);
            if (!audioId.isPresent()) continue;
            LOGGER.info("\u2713 Cancelling vanilla jukebox sound in SoundManager at {} for custom disc {} (jukebox at {})", new Object[]{pos, audioId.get(), checkPos});
            ci.cancel();
            return;
        }
        LOGGER.info("No custom disc found near sound position {}, allowing vanilla sound", (Object)pos);
    }
}

