/*
 * Decompiled with CFR 0.152.
 */
package org.stepan.audio_disc.playback;

import java.util.UUID;
import net.minecraft.class_2338;
import org.stepan.audio_disc.model.AudioMetadata;
import org.stepan.audio_disc.playback.SimpleVoiceChatIntegration;

public class ActivePlayback {
    private final String audioId;
    private final class_2338 position;
    private final UUID streamId;
    private final SimpleVoiceChatIntegration.AudioStreamInfo stream;
    private final long startTime;
    private final AudioMetadata metadata;
    private volatile boolean playing;

    public ActivePlayback(String audioId, class_2338 position, UUID streamId, SimpleVoiceChatIntegration.AudioStreamInfo stream, AudioMetadata metadata) {
        this.audioId = audioId;
        this.position = position;
        this.streamId = streamId;
        this.stream = stream;
        this.startTime = System.currentTimeMillis();
        this.metadata = metadata;
        this.playing = true;
    }

    public String getAudioId() {
        return this.audioId;
    }

    public class_2338 getPosition() {
        return this.position;
    }

    public UUID getStreamId() {
        return this.streamId;
    }

    public SimpleVoiceChatIntegration.AudioStreamInfo getStream() {
        return this.stream;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public AudioMetadata getMetadata() {
        return this.metadata;
    }

    public boolean isPlaying() {
        if (!this.playing || this.stream == null) {
            return false;
        }
        if (this.stream instanceof SimpleVoiceChatIntegration.PersonalAudioPlayerInfo) {
            SimpleVoiceChatIntegration.PersonalAudioPlayerInfo playerInfo = (SimpleVoiceChatIntegration.PersonalAudioPlayerInfo)this.stream;
            return this.stream.isPlaying() && !playerInfo.getAudioSupplier().isFinished();
        }
        return this.stream.isPlaying();
    }

    public long getElapsedTime() {
        return System.currentTimeMillis() - this.startTime;
    }

    public boolean isComplete() {
        if (this.metadata.duration() <= 0L) {
            return false;
        }
        return this.getElapsedTime() >= this.metadata.duration();
    }

    public void stop() {
        this.playing = false;
        if (this.stream != null) {
            this.stream.setPlaying(false);
        }
    }
}

