/*
 * Decompiled with CFR 0.152.
 */
package org.stepan.audio_disc.util;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.PosixFilePermission;
import java.util.HashSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilePermissionUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"AudioDisc");

    public static boolean setExecutablePermissions(Path file) {
        if (FilePermissionUtil.isWindows()) {
            LOGGER.debug("Windows detected, skipping permission setting");
            return true;
        }
        try {
            LOGGER.info("Setting executable permissions for: {}", (Object)file);
            HashSet<PosixFilePermission> perms = new HashSet<PosixFilePermission>();
            perms.add(PosixFilePermission.OWNER_READ);
            perms.add(PosixFilePermission.OWNER_WRITE);
            perms.add(PosixFilePermission.OWNER_EXECUTE);
            perms.add(PosixFilePermission.GROUP_READ);
            perms.add(PosixFilePermission.GROUP_EXECUTE);
            perms.add(PosixFilePermission.OTHERS_READ);
            perms.add(PosixFilePermission.OTHERS_EXECUTE);
            Files.setPosixFilePermissions(file, perms);
            LOGGER.info("Successfully set executable permissions using Java NIO");
            return true;
        }
        catch (UnsupportedOperationException e) {
            LOGGER.info("POSIX permissions not supported, falling back to chmod command");
            return FilePermissionUtil.setExecutablePermissionsViaChmod(file);
        }
        catch (Exception e) {
            LOGGER.error("Failed to set executable permissions using Java NIO: {}", (Object)e.getMessage());
            return FilePermissionUtil.setExecutablePermissionsViaChmod(file);
        }
    }

    private static boolean setExecutablePermissionsViaChmod(Path file) {
        try {
            ProcessBuilder pb = new ProcessBuilder("chmod", "+x", file.toString());
            pb.redirectErrorStream(true);
            Process process = pb.start();
            StringBuilder output = new StringBuilder();
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));){
                String line;
                while ((line = reader.readLine()) != null) {
                    output.append(line).append("\n");
                }
            }
            int exitCode = process.waitFor();
            if (exitCode == 0) {
                LOGGER.info("Successfully set executable permissions using chmod");
                return true;
            }
            LOGGER.error("chmod command failed with exit code {}: {}", (Object)exitCode, (Object)output);
            return false;
        }
        catch (Exception e) {
            LOGGER.error("Failed to execute chmod command: {}", (Object)e.getMessage());
            return false;
        }
    }

    public static boolean isWindows() {
        return System.getProperty("os.name").toLowerCase().contains("win");
    }
}

