/*
 * Decompiled with CFR 0.152.
 */
package org.stepan.audio_disc.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;

public class RateLimiter {
    private final Map<UUID, PlayerRateInfo> playerRates = new ConcurrentHashMap<UUID, PlayerRateInfo>();
    private final int maxUploadsPerMinute;
    private final long cooldownMillis;

    public RateLimiter(int maxUploadsPerMinute, long cooldownSeconds) {
        this.maxUploadsPerMinute = maxUploadsPerMinute;
        this.cooldownMillis = cooldownSeconds * 1000L;
    }

    public RateLimitResult checkLimit(UUID playerId) {
        long now = System.currentTimeMillis();
        PlayerRateInfo info = this.playerRates.computeIfAbsent(playerId, k -> new PlayerRateInfo());
        if (now - info.lastUploadTime < this.cooldownMillis) {
            long remainingCooldown = (this.cooldownMillis - (now - info.lastUploadTime)) / 1000L;
            return RateLimitResult.denied("Please wait " + remainingCooldown + " seconds before uploading again");
        }
        info.uploadTimes.removeIf(time -> now - time > 60000L);
        if (info.uploadTimes.size() >= this.maxUploadsPerMinute) {
            return RateLimitResult.denied("Upload limit reached. Maximum " + this.maxUploadsPerMinute + " uploads per minute");
        }
        return RateLimitResult.allowed();
    }

    public void recordUpload(UUID playerId) {
        long now = System.currentTimeMillis();
        PlayerRateInfo info = this.playerRates.computeIfAbsent(playerId, k -> new PlayerRateInfo());
        info.uploadTimes.add(now);
        info.lastUploadTime = now;
    }

    public long getRemainingCooldown(UUID playerId) {
        PlayerRateInfo info = this.playerRates.get(playerId);
        if (info == null) {
            return 0L;
        }
        long now = System.currentTimeMillis();
        long elapsed = now - info.lastUploadTime;
        if (elapsed >= this.cooldownMillis) {
            return 0L;
        }
        return (this.cooldownMillis - elapsed) / 1000L;
    }

    public void clearPlayer(UUID playerId) {
        this.playerRates.remove(playerId);
    }

    public void clearAll() {
        this.playerRates.clear();
    }

    private static class PlayerRateInfo {
        final List<Long> uploadTimes = new ArrayList<Long>();
        long lastUploadTime = 0L;

        private PlayerRateInfo() {
        }
    }

    public static class RateLimitResult {
        private final boolean allowed;
        private final String message;

        private RateLimitResult(boolean allowed, String message) {
            this.allowed = allowed;
            this.message = message;
        }

        public static RateLimitResult allowed() {
            return new RateLimitResult(true, null);
        }

        public static RateLimitResult denied(String message) {
            return new RateLimitResult(false, message);
        }

        public boolean isAllowed() {
            return this.allowed;
        }

        public String getMessage() {
            return this.message;
        }
    }
}

