package org.stepan.audio_disc.api;

import net.minecraft.class_2338;
import net.minecraft.class_3218;
import org.stepan.audio_disc.model.AudioMetadata;

/**
 * Event fired when audio playback starts.
 */
public record PlaybackStartEvent(
    class_2338 jukeboxPos,
    class_3218 world,
    String audioId,
    AudioMetadata metadata,
    long timestamp
) {
    /**
     * Creates a new playback start event.
     * 
     * @param jukeboxPos The position of the jukebox
     * @param world The server world
     * @param audioId The audio identifier
     * @param metadata The audio metadata
     */
    public PlaybackStartEvent(class_2338 jukeboxPos, class_3218 world, String audioId, AudioMetadata metadata) {
        this(jukeboxPos, world, audioId, metadata, System.currentTimeMillis());
    }
}
