package org.stepan.audio_disc.api;

import net.minecraft.class_2338;
import net.minecraft.class_3218;

/**
 * Event fired when audio playback stops.
 */
public record PlaybackStopEvent(
    class_2338 jukeboxPos,
    class_3218 world,
    String audioId,
    long playbackDuration,
    StopReason reason,
    long timestamp
) {
    /**
     * Creates a new playback stop event.
     * 
     * @param jukeboxPos The position of the jukebox
     * @param world The server world
     * @param audioId The audio identifier
     * @param playbackDuration The duration of playback in milliseconds
     * @param reason The reason playback stopped
     */
    public PlaybackStopEvent(class_2338 jukeboxPos, class_3218 world, String audioId, 
                            long playbackDuration, StopReason reason) {
        this(jukeboxPos, world, audioId, playbackDuration, reason, System.currentTimeMillis());
    }
}
