package org.stepan.audio_disc.events;

import net.fabricmc.fabric.api.event.player.UseBlockCallback;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2619;
import net.minecraft.class_3218;
import net.minecraft.class_3965;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.stepan.audio_disc.Audio_disc;
import org.stepan.audio_disc.playback.PlaybackManager;
import org.stepan.audio_disc.storage.AudioStorageManager;

import java.util.Optional;

/**
 * Handles jukebox interactions without using mixins.
 */
public class JukeboxEventHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger("AudioDisc");

    /**
     * Registers jukebox event handlers.
     */
    public static void register() {
        UseBlockCallback.EVENT.register(JukeboxEventHandler::onUseBlock);
        LOGGER.info("Registered jukebox event handlers");
    }

    /**
     * Handles block use events for jukeboxes.
     */
    private static class_1269 onUseBlock(net.minecraft.class_1657 player, class_1937 world, class_1268 hand, class_3965 hitResult) {
        if (world.field_9236) {
            return class_1269.field_5811;
        }

        class_2338 pos = hitResult.method_17777();
        
        // Check if it's a jukebox
        if (!world.method_8320(pos).method_27852(class_2246.field_10223)) {
            return class_1269.field_5811;
        }

        // Get jukebox block entity
        if (!(world.method_8321(pos) instanceof class_2619 jukebox)) {
            return class_1269.field_5811;
        }

        class_1799 heldItem = player.method_5998(hand);
        class_1799 currentDisc = jukebox.method_54079();

        // If jukebox is empty and player is holding a disc
        if (currentDisc.method_7960() && !heldItem.method_7960() && isMusicDisc(heldItem)) {
            return handleDiscInsertion(player, (class_3218) world, pos, jukebox, heldItem, hand);
        }
        
        // If jukebox has a disc and player clicked (regardless of hand contents)
        if (!currentDisc.method_7960()) {
            return handleDiscRemoval(player, (class_3218) world, pos, jukebox, currentDisc, heldItem.method_7960());
        }

        return class_1269.field_5811;
    }

    /**
     * Handles disc insertion into jukebox.
     */
    private static class_1269 handleDiscInsertion(net.minecraft.class_1657 player, class_3218 world, 
                                                   class_2338 pos, class_2619 jukebox, class_1799 disc, class_1268 hand) {
        
        AudioStorageManager storageManager = Audio_disc.getStorageManager();
        if (storageManager == null) {
            return class_1269.field_5811;
        }

        // Check if this disc has custom audio
        Optional<String> audioId = storageManager.getDiscAudioId(disc);
        if (audioId.isEmpty()) {
            // Not a custom disc, let vanilla handle it
            return class_1269.field_5811;
        }

        LOGGER.info("Custom audio disc detected, starting custom playback at {}", pos);

        // Insert the disc into jukebox
        class_1799 discCopy = disc.method_7972();
        discCopy.method_7939(1);
        jukebox.method_54077(discCopy);

        // Remove disc from player's hand
        if (!player.method_31549().field_7477) {
            disc.method_7934(1);
        }

        // Start custom playback
        PlaybackManager playbackManager = Audio_disc.getPlaybackManager();
        if (playbackManager != null) {
            boolean started = playbackManager.startPlayback(world, pos, discCopy);
            if (started) {
                LOGGER.info("Started custom audio playback at {}", pos);
            } else {
                LOGGER.warn("Failed to start custom audio playback at {}", pos);
            }
        }

        return class_1269.field_5812;
    }

    /**
     * Handles disc removal from jukebox.
     */
    private static class_1269 handleDiscRemoval(net.minecraft.class_1657 player, class_3218 world,
                                                 class_2338 pos, class_2619 jukebox, class_1799 currentDisc, boolean handWasEmpty) {
        
        AudioStorageManager storageManager = Audio_disc.getStorageManager();
        if (storageManager == null) {
            return class_1269.field_5811;
        }

        // Check if this is a custom disc
        Optional<String> audioId = storageManager.getDiscAudioId(currentDisc);
        if (audioId.isEmpty()) {
            // Not a custom disc, let vanilla handle it
            return class_1269.field_5811;
        }

        LOGGER.info("Removing custom audio disc from jukebox at {}", pos);

        // Stop custom playback
        PlaybackManager playbackManager = Audio_disc.getPlaybackManager();
        if (playbackManager != null) {
            playbackManager.stopPlayback(pos);
        }

        // If hand was empty, we handle the removal ourselves
        if (handWasEmpty) {
            // Remove disc from jukebox and give to player
            jukebox.method_54077(class_1799.field_8037);
            
            // Give disc to player
            if (!player.method_31548().method_7394(currentDisc)) {
                // If inventory is full, drop the disc
                player.method_7328(currentDisc, false);
            }
            
            return class_1269.field_5812;
        } else {
            // If hand was not empty, we only stop the playback and let vanilla handle the disc removal
            // This ensures the music stops even when the disc is ejected due to full hand
            return class_1269.field_5811;
        }
    }

    /**
     * Checks if an item is a music disc.
     */
    private static boolean isMusicDisc(class_1799 stack) {
        if (stack.method_7960()) return false;
        
        String itemName = stack.method_7909().toString();
        return itemName.contains("music_disc");
    }
}