package org.stepan.audio_disc.mixin;

import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.stepan.audio_disc.Audio_disc;
import org.stepan.audio_disc.model.AudioData;
import org.stepan.audio_disc.model.AudioMetadata;
import org.stepan.audio_disc.storage.AudioStorageManager;

import java.util.List;
import java.util.Optional;
import net.minecraft.class_124;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_9279;
import net.minecraft.class_9334;

/**
 * Mixin to add custom tooltips for audio discs.
 */
@Mixin(class_1799.class)
public abstract class ItemStackMixin {

    /**
     * Adds custom tooltip information for audio discs.
     */
    @Inject(method = "getTooltip", at = @At("RETURN"))
    private void addCustomAudioTooltip(class_1792.class_9635 context, net.minecraft.class_1657 player, 
                                      class_1836 type, CallbackInfoReturnable<List<class_2561>> cir) {
        class_1799 stack = (class_1799) (Object) this;
        
        // Check if this is a music disc
        if (!stack.method_7909().toString().contains("music_disc")) {
            return;
        }

        // Get storage manager
        AudioStorageManager storageManager = Audio_disc.getStorageManager();
        if (storageManager == null) {
            return;
        }

        // Check if this disc has custom audio
        Optional<String> audioIdOpt = storageManager.getDiscAudioId(stack);
        if (audioIdOpt.isEmpty()) {
            return;
        }

        String audioId = audioIdOpt.get();
        Optional<AudioData> audioDataOpt = storageManager.getAudio(audioId);
        
        if (audioDataOpt.isEmpty()) {
            return;
        }

        AudioData audioData = audioDataOpt.get();
        AudioMetadata metadata = audioData.metadata();
        
        List<class_2561> tooltip = cir.getReturnValue();
        
        // Add separator
        tooltip.add(class_2561.method_43470(""));
        
        // Add custom audio indicator
        tooltip.add(class_2561.method_43470("♪ Custom Audio Disc").method_27695(class_124.field_1065, class_124.field_1067));
        
        // Add title (check for custom title first)
        class_9279 customData = stack.method_58694(class_9334.field_49628);
        String title = metadata.title();
        
        if (customData != null) {
            class_2487 nbt = customData.method_57461();
            if (nbt.method_10545("audio_disc")) {
                Optional<class_2487> audioDiscNbtOpt = nbt.method_10562("audio_disc");
                if (audioDiscNbtOpt.isPresent()) {
                    class_2487 audioDiscNbt = audioDiscNbtOpt.get();
                    if (audioDiscNbt.method_10545("custom_title")) {
                        Optional<String> customTitleOpt = audioDiscNbt.method_10558("custom_title");
                        if (customTitleOpt.isPresent()) {
                            title = customTitleOpt.get();
                        }
                    }
                }
            }
        }
        
        tooltip.add(class_2561.method_43470("Title: ").method_27692(class_124.field_1080)
            .method_10852(class_2561.method_43470(title).method_27692(class_124.field_1068)));
        
        // Add duration
        if (metadata.duration() > 0) {
            long durationSeconds = metadata.duration() / 1000;
            long minutes = durationSeconds / 60;
            long seconds = durationSeconds % 60;
            String durationStr = String.format("%d:%02d", minutes, seconds);
            
            tooltip.add(class_2561.method_43470("Duration: ").method_27692(class_124.field_1080)
                .method_10852(class_2561.method_43470(durationStr).method_27692(class_124.field_1068)));
        }
        
        // Add format
        tooltip.add(class_2561.method_43470("Format: ").method_27692(class_124.field_1080)
            .method_10852(class_2561.method_43470(metadata.format().toUpperCase()).method_27692(class_124.field_1068)));
        
        // Add uploader
        tooltip.add(class_2561.method_43470("Uploaded by: ").method_27692(class_124.field_1080)
            .method_10852(class_2561.method_43470(audioData.uploadedBy()).method_27692(class_124.field_1075)));
    }
}
