package org.stepan.audio_disc.mixin;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.stepan.audio_disc.Audio_disc;
import org.stepan.audio_disc.playback.PlaybackManager;
import org.stepan.audio_disc.storage.AudioStorageManager;

import java.util.Optional;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2619;
import net.minecraft.class_3218;

/**
 * Mixin to intercept disc insertion into jukebox from any source (player, hopper, dropper, etc.)
 */
@Mixin(class_2619.class)
public abstract class JukeboxBlockEntityMixin {
    private static final Logger LOGGER = LoggerFactory.getLogger("AudioDisc");

    @Shadow
    public abstract class_1799 getStack();

    private class_1799 audio_disc$previousStack = class_1799.field_8037;

    @Inject(method = "setStack", at = @At("HEAD"))
    private void onSetStackHead(class_1799 stack, CallbackInfo ci) {
        class_2619 jukebox = (class_2619) (Object) this;
        
        // Store previous stack for comparison
        audio_disc$previousStack = jukebox.method_54079().method_7972();
        
        LOGGER.info("JukeboxBlockEntity.setStack called - Previous: {}, New: {}", 
            audio_disc$previousStack.method_7960() ? "empty" : audio_disc$previousStack.method_7909().toString(),
            stack.method_7960() ? "empty" : stack.method_7909().toString());
    }

    @Inject(method = "setStack", at = @At("TAIL"))
    private void onSetStackTail(class_1799 stack, CallbackInfo ci) {
        class_2619 jukebox = (class_2619) (Object) this;
        
        // Only process on server side
        if (jukebox.method_10997() == null || jukebox.method_10997().method_8608()) {
            LOGGER.info("Skipping setStack processing - client side or null world");
            return;
        }

        class_2338 pos = jukebox.method_11016();
        
        // If new stack is empty, disc was removed
        if (stack.method_7960() && !audio_disc$previousStack.method_7960()) {
            PlaybackManager playbackManager = Audio_disc.getPlaybackManager();
            if (playbackManager != null && playbackManager.getPlayback(pos).isPresent()) {
                LOGGER.info("Disc removed from jukebox at {} (via setStack), stopping playback", pos);
                playbackManager.stopPlayback(pos);
            }
            return;
        }

        // If new stack is not empty and previous was empty, disc was inserted
        if (!stack.method_7960() && audio_disc$previousStack.method_7960()) {
            // Check if this disc has custom audio
            AudioStorageManager storageManager = Audio_disc.getStorageManager();
            if (storageManager == null) {
                LOGGER.warn("AudioStorageManager is null");
                return;
            }

            Optional<String> audioId = storageManager.getDiscAudioId(stack);
            if (audioId.isEmpty()) {
                LOGGER.info("Not a custom disc, ignoring");
                return;
            }

            LOGGER.info("Custom audio disc inserted into jukebox at {} (via setStack), starting playback", pos);

            // Start custom playback
            PlaybackManager playbackManager = Audio_disc.getPlaybackManager();
            if (playbackManager != null) {
                boolean started = playbackManager.startPlayback((class_3218) jukebox.method_10997(), pos, stack);
                if (started) {
                    LOGGER.info("Started custom audio playback at {} from automated insertion", pos);
                } else {
                    LOGGER.warn("Failed to start custom audio playback at {}", pos);
                }
            } else {
                LOGGER.warn("PlaybackManager is null");
            }
        }
    }
}
