package org.stepan.audio_disc.util;

import org.stepan.audio_disc.model.AudioMetadata;
import java.util.Optional;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_9279;
import net.minecraft.class_9334;

public class NbtUtils {
    private static final String AUDIO_DISC_KEY = "audio_disc";
    private static final String AUDIO_ID_KEY = "audio_id";
    private static final String UPLOADED_BY_KEY = "uploaded_by";
    private static final String UPLOAD_TIME_KEY = "upload_time";
    private static final String METADATA_KEY = "metadata";
    private static final String FORMAT_KEY = "format";
    private static final String DURATION_KEY = "duration";
    private static final String BITRATE_KEY = "bitrate";
    private static final String SAMPLE_RATE_KEY = "sample_rate";
    private static final String TITLE_KEY = "title";

    public static class_2487 serializeMetadata(AudioMetadata metadata) {
        class_2487 nbt = new class_2487();
        nbt.method_10582(FORMAT_KEY, metadata.format());
        nbt.method_10544(DURATION_KEY, metadata.duration());
        nbt.method_10569(BITRATE_KEY, metadata.bitrate());
        nbt.method_10569(SAMPLE_RATE_KEY, metadata.sampleRate());
        nbt.method_10582(TITLE_KEY, metadata.title());
        return nbt;
    }

    public static Optional<AudioMetadata> deserializeMetadata(class_2487 nbt) {
        if (nbt == null || nbt.method_33133()) {
            return Optional.empty();
        }
        try {
            Optional<String> formatOpt = nbt.method_10558(FORMAT_KEY);
            Optional<Long> durationOpt = nbt.method_10537(DURATION_KEY);
            Optional<Integer> bitrateOpt = nbt.method_10550(BITRATE_KEY);
            Optional<Integer> sampleRateOpt = nbt.method_10550(SAMPLE_RATE_KEY);
            Optional<String> titleOpt = nbt.method_10558(TITLE_KEY);
            
            if (formatOpt.isEmpty() || titleOpt.isEmpty()) {
                return Optional.empty();
            }
            
            String format = formatOpt.get();
            String title = titleOpt.get();
            
            if (format.isBlank() || title.isBlank()) {
                return Optional.empty();
            }
            
            return Optional.of(new AudioMetadata(
                format,
                durationOpt.orElse(0L),
                bitrateOpt.orElse(0),
                sampleRateOpt.orElse(0),
                title
            ));
        } catch (Exception e) {
            return Optional.empty();
        }
    }

    public static void attachAudioToItem(class_1799 stack, String audioId, String uploadedBy, long uploadTime, AudioMetadata metadata) {
        if (stack.method_7960()) return;
        
        class_9279 currentData = stack.method_58695(class_9334.field_49628, class_9279.field_49302);
        class_2487 rootNbt = currentData.method_57461();
        
        class_2487 audioDiscNbt = new class_2487();
        audioDiscNbt.method_10582(AUDIO_ID_KEY, audioId);
        audioDiscNbt.method_10582(UPLOADED_BY_KEY, uploadedBy);
        audioDiscNbt.method_10544(UPLOAD_TIME_KEY, uploadTime);
        audioDiscNbt.method_10566(METADATA_KEY, serializeMetadata(metadata));
        
        rootNbt.method_10566(AUDIO_DISC_KEY, audioDiscNbt);
        stack.method_57379(class_9334.field_49628, class_9279.method_57456(rootNbt));
    }

    private static Optional<class_2487> getAudioDiscNbt(class_1799 stack) {
        if (stack == null || stack.method_7960()) {
            return Optional.empty();
        }
        
        class_9279 customData = stack.method_58694(class_9334.field_49628);
        if (customData == null) {
            return Optional.empty();
        }
        
        class_2487 rootNbt = customData.method_57461();
        if (!rootNbt.method_10545(AUDIO_DISC_KEY)) {
            return Optional.empty();
        }
        
        return rootNbt.method_10562(AUDIO_DISC_KEY);
    }

    public static Optional<String> getAudioId(class_1799 stack) {
        return getAudioDiscNbt(stack)
            .flatMap(nbt -> nbt.method_10558(AUDIO_ID_KEY))
            .filter(s -> !s.isBlank());
    }

    public static Optional<String> getUploadedBy(class_1799 stack) {
        return getAudioDiscNbt(stack)
            .flatMap(nbt -> nbt.method_10558(UPLOADED_BY_KEY))
            .filter(s -> !s.isBlank());
    }

    public static Optional<AudioMetadata> getMetadata(class_1799 stack) {
        return getAudioDiscNbt(stack)
            .filter(nbt -> nbt.method_10545(METADATA_KEY))
            .flatMap(nbt -> nbt.method_10562(METADATA_KEY))
            .flatMap(NbtUtils::deserializeMetadata);
    }

    public static boolean hasCustomAudio(class_1799 stack) {
        return getAudioId(stack).isPresent();
    }

    public static boolean validateNbtIntegrity(class_1799 stack) {
        return getAudioDiscNbt(stack)
            .map(nbt -> nbt.method_10545(AUDIO_ID_KEY) &&
                       nbt.method_10545(UPLOADED_BY_KEY) &&
                       nbt.method_10545(UPLOAD_TIME_KEY) &&
                       nbt.method_10545(METADATA_KEY))
            .orElse(false);
    }

    /**
     * Sets a custom title for a music disc.
     * 
     * @param stack The music disc ItemStack
     * @param customTitle The custom title to set
     */
    public static void setCustomTitle(class_1799 stack, String customTitle) {
        if (stack.method_7960()) return;
        
        class_9279 currentData = stack.method_58695(class_9334.field_49628, class_9279.field_49302);
        class_2487 rootNbt = currentData.method_57461();
        
        // Get or create audio_disc compound
        class_2487 audioDiscNbt;
        if (rootNbt.method_10545(AUDIO_DISC_KEY)) {
            Optional<class_2487> audioDiscNbtOpt = rootNbt.method_10562(AUDIO_DISC_KEY);
            audioDiscNbt = audioDiscNbtOpt.orElse(new class_2487());
        } else {
            audioDiscNbt = new class_2487();
        }
        
        // Set custom title
        audioDiscNbt.method_10582("custom_title", customTitle);
        
        rootNbt.method_10566(AUDIO_DISC_KEY, audioDiscNbt);
        stack.method_57379(class_9334.field_49628, class_9279.method_57456(rootNbt));
    }

    /**
     * Clears all audio data from a music disc.
     * 
     * @param stack The music disc ItemStack
     */
    public static void clearAudioData(class_1799 stack) {
        if (stack.method_7960()) return;
        
        class_9279 currentData = stack.method_58694(class_9334.field_49628);
        if (currentData == null) return;
        
        class_2487 rootNbt = currentData.method_57461();
        
        // Remove audio_disc data
        if (rootNbt.method_10545(AUDIO_DISC_KEY)) {
            rootNbt.method_10551(AUDIO_DISC_KEY);
            
            if (rootNbt.method_33133()) {
                // If NBT is now empty, remove the component entirely
                stack.method_57381(class_9334.field_49628);
            } else {
                stack.method_57379(class_9334.field_49628, class_9279.method_57456(rootNbt));
            }
        }
    }
}
