/*
 * Decompiled with CFR 0.152.
 */
package org.stepan.audio_disc;

import java.lang.reflect.Method;
import java.nio.file.Path;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.spi.AudioFileReader;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.loader.api.FabricLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.stepan.audio_disc.api.AudioDiscAPI;
import org.stepan.audio_disc.api.AudioDiscAPIImpl;
import org.stepan.audio_disc.command.AudioDiscCommand;
import org.stepan.audio_disc.config.AudioDiscConfig;
import org.stepan.audio_disc.download.AudioDownloadManager;
import org.stepan.audio_disc.download.FFmpegManager;
import org.stepan.audio_disc.download.YtDlpManager;
import org.stepan.audio_disc.events.JukeboxEventHandler;
import org.stepan.audio_disc.playback.PlaybackManager;
import org.stepan.audio_disc.playback.SimpleVoiceChatIntegration;
import org.stepan.audio_disc.processing.AudioProcessor;
import org.stepan.audio_disc.storage.AudioStorageManager;
import org.stepan.audio_disc.util.Localization;
import org.stepan.audio_disc.util.RateLimiter;

public class Audio_disc
implements ModInitializer {
    public static final String MOD_ID = "audio_disc";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"AudioDisc");
    private static AudioDiscConfig config;
    private static AudioDownloadManager downloadManager;
    private static AudioProcessor audioProcessor;
    private static AudioStorageManager storageManager;
    private static PlaybackManager playbackManager;
    private static SimpleVoiceChatIntegration voiceChatIntegration;
    private static RateLimiter rateLimiter;

    public void onInitialize() {
        LOGGER.info("Initializing Audio Disc mod");
        Path configPath = FabricLoader.getInstance().getConfigDir().resolve("audiodisc").resolve("config.json");
        config = AudioDiscConfig.load(configPath);
        if (!config.validate()) {
            LOGGER.error("Configuration validation failed. Please check your config.json file.");
        } else {
            LOGGER.info("Configuration loaded successfully");
        }
        Localization.loadLanguage(config.getLanguage());
        LOGGER.info("Localization loaded for language: {}", (Object)config.getLanguage());
        Audio_disc.testAudioLibraries();
        try {
            downloadManager = new AudioDownloadManager(config.getMaxFileSize(), config.getDownloadTimeout(), 5);
            LOGGER.info("AudioDownloadManager initialized");
            audioProcessor = new AudioProcessor();
            LOGGER.info("AudioProcessor initialized");
            Path storageDir = FabricLoader.getInstance().getGameDir().resolve(config.getStorageDirectory());
            storageManager = new AudioStorageManager(storageDir);
            LOGGER.info("AudioStorageManager initialized");
            voiceChatIntegration = new SimpleVoiceChatIntegration();
            voiceChatIntegration.setConfig(config);
            boolean voiceChatLoaded = FabricLoader.getInstance().isModLoaded("voicechat");
            if (voiceChatLoaded) {
                LOGGER.info("Simple Voice Chat mod detected");
                LOGGER.info("Voice Chat will initialize the plugin automatically");
            } else {
                LOGGER.warn("Simple Voice Chat mod not found! Custom audio playback will not work.");
                LOGGER.warn("Please install Simple Voice Chat: https://modrinth.com/plugin/simple-voice-chat");
            }
            LOGGER.info("SimpleVoiceChatIntegration created");
            playbackManager = new PlaybackManager(voiceChatIntegration, storageManager);
            LOGGER.info("PlaybackManager initialized");
            rateLimiter = new RateLimiter(config);
            LOGGER.info("RateLimiter initialized");
            AudioDiscAPIImpl.getInstance();
            LOGGER.info("API initialized and ready for addons");
            CommandRegistrationCallback.EVENT.register(AudioDiscCommand::register);
            LOGGER.info("Commands registered");
            JukeboxEventHandler.register();
            LOGGER.info("Jukebox event handlers registered");
            Audio_disc.initializeYtDlp();
            Audio_disc.initializeFFmpeg();
            Runtime.getRuntime().addShutdownHook(new Thread(() -> {
                LOGGER.info("Shutting down Audio Disc mod");
                if (downloadManager != null) {
                    downloadManager.shutdown();
                }
                if (playbackManager != null) {
                    playbackManager.shutdown();
                }
                if (voiceChatIntegration != null) {
                    voiceChatIntegration.stopAllStreams();
                }
            }));
        }
        catch (Exception e) {
            LOGGER.error("Failed to initialize Audio Disc mod", (Throwable)e);
        }
        LOGGER.info("Audio Disc mod initialized");
    }

    public static AudioDiscConfig getConfig() {
        return config;
    }

    public static AudioDownloadManager getDownloadManager() {
        return downloadManager;
    }

    public static AudioProcessor getAudioProcessor() {
        return audioProcessor;
    }

    public static AudioStorageManager getStorageManager() {
        return storageManager;
    }

    public static PlaybackManager getPlaybackManager() {
        return playbackManager;
    }

    public static SimpleVoiceChatIntegration getVoiceChatIntegration() {
        SimpleVoiceChatIntegration singleton = SimpleVoiceChatIntegration.getInstance();
        return singleton != null ? singleton : voiceChatIntegration;
    }

    public static RateLimiter getRateLimiter() {
        return rateLimiter;
    }

    public static AudioDiscAPI getAPI() {
        return AudioDiscAPIImpl.getInstance();
    }

    public static void updateConfig(AudioDiscConfig newConfig) {
        config = newConfig;
        LOGGER.info("Configuration updated");
    }

    private static void initializeYtDlp() {
        try {
            if (!config.isAutoInstallYtDlp()) {
                LOGGER.info("Automatic yt-dlp installation is disabled in config");
                LOGGER.info("Use /audiodisc ytdlp install to install manually if needed");
                LOGGER.info("YouTube functionality will only work if yt-dlp is manually installed");
                return;
            }
            LOGGER.info("Checking yt-dlp availability on server startup...");
            if (YtDlpManager.isAvailable()) {
                String executablePath = YtDlpManager.getExecutablePath();
                LOGGER.info("yt-dlp is already available at: {}", (Object)executablePath);
                LOGGER.info("YouTube functionality is ready!");
                long size = YtDlpManager.getInstallationSize();
                if (size > 0L) {
                    LOGGER.info("Installation size: {}", (Object)Audio_disc.formatBytes(size));
                }
                return;
            }
            LOGGER.info("yt-dlp not found. Starting automatic download...");
            LOGGER.info("This may take a few seconds depending on your internet connection...");
            LOGGER.info("Server startup will continue in the background...");
            ((CompletableFuture)YtDlpManager.downloadAndInstall().thenAccept(success -> {
                if (success.booleanValue()) {
                    LOGGER.info("yt-dlp successfully installed automatically!");
                    LOGGER.info("YouTube functionality is now available");
                    LOGGER.info("Players can now use /audiodisc youtube <url> command");
                    long size = YtDlpManager.getInstallationSize();
                    if (size > 0L) {
                        LOGGER.info("Installation size: {}", (Object)Audio_disc.formatBytes(size));
                    }
                } else {
                    LOGGER.warn("Failed to install yt-dlp automatically");
                    LOGGER.warn("YouTube functionality will not be available");
                    LOGGER.warn("You can try manual installation:");
                    LOGGER.warn("   - Use /audiodisc ytdlp install command (requires admin)");
                    LOGGER.warn("   - Or install yt-dlp manually on your system");
                    LOGGER.warn("   - Or disable auto-install in config: autoInstallYtDlp = false");
                }
            })).exceptionally(throwable -> {
                LOGGER.error("Error during yt-dlp installation", throwable);
                LOGGER.warn("YouTube functionality will not be available");
                LOGGER.warn("You can disable auto-install in config: autoInstallYtDlp = false");
                LOGGER.warn("Or try manual installation with /audiodisc ytdlp install");
                return null;
            });
        }
        catch (Exception e) {
            LOGGER.error("Error initializing yt-dlp", (Throwable)e);
            LOGGER.warn("YouTube functionality may not be available");
        }
    }

    private static void initializeFFmpeg() {
        try {
            if (!config.isAutoInstallFFmpeg()) {
                LOGGER.info("Automatic FFmpeg installation is disabled in config");
                LOGGER.info("FFmpeg is needed for M4A/WebM conversion");
                LOGGER.info("Install FFmpeg manually for better format support");
                return;
            }
            LOGGER.info("Checking FFmpeg availability on server startup...");
            if (FFmpegManager.isAvailable()) {
                String executablePath = FFmpegManager.getExecutablePath();
                LOGGER.info("FFmpeg is already available at: {}", (Object)executablePath);
                LOGGER.info("Audio conversion functionality is ready!");
                long size = FFmpegManager.getInstallationSize();
                if (size > 0L) {
                    LOGGER.info("Installation size: {}", (Object)Audio_disc.formatBytes(size));
                }
                return;
            }
            LOGGER.info("FFmpeg not found. Starting automatic download...");
            LOGGER.info("This may take a few minutes depending on your internet connection...");
            LOGGER.info("Server startup will continue in the background...");
            ((CompletableFuture)FFmpegManager.downloadAndInstall().thenAccept(success -> {
                if (success.booleanValue()) {
                    LOGGER.info("FFmpeg successfully installed automatically!");
                    LOGGER.info("Audio conversion functionality is now available");
                    LOGGER.info("M4A and WebM files will now be converted automatically");
                    long size = FFmpegManager.getInstallationSize();
                    if (size > 0L) {
                        LOGGER.info("Installation size: {}", (Object)Audio_disc.formatBytes(size));
                    }
                } else {
                    LOGGER.warn("Failed to install FFmpeg automatically");
                    LOGGER.warn("M4A/WebM conversion will not be available");
                    LOGGER.warn("You can try manual installation:");
                    LOGGER.warn("   - Download from https://ffmpeg.org/download.html");
                    LOGGER.warn("   - Or disable auto-install in config: autoInstallFFmpeg = false");
                }
            })).exceptionally(throwable -> {
                LOGGER.error("Error during FFmpeg installation", throwable);
                LOGGER.warn("Audio conversion functionality will not be available");
                LOGGER.warn("You can disable auto-install in config: autoInstallFFmpeg = false");
                LOGGER.warn("Or try manual installation from https://ffmpeg.org/download.html");
                return null;
            });
        }
        catch (Exception e) {
            LOGGER.error("Error initializing FFmpeg", (Throwable)e);
            LOGGER.warn("Audio conversion functionality may not be available");
        }
    }

    private static String formatBytes(long bytes) {
        if (bytes < 1024L) {
            return bytes + " B";
        }
        if (bytes < 0x100000L) {
            return String.format("%.1f KB", (double)bytes / 1024.0);
        }
        return String.format("%.1f MB", (double)bytes / 1048576.0);
    }

    private static void testAudioLibraries() {
        try {
            LOGGER.info("Testing audio library availability...");
            boolean mp3Support = false;
            boolean oggSupport = false;
            try {
                Method method = AudioSystem.class.getDeclaredMethod("getAudioFileReaders", new Class[0]);
                method.setAccessible(true);
                List readers = (List)method.invoke(null, new Object[0]);
                LOGGER.info("Found {} audio file readers:", (Object)readers.size());
                for (AudioFileReader reader : readers) {
                    String className = reader.getClass().getName();
                    LOGGER.info("  - {}", (Object)className);
                    if (className.contains("mpeg") || className.contains("mp3")) {
                        mp3Support = true;
                    }
                    if (!className.contains("ogg") && !className.contains("vorbis")) continue;
                    oggSupport = true;
                }
            }
            catch (Exception reflectionException) {
                LOGGER.warn("Could not list audio file readers using reflection: {}", (Object)reflectionException.getMessage());
                try {
                    Class.forName("javazoom.spi.mpeg.sampled.file.MpegAudioFileReader");
                    mp3Support = true;
                    LOGGER.info("MP3 support detected via class loading");
                }
                catch (ClassNotFoundException e) {
                    LOGGER.info("MP3 support not detected");
                }
                LOGGER.info("OGG support disabled to prevent conflicts");
            }
            LOGGER.info("Audio format support:");
            LOGGER.info("  MP3: {}", (Object)(mp3Support ? "\u2713" : "\u2717"));
            LOGGER.info("  OGG: {}", (Object)(oggSupport ? "\u2713" : "\u2717"));
            LOGGER.info("  WAV: \u2713 (built-in)");
            if (!mp3Support) {
                LOGGER.warn("MP3 support not available! MP3 files may not play correctly.");
                LOGGER.warn("Make sure mp3spi library is properly included in the mod.");
            }
            if (!oggSupport) {
                LOGGER.warn("OGG support not available! OGG files may not play correctly.");
                LOGGER.warn("Make sure vorbisspi library is properly included in the mod.");
            }
        }
        catch (Exception e) {
            LOGGER.error("Error testing audio libraries: {}", (Object)e.getMessage());
        }
    }
}

