/*
 * Decompiled with CFR 0.152.
 */
package org.stepan.audio_disc.api;

import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import net.minecraft.class_1799;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.stepan.audio_disc.Audio_disc;
import org.stepan.audio_disc.api.AudioDiscAPI;
import org.stepan.audio_disc.api.AudioEventListener;
import org.stepan.audio_disc.api.AudioModification;
import org.stepan.audio_disc.api.AudioModificationContext;
import org.stepan.audio_disc.api.AudioUploadEvent;
import org.stepan.audio_disc.api.PlaybackStartEvent;
import org.stepan.audio_disc.api.PlaybackStopEvent;
import org.stepan.audio_disc.model.AudioData;
import org.stepan.audio_disc.model.AudioMetadata;
import org.stepan.audio_disc.storage.AudioStorageManager;

public class AudioDiscAPIImpl
implements AudioDiscAPI {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"AudioDisc");
    private static AudioDiscAPIImpl instance;
    private final Set<AudioEventListener> listeners = new CopyOnWriteArraySet<AudioEventListener>();

    private AudioDiscAPIImpl() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static AudioDiscAPIImpl getInstance() {
        if (instance != null) return instance;
        Class<AudioDiscAPIImpl> clazz = AudioDiscAPIImpl.class;
        synchronized (AudioDiscAPIImpl.class) {
            if (instance != null) return instance;
            instance = new AudioDiscAPIImpl();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    @Override
    public void registerListener(AudioEventListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Listener cannot be null");
        }
        this.listeners.add(listener);
        LOGGER.info("Registered audio event listener: {}", (Object)listener.getClass().getName());
    }

    @Override
    public void unregisterListener(AudioEventListener listener) {
        if (listener == null) {
            return;
        }
        this.listeners.remove(listener);
        LOGGER.info("Unregistered audio event listener: {}", (Object)listener.getClass().getName());
    }

    @Override
    public Optional<AudioMetadata> getAudioMetadata(String audioId) {
        if (audioId == null || audioId.isBlank()) {
            return Optional.empty();
        }
        AudioStorageManager storageManager = Audio_disc.getStorageManager();
        if (storageManager == null) {
            return Optional.empty();
        }
        Optional<AudioData> audioData = storageManager.getAudio(audioId);
        return audioData.map(AudioData::metadata);
    }

    @Override
    public boolean hasCustomAudio(class_1799 disc) {
        if (disc == null || disc.method_7960()) {
            return false;
        }
        AudioStorageManager storageManager = Audio_disc.getStorageManager();
        if (storageManager == null) {
            return false;
        }
        return storageManager.getDiscAudioId(disc).isPresent();
    }

    @Override
    public Optional<String> getAudioId(class_1799 disc) {
        if (disc == null || disc.method_7960()) {
            return Optional.empty();
        }
        AudioStorageManager storageManager = Audio_disc.getStorageManager();
        if (storageManager == null) {
            return Optional.empty();
        }
        return storageManager.getDiscAudioId(disc);
    }

    public void firePlaybackStartEvent(PlaybackStartEvent event) {
        for (AudioEventListener listener : this.listeners) {
            try {
                listener.onPlaybackStart(event);
            }
            catch (Exception e) {
                LOGGER.error("Error in listener {} handling playback start event", (Object)listener.getClass().getName(), (Object)e);
            }
        }
    }

    public void firePlaybackStopEvent(PlaybackStopEvent event) {
        for (AudioEventListener listener : this.listeners) {
            try {
                listener.onPlaybackStop(event);
            }
            catch (Exception e) {
                LOGGER.error("Error in listener {} handling playback stop event", (Object)listener.getClass().getName(), (Object)e);
            }
        }
    }

    public void fireAudioUploadEvent(AudioUploadEvent event) {
        for (AudioEventListener listener : this.listeners) {
            try {
                listener.onAudioUpload(event);
            }
            catch (Exception e) {
                LOGGER.error("Error in listener {} handling audio upload event", (Object)listener.getClass().getName(), (Object)e);
            }
        }
    }

    public AudioModification callModifyAudio(AudioModificationContext context) {
        AudioModification finalModification = AudioModification.noChange();
        for (AudioEventListener listener : this.listeners) {
            try {
                AudioModification modification = listener.modifyAudio(context);
                if (modification.isCancelled()) {
                    LOGGER.info("Audio playback cancelled by listener: {}", (Object)listener.getClass().getName());
                    return modification;
                }
                if (!modification.isModified()) continue;
                finalModification = modification;
                LOGGER.debug("Audio modified by listener: {}", (Object)listener.getClass().getName());
            }
            catch (Exception e) {
                LOGGER.error("Error in listener {} modifying audio", (Object)listener.getClass().getName(), (Object)e);
            }
        }
        return finalModification;
    }

    public int getListenerCount() {
        return this.listeners.size();
    }

    public void clearListeners() {
        this.listeners.clear();
        LOGGER.info("Cleared all audio event listeners");
    }
}

