/*
 * Decompiled with CFR 0.152.
 */
package org.stepan.audio_disc.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AudioDiscConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"AudioDisc");
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private long maxFileSize = 0x3200000L;
    private int downloadTimeout = 30;
    private long maxDuration = -1L;
    private List<String> supportedFormats = List.of("mp3", "ogg", "wav");
    private boolean enableProgressUpdates = true;
    private int progressUpdateInterval = 25;
    private String storageDirectory = "audiodisc/audio";
    private boolean enableApiEvents = true;
    private String language = "en_us";
    private double audioRange = 64.0;
    private boolean autoInstallYtDlp = true;
    private boolean autoInstallFFmpeg = true;
    private boolean enableRateLimit = true;
    private int maxUploadsPerMinute = 3;
    private int maxUploadsPerHour = 10;
    private int rateLimitCooldown = 60;
    private int maxConcurrentDownloads = 5;

    public static AudioDiscConfig load(Path configPath) {
        if (Files.exists(configPath, new LinkOption[0])) {
            try {
                String json = Files.readString(configPath);
                AudioDiscConfig config = (AudioDiscConfig)GSON.fromJson(json, AudioDiscConfig.class);
                LOGGER.info("Loaded configuration from {}", (Object)configPath);
                return config;
            }
            catch (IOException e) {
                LOGGER.error("Failed to load configuration from {}, using defaults", (Object)configPath, (Object)e);
                return AudioDiscConfig.createDefault(configPath);
            }
        }
        LOGGER.info("Configuration file not found, creating default at {}", (Object)configPath);
        return AudioDiscConfig.createDefault(configPath);
    }

    private static AudioDiscConfig createDefault(Path configPath) {
        AudioDiscConfig config = new AudioDiscConfig();
        config.save(configPath);
        return config;
    }

    public void save(Path configPath) {
        try {
            Files.createDirectories(configPath.getParent(), new FileAttribute[0]);
            String json = GSON.toJson((Object)this);
            Files.writeString(configPath, (CharSequence)json, new OpenOption[0]);
            LOGGER.info("Saved configuration to {}", (Object)configPath);
        }
        catch (IOException e) {
            LOGGER.error("Failed to save configuration to {}", (Object)configPath, (Object)e);
        }
    }

    public boolean validate() {
        if (this.maxFileSize <= 0L || this.maxFileSize > 0x6400000L) {
            LOGGER.warn("Invalid maxFileSize: {}. Must be between 1 and 104857600 bytes", (Object)this.maxFileSize);
            return false;
        }
        if (this.downloadTimeout <= 0 || this.downloadTimeout > 300) {
            LOGGER.warn("Invalid downloadTimeout: {}. Must be between 1 and 300 seconds", (Object)this.downloadTimeout);
            return false;
        }
        if (this.maxDuration != -1L && this.maxDuration <= 0L) {
            LOGGER.warn("Invalid maxDuration: {}. Must be -1 (unlimited) or positive value in milliseconds", (Object)this.maxDuration);
            return false;
        }
        if (this.supportedFormats == null || this.supportedFormats.isEmpty()) {
            LOGGER.warn("supportedFormats cannot be empty");
            return false;
        }
        if (this.progressUpdateInterval <= 0 || this.progressUpdateInterval > 100) {
            LOGGER.warn("Invalid progressUpdateInterval: {}. Must be between 1 and 100", (Object)this.progressUpdateInterval);
            return false;
        }
        if (this.storageDirectory == null || this.storageDirectory.isBlank()) {
            LOGGER.warn("storageDirectory cannot be empty");
            return false;
        }
        if (this.language == null || this.language.isBlank()) {
            LOGGER.warn("language cannot be empty");
            return false;
        }
        if (this.audioRange <= 0.0 || this.audioRange > 1000.0) {
            LOGGER.warn("Invalid audioRange: {}. Must be between 1 and 1000 blocks", (Object)this.audioRange);
            return false;
        }
        return true;
    }

    public long getMaxFileSize() {
        return this.maxFileSize;
    }

    public int getDownloadTimeout() {
        return this.downloadTimeout;
    }

    public long getMaxDuration() {
        return this.maxDuration;
    }

    public List<String> getSupportedFormats() {
        return this.supportedFormats;
    }

    public boolean isEnableProgressUpdates() {
        return this.enableProgressUpdates;
    }

    public int getProgressUpdateInterval() {
        return this.progressUpdateInterval;
    }

    public String getStorageDirectory() {
        return this.storageDirectory;
    }

    public boolean isEnableApiEvents() {
        return this.enableApiEvents;
    }

    public String getLanguage() {
        return this.language;
    }

    public double getAudioRange() {
        return this.audioRange;
    }

    public boolean isAutoInstallYtDlp() {
        return this.autoInstallYtDlp;
    }

    public boolean isAutoInstallFFmpeg() {
        return this.autoInstallFFmpeg;
    }

    public boolean isEnableRateLimit() {
        return this.enableRateLimit;
    }

    public int getMaxUploadsPerMinute() {
        return this.maxUploadsPerMinute;
    }

    public int getMaxUploadsPerHour() {
        return this.maxUploadsPerHour;
    }

    public int getRateLimitCooldown() {
        return this.rateLimitCooldown;
    }

    public int getMaxConcurrentDownloads() {
        return this.maxConcurrentDownloads;
    }
}

