/*
 * Decompiled with CFR 0.152.
 */
package org.stepan.audio_disc.download;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.UUID;
import java.util.function.Consumer;
import org.stepan.audio_disc.model.DownloadStatus;

public class DownloadTask {
    private final UUID taskId;
    private final String url;
    private final UUID playerId;
    private volatile int progress;
    private volatile DownloadStatus status;
    private volatile boolean cancelled;
    private final Consumer<Integer> progressCallback;
    private final long maxFileSize;
    private final int timeoutSeconds;

    public DownloadTask(UUID taskId, String url, UUID playerId, Consumer<Integer> progressCallback, long maxFileSize, int timeoutSeconds) {
        this.taskId = taskId;
        this.url = url;
        this.playerId = playerId;
        this.progress = 0;
        this.status = DownloadStatus.PENDING;
        this.cancelled = false;
        this.progressCallback = progressCallback;
        this.maxFileSize = maxFileSize;
        this.timeoutSeconds = timeoutSeconds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] execute() throws IOException {
        if (this.cancelled) {
            this.status = DownloadStatus.CANCELLED;
            throw new IOException("Download cancelled");
        }
        this.status = DownloadStatus.DOWNLOADING;
        URL downloadUrl = new URL(this.url);
        HttpURLConnection connection = (HttpURLConnection)downloadUrl.openConnection();
        connection.setRequestMethod("GET");
        connection.setConnectTimeout(this.timeoutSeconds * 1000);
        connection.setReadTimeout(this.timeoutSeconds * 1000);
        connection.setRequestProperty("User-Agent", "AudioDisc-Minecraft-Mod/1.0");
        try {
            int bytesRead;
            long contentLength;
            int responseCode = connection.getResponseCode();
            if (responseCode != 200) {
                throw new IOException("HTTP error code: " + responseCode);
            }
            String contentType = connection.getContentType();
            if (contentType != null) {
                boolean validContentType;
                boolean bl = validContentType = (contentType = contentType.toLowerCase()).contains("audio/") || contentType.contains("application/octet-stream") || contentType.contains("application/ogg") || contentType.contains("application/binary");
                if (!validContentType) {
                    throw new IOException("Invalid content type: " + contentType + ". Expected audio file.");
                }
            }
            if ((contentLength = connection.getContentLengthLong()) > this.maxFileSize) {
                throw new IOException("File too large: " + contentLength + " bytes (max: " + this.maxFileSize + ")");
            }
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            InputStream inputStream = connection.getInputStream();
            byte[] buffer = new byte[8192];
            long totalBytesRead = 0L;
            int lastReportedProgress = 0;
            while ((bytesRead = inputStream.read(buffer)) != -1) {
                int currentProgress;
                if (this.cancelled) {
                    this.status = DownloadStatus.CANCELLED;
                    throw new IOException("Download cancelled");
                }
                outputStream.write(buffer, 0, bytesRead);
                if ((totalBytesRead += (long)bytesRead) > this.maxFileSize) {
                    throw new IOException("File size exceeded during download");
                }
                if (contentLength <= 0L || (currentProgress = (int)(totalBytesRead * 100L / contentLength)) < lastReportedProgress + 10) continue;
                this.progress = currentProgress;
                lastReportedProgress = currentProgress;
                if (this.progressCallback == null) continue;
                this.progressCallback.accept(currentProgress);
            }
            this.progress = 100;
            if (this.progressCallback != null) {
                this.progressCallback.accept(100);
            }
            this.status = DownloadStatus.COMPLETE;
            byte[] byArray = outputStream.toByteArray();
            return byArray;
        }
        finally {
            connection.disconnect();
        }
    }

    public void cancel() {
        this.cancelled = true;
        this.status = DownloadStatus.CANCELLED;
    }

    public UUID getTaskId() {
        return this.taskId;
    }

    public String getUrl() {
        return this.url;
    }

    public UUID getPlayerId() {
        return this.playerId;
    }

    public int getProgress() {
        return this.progress;
    }

    public DownloadStatus getStatus() {
        return this.status;
    }

    public boolean isCancelled() {
        return this.cancelled;
    }
}

