/*
 * Decompiled with CFR 0.152.
 */
package org.stepan.audio_disc.events;

import java.util.Optional;
import net.fabricmc.fabric.api.event.player.UseBlockCallback;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_2619;
import net.minecraft.class_3218;
import net.minecraft.class_3965;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.stepan.audio_disc.Audio_disc;
import org.stepan.audio_disc.playback.PlaybackManager;
import org.stepan.audio_disc.storage.AudioStorageManager;

public class JukeboxEventHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"AudioDisc");

    public static void register() {
        UseBlockCallback.EVENT.register(JukeboxEventHandler::onUseBlock);
        LOGGER.info("Registered jukebox event handlers");
    }

    private static class_1269 onUseBlock(class_1657 player, class_1937 world, class_1268 hand, class_3965 hitResult) {
        if (world.field_9236) {
            return class_1269.field_5811;
        }
        class_2338 pos = hitResult.method_17777();
        if (!world.method_8320(pos).method_27852(class_2246.field_10223)) {
            return class_1269.field_5811;
        }
        class_2586 class_25862 = world.method_8321(pos);
        if (!(class_25862 instanceof class_2619)) {
            return class_1269.field_5811;
        }
        class_2619 jukebox = (class_2619)class_25862;
        class_1799 heldItem = player.method_5998(hand);
        class_1799 currentDisc = jukebox.method_54079();
        if (currentDisc.method_7960() && !heldItem.method_7960() && JukeboxEventHandler.isMusicDisc(heldItem)) {
            return JukeboxEventHandler.handleDiscInsertion(player, (class_3218)world, pos, jukebox, heldItem, hand);
        }
        if (!currentDisc.method_7960()) {
            return JukeboxEventHandler.handleDiscRemoval(player, (class_3218)world, pos, jukebox, currentDisc, heldItem.method_7960());
        }
        return class_1269.field_5811;
    }

    private static class_1269 handleDiscInsertion(class_1657 player, class_3218 world, class_2338 pos, class_2619 jukebox, class_1799 disc, class_1268 hand) {
        PlaybackManager playbackManager;
        AudioStorageManager storageManager = Audio_disc.getStorageManager();
        if (storageManager == null) {
            return class_1269.field_5811;
        }
        Optional<String> audioId = storageManager.getDiscAudioId(disc);
        if (audioId.isEmpty()) {
            return class_1269.field_5811;
        }
        LOGGER.info("Custom audio disc detected, starting custom playback at {}", (Object)pos);
        class_1799 discCopy = disc.method_7972();
        discCopy.method_7939(1);
        jukebox.method_54077(discCopy);
        if (!player.method_31549().field_7477) {
            disc.method_7934(1);
        }
        if ((playbackManager = Audio_disc.getPlaybackManager()) != null) {
            boolean started = playbackManager.startPlayback(world, pos, discCopy);
            if (started) {
                LOGGER.info("Started custom audio playback at {}", (Object)pos);
            } else {
                LOGGER.warn("Failed to start custom audio playback at {}", (Object)pos);
            }
        }
        return class_1269.field_5812;
    }

    private static class_1269 handleDiscRemoval(class_1657 player, class_3218 world, class_2338 pos, class_2619 jukebox, class_1799 currentDisc, boolean handWasEmpty) {
        AudioStorageManager storageManager = Audio_disc.getStorageManager();
        if (storageManager == null) {
            return class_1269.field_5811;
        }
        Optional<String> audioId = storageManager.getDiscAudioId(currentDisc);
        if (audioId.isEmpty()) {
            return class_1269.field_5811;
        }
        LOGGER.info("Removing custom audio disc from jukebox at {}", (Object)pos);
        PlaybackManager playbackManager = Audio_disc.getPlaybackManager();
        if (playbackManager != null) {
            playbackManager.stopPlayback(pos);
        }
        if (handWasEmpty) {
            jukebox.method_54077(class_1799.field_8037);
            if (!player.method_31548().method_7394(currentDisc)) {
                player.method_7328(currentDisc, false);
            }
            return class_1269.field_5812;
        }
        return class_1269.field_5811;
    }

    private static boolean isMusicDisc(class_1799 stack) {
        if (stack.method_7960()) {
            return false;
        }
        String itemName = stack.method_7909().toString();
        return itemName.contains("music_disc");
    }
}

