/*
 * Decompiled with CFR 0.152.
 */
package org.stepan.audio_disc.model;

import org.stepan.audio_disc.model.AudioMetadata;

public class AudioData {
    private final String id;
    private final byte[] data;
    private final AudioMetadata metadata;
    private final String uploadedBy;
    private final long uploadTime;

    public AudioData(String id, byte[] data, AudioMetadata metadata, String uploadedBy, long uploadTime) {
        if (id == null || id.isBlank()) {
            throw new IllegalArgumentException("ID cannot be null or blank");
        }
        if (data == null || data.length == 0) {
            throw new IllegalArgumentException("Data cannot be null or empty");
        }
        if (metadata == null) {
            throw new IllegalArgumentException("Metadata cannot be null");
        }
        if (uploadedBy == null || uploadedBy.isBlank()) {
            throw new IllegalArgumentException("UploadedBy cannot be null or blank");
        }
        if (uploadTime < 0L) {
            throw new IllegalArgumentException("UploadTime cannot be negative");
        }
        this.id = id;
        this.data = (byte[])data.clone();
        this.metadata = metadata;
        this.uploadedBy = uploadedBy;
        this.uploadTime = uploadTime;
    }

    public String getId() {
        return this.id;
    }

    public byte[] getData() {
        return (byte[])this.data.clone();
    }

    public AudioMetadata getMetadata() {
        return this.metadata;
    }

    public String getUploadedBy() {
        return this.uploadedBy;
    }

    public long getUploadTime() {
        return this.uploadTime;
    }

    public String id() {
        return this.id;
    }

    public byte[] data() {
        return this.getData();
    }

    public AudioMetadata metadata() {
        return this.metadata;
    }

    public String uploadedBy() {
        return this.uploadedBy;
    }

    public long uploadTime() {
        return this.uploadTime;
    }
}

