/*
 * Decompiled with CFR 0.152.
 */
package org.stepan.audio_disc.playback;

import de.maxhenkel.voicechat.api.Position;
import de.maxhenkel.voicechat.api.audiochannel.AudioChannel;
import de.maxhenkel.voicechat.api.audiochannel.AudioPlayer;
import de.maxhenkel.voicechat.api.audiochannel.LocationalAudioChannel;
import de.maxhenkel.voicechat.api.opus.OpusEncoderMode;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_3218;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.stepan.audio_disc.api.AudioDiscAPIImpl;
import org.stepan.audio_disc.api.AudioModification;
import org.stepan.audio_disc.api.AudioModificationContext;
import org.stepan.audio_disc.api.PlaybackStartEvent;
import org.stepan.audio_disc.api.PlaybackStopEvent;
import org.stepan.audio_disc.api.StopReason;
import org.stepan.audio_disc.model.AudioData;
import org.stepan.audio_disc.model.AudioMetadata;
import org.stepan.audio_disc.playback.ActivePlayback;
import org.stepan.audio_disc.playback.SimpleVoiceChatIntegration;
import org.stepan.audio_disc.storage.AudioStorageManager;

public class PlaybackManager {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"AudioDisc");
    private final Map<class_2338, ActivePlayback> activePlaybacks = new ConcurrentHashMap<class_2338, ActivePlayback>();
    private final SimpleVoiceChatIntegration voiceChatIntegration;
    private final AudioStorageManager storageManager;
    private final ScheduledExecutorService scheduler;

    public PlaybackManager(SimpleVoiceChatIntegration voiceChatIntegration, AudioStorageManager storageManager) {
        this.voiceChatIntegration = voiceChatIntegration;
        this.storageManager = storageManager;
        this.scheduler = Executors.newScheduledThreadPool(1);
        this.startPlaybackMonitor();
    }

    private void startPlaybackMonitor() {
        this.scheduler.scheduleAtFixedRate(() -> {
            try {
                this.checkPlaybackCompletion();
            }
            catch (Exception e) {
                LOGGER.error("Error in playback monitor", (Throwable)e);
            }
        }, 1L, 1L, TimeUnit.SECONDS);
    }

    private void checkPlaybackCompletion() {
        this.activePlaybacks.entrySet().removeIf(entry -> {
            ActivePlayback playback = (ActivePlayback)entry.getValue();
            boolean audioFinished = false;
            SimpleVoiceChatIntegration.AudioStreamInfo streamInfo = playback.getStream();
            if (streamInfo instanceof SimpleVoiceChatIntegration.PersonalAudioPlayerInfo) {
                SimpleVoiceChatIntegration.PersonalAudioPlayerInfo playerInfo = (SimpleVoiceChatIntegration.PersonalAudioPlayerInfo)streamInfo;
                audioFinished = playerInfo.getAudioSupplier().isFinished();
            }
            if (!playback.isPlaying() || playback.isComplete() || audioFinished) {
                StopReason reason;
                LOGGER.info("Playback completed at position {} (finished: {}, complete: {})", new Object[]{entry.getKey(), audioFinished, playback.isComplete()});
                StopReason stopReason = reason = playback.isComplete() || audioFinished ? StopReason.PLAYBACK_COMPLETE : StopReason.MANUAL_STOP;
                if (reason == StopReason.PLAYBACK_COMPLETE) {
                    this.ejectDiscFromJukebox((class_2338)entry.getKey());
                }
                this.stopPlayback((class_2338)entry.getKey(), reason);
                return true;
            }
            return false;
        });
    }

    public boolean startPlayback(class_3218 world, class_2338 jukeboxPos, class_1799 disc) {
        Optional<String> audioIdOpt;
        if (this.activePlaybacks.containsKey(jukeboxPos)) {
            LOGGER.debug("Already playing at position {}", (Object)jukeboxPos);
            this.stopPlayback(jukeboxPos);
        }
        if ((audioIdOpt = this.storageManager.getDiscAudioId(disc)).isEmpty()) {
            LOGGER.debug("No custom audio on disc at position {}", (Object)jukeboxPos);
            return false;
        }
        String audioId = audioIdOpt.get();
        LOGGER.info("Starting playback of audio {} at position {}", (Object)audioId, (Object)jukeboxPos);
        Optional<AudioData> audioDataOpt = this.storageManager.getAudio(audioId);
        if (audioDataOpt.isEmpty()) {
            LOGGER.error("Audio data not found for ID: {}", (Object)audioId);
            return false;
        }
        AudioData audioData = audioDataOpt.get();
        AudioMetadata metadata = audioData.metadata();
        if (!this.voiceChatIntegration.isInitialized()) {
            LOGGER.warn("Simple Voice Chat not available, cannot play audio");
            LOGGER.warn("Integration initialized: {}", (Object)this.voiceChatIntegration.isInitialized());
            LOGGER.warn("Please make sure Simple Voice Chat is properly loaded");
            return false;
        }
        LOGGER.info("Simple Voice Chat is available, creating audio stream");
        try {
            AudioModificationContext modContext = new AudioModificationContext(audioId, audioData.data(), metadata, jukeboxPos, world);
            AudioModification modification = AudioDiscAPIImpl.getInstance().callModifyAudio(modContext);
            if (modification.isCancelled()) {
                LOGGER.info("Playback cancelled by API listener at position {}", (Object)jukeboxPos);
                return false;
            }
            byte[] finalAudioData = modification.isModified() && modification.getModifiedData() != null ? modification.getModifiedData() : audioData.data();
            UUID streamId = UUID.randomUUID();
            Position pos = this.voiceChatIntegration.getVoicechatApi().createPosition((double)jukeboxPos.method_10263() + 0.5, (double)jukeboxPos.method_10264() + 0.5, (double)jukeboxPos.method_10260() + 0.5);
            LocationalAudioChannel channel = this.voiceChatIntegration.getVoicechatApi().createLocationalAudioChannel(streamId, this.voiceChatIntegration.getVoicechatApi().fromServerLevel((Object)world), pos);
            if (channel == null) {
                LOGGER.error("Failed to create locational audio channel for jukebox");
                return false;
            }
            channel.setCategory("audio_disc");
            channel.setDistance(64.0f);
            LOGGER.info("Jukebox audio channel created at {} with distance: 64.0", (Object)jukeboxPos);
            SimpleVoiceChatIntegration.PersonalAudioSupplier audioSupplier = new SimpleVoiceChatIntegration.PersonalAudioSupplier(finalAudioData);
            AudioPlayer audioPlayer = this.voiceChatIntegration.getVoicechatApi().createAudioPlayer((AudioChannel)channel, this.voiceChatIntegration.getVoicechatApi().createEncoder(OpusEncoderMode.AUDIO), (Supplier)audioSupplier);
            if (audioPlayer == null) {
                LOGGER.error("Failed to create audio player for jukebox");
                return false;
            }
            SimpleVoiceChatIntegration.PersonalAudioPlayerInfo streamInfo = new SimpleVoiceChatIntegration.PersonalAudioPlayerInfo(streamId, channel, audioPlayer, audioSupplier, jukeboxPos, finalAudioData);
            ActivePlayback playback = new ActivePlayback(audioId, jukeboxPos, streamId, streamInfo, metadata);
            this.activePlaybacks.put(jukeboxPos, playback);
            audioPlayer.startPlaying();
            streamInfo.setPlaying(true);
            LOGGER.info("Started jukebox audio player at {}", (Object)jukeboxPos);
            PlaybackStartEvent startEvent = new PlaybackStartEvent(jukeboxPos, world, audioId, metadata);
            AudioDiscAPIImpl.getInstance().firePlaybackStartEvent(startEvent);
            LOGGER.info("Successfully started playback at position {}", (Object)jukeboxPos);
            return true;
        }
        catch (Exception e) {
            LOGGER.error("Error starting playback", (Throwable)e);
            return false;
        }
    }

    public void stopPlayback(class_2338 jukeboxPos) {
        this.stopPlayback(jukeboxPos, StopReason.MANUAL_STOP);
    }

    public void stopPlayback(class_2338 jukeboxPos, StopReason reason) {
        ActivePlayback playback = this.activePlaybacks.remove(jukeboxPos);
        if (playback != null) {
            long duration = playback.getElapsedTime();
            playback.stop();
            SimpleVoiceChatIntegration.AudioStreamInfo streamInfo = playback.getStream();
            if (streamInfo instanceof SimpleVoiceChatIntegration.PersonalAudioPlayerInfo) {
                SimpleVoiceChatIntegration.PersonalAudioPlayerInfo playerInfo = (SimpleVoiceChatIntegration.PersonalAudioPlayerInfo)streamInfo;
                playerInfo.getAudioPlayer().stopPlaying();
                LOGGER.info("Stopped jukebox audio player at {}", (Object)jukeboxPos);
            } else {
                this.voiceChatIntegration.stopStream(playback.getStreamId());
            }
            PlaybackStopEvent stopEvent = new PlaybackStopEvent(jukeboxPos, null, playback.getAudioId(), duration, reason);
            AudioDiscAPIImpl.getInstance().firePlaybackStopEvent(stopEvent);
            LOGGER.info("Stopped playback at position {} (reason: {})", (Object)jukeboxPos, (Object)reason);
        }
    }

    public Optional<ActivePlayback> getPlayback(class_2338 jukeboxPos) {
        return Optional.ofNullable(this.activePlaybacks.get(jukeboxPos));
    }

    public boolean isPlaying(class_2338 jukeboxPos) {
        ActivePlayback playback = this.activePlaybacks.get(jukeboxPos);
        return playback != null && playback.isPlaying();
    }

    public void stopAllPlaybacks() {
        LOGGER.info("Stopping all playbacks");
        this.activePlaybacks.keySet().forEach(this::stopPlayback);
    }

    public int getActivePlaybackCount() {
        return this.activePlaybacks.size();
    }

    private void ejectDiscFromJukebox(class_2338 jukeboxPos) {
        LOGGER.info("Playback completed at {} - disc can be manually removed", (Object)jukeboxPos);
    }

    public void shutdown() {
        LOGGER.info("Shutting down PlaybackManager");
        this.stopAllPlaybacks();
        this.scheduler.shutdown();
        try {
            if (!this.scheduler.awaitTermination(5L, TimeUnit.SECONDS)) {
                this.scheduler.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            this.scheduler.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }
}

