/*
 * Decompiled with CFR 0.152.
 */
package org.stepan.audio_disc.playback;

import de.maxhenkel.voicechat.api.Position;
import de.maxhenkel.voicechat.api.VoicechatApi;
import de.maxhenkel.voicechat.api.VoicechatPlugin;
import de.maxhenkel.voicechat.api.VoicechatServerApi;
import de.maxhenkel.voicechat.api.audiochannel.AudioChannel;
import de.maxhenkel.voicechat.api.audiochannel.AudioPlayer;
import de.maxhenkel.voicechat.api.audiochannel.LocationalAudioChannel;
import de.maxhenkel.voicechat.api.audiochannel.StaticAudioChannel;
import de.maxhenkel.voicechat.api.events.EventRegistration;
import de.maxhenkel.voicechat.api.events.VoicechatServerStartedEvent;
import de.maxhenkel.voicechat.api.opus.OpusEncoderMode;
import java.io.ByteArrayInputStream;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.UnsupportedAudioFileException;
import javax.sound.sampled.spi.AudioFileReader;
import net.minecraft.class_2338;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.stepan.audio_disc.config.AudioDiscConfig;
import org.stepan.audio_disc.util.Localization;

public class SimpleVoiceChatIntegration
implements VoicechatPlugin {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"AudioDisc");
    private static SimpleVoiceChatIntegration instance;
    private static VoicechatServerApi staticVoicechatApi;
    private static volatile boolean staticInitialized;
    private AudioDiscConfig config;
    private VoicechatServerApi voicechatApi;
    private volatile boolean initialized = false;
    private final Map<UUID, AudioStreamInfo> activeStreams;

    public SimpleVoiceChatIntegration() {
        this.config = null;
        this.activeStreams = new ConcurrentHashMap<UUID, AudioStreamInfo>();
        instance = this;
        LOGGER.info("SimpleVoiceChatIntegration instance created (config will be set later)");
    }

    public SimpleVoiceChatIntegration(AudioDiscConfig config) {
        this.config = config;
        this.activeStreams = new ConcurrentHashMap<UUID, AudioStreamInfo>();
        instance = this;
        LOGGER.info("SimpleVoiceChatIntegration instance created with config");
    }

    public void setConfig(AudioDiscConfig config) {
        this.config = config;
        LOGGER.info("Configuration set for SimpleVoiceChatIntegration");
    }

    public static SimpleVoiceChatIntegration getInstance() {
        return instance;
    }

    public String getPluginId() {
        return "audio_disc";
    }

    public void initialize(VoicechatApi api) {
        LOGGER.info("Simple Voice Chat plugin initialize() called");
        LOGGER.info("API type: {}", (Object)api.getClass().getName());
        if (api instanceof VoicechatServerApi) {
            LOGGER.info("Detected VoicechatServerApi, initializing...");
            this.initializeServerApi((VoicechatServerApi)api);
        } else {
            LOGGER.warn("API is not VoicechatServerApi, waiting for server started event");
        }
    }

    public void registerEvents(EventRegistration registration) {
        registration.registerEvent(VoicechatServerStartedEvent.class, this::onServerStarted);
    }

    private void onServerStarted(VoicechatServerStartedEvent event) {
        LOGGER.info("Voice chat server started event received");
        LOGGER.info("Event voicechat API: {}", (Object)event.getVoicechat());
        LOGGER.info("Current static state: staticInitialized={}, staticVoicechatApi={}", (Object)staticInitialized, (Object)(staticVoicechatApi != null ? 1 : 0));
        if (event.getVoicechat() != null) {
            LOGGER.info("Calling initializeServerApi from onServerStarted");
            this.initializeServerApi(event.getVoicechat());
        } else {
            LOGGER.warn("Event voicechat API is null!");
        }
    }

    public void initializeServerApi(VoicechatServerApi api) {
        LOGGER.info("initializeServerApi called with API: {}", (Object)api.getClass().getName());
        this.voicechatApi = api;
        this.initialized = true;
        staticVoicechatApi = api;
        staticInitialized = true;
        LOGGER.info("Set static flags: staticInitialized={}, staticVoicechatApi={}", (Object)staticInitialized, (Object)(staticVoicechatApi != null ? 1 : 0));
        try {
            String categoryName = Localization.getVoiceChatCategory();
            int[][] discIcon = this.createMusicDiscIcon();
            api.registerVolumeCategory(api.volumeCategoryBuilder().setId("audio_disc").setName(categoryName).setDescription("Volume for custom audio discs").setIcon(discIcon).build());
            LOGGER.info("Registered Voice Chat category: {}", (Object)categoryName);
        }
        catch (Exception e) {
            LOGGER.warn("Failed to register Voice Chat category: {}", (Object)e.getMessage());
        }
        LOGGER.info("Simple Voice Chat server API initialized successfully");
    }

    public VoicechatServerApi getVoicechatApi() {
        if (staticInitialized && staticVoicechatApi != null) {
            return staticVoicechatApi;
        }
        return this.voicechatApi;
    }

    public boolean isInitialized() {
        boolean instanceInit = this.initialized && this.voicechatApi != null;
        boolean staticInit = staticInitialized && staticVoicechatApi != null;
        LOGGER.info("isInitialized check: instanceInit={}, staticInit={}, staticInitialized={}, staticVoicechatApi={}", new Object[]{instanceInit, staticInit, staticInitialized, staticVoicechatApi != null});
        if (staticInit && !instanceInit) {
            LOGGER.info("Copying static Voice Chat API to instance");
            this.voicechatApi = staticVoicechatApi;
            this.initialized = true;
            instanceInit = true;
        }
        boolean result = staticInit || instanceInit;
        LOGGER.info("isInitialized returning: {}", (Object)result);
        return result;
    }

    public boolean createPersonalStream(UUID streamId, class_3222 player, byte[] audioData, String categoryId) {
        if (!this.isInitialized()) {
            LOGGER.warn("Cannot create personal audio stream: Simple Voice Chat not initialized");
            LOGGER.warn("Make sure Simple Voice Chat mod is installed on the server");
            return false;
        }
        try {
            Position pos = this.voicechatApi.createPosition(player.method_23317(), player.method_23318() + 1.0, player.method_23321());
            LocationalAudioChannel channel = this.voicechatApi.createLocationalAudioChannel(streamId, this.voicechatApi.fromServerLevel((Object)player.method_51469()), pos);
            if (channel == null) {
                LOGGER.error("Failed to create locational audio channel for player {}", (Object)player.method_5477().getString());
                return false;
            }
            if (categoryId != null) {
                channel.setCategory(categoryId);
            }
            double audioRange = this.config != null ? this.config.getAudioRange() : 64.0;
            channel.setDistance((float)Math.min(audioRange, 10.0));
            LOGGER.info("Personal locational audio channel created for player {} with ID: {}, category: {}, distance: 5.0", new Object[]{player.method_5477().getString(), streamId, categoryId});
            PersonalAudioSupplier audioSupplier = new PersonalAudioSupplier(audioData);
            AudioPlayer audioPlayer = this.voicechatApi.createAudioPlayer((AudioChannel)channel, this.voicechatApi.createEncoder(OpusEncoderMode.AUDIO), (Supplier)audioSupplier);
            if (audioPlayer == null) {
                LOGGER.error("Failed to create audio player for player {}", (Object)player.method_5477().getString());
                return false;
            }
            PersonalAudioPlayerInfo streamInfo = new PersonalAudioPlayerInfo(streamId, channel, audioPlayer, audioSupplier, player.method_24515(), audioData);
            this.activeStreams.put(streamId, streamInfo);
            audioPlayer.startPlaying();
            streamInfo.setPlaying(true);
            LOGGER.info("Created and started personal audio player {} for player {}", (Object)streamId, (Object)player.method_5477().getString());
            return true;
        }
        catch (Exception e) {
            LOGGER.error("Failed to create personal audio stream for player {}", (Object)player.method_5477().getString(), (Object)e);
            return false;
        }
    }

    public AudioStreamInfo createStream(UUID streamId, class_3218 world, class_2338 position, byte[] audioData, String categoryId) {
        if (!this.isInitialized()) {
            LOGGER.warn("Cannot create audio stream: Simple Voice Chat not initialized");
            LOGGER.warn("Make sure Simple Voice Chat mod is installed on the server");
            return null;
        }
        try {
            Position pos = this.voicechatApi.createPosition((double)position.method_10263() + 0.5, (double)position.method_10264() + 0.5, (double)position.method_10260() + 0.5);
            LocationalAudioChannel channel = this.voicechatApi.createLocationalAudioChannel(streamId, this.voicechatApi.fromServerLevel((Object)world), pos);
            if (channel == null) {
                LOGGER.error("Failed to create locational audio channel");
                return null;
            }
            channel.setCategory(categoryId);
            double audioRange = this.config != null ? this.config.getAudioRange() : 64.0;
            channel.setDistance((float)audioRange);
            LOGGER.info("Channel distance set to: {} blocks", (Object)audioRange);
            LOGGER.info("Channel category set to: {}", (Object)categoryId);
            try {
                LOGGER.info("Audio channel created with ID: {}, category: {}, distance: {}", new Object[]{streamId, categoryId, audioRange});
            }
            catch (Exception e) {
                LOGGER.warn("Error configuring audio channel: {}", (Object)e.getMessage());
            }
            AudioStreamInfo streamInfo = new AudioStreamInfo(streamId, channel, position, audioData);
            this.activeStreams.put(streamId, streamInfo);
            LOGGER.info("Created audio stream {} at position {}", (Object)streamId, (Object)position);
            return streamInfo;
        }
        catch (Exception e) {
            LOGGER.error("Failed to create audio stream", (Throwable)e);
            return null;
        }
    }

    public boolean startStream(UUID streamId) {
        AudioStreamInfo streamInfo = this.activeStreams.get(streamId);
        if (streamInfo == null) {
            LOGGER.warn("Cannot start stream: stream not found {}", (Object)streamId);
            return false;
        }
        try {
            streamInfo.setPlaying(true);
            Thread streamThread = new Thread(() -> this.streamAudioData(streamInfo));
            streamThread.setName("AudioDisc-Stream-" + String.valueOf(streamId));
            streamThread.setDaemon(true);
            streamThread.start();
            LOGGER.info("Started audio stream {}", (Object)streamId);
            return true;
        }
        catch (Exception e) {
            LOGGER.error("Failed to start audio stream", (Throwable)e);
            return false;
        }
    }

    private void streamPersonalAudioData(PersonalAudioStreamInfo streamInfo) {
        try {
            byte[] audioData = streamInfo.getAudioData();
            StaticAudioChannel channel = streamInfo.getStaticChannel();
            LOGGER.info("Starting personal audio stream for player {}: {} bytes", (Object)streamInfo.getPlayer().method_5477().getString(), (Object)audioData.length);
            ByteArrayInputStream bais = new ByteArrayInputStream(audioData);
            try {
                int bytesRead;
                AudioInputStream audioInputStream;
                LOGGER.info("Attempting to decode personal audio data: {} bytes", (Object)audioData.length);
                try {
                    audioInputStream = AudioSystem.getAudioInputStream(bais);
                }
                catch (NoClassDefFoundError ncdfe) {
                    LOGGER.error("Audio library missing: {}", (Object)ncdfe.getMessage());
                    LOGGER.error("Cannot decode audio - falling back to raw data");
                    throw new Exception("Audio library not available", ncdfe);
                }
                AudioFormat format = audioInputStream.getFormat();
                LOGGER.info("Original personal audio format: {} Hz, {} channels, {} bits, encoding: {}", new Object[]{Float.valueOf(format.getSampleRate()), format.getChannels(), format.getSampleSizeInBits(), format.getEncoding()});
                AudioFormat targetFormat = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, 24000.0f, 16, 1, 2, 24000.0f, false);
                AudioInputStream convertedStream = audioInputStream;
                if (!format.matches(targetFormat)) {
                    try {
                        AudioFormat pcmFormat;
                        if (!format.getEncoding().equals(AudioFormat.Encoding.PCM_SIGNED) && AudioSystem.isConversionSupported(pcmFormat = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, format.getSampleRate(), 16, format.getChannels(), format.getChannels() * 2, format.getSampleRate(), false), format)) {
                            convertedStream = AudioSystem.getAudioInputStream(pcmFormat, audioInputStream);
                            LOGGER.info("Converted personal audio to PCM format");
                        }
                        if (AudioSystem.isConversionSupported(targetFormat, convertedStream.getFormat())) {
                            convertedStream = AudioSystem.getAudioInputStream(targetFormat, convertedStream);
                            LOGGER.info("Converted personal audio to target format: 24kHz 16-bit mono");
                        } else {
                            LOGGER.warn("Direct conversion not supported for personal audio, trying alternative approach");
                            targetFormat = convertedStream.getFormat();
                        }
                    }
                    catch (Exception e) {
                        LOGGER.warn("Personal audio format conversion failed: {}", (Object)e.getMessage());
                        convertedStream = audioInputStream;
                        targetFormat = format;
                    }
                }
                LOGGER.info("Final personal audio format: {} Hz, {} channels, {} bits", new Object[]{Float.valueOf(targetFormat.getSampleRate()), targetFormat.getChannels(), targetFormat.getSampleSizeInBits()});
                int frameSize = targetFormat.getFrameSize();
                int sampleRate = (int)targetFormat.getSampleRate();
                int chunkDurationMs = 40;
                int framesPerChunk = sampleRate * chunkDurationMs / 1000;
                int chunkSize = framesPerChunk * frameSize;
                LOGGER.info("Using personal audio chunk size: {} bytes ({} frames, {}ms)", new Object[]{chunkSize, framesPerChunk, chunkDurationMs});
                byte[] buffer = new byte[chunkSize];
                while (streamInfo.isPlaying() && (bytesRead = convertedStream.read(buffer)) != -1) {
                    if (bytesRead == buffer.length) {
                        channel.send(buffer);
                    } else {
                        byte[] chunk = new byte[bytesRead];
                        System.arraycopy(buffer, 0, chunk, 0, bytesRead);
                        channel.send(chunk);
                    }
                    try {
                        Thread.sleep(chunkDurationMs);
                    }
                    catch (InterruptedException e) {
                        LOGGER.info("Personal audio stream {} interrupted during sleep", (Object)streamInfo.getStreamId());
                        Thread.currentThread().interrupt();
                        break;
                    }
                }
                convertedStream.close();
                audioInputStream.close();
            }
            catch (Exception e) {
                LOGGER.error("Could not parse personal audio format: {}", (Object)e.getMessage());
                LOGGER.warn("Attempting to send raw personal audio data as fallback");
                try {
                    int chunkSize = 4096;
                    for (int i = 0; i < audioData.length && streamInfo.isPlaying(); i += chunkSize) {
                        int length = Math.min(chunkSize, audioData.length - i);
                        byte[] chunk = new byte[length];
                        System.arraycopy(audioData, i, chunk, 0, length);
                        channel.send(chunk);
                        try {
                            Thread.sleep(10L);
                            continue;
                        }
                        catch (InterruptedException ie) {
                            LOGGER.info("Personal audio stream {} interrupted during fallback", (Object)streamInfo.getStreamId());
                            Thread.currentThread().interrupt();
                            break;
                        }
                    }
                }
                catch (Exception fallbackException) {
                    LOGGER.error("Fallback personal audio streaming also failed: {}", (Object)fallbackException.getMessage());
                }
                streamInfo.setPlaying(false);
                return;
            }
            streamInfo.setPlaying(false);
            LOGGER.info("Personal audio stream {} finished for player {}", (Object)streamInfo.getStreamId(), (Object)streamInfo.getPlayer().method_5477().getString());
        }
        catch (Exception e) {
            if (e instanceof InterruptedException) {
                LOGGER.info("Personal audio stream {} interrupted", (Object)streamInfo.getStreamId());
                Thread.currentThread().interrupt();
            } else {
                LOGGER.error("Error streaming personal audio data: {}", (Object)e.getMessage());
                LOGGER.debug("Full stack trace:", (Throwable)e);
            }
        }
        catch (NoClassDefFoundError e) {
            LOGGER.error("Audio library error (missing class) in personal stream: {}", (Object)e.getMessage());
            LOGGER.error("This usually means an audio library is not properly loaded");
            LOGGER.error("Try restarting the server or check audio library dependencies");
        }
        catch (Error e) {
            LOGGER.error("Critical error in personal audio streaming: {}", (Object)e.getMessage());
            LOGGER.debug("Full stack trace:", (Throwable)e);
        }
    }

    private void streamAudioData(AudioStreamInfo streamInfo) {
        try {
            byte[] audioData = streamInfo.getAudioData();
            LocationalAudioChannel channel = streamInfo.getChannel();
            ByteArrayInputStream bais = new ByteArrayInputStream(audioData);
            try {
                int bytesRead;
                AudioInputStream audioInputStream;
                LOGGER.info("Attempting to decode audio data: {} bytes", (Object)audioData.length);
                if (audioData.length >= 4) {
                    String header = String.format("%02X %02X %02X %02X", audioData[0] & 0xFF, audioData[1] & 0xFF, audioData[2] & 0xFF, audioData[3] & 0xFF);
                    LOGGER.info("Audio header bytes: {}", (Object)header);
                }
                try {
                    audioInputStream = AudioSystem.getAudioInputStream(bais);
                }
                catch (NoClassDefFoundError ncdfe) {
                    LOGGER.error("Audio library missing: {}", (Object)ncdfe.getMessage());
                    LOGGER.error("Cannot decode audio - falling back to raw data");
                    throw new Exception("Audio library not available", ncdfe);
                }
                AudioFormat format = audioInputStream.getFormat();
                LOGGER.info("Original audio format: {} Hz, {} channels, {} bits, encoding: {}", new Object[]{Float.valueOf(format.getSampleRate()), format.getChannels(), format.getSampleSizeInBits(), format.getEncoding()});
                AudioFormat targetFormat = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, 24000.0f, 16, 1, 2, 24000.0f, false);
                AudioInputStream convertedStream = audioInputStream;
                if (!format.matches(targetFormat)) {
                    try {
                        AudioFormat pcmFormat;
                        if (!format.getEncoding().equals(AudioFormat.Encoding.PCM_SIGNED) && AudioSystem.isConversionSupported(pcmFormat = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, format.getSampleRate(), 16, format.getChannels(), format.getChannels() * 2, format.getSampleRate(), false), format)) {
                            convertedStream = AudioSystem.getAudioInputStream(pcmFormat, audioInputStream);
                            LOGGER.info("Converted to PCM format");
                        }
                        if (AudioSystem.isConversionSupported(targetFormat, convertedStream.getFormat())) {
                            convertedStream = AudioSystem.getAudioInputStream(targetFormat, convertedStream);
                            LOGGER.info("Converted to target format: 24kHz 16-bit mono");
                        } else {
                            LOGGER.warn("Direct conversion not supported, trying alternative approach");
                            targetFormat = convertedStream.getFormat();
                        }
                    }
                    catch (Exception e) {
                        LOGGER.warn("Audio format conversion failed: {}", (Object)e.getMessage());
                        convertedStream = audioInputStream;
                        targetFormat = format;
                    }
                }
                LOGGER.info("Final audio format: {} Hz, {} channels, {} bits", new Object[]{Float.valueOf(targetFormat.getSampleRate()), targetFormat.getChannels(), targetFormat.getSampleSizeInBits()});
                int frameSize = targetFormat.getFrameSize();
                int sampleRate = (int)targetFormat.getSampleRate();
                int chunkDurationMs = 40;
                int framesPerChunk = sampleRate * chunkDurationMs / 1000;
                int chunkSize = framesPerChunk * frameSize;
                LOGGER.info("Using chunk size: {} bytes ({} frames, {}ms)", new Object[]{chunkSize, framesPerChunk, chunkDurationMs});
                byte[] buffer = new byte[chunkSize];
                while (streamInfo.isPlaying() && (bytesRead = convertedStream.read(buffer)) != -1) {
                    if (bytesRead == buffer.length) {
                        channel.send(buffer);
                    } else {
                        byte[] chunk = new byte[bytesRead];
                        System.arraycopy(buffer, 0, chunk, 0, bytesRead);
                        channel.send(chunk);
                    }
                    try {
                        Thread.sleep(chunkDurationMs);
                    }
                    catch (InterruptedException e) {
                        LOGGER.info("Audio stream {} interrupted during sleep", (Object)streamInfo.getStreamId());
                        Thread.currentThread().interrupt();
                        break;
                    }
                }
                convertedStream.close();
                audioInputStream.close();
            }
            catch (Exception e) {
                LOGGER.error("Could not parse audio format: {}", (Object)e.getMessage());
                LOGGER.error("Available audio file readers:");
                try {
                    Method method = AudioSystem.class.getDeclaredMethod("getAudioFileReaders", new Class[0]);
                    method.setAccessible(true);
                    List readers = (List)method.invoke(null, new Object[0]);
                    for (AudioFileReader reader : readers) {
                        LOGGER.error("  - {}", (Object)reader.getClass().getName());
                    }
                }
                catch (Exception reflectionException) {
                    LOGGER.error("Could not list audio file readers: {}", (Object)reflectionException.getMessage());
                }
                LOGGER.warn("Attempting to send raw audio data as fallback");
                try {
                    int chunkSize = 4096;
                    for (int i = 0; i < audioData.length && streamInfo.isPlaying(); i += chunkSize) {
                        int length = Math.min(chunkSize, audioData.length - i);
                        byte[] chunk = new byte[length];
                        System.arraycopy(audioData, i, chunk, 0, length);
                        channel.send(chunk);
                        try {
                            Thread.sleep(10L);
                            continue;
                        }
                        catch (InterruptedException ie) {
                            LOGGER.info("Audio stream {} interrupted during fallback", (Object)streamInfo.getStreamId());
                            Thread.currentThread().interrupt();
                            break;
                        }
                    }
                }
                catch (Exception fallbackException) {
                    LOGGER.error("Fallback audio streaming also failed: {}", (Object)fallbackException.getMessage());
                }
                streamInfo.setPlaying(false);
                return;
            }
            streamInfo.setPlaying(false);
            LOGGER.info("Audio stream {} finished", (Object)streamInfo.getStreamId());
        }
        catch (Exception e) {
            if (e instanceof InterruptedException) {
                LOGGER.info("Audio stream {} interrupted", (Object)streamInfo.getStreamId());
                Thread.currentThread().interrupt();
            } else {
                LOGGER.error("Error streaming audio data: {}", (Object)e.getMessage());
                LOGGER.debug("Full stack trace:", (Throwable)e);
            }
        }
        catch (NoClassDefFoundError e) {
            LOGGER.error("Audio library error (missing class): {}", (Object)e.getMessage());
            LOGGER.error("This usually means an audio library is not properly loaded");
            LOGGER.error("Try restarting the server or check audio library dependencies");
        }
        catch (Error e) {
            LOGGER.error("Critical error in audio streaming: {}", (Object)e.getMessage());
            LOGGER.debug("Full stack trace:", (Throwable)e);
        }
    }

    public void updateStreamPosition(UUID streamId, class_2338 position) {
        AudioStreamInfo streamInfo = this.activeStreams.get(streamId);
        if (streamInfo != null) {
            Position pos = this.voicechatApi.createPosition((double)position.method_10263() + 0.5, (double)position.method_10264() + 0.5, (double)position.method_10260() + 0.5);
            streamInfo.setPosition(position);
            LOGGER.debug("Updated stream {} position to {}", (Object)streamId, (Object)position);
        }
    }

    public void stopStream(UUID streamId) {
        AudioStreamInfo streamInfo = this.activeStreams.remove(streamId);
        if (streamInfo != null) {
            streamInfo.setPlaying(false);
            try {
                if (streamInfo instanceof PersonalAudioPlayerInfo) {
                    PersonalAudioPlayerInfo playerInfo = (PersonalAudioPlayerInfo)streamInfo;
                    playerInfo.getAudioPlayer().stopPlaying();
                    LOGGER.info("Stopped audio player for stream {}", (Object)streamId);
                }
            }
            catch (Exception e) {
                LOGGER.warn("Error stopping audio channel: {}", (Object)e.getMessage());
            }
            LOGGER.info("Stopped audio stream {}", (Object)streamId);
        }
    }

    public void stopAllStreams() {
        LOGGER.info("Stopping all audio streams");
        this.activeStreams.keySet().forEach(this::stopStream);
    }

    public int getActiveStreamCount() {
        return this.activeStreams.size();
    }

    private int[][] createMusicDiscIcon() {
        int x;
        int y;
        int[][] icon = new int[16][16];
        int transparent = 0;
        int black = -16777216;
        int darkGray = -12566464;
        int gray = -8355712;
        int lightGray = -4144960;
        int white = -1;
        int gold = -10496;
        for (y = 0; y < 16; ++y) {
            for (x = 0; x < 16; ++x) {
                icon[y][x] = transparent;
            }
        }
        for (y = 2; y < 14; ++y) {
            for (x = 2; x < 14; ++x) {
                double dx = (double)x - 7.5;
                double dy = (double)y - 7.5;
                double distance = Math.sqrt(dx * dx + dy * dy);
                if (distance <= 5.5 && distance >= 4.5) {
                    icon[y][x] = black;
                    continue;
                }
                if (distance <= 4.5 && distance >= 1.5) {
                    if (distance <= 2.5) {
                        icon[y][x] = lightGray;
                        continue;
                    }
                    if (distance <= 3.5) {
                        icon[y][x] = gray;
                        continue;
                    }
                    icon[y][x] = darkGray;
                    continue;
                }
                if (!(distance <= 1.5)) continue;
                icon[y][x] = black;
            }
        }
        icon[4][6] = white;
        icon[4][7] = white;
        icon[5][6] = lightGray;
        return icon;
    }

    static {
        staticInitialized = false;
        try {
            Class.forName("javazoom.spi.mpeg.sampled.file.MpegAudioFileReader");
            LOGGER.info("MP3 audio provider loaded successfully");
        }
        catch (ClassNotFoundException e) {
            LOGGER.warn("MP3 audio provider not available: {}", (Object)e.getMessage());
        }
        try {
            Method method = AudioSystem.class.getDeclaredMethod("getAudioFileReaders", new Class[0]);
            method.setAccessible(true);
            List readers = (List)method.invoke(null, new Object[0]);
            LOGGER.info("Available audio file readers: {}", (Object)readers.size());
            for (AudioFileReader reader : readers) {
                LOGGER.info("  - {}", (Object)reader.getClass().getName());
            }
        }
        catch (Exception e) {
            LOGGER.warn("Could not list audio file readers: {}", (Object)e.getMessage());
        }
    }

    public static class PersonalAudioSupplier
    implements Supplier<short[]> {
        private final byte[] audioData;
        private AudioInputStream audioInputStream;
        private boolean initialized = false;
        private boolean finished = false;
        private AudioFormat targetFormat;
        private int frameSize;

        public PersonalAudioSupplier(byte[] audioData) {
            this.audioData = audioData;
        }

        @Override
        public short[] get() {
            if (this.finished) {
                return null;
            }
            if (!this.initialized) {
                if (!this.initialize()) {
                    this.finished = true;
                    return null;
                }
                this.initialized = true;
            }
            try {
                short[] frame = new short[960];
                byte[] buffer = new byte[960 * this.frameSize];
                int bytesRead = this.audioInputStream.read(buffer);
                if (bytesRead <= 0) {
                    this.finished = true;
                    return null;
                }
                int samplesRead = bytesRead / 2;
                for (int i = 0; i < Math.min(samplesRead, 960); ++i) {
                    int byteIndex = i * 2;
                    if (byteIndex + 1 >= bytesRead) continue;
                    frame[i] = (short)(buffer[byteIndex] & 0xFF | (buffer[byteIndex + 1] & 0xFF) << 8);
                }
                return frame;
            }
            catch (Exception e) {
                LOGGER.error("Error reading audio data in supplier: {}", (Object)e.getMessage());
                this.finished = true;
                return null;
            }
        }

        private boolean initialize() {
            try {
                if (this.isM4AFormat(this.audioData)) {
                    LOGGER.warn("M4A format detected - Java AudioSystem cannot decode M4A natively");
                    LOGGER.warn("Attempting to process M4A file anyway - may fail");
                }
                if (this.isWebMFormat(this.audioData)) {
                    LOGGER.warn("WebM format detected - Java AudioSystem cannot decode WebM natively");
                    LOGGER.warn("WebM playback requires external decoder or conversion to PCM format");
                    LOGGER.error("Failed to initialize personal audio supplier: Stream of unsupported format");
                    return false;
                }
                ByteArrayInputStream bais = new ByteArrayInputStream(this.audioData);
                try {
                    this.audioInputStream = AudioSystem.getAudioInputStream(bais);
                }
                catch (UnsupportedAudioFileException e) {
                    if (this.isM4AFormat(this.audioData)) {
                        LOGGER.error("M4A format is not supported by Java AudioSystem");
                        LOGGER.error("To fix this issue, you need to:");
                        LOGGER.error("1. Install FFmpeg on your server");
                        LOGGER.error("2. Configure yt-dlp to convert M4A to MP3/OGG");
                        LOGGER.error("3. Or use a different audio format");
                        return false;
                    }
                    if (this.isWebMFormat(this.audioData)) {
                        LOGGER.error("WebM format is not supported by Java AudioSystem");
                        LOGGER.error("To fix this issue, you need to:");
                        LOGGER.error("1. Install FFmpeg on your server");
                        LOGGER.error("2. Configure yt-dlp to convert WebM to MP3/OGG");
                        LOGGER.error("3. Or use a different audio format");
                        return false;
                    }
                    throw e;
                }
                AudioFormat format = this.audioInputStream.getFormat();
                LOGGER.info("Personal audio supplier format: {} Hz, {} channels, {} bits, encoding: {}", new Object[]{Float.valueOf(format.getSampleRate()), format.getChannels(), format.getSampleSizeInBits(), format.getEncoding()});
                this.targetFormat = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, 48000.0f, 16, 1, 2, 48000.0f, false);
                if (!format.matches(this.targetFormat)) {
                    try {
                        AudioFormat pcmFormat;
                        if (!format.getEncoding().equals(AudioFormat.Encoding.PCM_SIGNED) && AudioSystem.isConversionSupported(pcmFormat = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, format.getSampleRate(), 16, format.getChannels(), format.getChannels() * 2, format.getSampleRate(), false), format)) {
                            this.audioInputStream = AudioSystem.getAudioInputStream(pcmFormat, this.audioInputStream);
                            LOGGER.info("Converted personal audio supplier to PCM format");
                        }
                        if (AudioSystem.isConversionSupported(this.targetFormat, this.audioInputStream.getFormat())) {
                            this.audioInputStream = AudioSystem.getAudioInputStream(this.targetFormat, this.audioInputStream);
                            LOGGER.info("Converted personal audio supplier to target format: 24kHz 16-bit mono");
                        } else {
                            LOGGER.warn("Direct conversion not supported for personal audio supplier, using available format");
                            this.targetFormat = this.audioInputStream.getFormat();
                        }
                    }
                    catch (Exception e) {
                        LOGGER.warn("Personal audio supplier format conversion failed: {}", (Object)e.getMessage());
                        this.targetFormat = format;
                    }
                }
                this.frameSize = this.targetFormat.getFrameSize();
                LOGGER.info("Personal audio supplier initialized: {} Hz, {} channels, {} bits, frame size: {} bytes", new Object[]{Float.valueOf(this.targetFormat.getSampleRate()), this.targetFormat.getChannels(), this.targetFormat.getSampleSizeInBits(), this.frameSize});
                LOGGER.info("Simple Voice Chat expects 960 samples per frame (20ms at 48kHz)");
                return true;
            }
            catch (Exception e) {
                LOGGER.error("Failed to initialize personal audio supplier: {}", (Object)e.getMessage());
                return false;
            }
        }

        public boolean isFinished() {
            return this.finished;
        }

        private boolean isM4AFormat(byte[] data) {
            if (data.length < 12) {
                return false;
            }
            byte[] M4A_FTYP = new byte[]{102, 116, 121, 112};
            for (int i = 0; i < M4A_FTYP.length; ++i) {
                if (data[4 + i] == M4A_FTYP[i]) continue;
                return false;
            }
            if (data.length >= 16) {
                String brand = new String(data, 8, 4);
                return brand.equals("M4A ") || brand.equals("mp41") || brand.equals("mp42") || brand.equals("isom");
            }
            return true;
        }

        private boolean isWebMFormat(byte[] data) {
            if (data.length < 4) {
                return false;
            }
            byte[] WEBM_MAGIC = new byte[]{26, 69, -33, -93};
            for (int i = 0; i < WEBM_MAGIC.length; ++i) {
                if (data[i] == WEBM_MAGIC[i]) continue;
                return false;
            }
            return true;
        }
    }

    public static class PersonalAudioPlayerInfo
    extends AudioStreamInfo {
        private final AudioPlayer audioPlayer;
        private final PersonalAudioSupplier audioSupplier;

        public PersonalAudioPlayerInfo(UUID streamId, LocationalAudioChannel channel, AudioPlayer audioPlayer, PersonalAudioSupplier audioSupplier, class_2338 position, byte[] audioData) {
            super(streamId, channel, position, audioData);
            this.audioPlayer = audioPlayer;
            this.audioSupplier = audioSupplier;
        }

        public AudioPlayer getAudioPlayer() {
            return this.audioPlayer;
        }

        public PersonalAudioSupplier getAudioSupplier() {
            return this.audioSupplier;
        }
    }

    public static class AudioStreamInfo {
        private final UUID streamId;
        private final LocationalAudioChannel channel;
        private class_2338 position;
        private final byte[] audioData;
        private volatile boolean playing;

        public AudioStreamInfo(UUID streamId, LocationalAudioChannel channel, class_2338 position, byte[] audioData) {
            this.streamId = streamId;
            this.channel = channel;
            this.position = position;
            this.audioData = audioData;
            this.playing = false;
        }

        public UUID getStreamId() {
            return this.streamId;
        }

        public LocationalAudioChannel getChannel() {
            return this.channel;
        }

        public class_2338 getPosition() {
            return this.position;
        }

        public void setPosition(class_2338 position) {
            this.position = position;
        }

        public byte[] getAudioData() {
            return this.audioData;
        }

        public boolean isPlaying() {
            return this.playing;
        }

        public void setPlaying(boolean playing) {
            this.playing = playing;
        }
    }

    public static class PersonalAudioStreamInfo
    extends AudioStreamInfo {
        private final StaticAudioChannel staticChannel;
        private final class_3222 player;

        public PersonalAudioStreamInfo(UUID streamId, StaticAudioChannel staticChannel, class_3222 player, byte[] audioData) {
            super(streamId, null, player.method_24515(), audioData);
            this.staticChannel = staticChannel;
            this.player = player;
        }

        public StaticAudioChannel getStaticChannel() {
            return this.staticChannel;
        }

        public class_3222 getPlayer() {
            return this.player;
        }
    }
}

