/*
 * Decompiled with CFR 0.152.
 */
package org.stepan.audio_disc.util;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_3222;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Localization {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"AudioDisc");
    private static final Gson GSON = new Gson();
    private static String defaultLanguage = "en_us";
    private static final Map<String, Map<String, String>> translations = new HashMap<String, Map<String, String>>();

    public static void loadLanguage(String language) {
        defaultLanguage = language.toLowerCase();
        Localization.loadLanguageInternal(defaultLanguage);
    }

    private static void loadLanguageInternal(String language) {
        JsonObject langObj;
        String json;
        if (translations.containsKey(language = language.toLowerCase())) {
            return;
        }
        HashMap langMap = new HashMap();
        String resourcePath = "/assets/audio_disc/lang/" + language + ".json";
        try (InputStream inputStream = Localization.class.getResourceAsStream(resourcePath);){
            if (inputStream != null) {
                json = new String(inputStream.readAllBytes());
                langObj = (JsonObject)GSON.fromJson(json, JsonObject.class);
                langObj.entrySet().forEach(entry -> langMap.put((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString()));
                LOGGER.info("Loaded default language from resources: {}", (Object)language);
            }
        }
        catch (Exception e) {
            LOGGER.warn("Failed to load language from resources: {}", (Object)resourcePath, (Object)e);
        }
        Path configLangPath = FabricLoader.getInstance().getConfigDir().resolve("audiodisc").resolve("lang").resolve(language + ".json");
        if (Files.exists(configLangPath, new LinkOption[0])) {
            try {
                json = Files.readString(configLangPath);
                langObj = (JsonObject)GSON.fromJson(json, JsonObject.class);
                langObj.entrySet().forEach(entry -> langMap.put((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString()));
                LOGGER.info("Loaded custom language overrides from config: {}", (Object)configLangPath);
            }
            catch (IOException e) {
                LOGGER.error("Failed to load custom language file: {}", (Object)configLangPath, (Object)e);
            }
        } else if (language.equals(defaultLanguage)) {
            // empty if block
        }
        translations.put(language, langMap);
        LOGGER.info("Language loaded: {} ({} translations)", (Object)language, (Object)langMap.size());
    }

    public static String get(String key, String language) {
        language = language.toLowerCase();
        Localization.loadLanguageInternal(language);
        Map<String, String> langMap = translations.get(language);
        if (langMap != null && langMap.containsKey(key)) {
            return langMap.get(key);
        }
        if (!language.equals("en_us")) {
            Localization.loadLanguageInternal("en_us");
            langMap = translations.get("en_us");
            if (langMap != null && langMap.containsKey(key)) {
                return langMap.get(key);
            }
        }
        return key;
    }

    public static String get(String key) {
        return Localization.get(key, defaultLanguage);
    }

    public static String format(String key, String language, Object ... args) {
        String template = Localization.get(key, language);
        return String.format(template, args);
    }

    public static String format(String key, Object ... args) {
        return Localization.format(key, defaultLanguage, args);
    }

    private static void createExampleLanguageFile(Path path, String language) {
        try {
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
            HashMap<String, String> example = new HashMap<String, String>();
            example.put("_comment", "Custom language overrides for Audio Disc mod");
            example.put("_info", "Add any translation keys here to override default translations");
            example.put("_example_command.upload.success", "\u00a7a\u2713 Custom success message!");
            example.put("_example_command.upload.starting", "\u00a7aCustom loading message...");
            if (language.equals("ru_ru")) {
                example.put("_example_command.upload.success2", "\u00a7a\u2713 \u041a\u0430\u0441\u0442\u043e\u043c\u043d\u043e\u0435 \u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435 \u043e\u0431 \u0443\u0441\u043f\u0435\u0445\u0435!");
                example.put("_example_command.upload.starting2", "\u00a7a\u041a\u0430\u0441\u0442\u043e\u043c\u043d\u043e\u0435 \u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435 \u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0438...");
            } else {
                example.put("_example_command.upload.success2", "\u00a7a\u2713 Custom success message!");
                example.put("_example_command.upload.starting2", "\u00a7aCustom loading message...");
            }
            String json = GSON.toJson(example);
            Files.writeString(path, (CharSequence)json, new OpenOption[0]);
            LOGGER.info("Created example custom language file: {}", (Object)path);
        }
        catch (IOException e) {
            LOGGER.error("Failed to create example language file: {}", (Object)path, (Object)e);
        }
    }

    private static void createDefaultLanguageFile(Path path, String language) {
        try {
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
            Map<String, String> defaults = Localization.getDefaultTranslations(language);
            String json = GSON.toJson(defaults);
            Files.writeString(path, (CharSequence)json, new OpenOption[0]);
            LOGGER.info("Created default language file: {}", (Object)path);
        }
        catch (IOException e) {
            LOGGER.error("Failed to create default language file: {}", (Object)path, (Object)e);
        }
    }

    public static String getPlayerLanguage(class_3222 player) {
        if (player == null) {
            return defaultLanguage;
        }
        String clientLanguage = player.method_53823().comp_1951();
        if (clientLanguage != null && !clientLanguage.isEmpty()) {
            return clientLanguage.toLowerCase();
        }
        return defaultLanguage;
    }

    public static String getForPlayer(String key, class_3222 player) {
        String playerLanguage = Localization.getPlayerLanguage(player);
        return Localization.get(key, playerLanguage);
    }

    public static String formatForPlayer(String key, class_3222 player, Object ... args) {
        String playerLanguage = Localization.getPlayerLanguage(player);
        return Localization.format(key, playerLanguage, args);
    }

    public static String getVoiceChatCategory() {
        return Localization.get("voicechat.category");
    }

    public static boolean createFullLanguageFile(String language) {
        try {
            String json;
            Path configLangPath = FabricLoader.getInstance().getConfigDir().resolve("audiodisc").resolve("lang").resolve(language.toLowerCase() + ".json");
            Files.createDirectories(configLangPath.getParent(), new FileAttribute[0]);
            Map<Object, Object> fullTranslations = new HashMap();
            String resourcePath = "/assets/audio_disc/lang/" + language.toLowerCase() + ".json";
            try (InputStream inputStream = Localization.class.getResourceAsStream(resourcePath);){
                if (inputStream != null) {
                    json = new String(inputStream.readAllBytes());
                    JsonObject langObj = (JsonObject)GSON.fromJson(json, JsonObject.class);
                    for (Map.Entry entry : langObj.entrySet()) {
                        fullTranslations.put((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
                    }
                }
            }
            if (fullTranslations.isEmpty()) {
                fullTranslations = Localization.getDefaultTranslations(language.toLowerCase());
            }
            HashMap<String, Object> fileContent = new HashMap<String, Object>();
            fileContent.put("_comment", "Custom language file for Audio Disc mod - Language: " + language);
            fileContent.put("_info", "Modify any translation below to customize messages");
            fileContent.put("_note", "Remove the underscore prefix from _comment, _info, _note to use them as actual translations");
            fullTranslations.forEach(fileContent::put);
            json = GSON.toJson(fileContent);
            Files.writeString(configLangPath, (CharSequence)json, new OpenOption[0]);
            LOGGER.info("Created full custom language file: {}", (Object)configLangPath);
            return true;
        }
        catch (Exception e) {
            LOGGER.error("Failed to create full language file for {}", (Object)language, (Object)e);
            return false;
        }
    }

    private static Map<String, String> getDefaultTranslations(String language) {
        HashMap<String, String> translations = new HashMap<String, String>();
        if (language.equals("ru_ru")) {
            translations.put("command.upload.no_disc", "\u00a7c\u0412\u044b \u0434\u043e\u043b\u0436\u043d\u044b \u0434\u0435\u0440\u0436\u0430\u0442\u044c \u043c\u0443\u0437\u044b\u043a\u0430\u043b\u044c\u043d\u044b\u0439 \u0434\u0438\u0441\u043a!");
            translations.put("command.upload.no_permission", "\u00a7c\u0423 \u0432\u0430\u0441 \u043d\u0435\u0442 \u043f\u0440\u0430\u0432 \u043d\u0430 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u0435 \u044d\u0442\u043e\u0439 \u043a\u043e\u043c\u0430\u043d\u0434\u044b!");
            translations.put("command.upload.rate_limit", "\u00a7c%s");
            translations.put("command.upload.invalid_url", "\u00a7c\u041f\u043e\u0436\u0430\u043b\u0443\u0439\u0441\u0442\u0430, \u0443\u043a\u0430\u0436\u0438\u0442\u0435 \u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u044b\u0439 URL!");
            translations.put("command.upload.url_protocol", "\u00a7cURL \u0434\u043e\u043b\u0436\u0435\u043d \u043d\u0430\u0447\u0438\u043d\u0430\u0442\u044c\u0441\u044f \u0441 http:// \u0438\u043b\u0438 https://");
            translations.put("command.upload.starting", "\u00a7a\u041d\u0430\u0447\u0438\u043d\u0430\u0435\u0442\u0441\u044f \u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0430 \u0430\u0443\u0434\u0438\u043e...");
            translations.put("command.upload.url_info", "\u00a77URL: %s");
            translations.put("command.upload.progress", "\u00a77\u041f\u0440\u043e\u0433\u0440\u0435\u0441\u0441 \u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0438: %d%%");
            translations.put("command.upload.complete", "\u00a7a\u0417\u0430\u0433\u0440\u0443\u0437\u043a\u0430 \u0437\u0430\u0432\u0435\u0440\u0448\u0435\u043d\u0430! \u0420\u0430\u0437\u043c\u0435\u0440: %s");
            translations.put("command.upload.processing", "\u00a77\u041e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0430 \u0430\u0443\u0434\u0438\u043e \u0444\u0430\u0439\u043b\u0430...");
            translations.put("command.upload.success", "\u00a7a\u2713 \u0410\u0443\u0434\u0438\u043e \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u0437\u0430\u0433\u0440\u0443\u0436\u0435\u043d\u043e \u043d\u0430 \u0434\u0438\u0441\u043a!");
            translations.put("command.upload.format", "\u00a77\u0424\u043e\u0440\u043c\u0430\u0442: %s");
            translations.put("command.upload.duration", "\u00a77\u0414\u043b\u0438\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u044c: %s");
            translations.put("command.upload.duration_exceeded", "\u00a7c\u0414\u043b\u0438\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u044c \u0430\u0443\u0434\u0438\u043e \u043f\u0440\u0435\u0432\u044b\u0448\u0430\u0435\u0442 \u043c\u0430\u043a\u0441\u0438\u043c\u0430\u043b\u044c\u043d\u043e \u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u0443\u044e (%s)!");
            translations.put("command.upload.bitrate", "\u00a77\u0411\u0438\u0442\u0440\u0435\u0439\u0442: %d kbps");
            translations.put("command.upload.error", "\u00a7c\u041e\u0448\u0438\u0431\u043a\u0430 \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0438 \u0430\u0443\u0434\u0438\u043e: %s");
            translations.put("command.upload.download_failed", "\u00a7c\u0417\u0430\u0433\u0440\u0443\u0437\u043a\u0430 \u043d\u0435 \u0443\u0434\u0430\u043b\u0430\u0441\u044c: %s");
            translations.put("command.upload.timeout", "\u00a77\u0417\u0430\u0433\u0440\u0443\u0437\u043a\u0430 \u0437\u0430\u043d\u044f\u043b\u0430 \u0441\u043b\u0438\u0448\u043a\u043e\u043c \u043c\u043d\u043e\u0433\u043e \u0432\u0440\u0435\u043c\u0435\u043d\u0438 (\u043c\u0430\u043a\u0441. 30 \u0441\u0435\u043a\u0443\u043d\u0434)");
            translations.put("command.upload.too_large", "\u00a77\u041c\u0430\u043a\u0441\u0438\u043c\u0430\u043b\u044c\u043d\u044b\u0439 \u0440\u0430\u0437\u043c\u0435\u0440 \u0444\u0430\u0439\u043b\u0430 50MB");
            translations.put("command.upload.unreachable", "\u00a77URL \u043d\u0435\u0434\u043e\u0441\u0442\u0443\u043f\u0435\u043d");
            translations.put("command.rename.no_disc", "\u00a7c\u0412\u044b \u0434\u043e\u043b\u0436\u043d\u044b \u0434\u0435\u0440\u0436\u0430\u0442\u044c \u043c\u0443\u0437\u044b\u043a\u0430\u043b\u044c\u043d\u044b\u0439 \u0434\u0438\u0441\u043a!");
            translations.put("command.rename.no_audio", "\u00a7c\u041d\u0430 \u044d\u0442\u043e\u043c \u0434\u0438\u0441\u043a\u0435 \u043d\u0435\u0442 \u043a\u0430\u0441\u0442\u043e\u043c\u043d\u043e\u0433\u043e \u0430\u0443\u0434\u0438\u043e! \u0421\u043d\u0430\u0447\u0430\u043b\u0430 \u0437\u0430\u0433\u0440\u0443\u0437\u0438\u0442\u0435 \u0430\u0443\u0434\u0438\u043e \u0441 \u043f\u043e\u043c\u043e\u0449\u044c\u044e /audiodisc upload <url>");
            translations.put("command.rename.too_long", "\u00a7c\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0441\u043b\u0438\u0448\u043a\u043e\u043c \u0434\u043b\u0438\u043d\u043d\u043e\u0435! \u041c\u0430\u043a\u0441\u0438\u043c\u0443\u043c 100 \u0441\u0438\u043c\u0432\u043e\u043b\u043e\u0432.");
            translations.put("command.rename.success", "\u00a7a\u2713 \u0414\u0438\u0441\u043a \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u043f\u0435\u0440\u0435\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d!");
            translations.put("command.rename.new_title", "\u00a77\u041d\u043e\u0432\u043e\u0435 \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435: \u00a7f%s");
            translations.put("command.rename.error", "\u00a7c\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0435\u0440\u0435\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u044f \u0434\u0438\u0441\u043a\u0430: %s");
            translations.put("command.info.no_disc", "\u00a7c\u0412\u044b \u0434\u043e\u043b\u0436\u043d\u044b \u0434\u0435\u0440\u0436\u0430\u0442\u044c \u043c\u0443\u0437\u044b\u043a\u0430\u043b\u044c\u043d\u044b\u0439 \u0434\u0438\u0441\u043a!");
            translations.put("command.info.no_audio", "\u00a7c\u041d\u0430 \u044d\u0442\u043e\u043c \u0434\u0438\u0441\u043a\u0435 \u043d\u0435\u0442 \u043a\u0430\u0441\u0442\u043e\u043c\u043d\u043e\u0433\u043e \u0430\u0443\u0434\u0438\u043e!");
            translations.put("command.info.header", "\u00a7a=== \u0418\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u044f \u043e\u0431 \u0430\u0443\u0434\u0438\u043e ===");
            translations.put("command.info.id", "\u00a77ID: \u00a7f%s");
            translations.put("command.info.title", "\u00a77\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435: \u00a7f%s");
            translations.put("command.info.format", "\u00a77\u0424\u043e\u0440\u043c\u0430\u0442: \u00a7f%s");
            translations.put("command.info.duration", "\u00a77\u0414\u043b\u0438\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u044c: \u00a7f%s");
            translations.put("command.info.bitrate", "\u00a77\u0411\u0438\u0442\u0440\u0435\u0439\u0442: \u00a7f%d kbps");
            translations.put("command.info.sample_rate", "\u00a77\u0427\u0430\u0441\u0442\u043e\u0442\u0430 \u0434\u0438\u0441\u043a\u0440\u0435\u0442\u0438\u0437\u0430\u0446\u0438\u0438: \u00a7f%d Hz");
            translations.put("command.info.uploaded_by", "\u00a77\u0417\u0430\u0433\u0440\u0443\u0437\u0438\u043b: \u00a7f%s");
            translations.put("command.info.upload_time", "\u00a77\u0412\u0440\u0435\u043c\u044f \u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0438: \u00a7f%s");
            translations.put("command.info.file_size", "\u00a77\u0420\u0430\u0437\u043c\u0435\u0440 \u0444\u0430\u0439\u043b\u0430: \u00a7f%s");
            translations.put("command.clear.no_disc", "\u00a7c\u0412\u044b \u0434\u043e\u043b\u0436\u043d\u044b \u0434\u0435\u0440\u0436\u0430\u0442\u044c \u043c\u0443\u0437\u044b\u043a\u0430\u043b\u044c\u043d\u044b\u0439 \u0434\u0438\u0441\u043a!");
            translations.put("command.clear.no_audio", "\u00a7c\u041d\u0430 \u044d\u0442\u043e\u043c \u0434\u0438\u0441\u043a\u0435 \u043d\u0435\u0442 \u043a\u0430\u0441\u0442\u043e\u043c\u043d\u043e\u0433\u043e \u0430\u0443\u0434\u0438\u043e!");
            translations.put("command.clear.success", "\u00a7a\u0410\u0443\u0434\u0438\u043e \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u0443\u0434\u0430\u043b\u0435\u043d\u043e \u0441 \u0434\u0438\u0441\u043a\u0430!");
            translations.put("command.clear.failed", "\u00a7c\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0443\u0434\u0430\u043b\u0438\u0442\u044c \u0430\u0443\u0434\u0438\u043e");
            translations.put("command.clear.error", "\u00a7c\u041e\u0448\u0438\u0431\u043a\u0430 \u0443\u0434\u0430\u043b\u0435\u043d\u0438\u044f \u0430\u0443\u0434\u0438\u043e: %s");
            translations.put("command.reload.success", "\u00a7a\u041a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u044f \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u043f\u0435\u0440\u0435\u0437\u0430\u0433\u0440\u0443\u0436\u0435\u043d\u0430!");
            translations.put("command.reload.failed", "\u00a7c\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043f\u0435\u0440\u0435\u0437\u0430\u0433\u0440\u0443\u0437\u0438\u0442\u044c \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u044e: %s");
            translations.put("tooltip.custom_disc", "\u266a \u041a\u0430\u0441\u0442\u043e\u043c\u043d\u044b\u0439 \u043c\u0443\u0437\u044b\u043a\u0430\u043b\u044c\u043d\u044b\u0439 \u0434\u0438\u0441\u043a");
            translations.put("tooltip.title", "\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435: %s");
            translations.put("tooltip.duration", "\u0414\u043b\u0438\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u044c: %s");
            translations.put("tooltip.format", "\u0424\u043e\u0440\u043c\u0430\u0442: %s");
            translations.put("tooltip.uploaded_by", "\u0417\u0430\u0433\u0440\u0443\u0437\u0438\u043b: %s");
            translations.put("voicechat.category", "\u041c\u0443\u0437\u044b\u043a\u0430\u043b\u044c\u043d\u044b\u0435 \u0434\u0438\u0441\u043a\u0438");
            translations.put("command.youtube.invalid_url", "\u00a7c\u041f\u043e\u0436\u0430\u043b\u0443\u0439\u0441\u0442\u0430, \u0443\u043a\u0430\u0436\u0438\u0442\u0435 \u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u0443\u044e YouTube \u0441\u0441\u044b\u043b\u043a\u0443!");
            translations.put("command.youtube.supported_formats", "\u00a77\u041f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u044e\u0442\u0441\u044f \u0441\u0441\u044b\u043b\u043a\u0438: youtube.com/watch?v=..., youtu.be/..., m.youtube.com/watch?v=...");
            translations.put("command.youtube.starting", "\u00a7a\u041d\u0430\u0447\u0438\u043d\u0430\u0435\u0442\u0441\u044f \u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0430 \u0430\u0443\u0434\u0438\u043e \u0441 YouTube...");
            translations.put("command.youtube.success", "\u00a7aYouTube \u0430\u0443\u0434\u0438\u043e \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u0434\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u043e \u043d\u0430 \u0434\u0438\u0441\u043a!");
            translations.put("command.youtube.error", "\u00a7c\u041e\u0448\u0438\u0431\u043a\u0430 \u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0438 \u0441 YouTube: %s");
            translations.put("command.youtube.not_found", "\u00a7c\u041e\u0448\u0438\u0431\u043a\u0430: \u0437\u0430\u0433\u0440\u0443\u0436\u0435\u043d\u043d\u044b\u0439 \u0444\u0430\u0439\u043b \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d");
            translations.put("command.youtube.yt_dlp_required", "\u00a77\u0414\u043b\u044f \u0440\u0430\u0431\u043e\u0442\u044b \u0441 YouTube \u043d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u043e \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c yt-dlp \u043d\u0430 \u0441\u0435\u0440\u0432\u0435\u0440\u0435");
            translations.put("command.youtube.use_direct", "\u00a77\u0418\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0439\u0442\u0435 \u043e\u0431\u044b\u0447\u043d\u0443\u044e \u043a\u043e\u043c\u0430\u043d\u0434\u0443 /audiodisc upload <\u043f\u0440\u044f\u043c\u0430\u044f_\u0441\u0441\u044b\u043b\u043a\u0430_\u043d\u0430_\u0430\u0443\u0434\u0438\u043e>");
        } else {
            translations.put("command.upload.no_disc", "\u00a7cYou must be holding a music disc!");
            translations.put("command.upload.no_permission", "\u00a7cYou don't have permission to use this command!");
            translations.put("command.upload.rate_limit", "\u00a7c%s");
            translations.put("command.upload.invalid_url", "\u00a7cPlease provide a valid URL!");
            translations.put("command.upload.url_protocol", "\u00a7cURL must start with http:// or https://");
            translations.put("command.upload.starting", "\u00a7aStarting audio download...");
            translations.put("command.upload.url_info", "\u00a77URL: %s");
            translations.put("command.upload.progress", "\u00a77Download progress: %d%%");
            translations.put("command.upload.complete", "\u00a7aDownload complete! Size: %s");
            translations.put("command.upload.processing", "\u00a77Processing audio file...");
            translations.put("command.upload.success", "\u00a7a\u2713 Audio successfully uploaded to disc!");
            translations.put("command.upload.format", "\u00a77Format: %s");
            translations.put("command.upload.duration", "\u00a77Duration: %s");
            translations.put("command.upload.duration_exceeded", "\u00a7cAudio duration exceeds maximum allowed (%s)!");
            translations.put("command.upload.bitrate", "\u00a77Bitrate: %d kbps");
            translations.put("command.upload.error", "\u00a7cError processing audio: %s");
            translations.put("command.upload.download_failed", "\u00a7cDownload failed: %s");
            translations.put("command.upload.timeout", "\u00a77The download took too long (max 30 seconds)");
            translations.put("command.upload.too_large", "\u00a77Maximum file size is 50MB");
            translations.put("command.upload.unreachable", "\u00a77The URL could not be reached");
            translations.put("command.rename.no_disc", "\u00a7cYou must be holding a music disc!");
            translations.put("command.rename.no_audio", "\u00a7cThis disc doesn't have custom audio! Upload audio first with /audiodisc upload <url>");
            translations.put("command.rename.too_long", "\u00a7cTitle is too long! Maximum 100 characters.");
            translations.put("command.rename.success", "\u00a7a\u2713 Disc renamed successfully!");
            translations.put("command.rename.new_title", "\u00a77New title: \u00a7f%s");
            translations.put("command.rename.error", "\u00a7cError renaming disc: %s");
            translations.put("command.info.no_disc", "\u00a7cYou must be holding a music disc!");
            translations.put("command.info.no_audio", "\u00a7cThis disc doesn't have custom audio!");
            translations.put("command.info.header", "\u00a7a=== Audio Information ===");
            translations.put("command.info.id", "\u00a77ID: \u00a7f%s");
            translations.put("command.info.title", "\u00a77Title: \u00a7f%s");
            translations.put("command.info.format", "\u00a77Format: \u00a7f%s");
            translations.put("command.info.duration", "\u00a77Duration: \u00a7f%s");
            translations.put("command.info.bitrate", "\u00a77Bitrate: \u00a7f%d kbps");
            translations.put("command.info.sample_rate", "\u00a77Sample Rate: \u00a7f%d Hz");
            translations.put("command.info.uploaded_by", "\u00a77Uploaded by: \u00a7f%s");
            translations.put("command.info.upload_time", "\u00a77Upload time: \u00a7f%s");
            translations.put("command.info.file_size", "\u00a77File size: \u00a7f%s");
            translations.put("command.clear.no_disc", "\u00a7cYou must be holding a music disc!");
            translations.put("command.clear.no_audio", "\u00a7cThis disc doesn't have custom audio!");
            translations.put("command.clear.success", "\u00a7aSuccessfully cleared audio from disc!");
            translations.put("command.clear.failed", "\u00a7cFailed to clear audio");
            translations.put("command.clear.error", "\u00a7cError clearing audio: %s");
            translations.put("command.reload.success", "\u00a7aConfiguration reloaded successfully!");
            translations.put("command.reload.failed", "\u00a7cFailed to reload configuration: %s");
            translations.put("tooltip.custom_disc", "\u266a Custom Audio Disc");
            translations.put("tooltip.title", "Title: %s");
            translations.put("tooltip.duration", "Duration: %s");
            translations.put("tooltip.format", "Format: %s");
            translations.put("tooltip.uploaded_by", "Uploaded by: %s");
            translations.put("voicechat.category", "Audio Discs");
            translations.put("command.youtube.invalid_url", "\u00a7cPlease provide a valid YouTube URL!");
            translations.put("command.youtube.supported_formats", "\u00a77Supported URLs: youtube.com/watch?v=..., youtu.be/..., m.youtube.com/watch?v=...");
            translations.put("command.youtube.starting", "\u00a7aStarting YouTube audio download...");
            translations.put("command.youtube.success", "\u00a7aYouTube audio successfully added to disc!");
            translations.put("command.youtube.error", "\u00a7cYouTube download error: %s");
            translations.put("command.youtube.not_found", "\u00a7cError: downloaded file not found");
            translations.put("command.youtube.yt_dlp_required", "\u00a77yt-dlp is required on the server for YouTube support");
            translations.put("command.youtube.use_direct", "\u00a77Use regular command /audiodisc upload <direct_audio_url>");
        }
        return translations;
    }
}

