/*
 * Decompiled with CFR 0.152.
 */
package net.dented.chancechoice.block.entity.custom;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import net.dented.chancechoice.block.entity.ModBlockEntities;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_4844;
import net.minecraft.server.MinecraftServer;

public class ChanceTableBlockEntity
extends class_2586 {
    private final Set<UUID> linkedPlayers = new HashSet<UUID>();
    private boolean locked = false;

    public ChanceTableBlockEntity(class_2338 pos, class_2680 state) {
        super(ModBlockEntities.CHANCE_TABLE_BE, pos, state);
    }

    public void linkPlayer(class_3222 player) {
        if (this.locked) {
            return;
        }
        this.linkedPlayers.add(player.method_5667());
        this.method_5431();
    }

    public void setLocked(boolean bl) {
        this.locked = bl;
        this.method_5431();
    }

    public boolean isLocked() {
        return this.locked;
    }

    public void unlinkPlayer(class_3222 player) {
        this.linkedPlayers.remove(player.method_5667());
        if (this.linkedPlayers.isEmpty()) {
            this.locked = false;
        }
        this.method_5431();
    }

    public void unlinkAll() {
        this.linkedPlayers.clear();
        this.locked = false;
        this.method_5431();
    }

    public boolean isLinked(class_3222 player) {
        return this.linkedPlayers.contains(player.method_5667());
    }

    public Collection<UUID> getLinkedUUIDs() {
        return this.linkedPlayers;
    }

    public List<String> getLinkedPlayerNames(MinecraftServer server) {
        return this.linkedPlayers.stream().map(uuid -> Optional.ofNullable(server.method_3760().method_14602(uuid)).map(p -> p.method_5477().getString()).orElse(class_2561.method_43471((String)"block.chancechoice.chance_table.unknown_player").getString())).toList();
    }

    public static void tick(class_1937 world, class_2338 pos, class_2680 state, ChanceTableBlockEntity be) {
        if (!(world instanceof class_3218)) {
            return;
        }
        class_3218 serverWorld = (class_3218)world;
        if (serverWorld.field_9229.method_39332(0, 20) != 0) {
            return;
        }
        for (UUID uuid : be.getLinkedUUIDs()) {
            boolean inRange;
            class_3222 player = serverWorld.method_8503().method_3760().method_14602(uuid);
            if (player == null || !(inRange = player.method_5649((double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5) <= 25.0)) continue;
            double px = (double)pos.method_10263() + 0.5;
            double py = (double)pos.method_10264() + 1.3;
            double pz = (double)pos.method_10260() + 0.5;
            double dx = (serverWorld.field_9229.method_43058() - 0.5) * 0.2;
            double dy = serverWorld.field_9229.method_43058() * 0.2;
            double dz = (serverWorld.field_9229.method_43058() - 0.5) * 0.2;
            serverWorld.method_14166(player, (class_2394)class_2398.field_11205, true, true, px, py, pz, 1, dx, dy, dz, 0.0);
        }
    }

    protected void method_11007(class_11372 view) {
        class_11372.class_11373 appender = view.method_71467("linked_players", class_4844.field_41525);
        for (UUID uuid : this.linkedPlayers) {
            appender.method_71484((Object)uuid);
        }
        view.method_71472("locked", this.locked);
    }

    protected void method_11014(class_11368 view) {
        view.method_71433("locked", false);
        this.linkedPlayers.clear();
        view.method_71435("linked_players", class_4844.field_41525).ifPresent(list -> list.forEach(this.linkedPlayers::add));
    }
}

