/*
 * Decompiled with CFR 0.152.
 */
package net.dented.chancechoice.mixin;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.dented.chancechoice.component.ModDataComponentTypes;
import net.dented.chancechoice.component.RecentlyDrawnCardsComponent;
import net.dented.chancechoice.component.SummonedItemDurabilityComponent;
import net.dented.chancechoice.item.ModItems;
import net.dented.chancechoice.item.custom.BaseDeckItem;
import net.dented.chancechoice.item.custom.FlashCardDeckItem;
import net.dented.chancechoice.util.ChanceChoiceResourceReloader;
import net.dented.chancechoice.util.ModTags;
import net.dented.chancechoice.util.TextHelper;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_10712;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_5250;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Environment(value=EnvType.CLIENT)
@Mixin(value={class_1799.class})
public class ItemStackMixin {
    @Inject(at={@At(value="HEAD")}, method={"method_67194(Lnet/minecraft/class_1792$class_9635;Lnet/minecraft/class_10712;Lnet/minecraft/class_1657;Lnet/minecraft/class_1836;Ljava/util/function/Consumer;)V"})
    private void chancechoice$appendTooltip(class_1792.class_9635 context, class_10712 displayComponent, class_1657 player, class_1836 type, Consumer<class_2561> textConsumer, CallbackInfo ci) {
        SummonedItemDurabilityComponent durability;
        class_1799 stack = (class_1799)this;
        if (stack.method_31573(ModTags.Items.SUMMONED) && !stack.method_31574(ModItems.SUMMONED_ARROW) && (durability = (SummonedItemDurabilityComponent)stack.method_58694(ModDataComponentTypes.SUMMONED_ITEM_DURABILITY)) != null && durability.total() > 0) {
            double pct = (double)durability.current() / (double)durability.total();
            class_5250 state = pct >= 0.75 ? class_2561.method_43471((String)"item.chancechoice.summoned.bright").method_27695(new class_124[]{class_124.field_1065, class_124.field_1056}) : (pct >= 0.5 ? class_2561.method_43471((String)"item.chancechoice.summoned.fading").method_27695(new class_124[]{class_124.field_1054, class_124.field_1056}) : (pct >= 0.25 ? class_2561.method_43471((String)"item.chancechoice.summoned.faded").method_27695(new class_124[]{class_124.field_1068, class_124.field_1056}) : class_2561.method_43471((String)"item.chancechoice.summoned.dim").method_27695(new class_124[]{class_124.field_1080, class_124.field_1056})));
            textConsumer.accept((class_2561)state);
        }
        if (stack.method_31573(ModTags.Items.CARD_DECKS)) {
            textConsumer.accept(TextHelper.getDeckCardText(((BaseDeckItem)stack.method_7909()).getDeckKey(), (Integer)stack.method_58694(ModDataComponentTypes.CURRENT_OBJECT)));
            int remaining = ((BaseDeckItem)stack.method_7909()).getDeckSize() - ((RecentlyDrawnCardsComponent)stack.method_58694(ModDataComponentTypes.RECENTLY_DRAWN_CARDS)).draws().size();
            textConsumer.accept((class_2561)TextHelper.styledTranslatable("item.chancechoice." + ((BaseDeckItem)stack.method_7909()).getDeckKey() + ".draws", remaining).method_27692(class_124.field_1080));
        }
        if (stack.method_31573(ModTags.Items.FLASH_CARD_DECKS)) {
            String card = ChanceChoiceResourceReloader.getFlashCard(((FlashCardDeckItem)stack.method_7909()).getFlashCardType(), (Integer)stack.method_58694(ModDataComponentTypes.CURRENTLY_DRAWN_FLASH_CARD) - 1);
            ItemStackMixin.addWrappedTooltip(textConsumer, class_310.method_1551().field_1772, card, 150, (Integer)stack.method_58694(ModDataComponentTypes.CURRENTLY_DRAWN_FLASH_CARD) <= 0 ? class_124.field_1068 : class_124.field_1065, true);
            int remaining = ((BaseDeckItem)stack.method_7909()).getDeckSize() - ((RecentlyDrawnCardsComponent)stack.method_58694(ModDataComponentTypes.RECENTLY_DRAWN_CARDS)).draws().size();
            textConsumer.accept((class_2561)TextHelper.styledTranslatable("item.chancechoice." + ((BaseDeckItem)stack.method_7909()).getDeckKey() + ".draws", remaining).method_27692(class_124.field_1080));
        }
    }

    @Unique
    private static void addWrappedTooltip(Consumer<class_2561> consumer, class_327 renderer, String text, int maxWidth, class_124 color, boolean italic) {
        List<String> lines = ItemStackMixin.wrapText(renderer, text, maxWidth);
        for (String line : lines) {
            class_5250 t = class_2561.method_43470((String)line).method_27692(italic ? class_124.field_1056 : class_124.field_1070).method_27692(color);
            consumer.accept((class_2561)t);
        }
    }

    private static List<String> wrapText(class_327 renderer, String text, int maxWidth) {
        ArrayList<String> lines = new ArrayList<String>();
        StringBuilder line = new StringBuilder();
        for (String word : text.split(" ")) {
            String testLine;
            String string = testLine = line.length() == 0 ? word : String.valueOf(line) + " " + word;
            if (renderer.method_1727(testLine) > maxWidth) {
                if (line.length() > 0) {
                    lines.add(line.toString());
                }
                line = new StringBuilder(word);
                continue;
            }
            line = new StringBuilder(testLine);
        }
        if (line.length() > 0) {
            lines.add(line.toString());
        }
        return lines;
    }
}

