/*
 * Decompiled with CFR 0.152.
 */
package net.dented.chancechoice.util;

import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.dented.chancechoice.effect.ModStatusEffects;
import net.minecraft.class_1297;
import net.minecraft.class_1314;
import net.minecraft.class_1657;
import net.minecraft.class_1922;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_4097;
import net.minecraft.class_4140;
import net.minecraft.class_4141;
import net.minecraft.class_4142;
import org.jetbrains.annotations.Nullable;

public class PanicIfBalanceCardTask<E extends class_1314>
extends class_4097<E> {
    private static final int MIN_RUN_TIME = 100;
    private static final int MAX_RUN_TIME = 600;
    private static final double DETECT_RADIUS = 16.0;
    private static final int FLEE_DISTANCE = 12;
    private static final int COMPLETION_RANGE = 1;
    private final float speed;
    private final Function<E, class_243> fallbackFinder;

    public PanicIfBalanceCardTask(float speed) {
        super(Map.of(class_4140.field_39408, class_4141.field_18458), 100, 600);
        this.speed = speed;
        this.fallbackFinder = e -> null;
    }

    protected boolean shouldRun(class_3218 world, E entity) {
        if (entity.method_18868().method_18896(class_4140.field_39408)) {
            return true;
        }
        List players = world.method_8390(class_1657.class, entity.method_5829().method_1014(16.0), p -> p.method_6059(ModStatusEffects.BALANCE_CARD));
        return !players.isEmpty();
    }

    protected boolean shouldKeepRunning(class_3218 world, E entity, long time) {
        return true;
    }

    protected void run(class_3218 world, E entity, long time) {
        entity.method_18868().method_18878(class_4140.field_39408, (Object)true);
        entity.method_18868().method_18875(class_4140.field_18445);
        entity.method_5942().method_6340();
    }

    protected void keepRunning(class_3218 world, E entity, long time) {
        class_243 fleeTarget;
        if (entity.method_5942().method_6357() && (fleeTarget = this.computeFleeTarget(world, entity)) != null) {
            entity.method_18868().method_18878(class_4140.field_18445, (Object)new class_4142(fleeTarget, this.speed, 1));
        }
    }

    protected void finishRunning(class_3218 world, E entity, long time) {
        entity.method_18868().method_18875(class_4140.field_39408);
        entity.method_18868().method_18875(class_4140.field_18445);
    }

    @Nullable
    private class_243 computeFleeTarget(class_3218 world, E entity) {
        List players = world.method_8390(class_1657.class, entity.method_5829().method_1014(10.0), p -> p.method_6059(ModStatusEffects.BALANCE_CARD));
        if (players.isEmpty()) {
            return null;
        }
        class_1657 nearest = (class_1657)players.get(0);
        double minDist = entity.method_5858((class_1297)nearest);
        for (class_1657 p2 : players) {
            double d = entity.method_5858((class_1297)p2);
            if (!(d < minDist)) continue;
            minDist = d;
            nearest = p2;
        }
        class_243 away = entity.method_73189().method_1020(nearest.method_73189()).method_1029();
        if (away.method_1027() < 1.0E-6) {
            away = new class_243(world.field_9229.method_43058() - 0.5, 0.0, world.field_9229.method_43058() - 0.5).method_1029();
        }
        double fleeDistance = 8.0;
        class_243 target = entity.method_73189().method_1019(away.method_1021(fleeDistance));
        if (!world.method_8320(new class_2338((int)target.method_10216(), (int)target.method_10214(), (int)target.method_10215())).method_26212((class_1922)world, new class_2338((int)target.method_10216(), (int)target.method_10214(), (int)target.method_10215()))) {
            return target;
        }
        return entity.method_73189();
    }
}

