/*
 * Decompiled with CFR 0.152.
 */
package net.dented.chancechoice;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import net.dented.chancechoice.block.ModBlocks;
import net.dented.chancechoice.block.dispenser.ModDispenserBehavior;
import net.dented.chancechoice.block.entity.ModBlockEntities;
import net.dented.chancechoice.component.ModDataComponentTypes;
import net.dented.chancechoice.config.Config;
import net.dented.chancechoice.effect.ModStatusEffects;
import net.dented.chancechoice.entity.ModEntities;
import net.dented.chancechoice.event.ModServerEvents;
import net.dented.chancechoice.item.ModItemGroups;
import net.dented.chancechoice.item.ModItems;
import net.dented.chancechoice.loot.ModLootRegistry;
import net.dented.chancechoice.network.ModNetworkRegistry;
import net.dented.chancechoice.potion.ModPotions;
import net.dented.chancechoice.util.ChanceChoiceResourceReloader;
import net.dented.chancechoice.village.ModTradeOffers;
import net.dented.chancechoice.world.LibraryChunkGenerator;
import net.dented.chancechoice.world.ModDimensions;
import net.dented.chancechoice.world.ModWorldgen;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerChunkEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.minecraft.class_2791;
import net.minecraft.class_3264;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChanceChoiceMod
implements ModInitializer {
    public static final String MOD_ID = "chancechoice";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"chancechoice");

    public void onInitialize() {
        LOGGER.info("Loading Chance & Choice");
        ChanceChoiceMod.loadConfig();
        ResourceManagerHelper.get((class_3264)class_3264.field_14190).registerReloadListener((IdentifiableResourceReloadListener)new ChanceChoiceResourceReloader());
        ModItems.registerModItems();
        ModBlocks.registerModBlocks();
        ModBlockEntities.registerModBlockEntities();
        ModEntities.registerModEntities();
        ModItemGroups.registerModItemGroups();
        ModDataComponentTypes.registerModDataComponentTypes();
        ModNetworkRegistry.registerNetworkHandling();
        ModTradeOffers.registerGamerTradeOffers();
        ModStatusEffects.registerModEffects();
        ModPotions.registerPotions();
        ModServerEvents.registerModEvents();
        ModLootRegistry.registerLootTableEvents();
        ModWorldgen.register();
        ModDispenserBehavior.register();
        ServerLifecycleEvents.SERVER_STARTING.register(server -> {
            if (server.method_3847(ModDimensions.INFINITE_LIBRARY) == null) {
                server.method_3847(ModDimensions.INFINITE_LIBRARY);
            }
        });
        ServerChunkEvents.CHUNK_LOAD.register((world, chunk) -> {
            if (world.method_27983() == ModDimensions.INFINITE_LIBRARY) {
                LibraryChunkGenerator.populateBookshelves(world, (class_2791)chunk);
            }
        });
    }

    public static void loadConfig() {
        Path configPath = Config.getConfigPath();
        if (Files.exists(configPath, new LinkOption[0])) {
            Config.loadConfigFromFile();
        }
        Config.writeConfigToFile();
    }
}

