/*
 * Decompiled with CFR 0.152.
 */
package net.dented.chancechoice.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import net.dented.chancechoice.ChanceChoiceMod;
import net.dented.chancechoice.config.ConfigComment;
import net.fabricmc.loader.api.FabricLoader;

public class Config {
    @ConfigComment(value="config.chancechoice.flashCardAndLettersBagOutputLanguage")
    public static String flashCardAndLettersBagOutputLanguage = "en_us";
    @ConfigComment(value="config.chancechoice.chanceTableItemUseCooldownTicks")
    public static int chanceTableItemUseCooldownTicks = 40;
    @ConfigComment(value="config.chancechoice.chanceTableMaxLinkedPlayers")
    public static int chanceTableMaxLinkedPlayers = 20;
    @ConfigComment(value="config.chancechoice.chanceTableRandomEffectChance")
    public static float chanceTableRandomEffectChance = 0.25f;
    @ConfigComment(value="config.chancechoice.chanceTableRandomEffectMinDurationTicks")
    public static int chanceTableRandomEffectMinDurationTicks = 200;
    @ConfigComment(value="config.chancechoice.chanceTableRandomEffectMaxDurationTicks")
    public static int chanceTableRandomEffectMaxDurationTicks = 800;
    @ConfigComment(value="config.chancechoice.summonedItemBrightnessDecreaseTicks")
    public static int summonedItemBrightnessDecreaseTicks = 20;
    @ConfigComment(value="config.chancechoice.summonedWorldshaperInitialBrightness")
    public static int summonedWorldshaperInitialBrightness = 2700;
    @ConfigComment(value="config.chancechoice.summonedSwordInitialBrightness")
    public static int summonedSwordInitialBrightness = 2700;
    @ConfigComment(value="config.chancechoice.summonedBowInitialBrightness")
    public static int summonedBowInitialBrightness = 2700;
    @ConfigComment(value="config.chancechoice.summonedHelmetInitialBrightness")
    public static int summonedHelmetInitialBrightness = 2700;
    @ConfigComment(value="config.chancechoice.summonedChestplateInitialBrightness")
    public static int summonedChestplateInitialBrightness = 2700;
    @ConfigComment(value="config.chancechoice.summonedLeggingsInitialBrightness")
    public static int summonedLeggingsInitialBrightness = 2700;
    @ConfigComment(value="config.chancechoice.summonedBootsInitialBrightness")
    public static int summonedBootsInitialBrightness = 2700;
    @ConfigComment(value="config.chancechoice.summonedArrowEffectDurationTicks")
    public static int summonedArrowEffectDurationTicks = 1200;
    @ConfigComment(value="config.chancechoice.gameMasterItemsLootChance")
    public static float gameMasterItemsLootChance = 0.2f;
    @ConfigComment(value="config.chancechoice.gameMasterItemsLootTables")
    public static ArrayList<String> gameMasterItemsLootTables = new ArrayList<String>(List.of("chests/trial_chambers/reward_ominous_unique"));
    @ConfigComment(value="config.chancechoice.gameMasterItemsEffectDurationTicks")
    public static int gameMasterItemsEffectDurationTicks = 6000;
    @ConfigComment(value="config.chancechoice.puzzleBoxItemLootChance")
    public static float puzzleBoxItemLootChance = 0.15f;
    @ConfigComment(value="config.chancechoice.puzzleBoxItemLootTables")
    public static ArrayList<String> puzzleBoxItemLootTables = new ArrayList<String>(List.of("archaeology/ocean_ruin_cold", "archaeology/ocean_ruin_warm"));
    @ConfigComment(value="config.chancechoice.puzzleBoxItemEffectDurationTicks")
    public static int puzzleBoxItemEffectDurationTicks = 3000;
    @ConfigComment(value="config.chancechoice.puzzleBoxItemAllowedUsers")
    public static ArrayList<String> puzzleBoxItemAllowedUsers = new ArrayList(List.of());
    @ConfigComment(value="config.chancechoice.puzzleBoxItemUseCooldownTicks")
    public static int puzzleBoxItemUseCooldownTicks = 60;
    @ConfigComment(value="config.chancechoice.deckOfManyThingsItemEffectDurationTicks")
    public static int deckOfManyThingsItemEffectDurationTicks = 36000;
    @ConfigComment(value="config.chancechoice.internalUseSingletonLootTables")
    public static ArrayList<String> internalUseSingletonLootTables = new ArrayList<String>(List.of("chests/trial_chambers/reward_ominous_unique", "chests/trial_chambers/reward_unique", "archaeology/desert_pyramid", "archaeology/desert_well", "archaeology/ocean_ruin_cold", "archaeology/ocean_ruin_warm", "archaeology/trail_ruins_common", "archaeology/trail_ruins_rare", "spawners/trial_chamber/key", "spawners/ominous/trial_chamber/key"));
    private static final transient Gson GSON = new GsonBuilder().excludeFieldsWithModifiers(new int[]{128}).serializeNulls().serializeSpecialFloatingPointValues().setPrettyPrinting().setLenient().create();

    public static Path getConfigPath() {
        return FabricLoader.getInstance().getConfigDir().resolve("chancechoice.json");
    }

    public static void loadConfigFromFile() {
        Path configPath = Config.getConfigPath();
        try {
            GSON.fromJson(Files.readString(configPath), Config.class);
        }
        catch (IOException e) {
            ChanceChoiceMod.LOGGER.warn("Failed to read config file from " + String.valueOf(configPath), (Throwable)e);
        }
    }

    public static void writeConfigToFile() {
        Path configPath = Config.getConfigPath();
        try {
            String jsonString = GSON.toJson((Object)new Config());
            Files.writeString(configPath, (CharSequence)jsonString, new OpenOption[0]);
        }
        catch (IOException e) {
            ChanceChoiceMod.LOGGER.warn("Failed to write config file to " + String.valueOf(configPath), (Throwable)e);
        }
    }
}

