/*
 * Decompiled with CFR 0.152.
 */
package net.dented.chancechoice.config;

import java.lang.invoke.LambdaMetafactory;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.dented.chancechoice.config.Config;
import net.dented.chancechoice.config.ConfigComment;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_350;
import net.minecraft.class_353;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_4667;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import net.minecraft.class_6379;

public class ConfigScreen
extends class_4667 {
    private ModOptionListWidget list;
    private final Map<Field, TextFieldEntry> fieldInputs = new LinkedHashMap<Field, TextFieldEntry>();
    private static final int LABEL_COLOR = -393218;
    private static final int FIELD_MAX_WIDTH = 310;
    private static final int FIELD_HEIGHT = 20;
    private static final int ROW_HEIGHT = 36;

    public ConfigScreen(class_437 parent) {
        super(parent, class_310.method_1551().field_1690, (class_2561)class_2561.method_43471((String)"config.chancechoice.title"));
    }

    protected void method_25426() {
        class_310 mc = Objects.requireNonNullElseGet(this.field_22787, class_310::method_1551);
        this.list = new ModOptionListWidget(mc, this.field_22789, this, 36);
        this.method_37063((class_364)this.list);
        this.buildEntriesFromConfig();
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_5244.field_24334, b -> this.onDone()).method_46434(this.field_22789 / 2 - 154, this.field_22790 - 28, 150, 20).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_5244.field_24335, b -> this.onCancel()).method_46434(this.field_22789 / 2 + 4, this.field_22790 - 28, 150, 20).method_46431());
    }

    private void buildEntriesFromConfig() {
        for (Field field : Config.class.getDeclaredFields()) {
            TextFieldEntry entry;
            Object value;
            if (!Modifier.isStatic(field.getModifiers()) || Modifier.isTransient(field.getModifiers())) continue;
            field.setAccessible(true);
            String labelKey = null;
            if (field.isAnnotationPresent(ConfigComment.class)) {
                labelKey = field.getAnnotation(ConfigComment.class).value();
            }
            try {
                value = field.get(null);
            }
            catch (IllegalAccessException e) {
                continue;
            }
            class_5250 labelText = labelKey != null ? class_2561.method_43471((String)labelKey) : class_2561.method_43470((String)field.getName());
            this.list.addCustomEntry(new LabelEntry(this, (class_2561)labelText));
            if (value instanceof String) {
                String s = (String)value;
                entry = new TextFieldEntry(this, s);
                this.list.addCustomEntry(entry);
                this.fieldInputs.put(field, entry);
                continue;
            }
            if (value instanceof Number) {
                Number n = (Number)value;
                entry = new TextFieldEntry(this, n.toString());
                this.list.addCustomEntry(entry);
                this.fieldInputs.put(field, entry);
                continue;
            }
            if (value instanceof List) {
                List l = (List)value;
                String joined = l.stream().map(Object::toString).collect(Collectors.joining(","));
                TextFieldEntry entry2 = new TextFieldEntry(this, joined);
                this.list.addCustomEntry(entry2);
                this.fieldInputs.put(field, entry2);
                continue;
            }
            entry = new TextFieldEntry(this, "<unsupported>");
            entry.field.method_1888(false);
            this.list.addCustomEntry(entry);
        }
    }

    protected void method_60325() {
    }

    private void onDone() {
        for (Map.Entry<Field, TextFieldEntry> e : this.fieldInputs.entrySet()) {
            Field field = e.getKey();
            String text = e.getValue().getText();
            try {
                Class<?> type = field.getType();
                if (type == String.class) {
                    field.set(null, text);
                    continue;
                }
                if (type == Integer.TYPE || type == Integer.class) {
                    field.set(null, Integer.parseInt(text));
                    continue;
                }
                if (type == Float.TYPE || type == Float.class) {
                    field.set(null, Float.valueOf(Float.parseFloat(text)));
                    continue;
                }
                if (!List.class.isAssignableFrom(type)) continue;
                List list = Arrays.stream(text.split(",")).map(String::trim).filter(s -> !s.isEmpty()).collect(Collectors.toCollection(ArrayList::new));
                field.set(null, list);
            }
            catch (Exception ex) {
                Objects.requireNonNullElseGet(this.field_22787, (Supplier<class_310>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, method_1551(), ()Lnet/minecraft/class_310;)()).field_1724.method_7353((class_2561)class_2561.method_43470((String)("Invalid value for " + field.getName())), false);
            }
        }
        Config.writeConfigToFile();
        Objects.requireNonNullElseGet(this.field_22787, class_310::method_1551).method_1507(this.field_21335);
    }

    private void onCancel() {
        Config.loadConfigFromFile();
        Objects.requireNonNullElseGet(this.field_22787, class_310::method_1551).method_1507(this.field_21335);
    }

    public void method_25432() {
        Config.loadConfigFromFile();
    }

    private static class ModOptionListWidget
    extends class_353 {
        private final int rowHeight;

        ModOptionListWidget(class_310 client, int width, class_4667 parent, int rowHeight) {
            super(client, width, parent);
            this.rowHeight = rowHeight;
        }

        public void addCustomEntry(class_353.class_354 entry) {
            super.method_25321((class_350.class_351)entry);
        }
    }

    private static class LabelEntry
    extends class_353.class_354 {
        private final ConfigScreen parent;
        private final class_2561 label;

        LabelEntry(ConfigScreen parent, class_2561 label) {
            super(Collections.emptyList(), (class_437)parent);
            this.parent = parent;
            this.label = label;
        }

        public void method_25343(class_332 context, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickProgress) {
            super.method_25343(context, index, y, x, entryWidth, entryHeight, mouseX, mouseY, hovered, tickProgress);
            int labelX = x + 10;
            Objects.requireNonNull(this.parent.field_22793);
            int labelY = y + (entryHeight - 9) / 2;
            context.method_27535(this.parent.field_22793, this.label, labelX, labelY, -393218);
        }

        public List<? extends class_364> method_25396() {
            return Collections.emptyList();
        }

        public List<? extends class_6379> method_37025() {
            return Collections.emptyList();
        }
    }

    private static class TextFieldEntry
    extends class_353.class_354 {
        private final ConfigScreen parent;
        private final class_342 field;

        TextFieldEntry(ConfigScreen parent, String initialText) {
            super(Collections.emptyList(), (class_437)parent);
            this.parent = parent;
            this.field = new class_342(parent.field_22793, 0, 0, Math.min(310, parent.field_22789 - 40), 20, (class_2561)class_2561.method_43470((String)""));
            this.field.method_1880(2048);
            this.field.method_1852(initialText);
            this.field.method_1856(true);
        }

        String getText() {
            return this.field.method_1882();
        }

        void setText(String text) {
            this.field.method_1852(text);
        }

        public void method_25343(class_332 context, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickProgress) {
            int w = Math.min(310, this.parent.field_22789 - 40);
            if (w != this.field.method_25368()) {
                this.field.method_25358(w);
            }
            int fieldX = x + (entryWidth - this.field.method_25368()) / 2;
            int fieldY = y + (entryHeight - this.field.method_25364()) / 2;
            this.field.method_46421(fieldX);
            this.field.method_46419(fieldY);
            this.field.method_25394(context, mouseX, mouseY, tickProgress);
        }

        public List<? extends class_364> method_25396() {
            return Collections.singletonList(this.field);
        }

        public List<? extends class_6379> method_37025() {
            return this.method_25396();
        }
    }
}

