/*
 * Decompiled with CFR 0.152.
 */
package net.dented.chancechoice.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.dented.chancechoice.ChanceChoiceMod;
import net.dented.chancechoice.config.Config;
import net.dented.chancechoice.item.custom.FlashCardDeckItem;
import net.dented.chancechoice.item.custom.LettersBagItem;
import net.fabricmc.fabric.api.resource.SimpleSynchronousResourceReloadListener;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_5819;

public class ChanceChoiceResourceReloader
implements SimpleSynchronousResourceReloadListener {
    private static final Map<LettersBagItem.LettersBagType, List<String>> WORDS = new EnumMap<LettersBagItem.LettersBagType, List<String>>(LettersBagItem.LettersBagType.class);
    private static final Map<FlashCardDeckItem.FlashCardType, List<String>> FLASH_CARDS = new EnumMap<FlashCardDeckItem.FlashCardType, List<String>>(FlashCardDeckItem.FlashCardType.class);

    public class_2960 getFabricId() {
        return class_2960.method_60655((String)"chancechoice", (String)"chance_output");
    }

    public void method_14491(class_3300 manager) {
        String expectedSuffix;
        WORDS.clear();
        FLASH_CARDS.clear();
        String lang = Config.flashCardAndLettersBagOutputLanguage.toLowerCase(Locale.ROOT);
        for (LettersBagItem.LettersBagType lettersBagType : LettersBagItem.LettersBagType.values()) {
            ArrayList<String> loadedWords = new ArrayList<String>();
            expectedSuffix = lang + "_" + lettersBagType.name().toLowerCase(Locale.ROOT) + ".txt";
            manager.method_14488("chance_output", id -> id.method_12832().endsWith(expectedSuffix)).forEach((id, resource) -> {
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(resource.method_14482(), StandardCharsets.UTF_8));){
                    reader.lines().map(String::trim).filter(line -> !line.isEmpty() && !line.startsWith("#")).forEach(loadedWords::add);
                }
                catch (IOException e) {
                    ChanceChoiceMod.LOGGER.error("Failed to read letters bag file {}", id, (Object)e);
                }
            });
            if (loadedWords.isEmpty() && lettersBagType == LettersBagItem.LettersBagType.ALPHABET) {
                for (char c = 'A'; c <= 'Z'; c = (char)(c + '\u0001')) {
                    loadedWords.add(String.valueOf(c));
                }
            }
            WORDS.put(lettersBagType, loadedWords);
        }
        for (Enum enum_ : FlashCardDeckItem.FlashCardType.values()) {
            ArrayList loadedFlashCards = new ArrayList();
            expectedSuffix = lang + "_" + enum_.name().toLowerCase(Locale.ROOT) + ".txt";
            manager.method_14488("chance_output", id -> id.method_12832().endsWith(expectedSuffix)).forEach((id, resource) -> {
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(resource.method_14482(), StandardCharsets.UTF_8));){
                    reader.lines().map(String::trim).filter(line -> !line.isEmpty() && !line.startsWith("#")).forEach(loadedFlashCards::add);
                }
                catch (IOException e) {
                    ChanceChoiceMod.LOGGER.error("Failed to read flash card file {}", id, (Object)e);
                }
            });
            FLASH_CARDS.put((FlashCardDeckItem.FlashCardType)enum_, loadedFlashCards);
        }
        ChanceChoiceMod.LOGGER.info("Loaded flash card set for {}: {}", (Object)lang, FLASH_CARDS.entrySet().stream().map(e -> String.valueOf(e.getKey()) + "=" + ((List)e.getValue()).size() + " entries").toList());
    }

    public static String getRandomWord(LettersBagItem.LettersBagType type, class_5819 random) {
        List pool = WORDS.getOrDefault((Object)type, List.of());
        if (pool.isEmpty()) {
            return "?";
        }
        return (String)pool.get(random.method_43048(pool.size()));
    }

    public static int getFlashCardCount(FlashCardDeckItem.FlashCardType type) {
        List pool = FLASH_CARDS.getOrDefault((Object)type, List.of());
        return pool.size();
    }

    public static String getFlashCard(FlashCardDeckItem.FlashCardType type, int index) {
        List pool = FLASH_CARDS.getOrDefault((Object)type, List.of());
        if (pool.isEmpty() || index < 0 || index >= pool.size()) {
            return class_2561.method_43471((String)"item.chancechoice.flash_card_deck.empty").getString();
        }
        return (String)pool.get(index);
    }
}

