/*
 * Decompiled with CFR 0.152.
 */
package net.felix.mixin;

import net.felix.CCLiveUtilitiesConfig;
import net.felix.utilities.AspectOverlay;
import net.felix.utilities.SchmiedTrackerUtility;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_332;
import net.minecraft.class_465;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_465.class})
public abstract class HandledScreenMixin {
    @Shadow
    protected int field_2776;
    @Shadow
    protected int field_2800;

    @Inject(method={"render"}, at={@At(value="TAIL")})
    private void onRender(class_332 context, int mouseX, int mouseY, float delta, CallbackInfo ci) {
        if (this.isSmithingInventory()) {
            this.renderSmithingFrames(context);
        }
        if (this.isBlueprintInventory()) {
            this.renderHideUncraftableButton(context);
        }
        if (this.isBlueprintInventory() && ((CCLiveUtilitiesConfig)CCLiveUtilitiesConfig.HANDLER.instance()).aspectOverlayEnabled) {
            this.updateAspectOverlay(mouseX, mouseY);
            this.renderAspectOverlay(context);
        }
    }

    @Inject(method={"mouseClicked"}, at={@At(value="HEAD")}, cancellable=true)
    private void onMouseClicked(double mouseX, double mouseY, int button, CallbackInfoReturnable<Boolean> cir) {
        if (this.isBlueprintInventory() && this.handleHideUncraftableButtonClick(mouseX, mouseY, button)) {
            cir.setReturnValue((Object)true);
        }
    }

    private void renderSmithingFrames(class_332 context) {
        try {
            class_465 screen = (class_465)this;
            SchmiedTrackerUtility.renderColoredFrames(context, screen, this.field_2776, this.field_2800);
        }
        catch (Exception e) {
            System.err.println("Error rendering smithing frames: " + e.getMessage());
            e.printStackTrace();
        }
    }

    private void renderHideUncraftableButton(class_332 context) {
        try {
            class_465 screen = (class_465)this;
            SchmiedTrackerUtility.renderHideUncraftableButton(context, screen);
        }
        catch (Exception e) {
            System.err.println("Error rendering Hide Uncraftable button: " + e.getMessage());
            e.printStackTrace();
        }
    }

    private boolean handleHideUncraftableButtonClick(double mouseX, double mouseY, int button) {
        try {
            return SchmiedTrackerUtility.handleButtonClick(mouseX, mouseY, button);
        }
        catch (Exception e) {
            System.err.println("Error handling Hide Uncraftable button click: " + e.getMessage());
            e.printStackTrace();
            return false;
        }
    }

    private void updateAspectOverlay(int mouseX, int mouseY) {
        try {
            class_1799 itemStack;
            class_465 screen = (class_465)this;
            class_1735 hoveredSlot = null;
            for (class_1735 slot : screen.method_17577().field_7761) {
                if (slot.field_7873 + this.field_2776 > mouseX || mouseX >= slot.field_7873 + this.field_2776 + 16 || slot.field_7872 + this.field_2800 > mouseY || mouseY >= slot.field_7872 + this.field_2800 + 16) continue;
                hoveredSlot = slot;
                break;
            }
            if (hoveredSlot != null && hoveredSlot.method_7681() && (itemStack = hoveredSlot.method_7677()) != null && !itemStack.method_7960()) {
                AspectOverlay.updateAspectInfo(itemStack);
                return;
            }
            AspectOverlay.onHoverStopped();
        }
        catch (Exception e) {
            System.err.println("Error updating aspect overlay: " + e.getMessage());
            e.printStackTrace();
        }
    }

    private void renderAspectOverlay(class_332 context) {
        try {
            AspectOverlay.renderForeground(context);
        }
        catch (Exception e) {
            System.err.println("Error rendering aspect overlay: " + e.getMessage());
            e.printStackTrace();
        }
    }

    private boolean isBlueprintInventory() {
        try {
            class_465 screen = (class_465)this;
            String title = screen.method_25440().getString();
            String cleanTitle = title.replaceAll("\u00a7[0-9a-fk-or]", "").replaceAll("[\\u3400-\\u4DBF]", "");
            return cleanTitle.contains("Baupl\u00e4ne [Waffen]") || cleanTitle.contains("Baupl\u00e4ne [R\u00fcstung]") || cleanTitle.contains("Baupl\u00e4ne [Werkzeuge]") || cleanTitle.contains("Bauplan [Shop]") || cleanTitle.contains("Favorisierte [R\u00fcstungsbaupl\u00e4ne]") || cleanTitle.contains("Favorisierte [Waffenbaupl\u00e4ne]") || cleanTitle.contains("CACTUS_CLICKER.blueprints.favorites.title.tools");
        }
        catch (Exception e) {
            System.err.println("Error checking blueprint inventory: " + e.getMessage());
            e.printStackTrace();
            return false;
        }
    }

    private boolean isSmithingInventory() {
        try {
            class_465 screen = (class_465)this;
            String title = screen.method_25440().getString();
            return title.contains("Zerlegen") || title.contains("Umschmieden") || title.contains("Ausr\u00fcstung [Ausw\u00e4hlen]") || title.contains("Aufwerten") || title.contains("R\u00fcstungs Sammlung") || title.contains("Waffen Sammlung") || title.contains("Werkzeug Sammlung") || title.contains("CACTUS_CLICKER.CACTUS_CLICKER") || title.contains("Gesch\u00fctzte Items");
        }
        catch (Exception e) {
            System.err.println("Error checking smithing inventory: " + e.getMessage());
            e.printStackTrace();
            return false;
        }
    }
}

