/*
 * Decompiled with CFR 0.152.
 */
package net.felix.utilities;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_5250;

public class ActionBarData {
    private static final Map<String, Integer> materials = new HashMap<String, Integer>();
    private static final List<Object> filteredTexts = new ArrayList<Object>();
    private static final Map<String, class_2561> materialTexts = new HashMap<String, class_2561>();
    private static final Pattern MATERIAL_PATTERN = Pattern.compile("(?:\\+\\d+|\\d+x)\\s+([^\\[]+)\\s*\\[(\\d+)\\]");
    private static String currentDimension = null;
    private static Boolean cachedIsOnFloor = null;

    public static void reset() {
        materials.clear();
        filteredTexts.clear();
        materialTexts.clear();
        cachedIsOnFloor = null;
    }

    public static void processActionBarMessage(class_2561 message) {
        if (message == null) {
            return;
        }
        String messageString = message.getString();
        if (messageString.trim().isEmpty()) {
            return;
        }
        if (!ActionBarData.isOnFloor()) {
            return;
        }
        Matcher matcher = MATERIAL_PATTERN.matcher(messageString);
        if (matcher.find()) {
            String materialName = matcher.group(1).trim();
            int count = Integer.parseInt(matcher.group(2));
            materials.put(materialName, count);
            materialTexts.put(materialName, message);
            ActionBarData.updateFilteredTexts();
        }
    }

    public static void processActionBarMessage(String message) {
        if (message == null || message.trim().isEmpty()) {
            return;
        }
        if (!ActionBarData.isOnFloor()) {
            return;
        }
        Matcher matcher = MATERIAL_PATTERN.matcher(message);
        if (matcher.find()) {
            String materialName = matcher.group(1).trim();
            int count = Integer.parseInt(matcher.group(2));
            materials.put(materialName, count);
            ActionBarData.updateFilteredTexts();
        }
    }

    private static boolean isOnFloor() {
        if (cachedIsOnFloor != null) {
            return cachedIsOnFloor;
        }
        try {
            class_310 client = class_310.method_1551();
            if (client != null && client.field_1687 != null) {
                String dimensionId = client.field_1687.method_27983().method_29177().toString().toLowerCase();
                boolean isFloor = dimensionId.contains("floor");
                cachedIsOnFloor = isFloor;
                return isFloor;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private static void updateFilteredTexts() {
        filteredTexts.clear();
        ArrayList<Map.Entry<String, Integer>> sortedMaterials = new ArrayList<Map.Entry<String, Integer>>(materials.entrySet());
        sortedMaterials.sort((a, b) -> ((Integer)b.getValue()).compareTo((Integer)a.getValue()));
        for (Map.Entry entry : sortedMaterials) {
            String materialName = (String)entry.getKey();
            int count = (Integer)entry.getValue();
            class_2561 originalText = materialTexts.get(materialName);
            if (originalText != null) {
                class_2561 materialOnlyText = ActionBarData.extractMaterialOnly(originalText, materialName);
                filteredTexts.add(materialOnlyText);
                continue;
            }
            filteredTexts.add(materialName + " [" + count + "]");
        }
    }

    public static List<Object> getFilteredTexts() {
        return new ArrayList<Object>(filteredTexts);
    }

    public static Map<String, Integer> getMaterials() {
        return new HashMap<String, Integer>(materials);
    }

    public static boolean hasMaterials() {
        return !materials.isEmpty();
    }

    public static void checkDimensionChange() {
        try {
            class_310 client = class_310.method_1551();
            if (client.field_1687 != null && client.field_1724 != null) {
                String newDimension = client.field_1687.method_27983().method_29177().toString();
                if (currentDimension != null && !currentDimension.equals(newDimension)) {
                    ActionBarData.reset();
                }
                if (currentDimension == null || !currentDimension.equals(newDimension)) {
                    cachedIsOnFloor = null;
                }
                currentDimension = newDimension;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static class_2561 extractMaterialOnly(class_2561 originalText, String materialName) {
        try {
            class_5250 output = class_2561.method_43470((String)"");
            for (class_2561 sibling : originalText.method_10855()) {
                String content = sibling.getString();
                if (content.matches("^\\d+x\\s?") || content.matches("^\\+\\d+\\s?")) continue;
                output.method_10852(sibling);
            }
            if (output.getString().trim().isEmpty()) {
                return class_2561.method_43470((String)(materialName + " [" + String.valueOf(materials.get(materialName)) + "]"));
            }
            return output;
        }
        catch (Exception e) {
            return class_2561.method_43470((String)(materialName + " [" + String.valueOf(materials.get(materialName)) + "]"));
        }
    }
}

