/*
 * Decompiled with CFR 0.152.
 */
package net.felix.utilities;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3675;
import net.minecraft.class_437;

public class AspectInfoGUI
extends class_437 {
    private static AspectInfoGUI instance;
    private static boolean shouldShow;
    private static String currentAspectName;
    private static String currentAspectDescription;
    private static int x;
    private static int y;
    private static Map<String, AspectInfo> aspectsDatabase;
    private static final String ASPECTS_CONFIG_FILE = "assets/cclive-utilities/Aspekte.json";

    public AspectInfoGUI() {
        super((class_2561)class_2561.method_43470((String)"Aspect Info"));
    }

    public static void initialize() {
        if (instance == null) {
            instance = new AspectInfoGUI();
        }
        AspectInfoGUI.loadAspectsDatabase();
    }

    public static AspectInfoGUI getInstance() {
        return instance;
    }

    public static void showAspectInfo(int mouseX, int mouseY) {
        class_310 client;
        boolean isShiftPressed;
        if (instance == null) {
            AspectInfoGUI.initialize();
        }
        boolean bl = isShiftPressed = class_3675.method_15987((long)(client = class_310.method_1551()).method_22683().method_4490(), (int)340) || class_3675.method_15987((long)client.method_22683().method_4490(), (int)344);
        if (!isShiftPressed) {
            shouldShow = false;
            return;
        }
        class_1799 hoveredItem = AspectInfoGUI.getHoveredItem(client, mouseX, mouseY);
        if (hoveredItem == null || hoveredItem.method_7960()) {
            shouldShow = false;
            return;
        }
        String itemName = AspectInfoGUI.getItemName(hoveredItem);
        if (itemName == null || !itemName.contains("[Bauplan]")) {
            shouldShow = false;
            return;
        }
        String cleanItemName = itemName.substring(0, itemName.indexOf("[Bauplan]")).trim();
        if (cleanItemName.startsWith("-")) {
            cleanItemName = cleanItemName.substring(1).trim();
        }
        if (cleanItemName.endsWith("-")) {
            cleanItemName = cleanItemName.substring(0, cleanItemName.length() - 1).trim();
        }
        cleanItemName = cleanItemName.replaceAll("\u00a7[0-9a-fk-or]", "");
        cleanItemName = cleanItemName.replaceAll("[\\u3400-\\u4DBF]", "");
        AspectInfo aspectInfo = aspectsDatabase.get(cleanItemName = cleanItemName.replaceAll("[^a-zA-Z\u00e4\u00f6\u00fc\u00df\u00c4\u00d6\u00dc\\s]", "").trim());
        if (aspectInfo != null && !aspectInfo.aspectName.isEmpty()) {
            currentAspectName = aspectInfo.aspectName;
            currentAspectDescription = aspectInfo.aspectDescription;
            shouldShow = true;
            x = mouseX + 10;
            y = mouseY - 10;
        } else {
            shouldShow = false;
        }
    }

    private static class_1799 getHoveredItem(class_310 client, int mouseX, int mouseY) {
        return null;
    }

    private static String getItemName(class_1799 itemStack) {
        if (itemStack == null || itemStack.method_7960()) {
            return null;
        }
        class_2561 displayName = itemStack.method_7964();
        if (displayName != null) {
            return displayName.getString();
        }
        return null;
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        if (!shouldShow) {
            return;
        }
        int guiX = x;
        int guiY = y;
        int screenWidth = class_310.method_1551().method_22683().method_4486();
        int screenHeight = class_310.method_1551().method_22683().method_4502();
        if (guiX + 200 > screenWidth) {
            guiX = mouseX - 210;
        }
        if (guiY + 80 > screenHeight) {
            guiY = mouseY - 90;
        }
        context.method_25294(guiX, guiY, guiX + 200, guiY + 80, -2013265920);
        context.method_25294(guiX, guiY, guiX + 200, guiY + 20, -1996499200);
        context.method_25294(guiX, guiY, guiX + 1, guiY + 80, -1);
        context.method_25294(guiX + 199, guiY, guiX + 200, guiY + 80, -1);
        context.method_25294(guiX, guiY, guiX + 200, guiY + 1, -1);
        context.method_25294(guiX, guiY + 79, guiX + 200, guiY + 80, -1);
        context.method_25303(this.field_22793, "Aspekt Information", guiX + 5, guiY + 5, 0);
        context.method_25303(this.field_22793, "Aspekt: " + currentAspectName, guiX + 5, guiY + 25, 65280);
        String[] descriptionLines = this.wrapText(currentAspectDescription, 30);
        for (int i = 0; i < descriptionLines.length; ++i) {
            context.method_25303(this.field_22793, descriptionLines[i], guiX + 5, guiY + 45 + i * 12, 0xFFFFFF);
        }
    }

    public void renderOverlay() {
        if (!shouldShow) {
            return;
        }
        class_310 client = class_310.method_1551();
        if (client == null || client.field_1772 == null) {
            return;
        }
        double mouseX = client.field_1729.method_1603() * (double)client.method_22683().method_4486() / (double)client.method_22683().method_4480();
        double mouseY = client.field_1729.method_1604() * (double)client.method_22683().method_4502() / (double)client.method_22683().method_4507();
        int guiX = x;
        int guiY = y;
        int screenWidth = client.method_22683().method_4486();
        int screenHeight = client.method_22683().method_4502();
        if (guiX + 200 > screenWidth) {
            guiX = (int)mouseX - 210;
        }
        if (guiY + 80 > screenHeight) {
            guiY = (int)mouseY - 90;
        }
    }

    private String[] wrapText(String text, int maxLength) {
        if (text.length() <= maxLength) {
            return new String[]{text};
        }
        String[] words = text.split(" ");
        StringBuilder currentLine = new StringBuilder();
        ArrayList<String> lines = new ArrayList<String>();
        for (String word : words) {
            if (currentLine.length() + word.length() + 1 <= maxLength) {
                if (currentLine.length() > 0) {
                    currentLine.append(" ");
                }
                currentLine.append(word);
                continue;
            }
            if (currentLine.length() > 0) {
                lines.add(currentLine.toString());
                currentLine = new StringBuilder(word);
                continue;
            }
            lines.add(word);
        }
        if (currentLine.length() > 0) {
            lines.add(currentLine.toString());
        }
        return lines.toArray(new String[0]);
    }

    public boolean method_25421() {
        return false;
    }

    public boolean method_25422() {
        return false;
    }

    private static void loadAspectsDatabase() {
        try {
            Path resource = (Path)((ModContainer)FabricLoader.getInstance().getModContainer("cclive-utilities").orElseThrow(() -> new RuntimeException("Mod container not found"))).findPath(ASPECTS_CONFIG_FILE).orElseThrow(() -> new RuntimeException("Aspects config file not found"));
            try (InputStream inputStream = Files.newInputStream(resource, new OpenOption[0]);
                 InputStreamReader reader = new InputStreamReader(inputStream);){
                JsonObject json = JsonParser.parseReader((Reader)reader).getAsJsonObject();
                for (String itemName : json.keySet()) {
                    JsonObject itemData = json.getAsJsonObject(itemName);
                    String aspectName = itemData.get("aspect_name").getAsString();
                    String aspectDescription = itemData.get("aspect_description").getAsString();
                    if (aspectName.isEmpty() && aspectDescription.isEmpty()) continue;
                    aspectsDatabase.put(itemName, new AspectInfo(aspectName, aspectDescription));
                }
            }
        }
        catch (Exception e) {
            System.err.println("Failed to load aspects database for GUI: " + e.getMessage());
            e.printStackTrace();
        }
    }

    static {
        shouldShow = false;
        currentAspectName = "";
        currentAspectDescription = "";
        aspectsDatabase = new HashMap<String, AspectInfo>();
    }

    private static class AspectInfo {
        public final String aspectName;
        public final String aspectDescription;

        public AspectInfo(String aspectName, String aspectDescription) {
            this.aspectName = aspectName;
            this.aspectDescription = aspectDescription;
        }
    }
}

