/*
 * Decompiled with CFR 0.152.
 */
package net.felix.utilities;

import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.message.v1.ClientReceiveMessageEvents;
import net.fabricmc.fabric.api.client.rendering.v1.HudRenderCallback;
import net.felix.CCLiveUtilitiesConfig;
import net.felix.utilities.EquipmentDisplayUtility;
import net.felix.utilities.KeyBindingUtility;
import net.minecraft.class_1297;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_9779;

public class BossHPUtility {
    private static boolean isInitialized = false;
    private static boolean showOverlays = true;
    private static BossHPUtility INSTANCE;
    private String currentBossName = null;
    private String currentBossText = null;
    private String lastKnownHP = null;
    private String lastKnownBossName = null;
    private boolean bossDefeated = false;
    private final Set<String> validBossNames = new HashSet<String>();
    private final Pattern bossPattern = Pattern.compile("(.+?)\\|{5}(\\d+)\\|{5}");
    private String lastDimension = "";
    private final Set<String> ignoredNames = new HashSet<String>();
    private boolean wavesActive = false;
    private boolean lastWaveState = false;
    private boolean waitingForBossResult = false;
    private long bossDisappearTimeWithoutReward = 0L;
    private static final long BOSS_DISAPPEAR_TIMEOUT = 5000L;
    private boolean bossLost = false;

    public BossHPUtility() {
        INSTANCE = this;
        this.initializeBossNames();
        this.initializeIgnoredNames();
    }

    public static BossHPUtility getInstance() {
        if (INSTANCE == null) {
            throw new IllegalStateException("BossHPUtility instance is null!");
        }
        return INSTANCE;
    }

    private void initializeBossNames() {
        this.validBossNames.add("Gro\u00dfer W\u00e4chter");
        this.validBossNames.add("Sniffer");
        this.validBossNames.add("Kamel");
        this.validBossNames.add("Wither");
        this.validBossNames.add("Warden");
        this.validBossNames.add("Riese");
        this.validBossNames.add("Ravager");
    }

    private void initializeIgnoredNames() {
        this.ignoredNames.add("(Forschraum)");
        this.ignoredNames.add("(Schmied)");
        this.ignoredNames.add("(Kaktusfarm)");
        this.ignoredNames.add("(Seelenraum)");
        this.ignoredNames.add("Freigeschalten!");
        this.ignoredNames.add("Kaktusmacs");
        this.ignoredNames.add("Forschermacs");
        this.ignoredNames.add("Schmiedmacs");
        this.ignoredNames.add("Seelenmacs");
        this.ignoredNames.add("Runenmacs");
        this.ignoredNames.add("Farmermacs");
        this.ignoredNames.add("Soul Harvester");
        this.ignoredNames.add("Essence Harvester");
        this.ignoredNames.add("Top Rangliste");
        this.ignoredNames.add("#");
        this.ignoredNames.add("Kaktus");
        this.ignoredNames.add("Seelen");
        this.ignoredNames.add("N\u00e4chste Aktualisierung");
        this.ignoredNames.add("Klicke f\u00fcr Ranglisten-Wechsel");
        this.ignoredNames.add("Deine Rangliste");
        this.ignoredNames.add("Aktuelles Tier");
        this.ignoredNames.add("N\u00e4chstes Tier in");
    }

    public static void initialize() {
        if (isInitialized) {
            return;
        }
        try {
            new BossHPUtility();
            BossHPUtility.registerCommands();
            ClientTickEvents.END_CLIENT_TICK.register(BossHPUtility::onClientTick);
            HudRenderCallback.EVENT.register((drawContext, tickDelta) -> BossHPUtility.onHudRender(drawContext, tickDelta));
            ClientReceiveMessageEvents.GAME.register(BossHPUtility::onChatMessage);
            isInitialized = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void registerCommands() {
    }

    private static void onClientTick(class_310 client) {
        BossHPUtility.checkTabKey();
        BossHPUtility instance = BossHPUtility.getInstance();
        if (client.field_1724 == null || client.field_1687 == null) {
            return;
        }
        String playerName = client.field_1724.method_5477().getString().toLowerCase();
        String dimensionPath = client.field_1687.method_27983().method_29177().method_12832();
        if (!dimensionPath.equals(instance.lastDimension)) {
            if (instance.lastDimension.equals(playerName)) {
                instance.clearCurrentBoss();
            }
            instance.lastDimension = dimensionPath;
        }
        if (dimensionPath.equals(playerName)) {
            instance.wavesActive = true;
            for (class_1297 entity : client.field_1687.method_18112()) {
                class_2561 customName;
                String displayText = null;
                if (entity.method_5864().toString().contains("text_display") || entity.method_5864().toString().contains("display")) {
                    displayText = BossHPUtility.getTextFromDisplayEntity(entity);
                } else if (entity.method_16914() && (customName = entity.method_5797()) != null) {
                    displayText = customName.getString().trim();
                }
                if (displayText == null || instance.shouldIgnoreEntity(displayText)) continue;
                instance.processTextDisplay(displayText);
            }
        } else {
            instance.wavesActive = false;
            if (instance.lastWaveState && !instance.wavesActive) {
                if (instance.waitingForBossResult) {
                    instance.handleBossLost();
                } else {
                    instance.clearCurrentBoss();
                }
            }
        }
        instance.lastWaveState = instance.wavesActive;
    }

    private static String getTextFromDisplayEntity(class_1297 entity) {
        block12: {
            try {
                String entityType = entity.getClass().getSimpleName();
                if (!entityType.contains("TextDisplay") && !entityType.contains("Display")) break block12;
                try {
                    Method getTextMethod = entity.getClass().getMethod("getText", new Class[0]);
                    Object textComponent = getTextMethod.invoke((Object)entity, new Object[0]);
                    if (textComponent instanceof class_2561) {
                        String result = ((class_2561)textComponent).getString();
                        return result;
                    }
                }
                catch (Exception getTextMethod) {
                    // empty catch block
                }
                try {
                    Method getTextStringMethod = entity.getClass().getMethod("getTextString", new Class[0]);
                    Object textString = getTextStringMethod.invoke((Object)entity, new Object[0]);
                    if (textString instanceof String) {
                        String result = (String)textString;
                        return result;
                    }
                }
                catch (Exception getTextStringMethod) {
                    // empty catch block
                }
                try {
                    class_2561 customName;
                    if (entity.method_16914() && (customName = entity.method_5797()) != null) {
                        String result = customName.getString();
                        return result;
                    }
                }
                catch (Exception customName) {
                    // empty catch block
                }
                String entityName = entity.method_5477().getString();
                if (entityName != null && !entityName.isEmpty() && !entityName.equals("entity.minecraft.text_display")) {
                    return entityName;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    private boolean shouldIgnoreEntity(String name) {
        name = name.trim();
        name = name.replaceAll("\\s+", " ");
        for (String ignoredName : this.ignoredNames) {
            if (!name.contains(ignoredName)) continue;
            return true;
        }
        return false;
    }

    public void processTextDisplay(String text) {
        String bossName;
        Matcher matcher;
        boolean containsBossName = this.validBossNames.stream().anyMatch(text::contains);
        if (containsBossName && (matcher = this.bossPattern.matcher(text)).matches() && this.validBossNames.contains(bossName = matcher.group(1).trim())) {
            if (this.bossDefeated) {
                this.bossDefeated = false;
            }
            this.currentBossName = bossName;
            this.currentBossText = text;
        }
    }

    public void hideOverlay() {
        this.lastKnownHP = null;
        this.lastKnownBossName = null;
        this.bossDisappearTimeWithoutReward = 0L;
        this.waitingForBossResult = false;
        this.bossDefeated = false;
        this.bossLost = false;
        this.currentBossName = null;
        this.currentBossText = null;
    }

    public void clearCurrentBoss() {
        if (this.currentBossName != null || this.currentBossText != null) {
            if (this.bossDefeated) {
                this.hideOverlay();
                return;
            }
            if (this.bossLost) {
                this.hideOverlay();
                return;
            }
            if (this.currentBossText != null) {
                String[] parts = this.currentBossText.split("\\|{5}");
                if (parts.length >= 2) {
                    String hp;
                    this.lastKnownHP = hp = parts[1].trim();
                    this.lastKnownBossName = this.currentBossName;
                    this.bossDisappearTimeWithoutReward = System.currentTimeMillis();
                    this.waitingForBossResult = true;
                } else {
                    this.hideOverlay();
                }
            } else {
                this.hideOverlay();
            }
            this.currentBossName = null;
            this.currentBossText = null;
        }
    }

    public boolean shouldShowDisappearedBoss() {
        boolean shouldShow;
        if (this.bossDefeated) {
            return false;
        }
        if (this.bossLost) {
            boolean shouldShow2;
            if (this.lastKnownHP == null || this.bossDisappearTimeWithoutReward == 0L) {
                return false;
            }
            long timeSinceDisappear = System.currentTimeMillis() - this.bossDisappearTimeWithoutReward;
            boolean bl = shouldShow2 = timeSinceDisappear < 5000L;
            if (!shouldShow2) {
                this.bossLost = false;
                this.hideOverlay();
            }
            return shouldShow2;
        }
        if (this.lastKnownHP == null || this.bossDisappearTimeWithoutReward == 0L) {
            return false;
        }
        if (!this.waitingForBossResult) {
            return false;
        }
        long timeSinceDisappear = System.currentTimeMillis() - this.bossDisappearTimeWithoutReward;
        boolean bl = shouldShow = timeSinceDisappear < 5000L;
        if (!shouldShow && this.waitingForBossResult) {
            this.waitingForBossResult = false;
            this.hideOverlay();
        }
        return shouldShow;
    }

    private static void onHudRender(class_332 context, class_9779 tickCounter) {
        class_310 client = class_310.method_1551();
        if (client == null) {
            return;
        }
        if (!(((CCLiveUtilitiesConfig)CCLiveUtilitiesConfig.HANDLER.instance()).enableMod && ((CCLiveUtilitiesConfig)CCLiveUtilitiesConfig.HANDLER.instance()).bossHPEnabled && ((CCLiveUtilitiesConfig)CCLiveUtilitiesConfig.HANDLER.instance()).showBossHP)) {
            return;
        }
        if (client.field_1724 == null || client.field_1687 == null) {
            return;
        }
        String playerName = client.field_1724.method_5477().getString().toLowerCase();
        String dimensionPath = client.field_1687.method_27983().method_29177().method_12832();
        if (!dimensionPath.equals(playerName)) {
            return;
        }
        BossHPUtility instance = BossHPUtility.getInstance();
        if (showOverlays && !EquipmentDisplayUtility.isEquipmentOverlayActive()) {
            BossHPUtility.renderBossHealthBars(context, client, instance);
        }
    }

    private static void renderBossHealthBars(class_332 context, class_310 client, BossHPUtility instance) {
        int configX = ((CCLiveUtilitiesConfig)CCLiveUtilitiesConfig.HANDLER.instance()).bossHPX;
        int configY = ((CCLiveUtilitiesConfig)CCLiveUtilitiesConfig.HANDLER.instance()).bossHPY;
        if (instance.currentBossName != null && instance.currentBossText != null && !instance.bossDefeated) {
            BossHPUtility.renderBossBar(context, client, configX, configY, instance.currentBossName, instance.currentBossText, false);
        } else if (instance.shouldShowDisappearedBoss()) {
            BossHPUtility.renderBossBar(context, client, configX, configY, instance.lastKnownBossName, instance.lastKnownHP, true);
        }
    }

    private static void renderBossBar(class_332 context, class_310 client, int x, int y, String bossName, String hpText, boolean isDisappeared) {
        int TEXT_COLOR = -1;
        int HP_COLOR = -43691;
        int BACKGROUND_COLOR = Integer.MIN_VALUE;
        int PADDING = 4;
        Object displayText = null;
        String displayHP = null;
        if (isDisappeared) {
            displayText = bossName + " verbleibend";
            displayHP = hpText;
        } else if (hpText.isEmpty()) {
            displayText = bossName;
            displayHP = "";
        } else {
            String[] parts = hpText.split("\\|{5}");
            if (parts.length >= 2) {
                displayText = parts[0].trim();
                displayHP = parts[1].trim();
            }
        }
        if (displayText == null) {
            return;
        }
        int nameWidth = client.field_1772.method_1727((String)displayText);
        int hpWidth = displayHP.isEmpty() ? 0 : client.field_1772.method_1727(displayHP);
        int totalWidth = nameWidth + (displayHP.isEmpty() ? 0 : 10 + hpWidth);
        int posX = x - totalWidth - 8;
        int posY = y;
        if (((CCLiveUtilitiesConfig)CCLiveUtilitiesConfig.HANDLER.instance()).bossHPShowBackground) {
            Objects.requireNonNull(client.field_1772);
            context.method_25294(posX, posY, posX + totalWidth + 8, posY + 9 + 8, Integer.MIN_VALUE);
        }
        context.method_51433(client.field_1772, (String)displayText, posX + 4, posY + 4, -1, true);
        if (!displayHP.isEmpty()) {
            context.method_51433(client.field_1772, displayHP, posX + 4 + nameWidth + 10, posY + 4, -43691, true);
        }
    }

    private static void checkTabKey() {
        showOverlays = !KeyBindingUtility.isPlayerListKeyPressed();
    }

    private static void onChatMessage(class_2561 message, boolean overlay) {
        BossHPUtility instance = BossHPUtility.getInstance();
        String content = message.getString();
        if (!overlay) {
            if (content.contains("Ein Monster hat") && content.contains("Kakteen") && content.contains("Seelen geklaut")) {
                instance.handleBossLost();
            }
            if (content.toLowerCase().contains("zu lange au\u00dferhalb") && content.toLowerCase().contains("kampfzone")) {
                instance.handleBossLost();
            }
            if (content.toLowerCase().contains("die welle wurde nicht geschafft") && content.toLowerCase().contains("farmen deaktiviert") && content.toLowerCase().contains("aktiver ertrag")) {
                instance.handleWaveFailed();
            }
        }
    }

    public void handleBossLost() {
        String[] parts;
        this.bossLost = true;
        this.waitingForBossResult = false;
        if (this.currentBossText != null && (parts = this.currentBossText.split("\\|{5}")).length >= 2) {
            String hp;
            this.lastKnownHP = hp = parts[1].trim();
            this.lastKnownBossName = this.currentBossName;
            this.bossDisappearTimeWithoutReward = System.currentTimeMillis();
        }
        this.currentBossName = null;
        this.currentBossText = null;
    }

    public void handleWaveFailed() {
        String[] parts;
        this.bossLost = true;
        this.waitingForBossResult = false;
        if (this.currentBossText != null && (parts = this.currentBossText.split("\\|{5}")).length >= 2) {
            String hp;
            this.lastKnownHP = hp = parts[1].trim();
            this.lastKnownBossName = this.currentBossName;
            this.bossDisappearTimeWithoutReward = System.currentTimeMillis();
        }
        this.currentBossName = null;
        this.currentBossText = null;
    }

    public void handleBossDefeated() {
        this.bossDefeated = true;
        this.waitingForBossResult = false;
        this.hideOverlay();
    }

    public static boolean isBossActive() {
        BossHPUtility instance = BossHPUtility.getInstance();
        return instance != null && instance.currentBossName != null && instance.currentBossText != null && !instance.bossDefeated;
    }

    public static String getCurrentBossName() {
        BossHPUtility instance = BossHPUtility.getInstance();
        return instance != null ? instance.currentBossName : null;
    }

    public static String getCurrentBossText() {
        BossHPUtility instance = BossHPUtility.getInstance();
        return instance != null ? instance.currentBossText : null;
    }
}

