/*
 * Decompiled with CFR 0.152.
 */
package net.felix.utilities;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.fabricmc.fabric.api.client.message.v1.ClientReceiveMessageEvents;
import net.fabricmc.fabric.api.client.rendering.v1.HudRenderCallback;
import net.felix.CCLiveUtilitiesConfig;
import net.felix.OverlayType;
import net.felix.utilities.EquipmentDisplayUtility;
import net.felix.utilities.KeyBindingUtility;
import net.minecraft.class_10799;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3675;
import net.minecraft.class_5250;
import net.minecraft.class_9779;
import org.joml.Matrix3x2fStack;

public class CardsStatuesUtility {
    private static boolean isInitialized = false;
    private static boolean showOverlays = true;
    private static CardsStatuesUtility INSTANCE;
    private static class_304 toggleKeyBinding;
    private static CardData currentCard;
    private static StatueData currentStatue;
    private static class_2960 lastDimension;
    private static final int BACKGROUND_WIDTH = 162;
    private static final int BACKGROUND_HEIGHT = 62;
    private static final class_2960 CARD_BACKGROUND_TEXTURE;
    private static final class_2960 STATUE_BACKGROUND_TEXTURE;

    private static void renderCardBackground(class_332 context, int x, int y) {
        try {
            Matrix3x2fStack matrices = context.method_51448();
            matrices.pushMatrix();
            float scale = ((CCLiveUtilitiesConfig)CCLiveUtilitiesConfig.HANDLER.instance()).cardOverlayScale;
            if (scale <= 0.0f) {
                scale = 1.0f;
            }
            matrices.translate((float)x, (float)y);
            matrices.scale(scale, scale);
            context.method_25290(class_10799.field_56883, CARD_BACKGROUND_TEXTURE, -11, -11, 0.0f, 0.0f, 162, 62, 162, 62);
            matrices.popMatrix();
        }
        catch (Exception e) {
            context.method_25294(x - 11, y - 11, x + 162 - 11, y + 62 - 11, Integer.MIN_VALUE);
        }
    }

    private static void renderStatueBackground(class_332 context, int x, int y) {
        try {
            Matrix3x2fStack matrices = context.method_51448();
            matrices.pushMatrix();
            float scale = ((CCLiveUtilitiesConfig)CCLiveUtilitiesConfig.HANDLER.instance()).statueOverlayScale;
            if (scale <= 0.0f) {
                scale = 1.0f;
            }
            matrices.translate((float)x, (float)y);
            matrices.scale(scale, scale);
            context.method_25290(class_10799.field_56883, STATUE_BACKGROUND_TEXTURE, -11, -11, 0.0f, 0.0f, 162, 62, 162, 62);
            matrices.popMatrix();
        }
        catch (Exception e) {
            context.method_25294(x - 11, y - 11, x + 162 - 11, y + 62 - 11, Integer.MIN_VALUE);
        }
    }

    public CardsStatuesUtility() {
        INSTANCE = this;
    }

    public static CardsStatuesUtility getInstance() {
        if (INSTANCE == null) {
            throw new IllegalStateException("CardsStatuesUtility instance is null!");
        }
        return INSTANCE;
    }

    public static void initialize() {
        if (isInitialized) {
            return;
        }
        try {
            new CardsStatuesUtility();
            CardsStatuesUtility.registerHotkey();
            CardsStatuesUtility.registerCommands();
            ClientTickEvents.END_CLIENT_TICK.register(CardsStatuesUtility::onClientTick);
            HudRenderCallback.EVENT.register((drawContext, tickDelta) -> CardsStatuesUtility.onHudRender(drawContext, tickDelta));
            ClientReceiveMessageEvents.GAME.register(CardsStatuesUtility::onChatMessage);
            isInitialized = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void registerHotkey() {
        toggleKeyBinding = KeyBindingHelper.registerKeyBinding((class_304)new class_304("key.cclive-utilities.cards-toggle", class_3675.class_307.field_1668, class_3675.field_16237.method_1444(), "category.cclive-utilities.cards"));
    }

    private static void registerCommands() {
        ClientCommandRegistrationCallback.EVENT.register((dispatcher, registryAccess) -> dispatcher.register((LiteralArgumentBuilder)ClientCommandManager.literal((String)"cards-statues").then(ClientCommandManager.literal((String)"show").executes(context -> {
            showOverlays = true;
            ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"\u00a7aKarten und Statuen Overlay eingeblendet!"));
            return 1;
        }))));
    }

    private static void onClientTick(class_310 client) {
        CardsStatuesUtility.checkTabKey();
        CardsStatuesUtility.handleHotkey();
        if (!((CCLiveUtilitiesConfig)CCLiveUtilitiesConfig.HANDLER.instance()).enableMod || !((CCLiveUtilitiesConfig)CCLiveUtilitiesConfig.HANDLER.instance()).cardsStatuesEnabled) {
            return;
        }
        if (client.field_1724 == null || client.field_1687 == null) {
            return;
        }
        class_2960 currentDimension = client.field_1687.method_27983().method_29177();
        if (lastDimension != null && !lastDimension.equals((Object)currentDimension)) {
            CardsStatuesUtility.clear();
        }
        lastDimension = currentDimension;
    }

    private static void checkTabKey() {
        showOverlays = !KeyBindingUtility.isPlayerListKeyPressed();
    }

    private static void handleHotkey() {
        if (toggleKeyBinding != null && toggleKeyBinding.method_1436()) {
            boolean currentShow = ((CCLiveUtilitiesConfig)CCLiveUtilitiesConfig.HANDLER.instance()).showCard || ((CCLiveUtilitiesConfig)CCLiveUtilitiesConfig.HANDLER.instance()).showStatue;
            ((CCLiveUtilitiesConfig)CCLiveUtilitiesConfig.HANDLER.instance()).showCard = !currentShow;
            ((CCLiveUtilitiesConfig)CCLiveUtilitiesConfig.HANDLER.instance()).showStatue = !currentShow;
            CCLiveUtilitiesConfig.HANDLER.save();
        }
    }

    private static void onChatMessage(class_2561 message, boolean overlay) {
        if (!((CCLiveUtilitiesConfig)CCLiveUtilitiesConfig.HANDLER.instance()).enableMod || !((CCLiveUtilitiesConfig)CCLiveUtilitiesConfig.HANDLER.instance()).cardsStatuesEnabled) {
            return;
        }
        class_310 client = class_310.method_1551();
        if (client == null || client.field_1687 == null) {
            return;
        }
        class_2960 currentDimension = client.field_1687.method_27983().method_29177();
        String dimensionPath = currentDimension.method_12832();
        if (!dimensionPath.matches(".*floor_\\d+.*")) {
            return;
        }
        String content = message.getString();
        class_2568 hoverEvent = message.method_10866().method_10969();
        String hoverContent = content;
        if (hoverEvent != null && hoverEvent.method_10892() == class_2568.class_5247.field_24342) {
            try {
                String hoverString = hoverEvent.toString();
                hoverContent = CardsStatuesUtility.parseHoverEventData(hoverString);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (content.contains("[") && content.contains("]") && content.contains("Karte") || content.contains("[Karte]")) {
            CardsStatuesUtility.handleCardMessage(message, hoverContent);
        } else if (content.contains("[") && content.contains("]") && content.contains("Statue") || content.contains("[Statue]")) {
            CardsStatuesUtility.handleStatueMessage(message, hoverContent);
        }
    }

    private static String parseHoverEventData(String hoverString) {
        int start;
        int end;
        StringBuilder result = new StringBuilder();
        if (hoverString.contains("value=literal{") && (end = hoverString.indexOf("}", start = hoverString.indexOf("value=literal{") + 14)) > start) {
            String mainName = hoverString.substring(start, end);
            result.append(mainName).append("\n");
        }
        if (hoverString.contains("siblings=[")) {
            String[] parts;
            String siblingsPart = hoverString.substring(hoverString.indexOf("siblings=["));
            for (String part : parts = siblingsPart.split("literal\\{")) {
                String text;
                int end2;
                if (!part.contains("}") || (end2 = part.indexOf("}")) <= 0 || (text = part.substring(0, end2)).trim().isEmpty()) continue;
                result.append(text).append("\n");
            }
        }
        String finalResult = result.toString().trim();
        return finalResult;
    }

    private static void handleCardMessage(class_2561 message, String hoverContent) {
        CardData cardData = new CardData();
        cardData.setColor(CardsStatuesUtility.getColorFromStyle(message.method_10866()));
        ArrayList<String> hoverLines = new ArrayList<String>();
        String[] lines = hoverContent.split("\n");
        for (String line : lines) {
            String trimmed = line.trim();
            if (trimmed.isEmpty()) continue;
            hoverLines.add(trimmed);
        }
        cardData.setHoverLines(hoverLines);
        if (!hoverLines.isEmpty()) {
            cardData.setName((String)hoverLines.get(0));
        }
        for (String line : hoverLines) {
            if (line.contains("Stufe:") && !line.contains("N\u00e4chste")) {
                String level = line.replaceAll("[^0-9]", "").trim();
                if (level.isEmpty()) continue;
                cardData.setLevel(level);
                continue;
            }
            if (line.contains("N\u00e4chste Stufe:")) {
                String nextLevel = line.replaceAll("[^0-9]", "").trim();
                if (nextLevel.isEmpty()) continue;
                cardData.setNextLevel(nextLevel);
                continue;
            }
            if (!line.startsWith("+") || line.contains("Stufe")) continue;
            cardData.setEffect(line);
        }
        currentCard = cardData;
    }

    private static void handleStatueMessage(class_2561 message, String hoverContent) {
        StatueData statueData = new StatueData();
        statueData.setColor(CardsStatuesUtility.getColorFromStyle(message.method_10866()));
        ArrayList<String> hoverLines = new ArrayList<String>();
        String[] lines = hoverContent.split("\n");
        for (String line : lines) {
            String trimmed = line.trim();
            if (trimmed.isEmpty()) continue;
            hoverLines.add(trimmed);
        }
        statueData.setHoverLines(hoverLines);
        if (!hoverLines.isEmpty()) {
            statueData.setName((String)hoverLines.get(0));
        }
        for (String line : hoverLines) {
            if (line.contains("Stufe:") && !line.contains("N\u00e4chste")) {
                String level = line.replaceAll("[^0-9]", "").trim();
                if (level.isEmpty()) continue;
                statueData.setLevel(level);
                continue;
            }
            if (line.contains("N\u00e4chste Stufe:")) {
                String nextLevel = line.replaceAll("[^0-9]", "").trim();
                if (nextLevel.isEmpty()) continue;
                statueData.setNextLevel(nextLevel);
                continue;
            }
            if (!line.startsWith("+") || line.contains("Stufe")) continue;
            statueData.setEffect(line);
        }
        currentStatue = statueData;
    }

    private static String getColorFromStyle(class_2583 style) {
        if (style.method_10973() != null) {
            return style.method_10973().method_27721();
        }
        return class_124.field_1068.method_537();
    }

    private static void onHudRender(class_332 context, class_9779 tickCounter) {
        CCLiveUtilitiesConfig config = (CCLiveUtilitiesConfig)CCLiveUtilitiesConfig.HANDLER.instance();
        if (!config.cardsStatuesEnabled) {
            return;
        }
        class_310 client = class_310.method_1551();
        if (client.field_1687 == null || client.field_1724 == null) {
            return;
        }
        if (!config.showCard && !config.showStatue) {
            return;
        }
        String dimension = client.field_1687.method_27983().method_29177().toString();
        if (!dimension.contains("floor_")) {
            return;
        }
        int screenWidth = client.method_22683().method_4486();
        int screenHeight = client.method_22683().method_4502();
        int cardX = screenWidth - config.cardX;
        int cardY = screenHeight - config.cardY;
        int statueX = screenWidth - config.statueX;
        int statueY = screenHeight - config.statueY;
        if (showOverlays && !EquipmentDisplayUtility.isEquipmentOverlayActive()) {
            if (config.cardEnabled && config.showCard && currentCard != null) {
                CardsStatuesUtility.renderCardInfo(context, currentCard, cardX, cardY);
            }
            if (config.statueEnabled && config.showStatue && currentStatue != null) {
                CardsStatuesUtility.renderStatueInfo(context, currentStatue, statueX, statueY);
            }
        }
    }

    private static void renderCardInfo(class_332 context, CardData card, int x, int y) {
        OverlayType cardOverlayType = ((CCLiveUtilitiesConfig)CCLiveUtilitiesConfig.HANDLER.instance()).cardOverlayType;
        if (cardOverlayType == OverlayType.CUSTOM || cardOverlayType == OverlayType.BLACK) {
            CardsStatuesUtility.renderCardBackground(context, x, y);
        }
        Matrix3x2fStack matrices = context.method_51448();
        matrices.pushMatrix();
        float scale = ((CCLiveUtilitiesConfig)CCLiveUtilitiesConfig.HANDLER.instance()).cardOverlayScale;
        if (scale <= 0.0f) {
            scale = 1.0f;
        }
        matrices.translate((float)x, (float)y);
        matrices.scale(scale, scale);
        int lineCount = 0;
        for (int i = 0; i < card.getHoverLines().size(); ++i) {
            String line = card.getHoverLines().get(i);
            if (line.contains("Statistik") || line.trim().isEmpty() || line.matches(".*[\u353b\u3535\u3536\u3537\u3538\u3539\u353a\u353b\u353c\u353d\u353e\u353f\u3540\u3541\u3542\u3543\u3544\u3545\u3546\u3547\u3548\u3549\u354a\u354b\u354c\u354d\u354e\u354f\u3550\u3551\u3552\u3553\u3554\u3555\u3556\u3557\u3558\u3559\u355a\u355b\u355c\u355d\u355e\u355f\u3560\u3561\u3562\u3563\u3564\u3565\u3566\u3567\u3568\u3569\u356a\u356b\u356c\u356d\u356e\u356f\u3570\u3571\u2572\u2573\u2574\u2575\u2576\u2577\u2578\u2579\u257a\u257b\u257c\u257d\u257e\u257f].*") || i < card.getHoverLines().size() - 1 && card.getHoverLines().get(i + 1).contains("Statistik")) continue;
            int textY = -1 + lineCount * 12;
            class_5250 textComponent = class_2561.method_43470((String)line);
            context.method_51439(class_310.method_1551().field_1772, (class_2561)textComponent, 1, textY, -1, true);
            ++lineCount;
        }
        matrices.popMatrix();
    }

    private static void renderStatueInfo(class_332 context, StatueData statue, int x, int y) {
        OverlayType statueOverlayType = ((CCLiveUtilitiesConfig)CCLiveUtilitiesConfig.HANDLER.instance()).statueOverlayType;
        if (statueOverlayType == OverlayType.CUSTOM || statueOverlayType == OverlayType.BLACK) {
            CardsStatuesUtility.renderStatueBackground(context, x, y);
        }
        Matrix3x2fStack matrices = context.method_51448();
        matrices.pushMatrix();
        float scale = ((CCLiveUtilitiesConfig)CCLiveUtilitiesConfig.HANDLER.instance()).statueOverlayScale;
        if (scale <= 0.0f) {
            scale = 1.0f;
        }
        matrices.translate((float)x, (float)y);
        matrices.scale(scale, scale);
        int lineCount = 0;
        for (int i = 0; i < statue.getHoverLines().size(); ++i) {
            String line = statue.getHoverLines().get(i);
            if (line.contains("Statistik") || line.trim().isEmpty() || line.matches(".*[\u353b\u3535\u3536\u3537\u3538\u3539\u353a\u353b\u353c\u353d\u353e\u353f\u3540\u3541\u3542\u3543\u3544\u3545\u3546\u3547\u3548\u3549\u354a\u354b\u354c\u354d\u354e\u354f\u3550\u3551\u3552\u3553\u3554\u3555\u3556\u3557\u3558\u3559\u355a\u355b\u355c\u355d\u355e\u355f\u3560\u3561\u3562\u3563\u3564\u3565\u3566\u3567\u3568\u3569\u356a\u356b\u356c\u356d\u356e\u356f\u3570\u3571\u3572\u3573\u3574\u3575\u3576\u3577\u3578\u3579\u357a\u357b\u357c\u357d\u357e\u357f].*") || i < statue.getHoverLines().size() - 1 && statue.getHoverLines().get(i + 1).contains("Statistik")) continue;
            int textY = -1 + lineCount * 12;
            class_5250 textComponent = class_2561.method_43470((String)line);
            context.method_51439(class_310.method_1551().field_1772, (class_2561)textComponent, 1, textY, -1, true);
            ++lineCount;
        }
        matrices.popMatrix();
    }

    public static void clear() {
        currentCard = null;
        currentStatue = null;
    }

    static {
        currentCard = null;
        currentStatue = null;
        lastDimension = null;
        CARD_BACKGROUND_TEXTURE = class_2960.method_60655((String)"cclive-utilities", (String)"textures/gui/karten_background.png");
        STATUE_BACKGROUND_TEXTURE = class_2960.method_60655((String)"cclive-utilities", (String)"textures/gui/statuen_background.png");
    }

    public static class CardData {
        private String name;
        private String level;
        private String nextLevel;
        private String effect;
        private String color;
        private List<String> hoverLines = new ArrayList<String>();

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getLevel() {
            return this.level;
        }

        public void setLevel(String level) {
            this.level = level;
        }

        public String getNextLevel() {
            return this.nextLevel;
        }

        public void setNextLevel(String nextLevel) {
            this.nextLevel = nextLevel;
        }

        public String getEffect() {
            return this.effect;
        }

        public void setEffect(String effect) {
            this.effect = effect;
        }

        public String getColor() {
            return this.color;
        }

        public void setColor(String color) {
            this.color = color;
        }

        public List<String> getHoverLines() {
            return this.hoverLines;
        }

        public void setHoverLines(List<String> hoverLines) {
            this.hoverLines = hoverLines;
        }
    }

    public static class StatueData {
        private String name;
        private String level;
        private String nextLevel;
        private String effect;
        private String color;
        private List<String> hoverLines = new ArrayList<String>();

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getLevel() {
            return this.level;
        }

        public void setLevel(String level) {
            this.level = level;
        }

        public String getNextLevel() {
            return this.nextLevel;
        }

        public void setNextLevel(String nextLevel) {
            this.nextLevel = nextLevel;
        }

        public String getEffect() {
            return this.effect;
        }

        public void setEffect(String effect) {
            this.effect = effect;
        }

        public String getColor() {
            return this.color;
        }

        public void setColor(String color) {
            this.color = color;
        }

        public List<String> getHoverLines() {
            return this.hoverLines;
        }

        public void setHoverLines(List<String> hoverLines) {
            this.hoverLines = hoverLines;
        }
    }
}

