/*
 * Decompiled with CFR 0.152.
 */
package net.felix.utilities.DragOverlay;

import java.util.Objects;
import net.felix.CCLiveUtilitiesConfig;
import net.felix.utilities.BossHPUtility;
import net.felix.utilities.DragOverlay.DraggableOverlay;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;

public class BossHPDraggableOverlay
implements DraggableOverlay {
    private static final int PADDING = 4;

    @Override
    public String getOverlayName() {
        return "";
    }

    @Override
    public int getX() {
        int rightEdge = ((CCLiveUtilitiesConfig)CCLiveUtilitiesConfig.HANDLER.instance()).bossHPX;
        int width = this.getWidth();
        return rightEdge - width;
    }

    @Override
    public int getY() {
        return ((CCLiveUtilitiesConfig)CCLiveUtilitiesConfig.HANDLER.instance()).bossHPY;
    }

    @Override
    public int getWidth() {
        String[] parts;
        String bossText;
        class_310 client = class_310.method_1551();
        if (client == null) {
            return 200;
        }
        BossData bossData = this.getCurrentBossData();
        if (bossData != null && (bossText = bossData.getBossText()) != null && !bossText.isEmpty() && (parts = bossText.split("\\|{5}")).length >= 2) {
            String displayText = parts[0].trim();
            String displayHP = parts[1].trim();
            int nameWidth = client.field_1772.method_1727(displayText);
            int hpWidth = displayHP.isEmpty() ? 0 : client.field_1772.method_1727(displayHP);
            int totalWidth = nameWidth + (displayHP.isEmpty() ? 0 : 10 + hpWidth);
            return totalWidth + 8;
        }
        return 50;
    }

    @Override
    public int getHeight() {
        class_310 client = class_310.method_1551();
        if (client == null) {
            return 20;
        }
        Objects.requireNonNull(client.field_1772);
        return 9 + 8;
    }

    @Override
    public void setPosition(int x, int y) {
        int width = this.getWidth();
        ((CCLiveUtilitiesConfig)CCLiveUtilitiesConfig.HANDLER.instance()).bossHPX = x + width;
        ((CCLiveUtilitiesConfig)CCLiveUtilitiesConfig.HANDLER.instance()).bossHPY = y;
    }

    @Override
    public void renderInEditMode(class_332 context, int mouseX, int mouseY, float delta) {
        int x = this.getX();
        int y = this.getY();
        int width = this.getWidth();
        int height = this.getHeight();
        context.method_25294(x, y, x + width, y + height, Integer.MIN_VALUE);
        context.method_49601(x, y, width, height, -65536);
        int rightEdgeX = x + width;
        this.renderBossData(context, rightEdgeX, y);
    }

    @Override
    public void savePosition() {
    }

    @Override
    public boolean isEnabled() {
        return ((CCLiveUtilitiesConfig)CCLiveUtilitiesConfig.HANDLER.instance()).bossHPEnabled && ((CCLiveUtilitiesConfig)CCLiveUtilitiesConfig.HANDLER.instance()).showBossHP;
    }

    @Override
    public class_2561 getTooltip() {
        return class_2561.method_43470((String)"Boss HP - Shows boss health information");
    }

    @Override
    public void resetToDefault() {
        ((CCLiveUtilitiesConfig)CCLiveUtilitiesConfig.HANDLER.instance()).bossHPX = 562;
        ((CCLiveUtilitiesConfig)CCLiveUtilitiesConfig.HANDLER.instance()).bossHPY = 201;
    }

    private void renderBossData(class_332 context, int x, int y) {
        class_310 client = class_310.method_1551();
        if (client == null) {
            return;
        }
        BossData bossData = this.getCurrentBossData();
        if (bossData != null && bossData.getName() != null) {
            String[] parts;
            String bossText = bossData.getBossText();
            String displayText = null;
            String displayHP = null;
            if (bossText != null && !bossText.isEmpty() && (parts = bossText.split("\\|{5}")).length >= 2) {
                displayText = parts[0].trim();
                displayHP = parts[1].trim();
            }
            if (displayText != null) {
                int nameWidth = client.field_1772.method_1727(displayText);
                int hpWidth = displayHP.isEmpty() ? 0 : client.field_1772.method_1727(displayHP);
                int totalWidth = nameWidth + (displayHP.isEmpty() ? 0 : 10 + hpWidth);
                int renderX = x - totalWidth - 8;
                context.method_51433(client.field_1772, displayText, renderX + 4, y + 4, -1, true);
                if (!displayHP.isEmpty()) {
                    context.method_51433(client.field_1772, displayHP, renderX + 4 + nameWidth + 10, y + 4, -43691, true);
                }
            }
        }
    }

    private BossData getCurrentBossData() {
        try {
            String[] parts;
            String bossName = BossHPUtility.getCurrentBossName();
            String bossText = BossHPUtility.getCurrentBossText();
            if (bossName != null && bossText != null && !bossName.isEmpty() && !bossText.isEmpty() && (parts = bossText.split("\\|{5}")).length >= 2) {
                String hp = parts[1].trim();
                return new BossData(bossName, hp, bossText);
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    private static class BossData {
        private final String name;
        private final String hp;
        private final String bossText;

        public BossData(String name, String hp, String bossText) {
            this.name = name;
            this.hp = hp;
            this.bossText = bossText;
        }

        public String getName() {
            return this.name;
        }

        public String getHP() {
            return this.hp;
        }

        public String getBossText() {
            return this.bossText;
        }
    }
}

