/*
 * Decompiled with CFR 0.152.
 */
package net.felix.utilities.DragOverlay;

import java.lang.reflect.Field;
import net.felix.CCLiveUtilitiesConfig;
import net.felix.OverlayType;
import net.felix.utilities.CardsStatuesUtility;
import net.felix.utilities.DragOverlay.DraggableOverlay;
import net.minecraft.class_10799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;

public class StatuesDraggableOverlay
implements DraggableOverlay {
    private static final int DEFAULT_WIDTH = 162;
    private static final int DEFAULT_HEIGHT = 62;
    private static final class_2960 STATUES_BACKGROUND_TEXTURE = class_2960.method_60655((String)"cclive-utilities", (String)"textures/gui/statuen_background.png");

    @Override
    public String getOverlayName() {
        return "Statues";
    }

    @Override
    public int getX() {
        class_310 client = class_310.method_1551();
        if (client.method_22683() == null) {
            return 0;
        }
        int screenWidth = client.method_22683().method_4486();
        int xOffset = ((CCLiveUtilitiesConfig)CCLiveUtilitiesConfig.HANDLER.instance()).statueX;
        return screenWidth - xOffset - 11;
    }

    @Override
    public int getY() {
        class_310 client = class_310.method_1551();
        if (client.method_22683() == null) {
            return 0;
        }
        int screenHeight = client.method_22683().method_4502();
        int yOffset = ((CCLiveUtilitiesConfig)CCLiveUtilitiesConfig.HANDLER.instance()).statueY;
        return screenHeight - yOffset - 11;
    }

    @Override
    public int getWidth() {
        return 162;
    }

    @Override
    public int getHeight() {
        return 62;
    }

    @Override
    public void setPosition(int x, int y) {
        class_310 client = class_310.method_1551();
        if (client.method_22683() == null) {
            return;
        }
        int screenWidth = client.method_22683().method_4486();
        int screenHeight = client.method_22683().method_4502();
        int xOffset = screenWidth - x - 11;
        int yOffset = screenHeight - y - 11;
        ((CCLiveUtilitiesConfig)CCLiveUtilitiesConfig.HANDLER.instance()).statueX = xOffset;
        ((CCLiveUtilitiesConfig)CCLiveUtilitiesConfig.HANDLER.instance()).statueY = yOffset;
    }

    @Override
    public void renderInEditMode(class_332 context, int mouseX, int mouseY, float delta) {
        int x = this.getX();
        int y = this.getY();
        int width = this.getWidth();
        int height = this.getHeight();
        OverlayType overlayType = ((CCLiveUtilitiesConfig)CCLiveUtilitiesConfig.HANDLER.instance()).statueOverlayType;
        if (overlayType == OverlayType.CUSTOM) {
            try {
                context.method_25290(class_10799.field_56883, STATUES_BACKGROUND_TEXTURE, x, y, 0.0f, 0.0f, width, height, width, height);
            }
            catch (Exception e) {
                context.method_25294(x, y, x + width, y + height, Integer.MIN_VALUE);
            }
        } else if (overlayType == OverlayType.BLACK) {
            context.method_25294(x, y, x + width, y + height, Integer.MIN_VALUE);
        }
        context.method_49601(x, y, width, height, -65536);
        context.method_51433(class_310.method_1551().field_1772, this.getOverlayName(), x + 5, y + 5, -1, true);
        this.renderStatueData(context, x, y);
    }

    @Override
    public void savePosition() {
    }

    @Override
    public boolean isEnabled() {
        return ((CCLiveUtilitiesConfig)CCLiveUtilitiesConfig.HANDLER.instance()).cardsStatuesEnabled && ((CCLiveUtilitiesConfig)CCLiveUtilitiesConfig.HANDLER.instance()).statueEnabled && ((CCLiveUtilitiesConfig)CCLiveUtilitiesConfig.HANDLER.instance()).showStatue;
    }

    @Override
    public class_2561 getTooltip() {
        return class_2561.method_43470((String)"Statues - Shows statue information and levels");
    }

    @Override
    public void resetToDefault() {
        ((CCLiveUtilitiesConfig)CCLiveUtilitiesConfig.HANDLER.instance()).statueX = 151;
        ((CCLiveUtilitiesConfig)CCLiveUtilitiesConfig.HANDLER.instance()).statueY = 60;
    }

    private void renderStatueData(class_332 context, int x, int y) {
        class_310 client = class_310.method_1551();
        if (client == null) {
            return;
        }
        try {
            CardsStatuesUtility.StatueData currentStatue = this.getCurrentStatueData();
            if (currentStatue != null && currentStatue.getName() != null) {
                Object statueName = currentStatue.getName();
                if (((String)statueName).length() > 25) {
                    statueName = ((String)statueName).substring(0, 22) + "...";
                }
                context.method_51433(client.field_1772, (String)statueName, x + 8, y + 20, -1, true);
                if (currentStatue.getLevel() != null) {
                    context.method_51433(client.field_1772, "Stufe: " + currentStatue.getLevel(), x + 8, y + 32, -1, true);
                }
                if (currentStatue.getEffect() != null) {
                    Object effect = currentStatue.getEffect();
                    if (((String)effect).length() > 25) {
                        effect = ((String)effect).substring(0, 22) + "...";
                    }
                    context.method_51433(client.field_1772, (String)effect, x + 8, y + 44, -16711936, true);
                }
                return;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        context.method_51433(client.field_1772, "Krieger Statue", x + 8, y + 20, -1, true);
        context.method_51433(client.field_1772, "Stufe: 3", x + 8, y + 32, -1, true);
        context.method_51433(client.field_1772, "+15% Verteidigung", x + 8, y + 44, -16711936, true);
    }

    private CardsStatuesUtility.StatueData getCurrentStatueData() {
        try {
            Field field = CardsStatuesUtility.class.getDeclaredField("currentStatue");
            field.setAccessible(true);
            return (CardsStatuesUtility.StatueData)field.get(null);
        }
        catch (Exception e) {
            return null;
        }
    }
}

