/*
 * Decompiled with CFR 0.152.
 */
package net.felix.utilities;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.fabricmc.fabric.api.client.rendering.v1.HudRenderCallback;
import net.felix.CCLiveUtilitiesConfig;
import net.felix.utilities.EquipmentDisplayUtility;
import net.felix.utilities.KeyBindingUtility;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3675;
import net.minecraft.class_9779;

public class KillsUtility {
    private static boolean isInitialized = false;
    private static boolean isTrackingKills = false;
    private static boolean showOverlays = true;
    private static class_304 toggleKeyBinding;
    private static class_304 resetKeyBinding;
    private static int initialKills;
    private static int currentKills;
    private static int newKills;
    private static String currentDimension;
    private static boolean firstBossBarUpdate;
    private static long sessionStartTime;
    private static double currentKPM;
    private static long lastKillTime;
    private static final Queue<Long> killTimes;
    private static final int KPM_WINDOW = 60000;
    private static final Map<Character, Integer> CHINESE_NUMBERS;
    private static final int MIN_OVERLAY_WIDTH = 65;
    private static final int MIN_OVERLAY_HEIGHT = 60;
    private static final int LINE_HEIGHT = 12;
    private static final int PADDING = 5;
    private static Boolean cachedIsOnFloor;

    public static void initialize() {
        if (isInitialized) {
            return;
        }
        try {
            KillsUtility.registerHotkeys();
            ClientTickEvents.END_CLIENT_TICK.register(KillsUtility::onClientTick);
            HudRenderCallback.EVENT.register((drawContext, tickDelta) -> KillsUtility.onHudRender(drawContext, tickDelta));
            isInitialized = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void registerHotkeys() {
        toggleKeyBinding = KeyBindingHelper.registerKeyBinding((class_304)new class_304("key.cclive-utilities.kills-toggle", class_3675.class_307.field_1668, 75, "category.cclive-utilities.kills"));
        resetKeyBinding = KeyBindingHelper.registerKeyBinding((class_304)new class_304("key.cclive-utilities.kills-reset", class_3675.class_307.field_1668, 82, "category.cclive-utilities.kills"));
    }

    private static void onClientTick(class_310 client) {
        KillsUtility.handleHotkeys();
        KillsUtility.checkTabKey();
        if (!(((CCLiveUtilitiesConfig)CCLiveUtilitiesConfig.HANDLER.instance()).enableMod && ((CCLiveUtilitiesConfig)CCLiveUtilitiesConfig.HANDLER.instance()).killsUtilityEnabled && ((CCLiveUtilitiesConfig)CCLiveUtilitiesConfig.HANDLER.instance()).showKillsUtility)) {
            return;
        }
        if (client.field_1724 == null || client.field_1687 == null) {
            isTrackingKills = false;
            return;
        }
        KillsUtility.checkDimensionChange(client);
        boolean shouldTrack = KillsUtility.isOnFloor();
        if (shouldTrack != isTrackingKills) {
            isTrackingKills = shouldTrack;
            if (shouldTrack) {
                initialKills = -1;
                currentKills = 0;
                newKills = 0;
                firstBossBarUpdate = true;
                sessionStartTime = System.currentTimeMillis();
                cachedIsOnFloor = null;
            }
        }
        if (isTrackingKills) {
            KillsUtility.readKillsFromBossbar(client);
        }
        KillsUtility.updateKPM();
    }

    private static void checkTabKey() {
        showOverlays = !KeyBindingUtility.isPlayerListKeyPressed();
    }

    private static void handleHotkeys() {
        if (toggleKeyBinding != null && toggleKeyBinding.method_1436()) {
            boolean currentShow = ((CCLiveUtilitiesConfig)CCLiveUtilitiesConfig.HANDLER.instance()).showKillsUtility;
            ((CCLiveUtilitiesConfig)CCLiveUtilitiesConfig.HANDLER.instance()).showKillsUtility = !currentShow;
            CCLiveUtilitiesConfig.HANDLER.save();
        }
        if (resetKeyBinding != null && resetKeyBinding.method_1436()) {
            KillsUtility.reset();
        }
    }

    private static void checkDimensionChange(class_310 client) {
        try {
            if (client.field_1687 != null && client.field_1724 != null) {
                String newDimension = client.field_1687.method_27983().method_29177().toString();
                if (currentDimension != null && !currentDimension.equals(newDimension)) {
                    KillsUtility.reset();
                }
                if (currentDimension == null || !currentDimension.equals(newDimension)) {
                    cachedIsOnFloor = null;
                }
                currentDimension = newDimension;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void reset() {
        initialKills = -1;
        currentKills = 0;
        newKills = 0;
        firstBossBarUpdate = true;
        currentKPM = 0.0;
        sessionStartTime = System.currentTimeMillis();
        currentDimension = null;
        cachedIsOnFloor = null;
    }

    private static void readKillsFromBossbar(class_310 client) {
        try {
            if (isTrackingKills && initialKills == -1) {
                initialKills = 0;
                currentKills = 0;
                newKills = 0;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static int decodeChineseNumber(String text) {
        try {
            StringBuilder numberStr = new StringBuilder();
            for (char c : text.toCharArray()) {
                Integer digit = CHINESE_NUMBERS.get(Character.valueOf(c));
                if (digit == null) continue;
                numberStr.append(digit);
            }
            if (numberStr.length() > 0) {
                return Integer.parseInt(numberStr.toString());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return -1;
    }

    private static void updateKPM() {
        if (sessionStartTime == 0L || newKills == 0) {
            currentKPM = 0.0;
            return;
        }
        long currentTime = System.currentTimeMillis();
        long sessionDuration = currentTime - sessionStartTime;
        if (sessionDuration > 0L) {
            double minutesElapsed = (double)sessionDuration / 60000.0;
            currentKPM = (double)newKills / minutesElapsed;
        }
    }

    private static void onHudRender(class_332 context, class_9779 tickCounter) {
        if (!((CCLiveUtilitiesConfig)CCLiveUtilitiesConfig.HANDLER.instance()).enableMod) {
            return;
        }
        if (!((CCLiveUtilitiesConfig)CCLiveUtilitiesConfig.HANDLER.instance()).killsUtilityEnabled) {
            return;
        }
        if (!((CCLiveUtilitiesConfig)CCLiveUtilitiesConfig.HANDLER.instance()).showKillsUtility) {
            return;
        }
        if (!isTrackingKills) {
            return;
        }
        class_310 client = class_310.method_1551();
        if (client.field_1724 == null) {
            return;
        }
        if (showOverlays && !EquipmentDisplayUtility.isEquipmentOverlayActive()) {
            KillsUtility.renderKillsDisplay(context, client);
        }
    }

    private static void renderKillsDisplay(class_332 context, class_310 client) {
        if (client.method_22683() == null) {
            return;
        }
        int screenWidth = client.method_22683().method_4486();
        int screenHeight = client.method_22683().method_4502();
        int xOffset = ((CCLiveUtilitiesConfig)CCLiveUtilitiesConfig.HANDLER.instance()).killsUtilityX;
        int yOffset = ((CCLiveUtilitiesConfig)CCLiveUtilitiesConfig.HANDLER.instance()).killsUtilityY;
        String title = "Kills/min";
        String kpmText = String.format("KPM: %.1f", currentKPM);
        String newKillsText = String.format("Kills: %d", newKills);
        String timeText = "";
        if (sessionStartTime > 0L || isTrackingKills) {
            long sessionDuration = sessionStartTime > 0L ? System.currentTimeMillis() - sessionStartTime : 0L;
            long minutes = sessionDuration / 60000L;
            long seconds = sessionDuration % 60000L / 1000L;
            timeText = String.format("Zeit: %02d:%02d", minutes, seconds);
        }
        int titleWidth = client.field_1772.method_1727(title);
        int kpmWidth = client.field_1772.method_1727(kpmText);
        int newKillsWidth = client.field_1772.method_1727(newKillsText);
        int timeWidth = timeText.isEmpty() ? 0 : client.field_1772.method_1727(timeText);
        int maxTextWidth = Math.max(Math.max(titleWidth, kpmWidth), Math.max(newKillsWidth, timeWidth));
        int overlayWidth = Math.max(65, maxTextWidth + 10);
        int overlayHeight = 48;
        if (!timeText.isEmpty()) {
            overlayHeight += 12;
        }
        int xPosition = screenWidth - overlayWidth - xOffset;
        int yPosition = yOffset;
        if (((CCLiveUtilitiesConfig)CCLiveUtilitiesConfig.HANDLER.instance()).killsUtilityShowBackground) {
            context.method_25294(xPosition, yPosition, xPosition + overlayWidth, yPosition + overlayHeight, Integer.MIN_VALUE);
        }
        int titleColor = ((CCLiveUtilitiesConfig)CCLiveUtilitiesConfig.HANDLER.instance()).killsUtilityHeaderColor.getRGB();
        context.method_51433(client.field_1772, title, xPosition + 5, yPosition + 5, titleColor, true);
        int currentY = yPosition + 5 + 15;
        int textColor = ((CCLiveUtilitiesConfig)CCLiveUtilitiesConfig.HANDLER.instance()).killsUtilityTextColor.getRGB();
        context.method_51433(client.field_1772, kpmText, xPosition + 5, currentY, textColor, true);
        context.method_51433(client.field_1772, newKillsText, xPosition + 5, currentY += 12, textColor, true);
        if (!timeText.isEmpty()) {
            context.method_51433(client.field_1772, timeText, xPosition + 5, currentY += 12, textColor, true);
        }
    }

    private static boolean isOnFloor() {
        if (cachedIsOnFloor != null) {
            return cachedIsOnFloor;
        }
        try {
            class_310 client = class_310.method_1551();
            if (client != null && client.field_1687 != null) {
                String dimensionId = client.field_1687.method_27983().method_29177().toString().toLowerCase();
                boolean isFloor = dimensionId.contains("floor");
                cachedIsOnFloor = isFloor;
                return isFloor;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public static double getCurrentKPM() {
        return currentKPM;
    }

    public static int getNewKills() {
        return newKills;
    }

    public static int getTotalKills() {
        return currentKills;
    }

    public static boolean hasKills() {
        return newKills > 0 || currentKills > 0;
    }

    public static void processBossBarKills(String bossBarName) {
        try {
            if (!isTrackingKills) {
                return;
            }
            int kills = KillsUtility.decodeChineseNumber(bossBarName);
            if (kills >= 0) {
                if (firstBossBarUpdate) {
                    initialKills = kills;
                    currentKills = kills;
                    newKills = 0;
                    firstBossBarUpdate = false;
                } else if (kills > currentKills) {
                    currentKills = kills;
                    newKills = currentKills - initialKills;
                } else if (kills < currentKills) {
                    initialKills = kills;
                    currentKills = kills;
                    newKills = 0;
                } else {
                    currentKills = kills;
                    newKills = currentKills - initialKills;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static {
        initialKills = -1;
        currentKills = 0;
        newKills = 0;
        currentDimension = null;
        firstBossBarUpdate = true;
        sessionStartTime = 0L;
        currentKPM = 0.0;
        lastKillTime = 0L;
        killTimes = new LinkedList<Long>();
        CHINESE_NUMBERS = new HashMap<Character, Integer>();
        CHINESE_NUMBERS.put(Character.valueOf('\u36b0'), 0);
        CHINESE_NUMBERS.put(Character.valueOf('\u36b1'), 1);
        CHINESE_NUMBERS.put(Character.valueOf('\u36b2'), 2);
        CHINESE_NUMBERS.put(Character.valueOf('\u36b3'), 3);
        CHINESE_NUMBERS.put(Character.valueOf('\u36b4'), 4);
        CHINESE_NUMBERS.put(Character.valueOf('\u36b5'), 5);
        CHINESE_NUMBERS.put(Character.valueOf('\u36b6'), 6);
        CHINESE_NUMBERS.put(Character.valueOf('\u36b7'), 7);
        CHINESE_NUMBERS.put(Character.valueOf('\u36b8'), 8);
        CHINESE_NUMBERS.put(Character.valueOf('\u36b9'), 9);
        cachedIsOnFloor = null;
    }
}

