/*
 * Decompiled with CFR 0.152.
 */
package net.felix.utilities;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.felix.CCLiveUtilitiesConfig;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_465;
import net.minecraft.class_9290;
import net.minecraft.class_9334;

public class SearchBarUtility {
    private static boolean isSearchBarVisible = false;
    private static String searchText = "";
    private static boolean isSearchBarFocused = false;
    private static int cursorPosition = 0;
    private static int selectionStart = 0;
    private static int selectionEnd = 0;
    private static int searchBarX = 0;
    private static int searchBarY = 0;
    private static int searchBarWidth = 200;
    private static int searchBarHeight = 20;
    private static long cursorBlinkTime = 0L;
    private static boolean cursorVisible = true;
    private static int helpButtonX = 0;
    private static int helpButtonY = 0;
    private static int helpButtonSize = 16;
    private static boolean helpScreenOpen = false;
    private static Set<Integer> matchingSlots = new HashSet<Integer>();
    private static final int SLOT_SIZE = 16;
    private static List<class_1799> previousInventory = new ArrayList<class_1799>();

    public static void initialize() {
        ClientTickEvents.END_CLIENT_TICK.register(SearchBarUtility::onClientTick);
    }

    private static void onClientTick(class_310 client) {
        if (!(((CCLiveUtilitiesConfig)CCLiveUtilitiesConfig.HANDLER.instance()).enableMod && ((CCLiveUtilitiesConfig)CCLiveUtilitiesConfig.HANDLER.instance()).searchBarEnabled && ((CCLiveUtilitiesConfig)CCLiveUtilitiesConfig.HANDLER.instance()).showSearchBar)) {
            isSearchBarVisible = false;
            SearchBarUtility.clearSearchBar();
            return;
        }
        if (client.field_1724 == null || client.field_1755 == null) {
            isSearchBarVisible = false;
            SearchBarUtility.clearSearchBar();
            return;
        }
        class_437 class_4372 = client.field_1755;
        if (class_4372 instanceof class_465) {
            class_465 handledScreen = (class_465)class_4372;
            String title = handledScreen.method_25440().getString();
            String cleanTitle = title.replaceAll("\u00a7[0-9a-fk-or]", "");
            if (cleanTitle.contains("\u3b66") || cleanTitle.contains("Bauplan") || cleanTitle.contains("Baupl\u00e4ne") || cleanTitle.contains("Umschmieden") || cleanTitle.contains("Zerlegen") || cleanTitle.contains("Ausr\u00fcstung") || cleanTitle.contains("Essenz") || cleanTitle.contains("Essenz-Tasche") || cleanTitle.contains("CACTUS_CLICKER.CACTUS_CLICKER") || cleanTitle.contains("Runen [Baupl\u00e4ne]") || cleanTitle.contains("Werkzeug Sammlung") || cleanTitle.contains("Waffen Sammlung") || cleanTitle.contains("R\u00fcstungs Sammlung") || cleanTitle.contains("Favorisierte [R\u00fcstungsbaupl\u00e4ne]") || cleanTitle.contains("Favorisierte [Waffenbaupl\u00e4ne]") || cleanTitle.contains("CACTUS_CLICKER.blueprints.favorites.title.tools")) {
                isSearchBarVisible = true;
                SearchBarUtility.checkInventoryChanges(handledScreen);
                if (isSearchBarFocused) {
                    long currentTime = System.currentTimeMillis();
                    if (currentTime - cursorBlinkTime > 500L) {
                        cursorVisible = !cursorVisible;
                        cursorBlinkTime = currentTime;
                    }
                } else {
                    cursorVisible = false;
                }
            } else {
                isSearchBarVisible = false;
                SearchBarUtility.clearSearchBar();
            }
        } else {
            isSearchBarVisible = false;
            SearchBarUtility.clearSearchBar();
        }
    }

    private static void checkInventoryChanges(class_465<?> screen) {
        int[] slotsToCheck;
        ArrayList<class_1799> currentInventory = new ArrayList<class_1799>();
        for (int slot : slotsToCheck = SearchBarUtility.getSlotsForMenu(screen)) {
            if (slot >= screen.method_17577().field_7761.size()) continue;
            class_1735 slotObj = (class_1735)screen.method_17577().field_7761.get(slot);
            currentInventory.add(slotObj.method_7677());
        }
        if (!SearchBarUtility.inventoryEquals(previousInventory, currentInventory)) {
            previousInventory = new ArrayList<class_1799>(currentInventory);
            if (!searchText.isEmpty()) {
                SearchBarUtility.performSearch();
            }
        }
    }

    private static int[] getSlotsForMenu(class_465<?> screen) {
        String title = screen.method_25440().getString();
        String cleanTitle = title.replaceAll("\u00a7[0-9a-fk-or]", "");
        if (cleanTitle.contains("\u3b66")) {
            return new int[]{0, 1, 2, 3, 5, 6, 7, 9, 10, 11, 12, 14, 15, 16, 18, 19, 20, 21, 23, 24, 25, 27, 28, 29, 30, 32, 33, 34};
        }
        if (cleanTitle.contains("Umschmieden") || cleanTitle.contains("CACTUS_CLICKER.CACTUS_CLICKER")) {
            return new int[]{10, 11, 12, 13, 14, 15, 16, 19, 20, 21, 22, 23, 24, 25, 28, 29, 30, 31, 32, 33, 34, 37, 38, 39, 40, 41, 42, 43};
        }
        if (cleanTitle.contains("Runen [Baupl\u00e4ne]")) {
            return new int[]{10, 11, 12, 13, 14, 15, 16, 19, 20, 21, 22, 23, 24, 25, 28, 29, 30, 31, 32, 33, 34};
        }
        if (cleanTitle.contains("Ausr\u00fcstung") || cleanTitle.contains("Zerlegen")) {
            return new int[]{9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44};
        }
        if (cleanTitle.contains("Essenz")) {
            return new int[]{9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43};
        }
        if (cleanTitle.contains("Werkzeug Sammlung") || cleanTitle.contains("Waffen Sammlung") || cleanTitle.contains("R\u00fcstungs Sammlung")) {
            return new int[]{10, 11, 12, 13, 14, 15, 16, 19, 20, 21, 22, 23, 24, 25, 28, 29, 30, 31, 32, 33, 34, 37, 38, 39, 40, 41, 42, 43};
        }
        return new int[]{10, 11, 12, 13, 14, 15, 16, 19, 20, 21, 22, 23, 24, 25, 28, 29, 30, 31, 32, 33, 34, 37, 38, 39, 40, 41, 42, 43};
    }

    private static boolean inventoryEquals(List<class_1799> inv1, List<class_1799> inv2) {
        if (inv1.size() != inv2.size()) {
            return false;
        }
        for (int i = 0; i < inv1.size(); ++i) {
            class_1799 stack2;
            class_1799 stack1 = inv1.get(i);
            if (class_1799.method_7973((class_1799)stack1, (class_1799)(stack2 = inv2.get(i)))) continue;
            return false;
        }
        return true;
    }

    public static void renderInScreen(class_332 context, class_465<?> screen, int screenX, int screenY) {
        int scrollOffset;
        if (!(((CCLiveUtilitiesConfig)CCLiveUtilitiesConfig.HANDLER.instance()).enableMod && ((CCLiveUtilitiesConfig)CCLiveUtilitiesConfig.HANDLER.instance()).searchBarEnabled && ((CCLiveUtilitiesConfig)CCLiveUtilitiesConfig.HANDLER.instance()).showSearchBar)) {
            return;
        }
        if (!isSearchBarVisible) {
            return;
        }
        class_310 client = class_310.method_1551();
        if (client.field_1724 == null) {
            return;
        }
        searchBarX = screenX + (176 - searchBarWidth) / 2;
        searchBarY = screenY + 166 + 65;
        helpButtonX = searchBarX - helpButtonSize - 5;
        helpButtonY = searchBarY + 2;
        SearchBarUtility.drawHelpButton(context, client);
        if (((CCLiveUtilitiesConfig)CCLiveUtilitiesConfig.HANDLER.instance()).searchBarShowBackground) {
            context.method_25294(searchBarX, searchBarY, searchBarX + searchBarWidth, searchBarY + searchBarHeight, Integer.MIN_VALUE);
        }
        context.method_25294(searchBarX, searchBarY, searchBarX + searchBarWidth, searchBarY + 1, -1);
        context.method_25294(searchBarX, searchBarY + searchBarHeight - 1, searchBarX + searchBarWidth, searchBarY + searchBarHeight, -1);
        context.method_25294(searchBarX, searchBarY, searchBarX + 1, searchBarY + searchBarHeight, -1);
        context.method_25294(searchBarX + searchBarWidth - 1, searchBarY, searchBarX + searchBarWidth, searchBarY + searchBarHeight, -1);
        String displayText = searchText.isEmpty() ? "Suche..." : searchText;
        int textColor = searchText.isEmpty() ? -2139062144 : -1;
        int textX = searchBarX + 5;
        int availableWidth = searchBarWidth - 10;
        if (!searchText.isEmpty()) {
            int textWidth = client.field_1772.method_1727(displayText);
            if (textWidth > availableWidth) {
                int cursorX = client.field_1772.method_1727(searchText.substring(0, cursorPosition));
                scrollOffset = Math.max(0, cursorX - availableWidth + 20);
                String visibleText = SearchBarUtility.getVisibleText(displayText, scrollOffset, availableWidth, client.field_1772);
                context.method_51433(client.field_1772, visibleText, textX, searchBarY + 6, textColor, true);
            } else if (SearchBarUtility.hasSelection() && isSearchBarFocused) {
                SearchBarUtility.renderTextWithSelection(context, client, displayText, textX, searchBarY + 6, textColor);
            } else {
                context.method_51433(client.field_1772, displayText, textX, searchBarY + 6, textColor, true);
            }
        } else {
            context.method_51433(client.field_1772, displayText, textX, searchBarY + 6, textColor, true);
        }
        if (isSearchBarFocused && cursorVisible) {
            int cursorX;
            if (searchText.isEmpty()) {
                cursorX = searchBarX + 5;
            } else {
                cursorX = searchBarX + 5 + client.field_1772.method_1727(searchText.substring(0, cursorPosition));
                int textWidth = client.field_1772.method_1727(searchText);
                if (textWidth > availableWidth) {
                    scrollOffset = Math.max(0, cursorX - searchBarX - 5 - availableWidth + 20);
                    cursorX = searchBarX + 5 + client.field_1772.method_1727(searchText.substring(0, cursorPosition)) - scrollOffset;
                }
            }
            if (cursorX >= searchBarX + 5 && cursorX <= searchBarX + searchBarWidth - 5) {
                context.method_25294(cursorX, searchBarY + 3, cursorX + 1, searchBarY + searchBarHeight - 3, -1);
            }
        }
        if (helpScreenOpen) {
            SearchBarUtility.drawHelpScreen(context, client);
        }
    }

    private static String getVisibleText(String text, int scrollOffset, int availableWidth, class_327 textRenderer) {
        if (scrollOffset <= 0) {
            return text;
        }
        int charIndex = 0;
        int currentWidth = 0;
        for (int i = 0; i < text.length(); ++i) {
            int charWidth = textRenderer.method_1727(String.valueOf(text.charAt(i)));
            if (currentWidth + charWidth > scrollOffset) {
                charIndex = i;
                break;
            }
            currentWidth += charWidth;
        }
        String visibleText = text.substring(charIndex);
        while (textRenderer.method_1727(visibleText) > availableWidth && visibleText.length() > 1) {
            visibleText = visibleText.substring(0, visibleText.length() - 1);
        }
        return visibleText;
    }

    public static void setSearchText(String text) {
        searchText = text;
        cursorPosition = text.length();
        SearchBarUtility.performSearch();
    }

    private static void performSearch() {
        int[] slotsToSearch;
        String searchTerm;
        class_437 class_4372;
        if (searchText.isEmpty()) {
            matchingSlots.clear();
            return;
        }
        class_310 client = class_310.method_1551();
        if (client.field_1755 == null || !((class_4372 = client.field_1755) instanceof class_465)) {
            matchingSlots.clear();
            return;
        }
        class_465 handledScreen = (class_465)class_4372;
        matchingSlots.clear();
        boolean isAtSearch = searchText.startsWith("@");
        if (isAtSearch) {
            searchTerm = searchText.substring(1).trim();
            if (searchTerm.isEmpty()) {
                return;
            }
        } else {
            searchTerm = searchText;
        }
        String searchLower = searchTerm.toLowerCase();
        String searchExact = searchTerm;
        List<SearchFilter> filters = SearchBarUtility.parseMultipleFilters(searchTerm);
        for (int slot : slotsToSearch = SearchBarUtility.getSlotsForMenu(handledScreen)) {
            class_1735 slotObj;
            class_1799 itemStack;
            if (slot >= handledScreen.method_17577().field_7761.size() || (itemStack = (slotObj = (class_1735)handledScreen.method_17577().field_7761.get(slot)).method_7677()).method_7960()) continue;
            boolean matches = false;
            if (isAtSearch) {
                matches = !filters.isEmpty() ? SearchBarUtility.checkAllFilters(itemStack, filters) : SearchBarUtility.searchInItemTooltips(itemStack, searchExact, searchLower);
            } else {
                String itemName = itemStack.method_7964().getString();
                String itemNameLower = itemName.toLowerCase();
                boolean bl = matches = itemName.contains(searchExact) || itemNameLower.contains(searchLower);
            }
            if (!matches) continue;
            matchingSlots.add(slot);
        }
    }

    private static List<SearchFilter> parseMultipleFilters(String searchTerm) {
        String[] parts;
        ArrayList<SearchFilter> filters = new ArrayList<SearchFilter>();
        for (String part : parts = searchTerm.split(",")) {
            String filterText;
            if ((part = part.trim()).isEmpty()) continue;
            boolean isAtFilter = part.startsWith("@");
            String string = filterText = isAtFilter ? part.substring(1).trim() : part;
            if (filterText.isEmpty()) continue;
            ComparisonOperator comparison = SearchBarUtility.parseComparisonOperator(filterText);
            if (comparison != null) {
                filters.add(new SearchFilter(comparison.attribute, comparison.operator, comparison.value));
                continue;
            }
            filters.add(new SearchFilter(filterText));
        }
        return filters;
    }

    private static boolean checkAllFilters(class_1799 itemStack, List<SearchFilter> filters) {
        for (SearchFilter filter : filters) {
            if (SearchBarUtility.checkSingleFilter(itemStack, filter)) continue;
            return false;
        }
        return true;
    }

    private static boolean checkSingleFilter(class_1799 itemStack, SearchFilter filter) {
        switch (filter.type.ordinal()) {
            case 0: {
                return SearchBarUtility.searchWithComparison(itemStack, new ComparisonOperator(filter.attribute, filter.operator, filter.value));
            }
            case 1: {
                return SearchBarUtility.searchInItemTooltips(itemStack, filter.text, filter.text.toLowerCase());
            }
        }
        return false;
    }

    private static ComparisonOperator parseComparisonOperator(String searchTerm) {
        String[] parts;
        if (searchTerm.contains(">")) {
            String[] parts2 = searchTerm.split(">", 2);
            if (parts2.length == 2) {
                try {
                    double value = Double.parseDouble(parts2[1].trim());
                    return new ComparisonOperator(parts2[0].trim(), ">", value);
                }
                catch (NumberFormatException value) {}
            }
        } else if (searchTerm.contains("<")) {
            String[] parts3 = searchTerm.split("<", 2);
            if (parts3.length == 2) {
                try {
                    double value = Double.parseDouble(parts3[1].trim());
                    return new ComparisonOperator(parts3[0].trim(), "<", value);
                }
                catch (NumberFormatException value) {}
            }
        } else if (searchTerm.contains("=") && (parts = searchTerm.split("=", 2)).length == 2) {
            try {
                double value = Double.parseDouble(parts[1].trim());
                return new ComparisonOperator(parts[0].trim(), "=", value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    private static boolean searchWithComparison(class_1799 itemStack, ComparisonOperator comparison) {
        try {
            double extractedValue;
            String itemName;
            String itemNameLower;
            class_9290 loreComponent = (class_9290)itemStack.method_58694(class_9334.field_49632);
            if (loreComponent != null) {
                List lore = loreComponent.comp_2400();
                for (class_2561 loreText : lore) {
                    double extractedValue2;
                    String loreString = SearchBarUtility.extractTextWithColors(loreText);
                    String loreLower = loreString.toLowerCase();
                    if (!loreLower.contains(comparison.attribute.toLowerCase()) || (extractedValue2 = SearchBarUtility.extractNumericValue(loreString)) == -1.0) continue;
                    switch (comparison.operator) {
                        case ">": {
                            return extractedValue2 > comparison.value;
                        }
                        case "<": {
                            return extractedValue2 < comparison.value;
                        }
                        case "=": {
                            return Math.abs(extractedValue2 - comparison.value) < 0.01;
                        }
                    }
                }
            }
            if ((itemNameLower = (itemName = itemStack.method_7964().getString()).toLowerCase()).contains(comparison.attribute.toLowerCase()) && (extractedValue = SearchBarUtility.extractNumericValue(itemName)) != -1.0) {
                switch (comparison.operator) {
                    case ">": {
                        return extractedValue > comparison.value;
                    }
                    case "<": {
                        return extractedValue < comparison.value;
                    }
                    case "=": {
                        return Math.abs(extractedValue - comparison.value) < 0.01;
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private static double extractNumericValue(String text) {
        String cleanText = text.replaceAll("\u00a7[0-9a-fk-or]", "").trim();
        Pattern pattern = Pattern.compile("([0-9]+(?:\\.[0-9]+)?)");
        Matcher matcher = pattern.matcher(cleanText);
        if (matcher.find()) {
            try {
                return Double.parseDouble(matcher.group(1));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return -1.0;
    }

    private static boolean searchInItemTooltips(class_1799 itemStack, String searchExact, String searchLower) {
        try {
            String customName;
            String itemName = itemStack.method_7964().getString();
            String itemNameLower = itemName.toLowerCase();
            if (itemName.contains(searchExact) || itemNameLower.contains(searchLower)) {
                return true;
            }
            class_9290 loreComponent = (class_9290)itemStack.method_58694(class_9334.field_49632);
            if (loreComponent != null) {
                List lore = loreComponent.comp_2400();
                for (class_2561 loreText : lore) {
                    String loreString = SearchBarUtility.extractTextWithColors(loreText);
                    String loreLower = loreString.toLowerCase();
                    if (!loreString.contains(searchExact) && !loreLower.contains(searchLower)) continue;
                    return true;
                }
            }
            if ((customName = SearchBarUtility.extractCustomName(itemStack)) != null) {
                String customNameLower = customName.toLowerCase();
                if (customName.contains(searchExact) || customNameLower.contains(searchLower)) {
                    return true;
                }
            }
        }
        catch (Exception e) {
            String itemName = itemStack.method_7964().getString();
            String itemNameLower = itemName.toLowerCase();
            return itemName.contains(searchExact) || itemNameLower.contains(searchLower);
        }
        return false;
    }

    private static String extractTextWithColors(class_2561 text) {
        if (text == null) {
            return "";
        }
        StringBuilder result = new StringBuilder();
        SearchBarUtility.extractTextColor(text, result);
        return result.toString();
    }

    private static void extractTextColor(class_2561 text, StringBuilder result) {
        if (text == null) {
            return;
        }
        result.append(text.getString());
        for (class_2561 sibling : text.method_10855()) {
            SearchBarUtility.extractTextColor(sibling, result);
        }
    }

    private static String extractCustomName(class_1799 itemStack) {
        try {
            class_2561 customName = (class_2561)itemStack.method_58694(class_9334.field_49631);
            if (customName != null) {
                return SearchBarUtility.extractTextWithColors(customName);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static void setFocused(boolean focused) {
        isSearchBarFocused = focused;
    }

    public static boolean isVisible() {
        return isSearchBarVisible;
    }

    public static boolean isHelpScreenOpen() {
        return helpScreenOpen;
    }

    public static String getSearchText() {
        return searchText;
    }

    private static void clearSearchBar() {
        searchText = "";
        cursorPosition = 0;
        selectionStart = 0;
        selectionEnd = 0;
        isSearchBarFocused = false;
        matchingSlots.clear();
        cursorVisible = false;
        helpScreenOpen = false;
        previousInventory.clear();
    }

    private static boolean hasSelection() {
        return selectionStart != selectionEnd;
    }

    private static void clearSelection() {
        selectionStart = 0;
        selectionEnd = 0;
    }

    private static void insertCharacter(char character) {
        if (SearchBarUtility.hasSelection()) {
            int start = Math.min(selectionStart, selectionEnd);
            int end = Math.max(selectionStart, selectionEnd);
            searchText = searchText.substring(0, start) + character + searchText.substring(end);
            cursorPosition = start + 1;
            SearchBarUtility.clearSelection();
        } else {
            searchText = searchText.substring(0, cursorPosition) + character + searchText.substring(cursorPosition);
            ++cursorPosition;
        }
        SearchBarUtility.performSearch();
    }

    private static void renderTextWithSelection(class_332 context, class_310 client, String text, int x, int y, int textColor) {
        int start = Math.min(selectionStart, selectionEnd);
        int end = Math.max(selectionStart, selectionEnd);
        if (start > 0) {
            String beforeSelection = text.substring(0, start);
            context.method_51433(client.field_1772, beforeSelection, x, y, textColor, true);
        }
        int selectionX = x + client.field_1772.method_1727(text.substring(0, start));
        String selectedText = text.substring(start, end);
        int selectionWidth = client.field_1772.method_1727(selectedText);
        context.method_25294(selectionX, y - 1, selectionX + selectionWidth, y + 9, -16746284);
        context.method_51433(client.field_1772, selectedText, selectionX, y, -1, true);
        if (end < text.length()) {
            String afterSelection = text.substring(end);
            int afterX = selectionX + selectionWidth;
            context.method_51433(client.field_1772, afterSelection, afterX, y, textColor, true);
        }
    }

    public static boolean handleMouseClick(double mouseX, double mouseY, int button) {
        class_310 client;
        if (!isSearchBarVisible) {
            return false;
        }
        if (mouseX >= (double)helpButtonX && mouseX <= (double)(helpButtonX + helpButtonSize) && mouseY >= (double)helpButtonY && mouseY <= (double)(helpButtonY + helpButtonSize) && button == 0) {
            helpScreenOpen = !helpScreenOpen;
            return true;
        }
        if (helpScreenOpen && (client = class_310.method_1551()) != null) {
            int screenWidth = client.method_22683().method_4486();
            int screenHeight = client.method_22683().method_4502();
            int boxWidth = Math.min(350, screenWidth - 40);
            int boxHeight = Math.min(400, screenHeight - 40);
            int boxX = (screenWidth - boxWidth) / 2;
            int boxY = (screenHeight - boxHeight) / 2;
            int closeButtonX = boxX + boxWidth - 20;
            int closeButtonY = boxY + 10;
            if (mouseX >= (double)closeButtonX && mouseX <= (double)(closeButtonX + 10) && mouseY >= (double)closeButtonY && mouseY <= (double)(closeButtonY + 10) && button == 0) {
                helpScreenOpen = false;
                return true;
            }
        }
        if (helpScreenOpen) {
            helpScreenOpen = false;
            return false;
        }
        if (mouseX >= (double)searchBarX && mouseX <= (double)(searchBarX + searchBarWidth) && mouseY >= (double)searchBarY && mouseY <= (double)(searchBarY + searchBarHeight)) {
            if (button == 0) {
                isSearchBarFocused = true;
                SearchBarUtility.clearSelection();
                client = class_310.method_1551();
                if (client != null) {
                    int clickX = (int)(mouseX - (double)searchBarX - 5.0);
                    cursorPosition = SearchBarUtility.calculateCursorPosition(clickX, searchText, client.field_1772);
                } else {
                    cursorPosition = searchText.length();
                }
                cursorVisible = true;
                cursorBlinkTime = System.currentTimeMillis();
                return true;
            }
        } else {
            isSearchBarFocused = false;
        }
        return false;
    }

    public static boolean handleKeyPress(int keyCode, int scanCode, int modifiers) {
        if (helpScreenOpen && keyCode == 256) {
            helpScreenOpen = false;
            return true;
        }
        if (!isSearchBarFocused) {
            return false;
        }
        class_310 client = class_310.method_1551();
        if (client == null) {
            return false;
        }
        cursorVisible = true;
        cursorBlinkTime = System.currentTimeMillis();
        if (keyCode == 256) {
            isSearchBarFocused = false;
            return true;
        }
        if (keyCode == 257) {
            SearchBarUtility.performSearch();
            return true;
        }
        if (modifiers == 2) {
            switch (keyCode) {
                case 67: {
                    if (SearchBarUtility.hasSelection()) {
                        String selectedText = searchText.substring(Math.min(selectionStart, selectionEnd), Math.max(selectionStart, selectionEnd));
                        client.field_1774.method_1455(selectedText);
                    } else if (!searchText.isEmpty()) {
                        client.field_1774.method_1455(searchText);
                    }
                    return true;
                }
                case 86: {
                    String clipboardText = client.field_1774.method_1460();
                    if (clipboardText != null && !clipboardText.isEmpty()) {
                        if (SearchBarUtility.hasSelection()) {
                            int start = Math.min(selectionStart, selectionEnd);
                            int end = Math.max(selectionStart, selectionEnd);
                            searchText = searchText.substring(0, start) + clipboardText + searchText.substring(end);
                            cursorPosition = start + clipboardText.length();
                            SearchBarUtility.clearSelection();
                        } else {
                            searchText = searchText.substring(0, cursorPosition) + clipboardText + searchText.substring(cursorPosition);
                            cursorPosition += clipboardText.length();
                        }
                        SearchBarUtility.performSearch();
                    }
                    return true;
                }
                case 65: {
                    if (!searchText.isEmpty()) {
                        selectionStart = 0;
                        selectionEnd = searchText.length();
                        cursorPosition = searchText.length();
                    }
                    return true;
                }
            }
        }
        if (keyCode == 259) {
            if (SearchBarUtility.hasSelection()) {
                int start = Math.min(selectionStart, selectionEnd);
                int end = Math.max(selectionStart, selectionEnd);
                searchText = searchText.substring(0, start) + searchText.substring(end);
                cursorPosition = start;
                SearchBarUtility.clearSelection();
                SearchBarUtility.performSearch();
            } else if (cursorPosition > 0) {
                if (modifiers == 2) {
                    int wordStart = SearchBarUtility.findWordStart(searchText, cursorPosition);
                    searchText = searchText.substring(0, wordStart) + searchText.substring(cursorPosition);
                    cursorPosition = wordStart;
                } else {
                    searchText = searchText.substring(0, cursorPosition - 1) + searchText.substring(cursorPosition);
                    --cursorPosition;
                }
                SearchBarUtility.performSearch();
            }
            return true;
        }
        if (keyCode == 261) {
            if (SearchBarUtility.hasSelection()) {
                int start = Math.min(selectionStart, selectionEnd);
                int end = Math.max(selectionStart, selectionEnd);
                searchText = searchText.substring(0, start) + searchText.substring(end);
                cursorPosition = start;
                SearchBarUtility.clearSelection();
                SearchBarUtility.performSearch();
            } else if (cursorPosition < searchText.length()) {
                searchText = searchText.substring(0, cursorPosition) + searchText.substring(cursorPosition + 1);
                SearchBarUtility.performSearch();
            }
            return true;
        }
        if (keyCode == 263) {
            SearchBarUtility.clearSelection();
            if (cursorPosition > 0) {
                --cursorPosition;
            }
            return true;
        }
        if (keyCode == 262) {
            SearchBarUtility.clearSelection();
            if (cursorPosition < searchText.length()) {
                ++cursorPosition;
            }
            return true;
        }
        if (keyCode == 32) {
            SearchBarUtility.insertCharacter(' ');
            return true;
        }
        if (keyCode == 188) {
            SearchBarUtility.insertCharacter(',');
            return true;
        }
        if (keyCode == 190) {
            SearchBarUtility.insertCharacter('.');
            return true;
        }
        if (keyCode == 44) {
            SearchBarUtility.insertCharacter(',');
            return true;
        }
        if (keyCode == 46) {
            SearchBarUtility.insertCharacter('.');
            return true;
        }
        if (keyCode == 189) {
            SearchBarUtility.insertCharacter('-');
            return true;
        }
        if (keyCode == 187) {
            SearchBarUtility.insertCharacter('+');
            return true;
        }
        if (keyCode == 186) {
            SearchBarUtility.insertCharacter(';');
            return true;
        }
        if (keyCode == 222) {
            SearchBarUtility.insertCharacter('\"');
            return true;
        }
        if (keyCode == 192) {
            SearchBarUtility.insertCharacter('`');
            return true;
        }
        boolean handled = false;
        if (modifiers == 6) {
            switch (keyCode) {
                case 56: {
                    SearchBarUtility.insertCharacter('[');
                    handled = true;
                    break;
                }
                case 57: {
                    SearchBarUtility.insertCharacter(']');
                    handled = true;
                    break;
                }
                case 55: {
                    SearchBarUtility.insertCharacter('{');
                    handled = true;
                    break;
                }
                case 48: {
                    SearchBarUtility.insertCharacter('}');
                    handled = true;
                    break;
                }
                case 81: {
                    SearchBarUtility.insertCharacter('@');
                    handled = true;
                }
            }
        }
        if (modifiers == 1) {
            switch (keyCode) {
                case 55: {
                    SearchBarUtility.insertCharacter('/');
                    handled = true;
                    break;
                }
                case 56: {
                    SearchBarUtility.insertCharacter('(');
                    handled = true;
                    break;
                }
                case 57: {
                    SearchBarUtility.insertCharacter(')');
                    handled = true;
                    break;
                }
                case 48: {
                    SearchBarUtility.insertCharacter('=');
                    handled = true;
                    break;
                }
                case 220: {
                    SearchBarUtility.insertCharacter('|');
                    handled = true;
                }
            }
        }
        if (keyCode == 53 && modifiers == 1) {
            SearchBarUtility.insertCharacter('%');
            return true;
        }
        if (keyCode == 92) {
            SearchBarUtility.insertCharacter('#');
            return true;
        }
        if (keyCode == 93) {
            SearchBarUtility.insertCharacter('+');
            return true;
        }
        if (keyCode == 47) {
            SearchBarUtility.insertCharacter('-');
            return true;
        }
        if (keyCode == 162 && modifiers == 0) {
            SearchBarUtility.insertCharacter('<');
            return true;
        }
        if (keyCode == 162 && modifiers == 1) {
            SearchBarUtility.insertCharacter('>');
            return true;
        }
        if (keyCode == 45) {
            SearchBarUtility.insertCharacter('\u00df');
            return true;
        }
        if (keyCode == 39) {
            SearchBarUtility.insertCharacter('\u00e4');
            return true;
        }
        if (keyCode == 59) {
            SearchBarUtility.insertCharacter('\u00f6');
            return true;
        }
        if (keyCode == 91) {
            SearchBarUtility.insertCharacter('\u00fc');
            return true;
        }
        if (keyCode == 334) {
            SearchBarUtility.insertCharacter('+');
            return true;
        }
        if (keyCode == 333) {
            SearchBarUtility.insertCharacter('-');
            return true;
        }
        if (keyCode == 320) {
            SearchBarUtility.insertCharacter('0');
            return true;
        }
        if (keyCode >= 321 && keyCode <= 329) {
            char number = (char)(48 + (keyCode - 321 + 1));
            SearchBarUtility.insertCharacter(number);
            return true;
        }
        if (handled) {
            return true;
        }
        if (modifiers == 0 && keyCode >= 48 && keyCode <= 57) {
            char number = (char)keyCode;
            SearchBarUtility.insertCharacter(number);
            return true;
        }
        if (keyCode >= 65 && keyCode <= 90) {
            int letter = keyCode == 89 ? (modifiers == 1 ? 90 : 122) : (keyCode == 90 ? (modifiers == 1 ? 89 : 121) : (int)(modifiers == 1 ? (char)keyCode : (char)(keyCode + 32)));
            SearchBarUtility.insertCharacter((char)letter);
            return true;
        }
        return false;
    }

    private static void drawHelpButton(class_332 context, class_310 client) {
        context.method_25294(helpButtonX, helpButtonY, helpButtonX + helpButtonSize, helpButtonY + helpButtonSize, Integer.MIN_VALUE);
        context.method_25294(helpButtonX, helpButtonY, helpButtonX + helpButtonSize, helpButtonY + 1, -1);
        context.method_25294(helpButtonX, helpButtonY + helpButtonSize - 1, helpButtonX + helpButtonSize, helpButtonY + helpButtonSize, -1);
        context.method_25294(helpButtonX, helpButtonY, helpButtonX + 1, helpButtonY + helpButtonSize, -1);
        context.method_25294(helpButtonX + helpButtonSize - 1, helpButtonY, helpButtonX + helpButtonSize, helpButtonY + helpButtonSize, -1);
        context.method_51433(client.field_1772, "?", helpButtonX + 5, helpButtonY + 3, -1, true);
    }

    private static void drawHelpScreen(class_332 context, class_310 client) {
        String[] helpText;
        int screenWidth = client.method_22683().method_4486();
        int screenHeight = client.method_22683().method_4502();
        context.method_25294(0, 0, screenWidth, screenHeight, Integer.MIN_VALUE);
        int boxWidth = Math.min(350, screenWidth - 40);
        int boxHeight = Math.min(400, screenHeight - 40);
        int boxX = (screenWidth - boxWidth) / 2;
        int boxY = (screenHeight - boxHeight) / 2;
        context.method_25294(boxX, boxY, boxX + boxWidth, boxY + boxHeight, -16777216);
        context.method_25294(boxX, boxY, boxX + boxWidth, boxY + 1, -1);
        context.method_25294(boxX, boxY + boxHeight - 1, boxX + boxWidth, boxY + boxHeight, -1);
        context.method_25294(boxX, boxY, boxX + 1, boxY + boxHeight, -1);
        context.method_25294(boxX + boxWidth - 1, boxY, boxX + boxWidth, boxY + boxHeight, -1);
        context.method_51433(client.field_1772, "Suchleiste Hilfe", boxX + 10, boxY + 10, -256, true);
        int textY = boxY + 40;
        int lineHeight = 11;
        for (String line : helpText = new String[]{"Grundlegende Suche:", "\u2022 Makiert Items mit dem eingegebenen Namen", "", "Erweiterte Suche (@):", "\u2022 @Ring - Makiert alle Ringe", "\u2022 @Schaden>100 - Makiert items mit mehr als 100 Schaden", "\u2022 @Ring, @R\u00fcstung>100 - Kombinierte Suche", "", "Vergleichsoperatoren:", "\u2022 > (gr\u00f6\u00dfer als)", "\u2022 < (kleiner als)", "\u2022 = (gleich)", "", "Beispiele:", "\u2022 G\u00f6ttlich - Makiert alle items mit G\u00f6ttlich im Namen", "\u2022 @R\u00fcstung>50 - Items mit R\u00fcstung>50", "\u2022 @Ring, @R\u00fcstung>50 - Ringe mit mehr als 50 R\u00fcstung", "\u2022 @Ring, @R\u00fcstung>50, G\u00f6ttlich - Ringe mit mehr als 50 R\u00fcstung und ", "                                        G\u00f6ttlich im Namen", ""}) {
            context.method_51433(client.field_1772, line, boxX + 10, textY, -1, true);
            textY += lineHeight;
        }
    }

    private static int findWordStart(String text, int position) {
        int wordStart;
        if (position <= 0) {
            return 0;
        }
        for (wordStart = position; wordStart > 0 && SearchBarUtility.isWordSeparator(text.charAt(wordStart - 1)); --wordStart) {
        }
        while (wordStart > 0 && !SearchBarUtility.isWordSeparator(text.charAt(wordStart - 1))) {
            --wordStart;
        }
        return wordStart;
    }

    private static boolean isWordSeparator(char c) {
        return Character.isWhitespace(c) || c == ',' || c == '.' || c == ';' || c == ':' || c == '!' || c == '?' || c == '@';
    }

    private static int calculateCursorPosition(int clickX, String text, class_327 textRenderer) {
        if (text.isEmpty()) {
            return 0;
        }
        int bestPosition = 0;
        int bestDistance = Integer.MAX_VALUE;
        for (int i = 0; i <= text.length(); ++i) {
            int textWidth = textRenderer.method_1727(text.substring(0, i));
            int distance = Math.abs(clickX - textWidth);
            if (distance >= bestDistance) continue;
            bestDistance = distance;
            bestPosition = i;
        }
        return bestPosition;
    }

    public static void renderSearchFrames(class_332 context, class_465<?> screen, int screenX, int screenY) {
        if (!isSearchBarVisible || searchText.isEmpty() || matchingSlots.isEmpty()) {
            return;
        }
        int frameColor = ((CCLiveUtilitiesConfig)CCLiveUtilitiesConfig.HANDLER.instance()).searchBarFrameColor.getRGB();
        for (Integer slotIndex : matchingSlots) {
            if (slotIndex >= screen.method_17577().field_7761.size()) continue;
            class_1735 slot = (class_1735)screen.method_17577().field_7761.get(slotIndex.intValue());
            int slotX = screenX + slot.field_7873;
            int slotY = screenY + slot.field_7872;
            context.method_25294(slotX - 1, slotY - 1, slotX + 16 + 1, slotY, frameColor);
            context.method_25294(slotX - 1, slotY + 16, slotX + 16 + 1, slotY + 16 + 1, frameColor);
            context.method_25294(slotX - 1, slotY - 1, slotX, slotY + 16 + 1, frameColor);
            context.method_25294(slotX + 16, slotY - 1, slotX + 16 + 1, slotY + 16 + 1, frameColor);
        }
    }

    private static class ComparisonOperator {
        String attribute;
        String operator;
        double value;

        ComparisonOperator(String attribute, String operator, double value) {
            this.attribute = attribute;
            this.operator = operator;
            this.value = value;
        }
    }

    private static class SearchFilter {
        Type type;
        String attribute;
        String operator;
        double value;
        String text;

        SearchFilter(String attribute, String operator, double value) {
            this.type = Type.COMPARISON;
            this.attribute = attribute;
            this.operator = operator;
            this.value = value;
        }

        SearchFilter(String text) {
            this.type = Type.TEXT;
            this.text = text;
        }

        static enum Type {
            COMPARISON,
            TEXT;

        }
    }
}

